import PropTypes from 'prop-types';

export const OrderConst = {
    SORT_ASC: 'asc',
    SORT_DESC: 'desc'
};

export const Column = PropTypes.shape({
    class: PropTypes.string,
    propertyName: PropTypes.string.isRequired,
    label: PropTypes.string.isRequired,
    sortable: PropTypes.bool.isRequired,
});

export const OrderBy = PropTypes.shape({
    propertyName: PropTypes.string.isRequired,
    direction: PropTypes.oneOf([OrderConst.SORT_DESC, OrderConst.SORT_ASC]),
});
