import React from 'react';
import PropTypes from 'prop-types';
import {XlReactWidgetString} from 'xl-react-components';
import {VariableConstants} from './../../../../../../core/xlr-ui/app/js/variables/variable-constants';

import './display-variable.less';

export const DisplayVariable = ({variable}) => {

    const renderStringField = (isPassword = false) => (
        <XlReactWidgetString
            displayMode={'visual'}
            metadata={{label: variable.key, type: isPassword ? 'password' : 'text'}}
            model={variable.value}/>
    );

    const renderBooleanField = () => (
        <XlReactWidgetString
            displayMode={'visual'}
            metadata={{label: variable.key}}
            model={variable.value ? 'True' : 'False'}/>
    );

    const renderSetField = () => (
        <XlReactWidgetString
            displayMode={'visual'}
            metadata={{label: variable.key}}
            model={`set(${transformObjectToText()})`}/>
    );

    const renderObjectField = () => (
        <XlReactWidgetString
            displayMode={'visual'}
            metadata={{label: variable.key}}
            model={transformObjectToText()}/>
    );

    const renderDateTimeField = () => {
        const value = moment(variable.value).format('DD/MM/YYYY hh:mm A');
        return (
            <XlReactWidgetString
                displayMode={'visual'}
                metadata={{label: variable.key}}
                model={value}/>
        );
    };

    // eslint-disable-next-line no-console, angular/json-functions
    const transformObjectToText = () => JSON.stringify(variable.value).split(',').join(', ');

    const renderSwitch = () => {
        switch (variable.type) {
            case VariableConstants.type.string.key:
            case VariableConstants.type.integer.key:
                return renderStringField();
            case VariableConstants.type.passwordString.key:
                return renderStringField(true);
            case VariableConstants.type.boolean.key:
                return renderBooleanField();
            case VariableConstants.type.setString.key:
                return renderSetField();
            case VariableConstants.type.date.key:
                return renderDateTimeField();
            case VariableConstants.type.listString.key:
            case VariableConstants.type.mapStringString.key:
            default:
                return renderObjectField();
        }
    };

    return <div className='display-variable-wrapper form-group'>
        {renderSwitch()}
    </div>;
};

DisplayVariable.propTypes = {
    variable: PropTypes.any
};
