import React from 'react';
import PropTypes from 'prop-types';
import {XlReactWidgetTreeSelect} from 'xl-react-components';

import './select-tree.component.less';

const SelectTreeComponent = ({clearable, data, onModelChange, selectedItemId}) => {
    return <div className='select-tree-component'>
        <XlReactWidgetTreeSelect
            clearable={clearable}
            data={data}
            expandAll={true}
            indentGroupPadding={10}
            onModelChange={onModelChange}
            selectedFolderId={selectedItemId}
        />
    </div>;
};

SelectTreeComponent.propTypes = {
    clearable: PropTypes.bool,
    data: PropTypes.arrayOf(PropTypes.shape({
        id: PropTypes.string.isRequired,
        title: PropTypes.string.isRequired
    })),
    onModelChange: PropTypes.func,
    selectedItemId: PropTypes.string
};

export {SelectTreeComponent};
