import React from 'react';
import PropTypes from 'prop-types';
import {DEFAULT_CLASSNAMES} from './xlr-tags-constants';

export const RemoveComponent = (props) => {
    const {readOnly, removeComponent, onClick, className} = props;
    if (readOnly) {
        return <span/>;
    }

    if (removeComponent) {
        const Component = removeComponent;
        return <Component {...props} />;
    }

    return (
        <a className={className} onClick={onClick} onKeyDown={onClick}>
            <i className={"xl-icon close-icon icon-s"}/>
        </a>
    );
};

RemoveComponent.propTypes = {
    className: PropTypes.string,
    onClick: PropTypes.func.isRequired,
    readOnly: PropTypes.bool,
    removeComponent: PropTypes.func,
};

RemoveComponent.defaultProps = {
    className: DEFAULT_CLASSNAMES.remove,
    readOnly: false
};
