/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.storage.s3;

import com.xebialabs.xlrelease.storage.Storage;
import com.xebialabs.xlrelease.storage.s3.S3Storage$;
import com.xebialabs.xlrelease.storage.s3.S3StorageConfig;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;
import software.amazon.awssdk.utils.StringUtils;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\u0013&\u0001AB\u0001b\u0011\u0001\u0003\u0006\u0004%I\u0001\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u000b\")!\n\u0001C\u0001\u0017\"Aa\n\u0001b\u0001\n\u0003)s\n\u0003\u0004^\u0001\u0001\u0006I\u0001\u0015\u0005\u0006=\u0002!Y\u0001\u0012\u0005\u0006?\u0002!\t\u0005\u0019\u0005\u0006g\u0002!\t\u0005\u001e\u0005\u0006m\u0002!\te\u001e\u0005\u0006y\u0002!\t% \u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u00020\u0001!\t%!\r\t\u000f\u0005U\u0002\u0001\"\u0011\u00028!9\u00111\b\u0001\u0005B\u0005uraBA(K!\u0005\u0011\u0011\u000b\u0004\u0007I\u0015B\t!a\u0015\t\r)\u0013B\u0011AA+\u0011%\t9F\u0005b\u0001\n\u0013\tI\u0006\u0003\u0005\u0002fI\u0001\u000b\u0011BA.\r\u0019\t9GE\u0001\u0002j!Q\u00111\u000e\f\u0003\u0002\u0003\u0006I!a\u0010\t\r)3B\u0011AA7\u0011\u001d\t)H\u0006C\u0001\u0003oBq!a\u001f\u0017\t\u0003\ti\bC\u0004\u0002\u0002Z!\t!a!\t\u000f\u0005\u001de\u0003\"\u0003\u0002\n\"I\u0011Q\u0012\n\u0002\u0002\u0013\r\u0011q\u0012\u0004\u0007\u0003'\u0013\u0012!!&\t\u0011)t\"\u0011!Q\u0001\n\u0005DaA\u0013\u0010\u0005\u0002\u0005]\u0005bBA>=\u0011\u0005\u0011Q\u0014\u0005\b\u0003\u0003sB\u0011AAQ\u0011%\t)KEA\u0001\n\u0007\t9KA\u0005TgM#xN]1hK*\u0011aeJ\u0001\u0003gNR!\u0001K\u0015\u0002\u000fM$xN]1hK*\u0011!fK\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001L\u0017\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0018\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001\ttg\u000f\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005aJT\"A\u0014\n\u0005i:#aB*u_J\fw-\u001a\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nQa\u001d7gi)T\u0011\u0001Q\u0001\tOJL'P\u001f7fI&\u0011!)\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOV\tQ\t\u0005\u0002G\u000f6\tQ%\u0003\u0002IK\ty1kM*u_J\fw-Z\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\rqJg.\u001b;?)\taU\n\u0005\u0002G\u0001!)1i\u0001a\u0001\u000b\u0006A1oM\"mS\u0016tG/F\u0001Q!\t\t6,D\u0001S\u0015\t13K\u0003\u0002U+\u0006A1/\u001a:wS\u000e,7O\u0003\u0002W/\u00061\u0011m^:tI.T!\u0001W-\u0002\r\u0005l\u0017M_8o\u0015\u0005Q\u0016\u0001C:pMR<\u0018M]3\n\u0005q\u0013&\u0001C*4\u00072LWM\u001c;\u0002\u0013M\u001c4\t\\5f]R\u0004\u0013AD5na2L7-\u001b;D_:4\u0017nZ\u0001\u0004aV$HcA1jWB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0004]\u0016$(\"\u00014\u0002\t)\fg/Y\u0005\u0003Q\u000e\u00141!\u0016*J\u0011\u0015Qw\u00011\u0001b\u0003\r)(/\u001b\u0005\u0006Y\u001e\u0001\r!\\\u0001\u0005I\u0006$\u0018\r\u0005\u0002oc6\tqN\u0003\u0002qK\u0006\u0011\u0011n\\\u0005\u0003e>\u00141\"\u00138qkR\u001cFO]3b[\u0006\u0019q-\u001a;\u0015\u00055,\b\"\u00026\t\u0001\u0004\t\u0017AB3ySN$8\u000f\u0006\u0002ywB\u0011!'_\u0005\u0003uN\u0012qAQ8pY\u0016\fg\u000eC\u0003k\u0013\u0001\u0007\u0011-\u0001\u0003tSj,Gc\u0001@\u0002\u0004A\u0011!g`\u0005\u0004\u0003\u0003\u0019$\u0001\u0002'p]\u001eDQA\u001b\u0006A\u0002\u0005\fa\u0001Z3mKR,Gc\u0001=\u0002\n!)!n\u0003a\u0001C\u0006iA-\u001a7fi\u0016Le-R7qif$2\u0001_A\b\u0011\u0015QG\u00021\u0001b\u0003=a\u0017n\u001d;ESJ,7\r^8sS\u0016\u001cH\u0003BA\u000b\u0003[\u0001R!a\u0006\u0002(\u0005tA!!\u0007\u0002$9!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 =\na\u0001\u0010:p_Rt\u0014\"\u0001\u001b\n\u0007\u0005\u00152'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00121\u0006\u0002\u0005\u0019&\u001cHOC\u0002\u0002&MBQA[\u0007A\u0002\u0005\f\u0011\u0002\\5ti\u001aKG.Z:\u0015\t\u0005U\u00111\u0007\u0005\u0006U:\u0001\r!Y\u0001\bG2,\u0017M\\;q)\rA\u0018\u0011\b\u0005\u0006U>\u0001\r!Y\u0001\nkJL7k\u00195f[\u0016,\"!a\u0010\u0011\t\u0005\u0005\u0013\u0011\n\b\u0005\u0003\u0007\n)\u0005E\u0002\u0002\u001cMJ1!a\u00124\u0003\u0019\u0001&/\u001a3fM&!\u00111JA'\u0005\u0019\u0019FO]5oO*\u0019\u0011qI\u001a\u0002\u0013M\u001b4\u000b^8sC\u001e,\u0007C\u0001$\u0013'\t\u0011\u0012\u0007\u0006\u0002\u0002R\u0005IA)\u0012'J\u001b&#VIU\u000b\u0003\u00037\u0002B!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0004\u0003C*\u0017\u0001\u00027b]\u001eLA!a\u0013\u0002`\u0005QA)\u0012'J\u001b&#VI\u0015\u0011\u0003\u001fM#(/\u001b8h\u000bb$XM\\:j_:\u001c\"AF\u0019\u0002\u000f-,\u0017\u0010U1uQR!\u0011qNA:!\r\t\tHF\u0007\u0002%!9\u00111\u000e\rA\u0002\u0005}\u0012\u0001\u0003;p\u0017\u0016LXK]5\u0015\u0007\u0005\fI\bC\u0003D3\u0001\u000fQ)A\u0003u_.+\u0017\u0010\u0006\u0003\u0002@\u0005}\u0004\"B\"\u001b\u0001\b)\u0015!\u0003;p\r&dWmS3z)\u0011\ty$!\"\t\u000b\r[\u00029A#\u0002\u001dA\u0014X\r]1sK.+\u0017\u0010U1uQR!\u0011qHAF\u0011\u0015\u0019E\u00041\u0001F\u0003=\u0019FO]5oO\u0016CH/\u001a8tS>tG\u0003BA8\u0003#Cq!a\u001b\u001e\u0001\u0004\tyD\u0001\u0007Ve&,\u0005\u0010^3og&|gn\u0005\u0002\u001fcQ!\u0011\u0011TAN!\r\t\tH\b\u0005\u0006U\u0002\u0002\r!\u0019\u000b\u0005\u0003\u007f\ty\nC\u0003DC\u0001\u000fQ\t\u0006\u0003\u0002@\u0005\r\u0006\"B\"#\u0001\b)\u0015\u0001D+sS\u0016CH/\u001a8tS>tG\u0003BAM\u0003SCQA[\u0012A\u0002\u0005\u0004")
public class S3Storage
implements Storage,
Logging {
    private final S3StorageConfig config;
    private final S3Client s3Client;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static UriExtension UriExtension(URI uri) {
        return S3Storage$.MODULE$.UriExtension(uri);
    }

    public static StringExtension StringExtension(String keyPath) {
        return S3Storage$.MODULE$.StringExtension(keyPath);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        S3Storage s3Storage = this;
        synchronized (s3Storage) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private S3StorageConfig config() {
        return this.config;
    }

    public S3Client s3Client() {
        return this.s3Client;
    }

    private S3StorageConfig implicitConfig() {
        return this.config();
    }

    @Override
    public URI put(URI uri, InputStream data) {
        String key;
        block0: {
            key = S3Storage$.MODULE$.UriExtension(uri).toFileKey(this.implicitConfig());
            PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.config().bucketName()).key(key).build();
            RequestBody requestBody = RequestBody.fromInputStream((InputStream)data, (long)data.available());
            PutObjectResponse putResponse = this.s3Client().putObject(putObjectRequest, requestBody);
            if (!this.logger().isTraceEnabled()) break block0;
            this.logger().trace((Function0 & Serializable)() -> "Put object " + key + " with request ID " + putResponse.responseMetadata().requestId());
        }
        return S3Storage$.MODULE$.StringExtension(key).toKeyUri(this.implicitConfig());
    }

    @Override
    public InputStream get(URI uri) {
        ResponseInputStream responseInputStream;
        String key = S3Storage$.MODULE$.UriExtension(uri).toFileKey(this.implicitConfig());
        try {
            ResponseInputStream s3object;
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.config().bucketName()).key(key).build();
            this.logger().trace((Function0 & Serializable)() -> "Get object " + key);
            responseInputStream = s3object = this.s3Client().getObject(getObjectRequest);
        }
        catch (NoSuchKeyException noSuchKeyException) {
            throw new FileNotFoundException("Unable to find file at '" + uri + "'");
        }
        catch (SdkClientException e) {
            throw new IOException("Unable to find file at '" + uri + "'", e);
        }
        return responseInputStream;
    }

    @Override
    public boolean exists(URI uri) {
        boolean bl;
        String key = S3Storage$.MODULE$.UriExtension(uri).toFileKey(this.implicitConfig());
        try {
            HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.config().bucketName()).key(key).build();
            this.s3Client().headObject(headObjectRequest);
            bl = true;
        }
        catch (NoSuchKeyException noSuchKeyException) {
            bl = false;
        }
        catch (SdkClientException e) {
            throw new IOException("Unable to find file at '" + uri + "'", e);
        }
        return bl;
    }

    @Override
    public long size(URI uri) {
        long l;
        String key = S3Storage$.MODULE$.UriExtension(uri).toFileKey(this.implicitConfig());
        try {
            HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.config().bucketName()).key(key).build();
            HeadObjectResponse response = this.s3Client().headObject(headObjectRequest);
            if (this.logger().isTraceEnabled()) {
                this.logger().trace((Function0 & Serializable)() -> "Get size " + key + " with version " + response.versionId());
            }
            l = Predef$.MODULE$.Long2long(response.contentLength());
        }
        catch (NoSuchKeyException noSuchKeyException) {
            throw new FileNotFoundException("Unable to find file at '" + uri + "'");
        }
        catch (SdkClientException e) {
            throw new IOException("Unable to find file size at '" + uri + "'", e);
        }
        return l;
    }

    @Override
    public boolean delete(URI uri) {
        boolean bl;
        String key = S3Storage$.MODULE$.UriExtension(uri).toFileKey(this.implicitConfig());
        try {
            this.logger().trace((Function0 & Serializable)() -> "Delete object " + key);
            this.s3Client().deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.config().bucketName()).key(key).build());
            bl = true;
        }
        catch (NoSuchKeyException noSuchKeyException) {
            this.logger().warn((Function0 & Serializable)() -> "No such key: " + key);
            bl = false;
        }
        catch (SdkException e) {
            throw new IOException("Unable to delete file at '" + uri + "'", e);
        }
        return bl;
    }

    @Override
    public boolean deleteIfEmpty(URI uri) {
        boolean bl;
        String key = S3Storage$.MODULE$.UriExtension(uri).toKey(this.implicitConfig());
        try {
            ListObjectsV2Request listObjectsRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.config().bucketName()).prefix(key).build();
            ListObjectsV2Response objectListing = this.s3Client().listObjectsV2(listObjectsRequest);
            if (objectListing.contents().isEmpty()) {
                DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.config().bucketName()).key(key).build();
                this.s3Client().deleteObject(deleteObjectRequest);
                bl = true;
            } else {
                bl = false;
            }
        }
        catch (NoSuchKeyException noSuchKeyException) {
            bl = true;
        }
        catch (SdkClientException e) {
            throw new IOException("Unable to delete if empty at '" + uri + "'", e);
        }
        return bl;
    }

    @Override
    public List<URI> listDirectories(URI uri) {
        List list2;
        String key = S3Storage$.MODULE$.UriExtension(uri).toKey(this.implicitConfig());
        try {
            this.logger().trace((Function0 & Serializable)() -> "List directories for " + key);
            ListObjectsV2Iterable objectListing = this.s3Client().listObjectsV2Paginator((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.config().bucketName()).prefix(key).delimiter(S3Storage$.MODULE$.com$xebialabs$xlrelease$storage$s3$S3Storage$$DELIMITER()).build());
            list2 = CollectionConverters$.MODULE$.IteratorHasAsScala(objectListing.iterator()).asScala().flatMap((Function1 & Serializable)list -> (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(list.commonPrefixes()).asScala().sortBy((Function1 & Serializable)s -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)s.prefix().length()), (Object)s.prefix()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.String$.MODULE$))).map((Function1 & Serializable)s -> S3Storage$.MODULE$.StringExtension(s.prefix()).toKeyUri(this.implicitConfig()))).toList();
        }
        catch (NoSuchKeyException noSuchKeyException) {
            throw new FileNotFoundException("Unable to find directory key at '" + uri + "'");
        }
        catch (SdkClientException e) {
            throw new IOException("Unable to list directories at '" + uri + "'", e);
        }
        return list2;
    }

    @Override
    public List<URI> listFiles(URI uri) {
        List list2;
        String key = S3Storage$.MODULE$.UriExtension(uri).toKey(this.implicitConfig());
        try {
            this.logger().trace((Function0 & Serializable)() -> "List files for " + key);
            ListObjectsV2Iterable objectListing = this.s3Client().listObjectsV2Paginator((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.config().bucketName()).prefix(key).delimiter(S3Storage$.MODULE$.com$xebialabs$xlrelease$storage$s3$S3Storage$$DELIMITER()).build());
            list2 = CollectionConverters$.MODULE$.IteratorHasAsScala(objectListing.iterator()).asScala().flatMap((Function1 & Serializable)list -> (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(list.contents()).asScala().sortBy((Function1 & Serializable)obj -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)obj.key().length()), (Object)obj.key()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.String$.MODULE$))).map((Function1 & Serializable)obj -> S3Storage$.MODULE$.StringExtension(obj.key()).toKeyUri(this.implicitConfig()))).toList();
        }
        catch (NoSuchKeyException noSuchKeyException) {
            throw new FileNotFoundException("Unable to find directory key at '" + uri + "'");
        }
        catch (SdkClientException e) {
            throw new IOException("Unable to list files at '" + uri + "'", e);
        }
        return list2;
    }

    @Override
    public boolean cleanup(URI uri) {
        boolean bl;
        String key = S3Storage$.MODULE$.UriExtension(uri).toKey(this.implicitConfig());
        try {
            this.logger().trace((Function0 & Serializable)() -> "Clean directories under " + key);
            ListObjectsV2Iterable listingToDelete = this.s3Client().listObjectsV2Paginator((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.config().bucketName()).prefix(key).delimiter(S3Storage$.MODULE$.com$xebialabs$xlrelease$storage$s3$S3Storage$$DELIMITER()).build());
            Iterator deleteIterator = CollectionConverters$.MODULE$.IteratorHasAsScala(listingToDelete.iterator()).asScala();
            while (deleteIterator.hasNext()) {
                BoxedUnit boxedUnit;
                Buffer keysToDelete = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(((ListObjectsV2Response)deleteIterator.next()).contents()).asScala().map((Function1 & Serializable)obj -> (ObjectIdentifier)ObjectIdentifier.builder().key(obj.key()).build());
                if (keysToDelete.nonEmpty()) {
                    Delete delete = (Delete)Delete.builder().objects((Collection)CollectionConverters$.MODULE$.BufferHasAsJava(keysToDelete).asJava()).build();
                    boxedUnit = this.s3Client().deleteObjects((DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.config().bucketName()).delete(delete).build());
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = true;
        }
        catch (NoSuchKeyException noSuchKeyException) {
            throw new FileNotFoundException("Unable to find directory key at '" + uri + "'");
        }
        catch (Exception e) {
            this.logger().warn((Function0 & Serializable)() -> "Exception while deleting under key " + key + ": " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    @Override
    public String uriScheme() {
        return this.config().uriScheme();
    }

    public S3Storage(S3StorageConfig config) {
        this.config = config;
        Logging.$init$((Logging)this);
        S3ClientBuilder builder = (S3ClientBuilder)S3Client.builder().region(Region.of((String)config.region()));
        Object object = StringUtils.isNotBlank((CharSequence)config.endpointUri()) ? builder.endpointOverride(URI.create(config.endpointUri())) : BoxedUnit.UNIT;
        this.s3Client = (S3Client)builder.build();
    }

    public static class StringExtension {
        private final String keyPath;

        public URI toKeyUri(S3StorageConfig config) {
            return new URI(config.uriScheme(), null, S3Storage$.MODULE$.com$xebialabs$xlrelease$storage$s3$S3Storage$$DELIMITER() + this.prepareKeyPath(config), null);
        }

        public String toKey(S3StorageConfig config) {
            String key = this.prepareKeyPath(config);
            if (key.endsWith(S3Storage$.MODULE$.com$xebialabs$xlrelease$storage$s3$S3Storage$$DELIMITER())) {
                return key;
            }
            return key + S3Storage$.MODULE$.com$xebialabs$xlrelease$storage$s3$S3Storage$$DELIMITER();
        }

        public String toFileKey(S3StorageConfig config) {
            return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.prepareKeyPath(config)), S3Storage$.MODULE$.com$xebialabs$xlrelease$storage$s3$S3Storage$$DELIMITER());
        }

        private String prepareKeyPath(S3StorageConfig config) {
            String path = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(this.keyPath.replace("\\", S3Storage$.MODULE$.com$xebialabs$xlrelease$storage$s3$S3Storage$$DELIMITER())), S3Storage$.MODULE$.com$xebialabs$xlrelease$storage$s3$S3Storage$$DELIMITER());
            if (path.startsWith(config.baseKey())) {
                return path;
            }
            return config.baseKey() + S3Storage$.MODULE$.com$xebialabs$xlrelease$storage$s3$S3Storage$$DELIMITER() + path;
        }

        public StringExtension(String keyPath) {
            this.keyPath = keyPath;
        }
    }

    public static class UriExtension {
        private final URI uri;

        public String toKey(S3StorageConfig config) {
            return S3Storage$.MODULE$.StringExtension(this.uri.getPath()).toKey(config);
        }

        public String toFileKey(S3StorageConfig config) {
            return S3Storage$.MODULE$.StringExtension(this.uri.getPath()).toFileKey(config);
        }

        public UriExtension(URI uri) {
            this.uri = uri;
        }
    }
}

