/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.storage.local;

import com.xebialabs.xlrelease.storage.Storage;
import com.xebialabs.xlrelease.storage.local.LocalStorageConfig;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Marker;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StreamUtils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001\u0002\r\u001a\u0001\u0011B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005s!)a\b\u0001C\u0001\u007f!)!\t\u0001C\u0006q!)1\t\u0001C!\t\")q\u000b\u0001C!1\")!\f\u0001C!7\")\u0001\r\u0001C!C\")a\r\u0001C!O\")\u0011\u000e\u0001C!U\")\u0001\u0010\u0001C!s\")1\u0010\u0001C!y\")a\u0010\u0001C!\u007f\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001\u0002CA\f\u0001\u0011\u0005\u0011$!\u0007\t\u000f\u00055\u0002\u0001\"\u0003\u00020\u00191\u00111\b\u0001\u0006\u0003{A\u0001BT\t\u0003\u0002\u0003\u0006I!\u0012\u0005\u0007}E!\t!a\u0010\t\u000f\u0005\u001d\u0013\u0003\"\u0001\u0002J!9\u0011QJ\t\u0005\u0002\u0005=\u0003\"CA*\u0001\u0005\u0005I1BA+\u0011\u001d\tI\u0006\u0001C\u0005\u00037\u0012A\u0002T8dC2\u001cFo\u001c:bO\u0016T!AG\u000e\u0002\u000b1|7-\u00197\u000b\u0005qi\u0012aB:u_J\fw-\u001a\u0006\u0003=}\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u0001\n\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0013aA2p[\u000e\u00011\u0003\u0002\u0001&W=\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u0017.\u001b\u0005Y\u0012B\u0001\u0018\u001c\u0005\u001d\u0019Fo\u001c:bO\u0016\u0004\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\u000bMdg\r\u000e6\u000b\u0003Q\n\u0001b\u001a:jujdW\rZ\u0005\u0003mE\u0012q\u0001T8hO&tw-\u0001\u0004d_:4\u0017nZ\u000b\u0002sA\u0011!hO\u0007\u00023%\u0011A(\u0007\u0002\u0013\u0019>\u001c\u0017\r\\*u_J\fw-Z\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\rqJg.\u001b;?)\t\u0001\u0015\t\u0005\u0002;\u0001!)qg\u0001a\u0001s\u0005q\u0011.\u001c9mS\u000eLGoQ8oM&<\u0017a\u00019viR\u0019Q)T(\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015a\u00018fi*\t!*\u0001\u0003kCZ\f\u0017B\u0001'H\u0005\r)&+\u0013\u0005\u0006\u001d\u0016\u0001\r!R\u0001\u0004kJL\u0007\"\u0002)\u0006\u0001\u0004\t\u0016\u0001\u00023bi\u0006\u0004\"AU+\u000e\u0003MS!\u0001V%\u0002\u0005%|\u0017B\u0001,T\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\u0007\u001d,G\u000f\u0006\u0002R3\")aJ\u0002a\u0001\u000b\u0006!1/\u001b>f)\tav\f\u0005\u0002';&\u0011al\n\u0002\u0005\u0019>tw\rC\u0003O\u000f\u0001\u0007Q)\u0001\u0004eK2,G/\u001a\u000b\u0003E\u0016\u0004\"AJ2\n\u0005\u0011<#a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001d\"\u0001\r!R\u0001\u000eI\u0016dW\r^3JM\u0016k\u0007\u000f^=\u0015\u0005\tD\u0007\"\u0002(\n\u0001\u0004)\u0015a\u00047jgR$\u0015N]3di>\u0014\u0018.Z:\u0015\u0005-<\bc\u00017u\u000b:\u0011QN\u001d\b\u0003]Fl\u0011a\u001c\u0006\u0003a\u000e\na\u0001\u0010:p_Rt\u0014\"\u0001\u0015\n\u0005M<\u0013a\u00029bG.\fw-Z\u0005\u0003kZ\u0014A\u0001T5ti*\u00111o\n\u0005\u0006\u001d*\u0001\r!R\u0001\nY&\u001cHOR5mKN$\"a\u001b>\t\u000b9[\u0001\u0019A#\u0002\r\u0015D\u0018n\u001d;t)\t\u0011W\u0010C\u0003O\u0019\u0001\u0007Q)A\u0004dY\u0016\fg.\u001e9\u0015\u0007\t\f\t\u0001C\u0003O\u001b\u0001\u0007Q)A\u0005ve&\u001c6\r[3nKV\u0011\u0011q\u0001\t\u0005\u0003\u0013\t\tB\u0004\u0003\u0002\f\u00055\u0001C\u00018(\u0013\r\tyaJ\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0011Q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=q%\u0001\u0007hKRdunY1m!\u0006$\b\u000e\u0006\u0003\u0002\u001c\u0005-\u0002\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0005M&dWMC\u0002\u0002&%\u000b1A\\5p\u0013\u0011\tI#a\b\u0003\tA\u000bG\u000f\u001b\u0005\u0006\u001d>\u0001\r!R\u0001\u0010GJ,\u0017\r^3ESJ,7\r^8ssR!\u0011\u0011GA\u001c!\r1\u00131G\u0005\u0004\u0003k9#\u0001B+oSRDa!!\u000f\u0011\u0001\u0004)\u0015AB1qa\u0016tGM\u0001\u0007Ve&,\u0005\u0010^3og&|gn\u0005\u0002\u0012KQ!\u0011\u0011IA#!\r\t\u0019%E\u0007\u0002\u0001!)aj\u0005a\u0001\u000b\u0006Yq-\u001a;Gk2d\u0007+\u0019;i)\u0011\tY\"a\u0013\t\u000b]\"\u00029A\u001d\u0002/\u001d,G/\u00112t_2,H/\u001a)bi\"dunY1uS>tG\u0003BA\u0004\u0003#BQaN\u000bA\u0004e\nA\"\u0016:j\u000bb$XM\\:j_:$B!!\u0011\u0002X!)aJ\u0006a\u0001\u000b\u0006aA.[:u\u0007>tG/\u001a8ugR)1.!\u0018\u0002h!9\u0011qL\fA\u0002\u0005\u0005\u0014!\u00033je\u0016\u001cGo\u001c:z!\r\u0011\u00161M\u0005\u0004\u0003K\u001a&\u0001\u0002$jY\u0016Dq!!\u001b\u0018\u0001\u0004\tY'\u0001\bgS2,g.Y7f\r&dG/\u001a:\u0011\u0007I\u000bi'C\u0002\u0002pM\u0013aBR5mK:\fW.\u001a$jYR,'\u000f")
public class LocalStorage
implements Storage,
Logging {
    private final LocalStorageConfig config;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        LocalStorage localStorage = this;
        synchronized (localStorage) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public LocalStorageConfig config() {
        return this.config;
    }

    private LocalStorageConfig implicitConfig() {
        return this.config();
    }

    @Override
    public URI put(URI uri, InputStream data) {
        this.createDirectory(uri);
        File file = this.getLocalPath(uri).toFile();
        Using$.MODULE$.resource((Object)new FileOutputStream(file), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)LocalStorage.$anonfun$put$1(data, x$1)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return new URI(this.uriScheme(), null, this.UriExtension(uri).getFullPath(this.implicitConfig()).toUri().getPath(), null);
    }

    @Override
    public InputStream get(URI uri) {
        File file = this.getLocalPath(uri).toFile();
        return new BufferedInputStream(new FileInputStream(file));
    }

    @Override
    public long size(URI uri) {
        long l;
        try {
            Path path = this.getLocalPath(uri);
            l = Files.size(path);
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new FileNotFoundException("Unable to find file at '" + uri + "'");
        }
        catch (IOException e) {
            throw new IOException("Unable to find file size at '" + uri + "'", e);
        }
        return l;
    }

    @Override
    public boolean delete(URI uri) {
        boolean bl;
        File file = this.getLocalPath(uri).toFile();
        try {
            bl = FileSystemUtils.deleteRecursively((File)file);
        }
        catch (Exception ex) {
            this.logger().error((Function0 & Serializable)() -> "Unable to delete " + file.getName(), (Function0 & Serializable)() -> ex);
            throw ex;
        }
        return bl;
    }

    @Override
    public boolean deleteIfEmpty(URI uri) {
        File file = this.getLocalPath(uri).toFile();
        if (file.exists() && file.isDirectory() && ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])file.list()))) {
            return file.delete();
        }
        return false;
    }

    @Override
    public List<URI> listDirectories(URI uri) {
        File file = this.getLocalPath(uri).toFile();
        return this.listContents(file, (dir, name) -> new File(dir, name).isDirectory());
    }

    @Override
    public List<URI> listFiles(URI uri) {
        File file = this.getLocalPath(uri).toFile();
        return this.listContents(file, (dir, name) -> new File(dir, name).isFile());
    }

    @Override
    public boolean exists(URI uri) {
        File file = this.getLocalPath(uri).toFile();
        return file.isFile();
    }

    @Override
    public boolean cleanup(URI uri) {
        File dir = this.getLocalPath(uri).toFile();
        this.logger().trace((Function0 & Serializable)() -> "Clean directories under " + dir);
        if (dir.exists()) {
            return FileSystemUtils.deleteRecursively((File)dir);
        }
        return false;
    }

    @Override
    public String uriScheme() {
        return this.config().uriScheme();
    }

    public Path getLocalPath(URI uri) {
        URI fileUri = new URI(null, null, uri.getPath(), null);
        return this.UriExtension(fileUri).getFullPath(this.implicitConfig());
    }

    private void createDirectory(URI append) {
        File file;
        if (append != null) {
            Path path = this.getLocalPath(append);
            v0 = path.getParent().toFile();
        } else {
            v0 = file = new File(this.config().basePath().toUri());
        }
        if (!file.exists() && !file.mkdirs()) {
            if (!file.exists()) {
                throw new RuntimeException("Cannot create directory: " + file.getAbsolutePath());
            }
            return;
        }
    }

    private UriExtension UriExtension(URI uri) {
        return new UriExtension(this, uri);
    }

    private List<URI> listContents(File directory, FilenameFilter filenameFilter) {
        String uri = directory.toPath().toUri().toString();
        if (directory.isDirectory()) {
            List dirItems = Predef$.MODULE$.wrapRefArray((Object[])directory.list(filenameFilter)).toList();
            if (dirItems.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LocalStorage.$anonfun$listContents$1(x$2)))) {
                return ((List)dirItems.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)name -> URI.create(uri + name));
            }
            return ((List)dirItems.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$3)))).sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)name -> LocalStorage.$anonfun$listContents$5(uri, BoxesRunTime.unboxToLong((Object)name)));
        }
        return package$.MODULE$.List().empty();
    }

    public static final /* synthetic */ int $anonfun$put$1(InputStream data$1, FileOutputStream x$1) {
        return StreamUtils.copy((InputStream)data$1, (OutputStream)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$listContents$2(char x$1) {
        return Character.isDigit(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$listContents$1(String x$2) {
        return !StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(x$2), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LocalStorage.$anonfun$listContents$2(BoxesRunTime.unboxToChar((Object)x$1))));
    }

    public static final /* synthetic */ URI $anonfun$listContents$5(String uri$1, long name) {
        return URI.create(uri$1 + name);
    }

    public LocalStorage(LocalStorageConfig config) {
        this.config = config;
        Logging.$init$((Logging)this);
        this.createDirectory(null);
    }

    private class UriExtension {
        private final URI uri;
        public final /* synthetic */ LocalStorage $outer;

        public Path getFullPath(LocalStorageConfig config) {
            Path resolvedPath;
            String[] pathChunks = this.uri.getPath().split("/");
            Path path = this.uri.getPath().matches("^/[a-zA-Z]:.*") ? Paths.get("", pathChunks) : Paths.get("/", pathChunks);
            Path basePath = config.basePath().toAbsolutePath();
            Path path2 = resolvedPath = path.startsWith(basePath) ? path : Paths.get(((Object)basePath).toString(), ((Object)path).toString());
            if (!resolvedPath.normalize().startsWith(basePath)) {
                throw new IllegalArgumentException("Resolved path '" + resolvedPath + " for 'URI '" + this.uri + "' is outside of the base path '" + basePath + "'. '");
            }
            return resolvedPath;
        }

        public String getAbsolutePathLocation(LocalStorageConfig config) {
            return ((Object)this.getFullPath(config).toAbsolutePath()).toString();
        }

        public /* synthetic */ LocalStorage com$xebialabs$xlrelease$storage$local$LocalStorage$UriExtension$$$outer() {
            return this.$outer;
        }

        public UriExtension(LocalStorage $outer, URI uri) {
            this.uri = uri;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

