package com.xebialabs.xlrelease.storage

import java.io.InputStream
import java.net.URI
import java.nio.file.{Path, Paths}

trait Storage {
  def put(uri: URI, data: InputStream): URI

  def get(uri: URI): InputStream

  def listDirectories(uri: URI): List[URI]

  def listFiles(uri: URI): List[URI]

  def exists(uri: URI): Boolean

  def size(uri: URI): Long

  def delete(uri: URI): Boolean

  def deleteIfEmpty(uri: URI): Boolean

  def cleanup(uri: URI): Boolean

  def uriScheme: String
}

object Storage {
  def toPath(uri: URI): Path = {
    if (uri.getScheme.equalsIgnoreCase("file")) {
      // uri is valid filesystem path
      Paths.get(uri)
    } else {
      // get path without protocol just for filename extraction
      Paths.get(uri.getPath)
    }
  }
}