/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.storage.service;

import com.xebialabs.xlrelease.storage.Storage;
import com.xebialabs.xlrelease.storage.domain.StorageEntry;
import com.xebialabs.xlrelease.storage.domain.StorageEntryRef;
import com.xebialabs.xlrelease.storage.domain.StorageScheme;
import com.xebialabs.xlrelease.storage.service.StorageService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005Y4AAC\u0006\u0001-!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u00032\u0001\u0011\u0005!\u0007C\u00036\u0001\u0011%a\u0007C\u0003@\u0001\u0011\u0005\u0003\tC\u0003O\u0001\u0011\u0005s\nC\u0003\\\u0001\u0011\u0005C\fC\u0003k\u0001\u0011\u00053\u000eC\u0003n\u0001\u0011\u0005c\u000eC\u0003t\u0001\u0011\u0005COA\u000bEK\u001a\fW\u000f\u001c;Ti>\u0014\u0018mZ3TKJ4\u0018nY3\u000b\u00051i\u0011aB:feZL7-\u001a\u0006\u0003\u001d=\tqa\u001d;pe\u0006<WM\u0003\u0002\u0011#\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003%M\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003Q\t1aY8n\u0007\u0001\u0019B\u0001A\f\u001eCA\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0010\u000e\u0003-I!\u0001I\u0006\u0003\u001dM#xN]1hKN+'O^5dKB\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0006g24GG\u001b\u0006\u0002M\u0005AqM]5{u2,G-\u0003\u0002)G\t9Aj\\4hS:<\u0017\u0001C:u_J\fw-Z:\u0011\u0007aYS&\u0003\u0002-3\t)\u0011I\u001d:bsB\u0011afL\u0007\u0002\u001b%\u0011\u0001'\u0004\u0002\b'R|'/Y4f\u0003\u0019a\u0014N\\5u}Q\u00111\u0007\u000e\t\u0003=\u0001AQ!\u000b\u0002A\u0002)\n!bZ3u'R|'/Y4f)\tis\u0007C\u00039\u0007\u0001\u0007\u0011(A\u0007ti>\u0014\u0018mZ3TG\",W.\u001a\t\u0003uuj\u0011a\u000f\u0006\u0003y5\ta\u0001Z8nC&t\u0017B\u0001 <\u00055\u0019Fo\u001c:bO\u0016\u001c6\r[3nK\u0006)1\u000f^8sKR\u0011\u0011)\u0013\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000b1A\\3u\u0015\u00051\u0015\u0001\u00026bm\u0006L!\u0001S\"\u0003\u0007U\u0013\u0016\nC\u0003K\t\u0001\u00071*\u0001\u0007ti>\u0014\u0018mZ3F]R\u0014\u0018\u0010\u0005\u0002;\u0019&\u0011Qj\u000f\u0002\r'R|'/Y4f\u000b:$(/_\u0001\u0004O\u0016$HC\u0001)W!\t\tF+D\u0001S\u0015\t\u0019V)\u0001\u0002j_&\u0011QK\u0015\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003X\u000b\u0001\u0007\u0001,A\bti>\u0014\u0018mZ3F]R\u0014\u0018PU3g!\tQ\u0014,\u0003\u0002[w\ty1\u000b^8sC\u001e,WI\u001c;ssJ+g-A\bmSN$H)\u001b:fGR|'/[3t)\ti\u0016\u000eE\u0002_M\u0006s!a\u00183\u000f\u0005\u0001\u001cW\"A1\u000b\u0005\t,\u0012A\u0002\u001fs_>$h(C\u0001\u001b\u0013\t)\u0017$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dD'\u0001\u0002'jgRT!!Z\r\t\u000b]3\u0001\u0019\u0001-\u0002\u00131L7\u000f\u001e$jY\u0016\u001cHCA/m\u0011\u00159v\u00011\u0001Y\u0003\u0019!W\r\\3uKR\u0011qN\u001d\t\u00031AL!!]\r\u0003\u000f\t{w\u000e\\3b]\")q\u000b\u0003a\u00011\u0006iA-\u001a7fi\u0016Le-R7qif$\"a\\;\t\u000b]K\u0001\u0019\u0001-")
public class DefaultStorageService
implements StorageService,
Logging {
    private final Storage[] storages;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultStorageService defaultStorageService = this;
        synchronized (defaultStorageService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private Storage getStorage(StorageScheme storageScheme) {
        return (Storage)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])this.storages), (Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DefaultStorageService.$anonfun$getStorage$1(storageScheme, s))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Unable to find storage for entry " + storageScheme);
        });
    }

    @Override
    public URI store(StorageEntry storageEntry) {
        Storage storage = this.getStorage(storageEntry);
        URI entryUri = URI.create(storage.uriScheme() + "://" + storageEntry.uriPath());
        this.logger().trace((Function0 & Serializable)() -> "Storing log entry: " + storageEntry + " with uri " + entryUri);
        return (URI)Using$.MODULE$.apply((Function0 & Serializable)() -> storageEntry.content(), (Function1 & Serializable)is -> {
            URI storedUri = storage.put(entryUri, (InputStream)is);
            return storedUri;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).recoverWith((PartialFunction)new Serializable(null, storageEntry, entryUri){
            private static final long serialVersionUID = 0L;
            private final StorageEntry storageEntry$1;
            private final URI entryUri$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new RuntimeException("Unable to store log entry " + this.storageEntry$1 + " with uri " + this.entryUri$1, A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.storageEntry$1 = storageEntry$1;
                this.entryUri$1 = entryUri$1;
            }
        }).get();
    }

    @Override
    public InputStream get(StorageEntryRef storageEntryRef) {
        Storage storage = this.getStorage(storageEntryRef);
        return storage.get(storageEntryRef.uri());
    }

    @Override
    public List<URI> listDirectories(StorageEntryRef storageEntryRef) {
        Storage storage = this.getStorage(storageEntryRef);
        return storage.listDirectories(storageEntryRef.uri());
    }

    @Override
    public List<URI> listFiles(StorageEntryRef storageEntryRef) {
        Storage storage = this.getStorage(storageEntryRef);
        return storage.listFiles(storageEntryRef.uri());
    }

    @Override
    public boolean delete(StorageEntryRef storageEntryRef) {
        Storage storage = this.getStorage(storageEntryRef);
        return storage.delete(storageEntryRef.uri());
    }

    @Override
    public boolean deleteIfEmpty(StorageEntryRef storageEntryRef) {
        Storage storage = this.getStorage(storageEntryRef);
        return storage.deleteIfEmpty(storageEntryRef.uri());
    }

    public static final /* synthetic */ boolean $anonfun$getStorage$1(StorageScheme storageScheme$1, Storage s) {
        String string = s.uriScheme();
        String string2 = storageScheme$1.uriScheme();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DefaultStorageService(Storage[] storages) {
        this.storages = storages;
        Logging.$init$((Logging)this);
    }
}

