package com.xebialabs.xlrelease.storage.service

import com.xebialabs.xlrelease.storage.domain.{StorageEntry, StorageEntryRef}

import java.io.InputStream
import java.net.URI

trait StorageService {
  def store(storageEntry: StorageEntry): URI

  def get(storageEntryRef: StorageEntryRef): InputStream

  def listDirectories(storageEntryRef: StorageEntryRef): List[URI]

  def listFiles(storageEntryRef: StorageEntryRef): List[URI]

  def delete(storageEntryRef: StorageEntryRef): Boolean

  def deleteIfEmpty(storageEntryRef: StorageEntryRef): Boolean
}
