/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.storage.local;

import com.xebialabs.xlrelease.storage.Storage;
import com.xebialabs.xlrelease.storage.local.LocalStorageConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StreamUtils;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\te\u0001\u0011\t\u0011)A\u0005]!)1\u0007\u0001C\u0001i!)q\u0007\u0001C\u0006[!)\u0001\b\u0001C!s!)A\n\u0001C!\u001b\")q\n\u0001C!!\")Q\u000b\u0001C!-\")1\f\u0001C!9\")a\f\u0001C\u0005?\")Q\r\u0001C!M\u001a!!\u000fA\u0003t\u0011!\u0019EB!A!\u0002\u0013Q\u0004\"B\u001a\r\t\u0003!\b\"\u0002=\r\t\u0003I\bbBA\u0004\u0019\u0011\u0005\u0011\u0011\u0002\u0005\n\u0003\u001b\u0001\u0011\u0011!C\u0006\u0003\u001fAq!a\u0005\u0001\t\u0013\t)\u0002C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F\taAj\\2bYN#xN]1hK*\u0011q\u0003G\u0001\u0006Y>\u001c\u0017\r\u001c\u0006\u00033i\tqa\u001d;pe\u0006<WM\u0003\u0002\u001c9\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003;y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003}\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0011\u0011FK\u0007\u00021%\u00111\u0006\u0007\u0002\b'R|'/Y4f\u0003\u0019\u0019wN\u001c4jOV\ta\u0006\u0005\u00020a5\ta#\u0003\u00022-\t\u0011Bj\\2bYN#xN]1hK\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\na\u0001P5oSRtDCA\u001b7!\ty\u0003\u0001C\u0003-\u0007\u0001\u0007a&\u0001\bj[Bd\u0017nY5u\u0007>tg-[4\u0002\u0007A,H\u000fF\u0002;\u0005\u0012\u0003\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\u00079,GOC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$aA+S\u0013\")1)\u0002a\u0001u\u0005\u0019QO]5\t\u000b\u0015+\u0001\u0019\u0001$\u0002\t\u0011\fG/\u0019\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013z\n!![8\n\u0005-C%aC%oaV$8\u000b\u001e:fC6\f1aZ3u)\t1e\nC\u0003D\r\u0001\u0007!(\u0001\u0003tSj,GCA)U!\t\u0019#+\u0003\u0002TI\t!Aj\u001c8h\u0011\u0015\u0019u\u00011\u0001;\u0003\u0019!W\r\\3uKR\u0011qK\u0017\t\u0003GaK!!\u0017\u0013\u0003\u000f\t{w\u000e\\3b]\")1\t\u0003a\u0001u\u0005iA-\u001a7fi\u0016Le-R7qif$\"aV/\t\u000b\rK\u0001\u0019\u0001\u001e\u0002\u001f\r\u0014X-\u0019;f\t&\u0014Xm\u0019;pef$\"\u0001Y2\u0011\u0005\r\n\u0017B\u00012%\u0005\u0011)f.\u001b;\t\u000b\u0011T\u0001\u0019\u0001\u001e\u0002\r\u0005\u0004\b/\u001a8e\u0003%)(/[*dQ\u0016lW-F\u0001h!\tAwN\u0004\u0002j[B\u0011!\u000eJ\u0007\u0002W*\u0011A\u000eI\u0001\u0007yI|w\u000e\u001e \n\u00059$\u0013A\u0002)sK\u0012,g-\u0003\u0002qc\n11\u000b\u001e:j]\u001eT!A\u001c\u0013\u0003\u0019U\u0013\u0018.\u0012=uK:\u001c\u0018n\u001c8\u0014\u00051\u0011CCA;x!\t1H\"D\u0001\u0001\u0011\u0015\u0019e\u00021\u0001;\u0003-9W\r\u001e$vY2\u0004\u0016\r\u001e5\u0015\u0007i\f)\u0001E\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\fAAZ5mK*\u0011qPP\u0001\u0004]&|\u0017bAA\u0002y\n!\u0001+\u0019;i\u0011\u0015as\u0002q\u0001/\u0003]9W\r^!cg>dW\u000f^3QCRDGj\\2bi&|g\u000eF\u0002h\u0003\u0017AQ\u0001\f\tA\u00049\nA\"\u0016:j\u000bb$XM\\:j_:$2!^A\t\u0011\u0015\u0019\u0015\u00031\u0001;\u00031a\u0017n\u001d;D_:$XM\u001c;t)\u0019\t9\"!\u000b\u00024A)\u0011\u0011DA\u0012u9!\u00111DA\u0010\u001d\rQ\u0017QD\u0005\u0002K%\u0019\u0011\u0011\u0005\u0013\u0002\u000fA\f7m[1hK&!\u0011QEA\u0014\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u0005B\u0005C\u0004\u0002,I\u0001\r!!\f\u0002\u0013\u0011L'/Z2u_JL\bcA$\u00020%\u0019\u0011\u0011\u0007%\u0003\t\u0019KG.\u001a\u0005\b\u0003k\u0011\u0002\u0019AA\u001c\u000391\u0017\u000e\\3oC6,g)\u001b7uKJ\u00042aRA\u001d\u0013\r\tY\u0004\u0013\u0002\u000f\r&dWM\\1nK\u001aKG\u000e^3s\u0003=a\u0017n\u001d;ESJ,7\r^8sS\u0016\u001cH\u0003BA\f\u0003\u0003BQaQ\nA\u0002i\n\u0011\u0002\\5ti\u001aKG.Z:\u0015\t\u0005]\u0011q\t\u0005\u0006\u0007R\u0001\rA\u000f")
public class LocalStorage
implements Storage {
    private final LocalStorageConfig config;

    public LocalStorageConfig config() {
        return this.config;
    }

    private LocalStorageConfig implicitConfig() {
        return this.config();
    }

    @Override
    public URI put(URI uri, InputStream data) {
        this.createDirectory(uri);
        Using$.MODULE$.resource((Object)new FileOutputStream(this.UriExtension(uri).getFullPath(this.implicitConfig()).toFile()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)LocalStorage.$anonfun$put$1(data, x$1)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return URI.create(this.uriScheme() + "://" + uri.getPath());
    }

    @Override
    public InputStream get(URI uri) {
        return new BufferedInputStream(new FileInputStream(this.UriExtension(URI.create(uri.getPath())).getAbsolutePathLocation(this.implicitConfig())));
    }

    @Override
    public long size(URI uri) {
        long l;
        try {
            l = Files.size(this.UriExtension(URI.create(uri.getPath())).getFullPath(this.implicitConfig()));
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new FileNotFoundException("Unable to find file at '" + uri + "'");
        }
        catch (IOException e) {
            throw new IOException("Unable to find file size at '" + uri + "'", e);
        }
        return l;
    }

    @Override
    public boolean delete(URI uri) {
        File file = this.UriExtension(URI.create(uri.getPath())).getFullPath(this.implicitConfig()).toFile();
        return FileSystemUtils.deleteRecursively((File)file);
    }

    @Override
    public boolean deleteIfEmpty(URI uri) {
        File file = this.UriExtension(URI.create(uri.getPath())).getFullPath(this.implicitConfig()).toFile();
        if (file.exists() && file.isDirectory() && ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])file.list()))) {
            return file.delete();
        }
        return false;
    }

    private void createDirectory(URI append) {
        File file;
        File file2;
        if (append != null) {
            Path path = Paths.get(((Object)this.config().basePath().toAbsolutePath()).toString(), append.getPath());
            file2 = path.getParent().toFile();
        } else {
            file2 = file = new File(this.config().basePath().toUri());
        }
        if (!file.exists() && !file.mkdirs()) {
            if (!file.exists()) {
                throw new RuntimeException("Cannot create directory: " + file.getAbsolutePath());
            }
            return;
        }
    }

    @Override
    public String uriScheme() {
        return this.config().uriScheme();
    }

    private UriExtension UriExtension(URI uri) {
        return new UriExtension(this, uri);
    }

    private List<URI> listContents(File directory, FilenameFilter filenameFilter) {
        String uri = directory.toPath().toUri().toString();
        if (directory.isDirectory()) {
            List dirItems = Predef$.MODULE$.wrapRefArray((Object[])directory.list(filenameFilter)).toList();
            if (dirItems.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LocalStorage.$anonfun$listContents$1(x$2)))) {
                return ((List)dirItems.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)name -> URI.create(uri + name));
            }
            return ((List)dirItems.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$3)))).sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)name -> LocalStorage.$anonfun$listContents$5(uri, BoxesRunTime.unboxToLong((Object)name)));
        }
        return package$.MODULE$.List().empty();
    }

    @Override
    public List<URI> listDirectories(URI uri) {
        File file = this.UriExtension(URI.create(uri.getPath())).getFullPath(this.implicitConfig()).toFile();
        return this.listContents(file, (dir, name) -> new File(dir, name).isDirectory());
    }

    @Override
    public List<URI> listFiles(URI uri) {
        File file = this.UriExtension(URI.create(uri.getPath())).getFullPath(this.implicitConfig()).toFile();
        return this.listContents(file, (dir, name) -> new File(dir, name).isFile());
    }

    public static final /* synthetic */ int $anonfun$put$1(InputStream data$1, FileOutputStream x$1) {
        return StreamUtils.copy((InputStream)data$1, (OutputStream)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$listContents$2(char x$1) {
        return Character.isDigit(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$listContents$1(String x$2) {
        return !StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(x$2), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LocalStorage.$anonfun$listContents$2(BoxesRunTime.unboxToChar((Object)x$1))));
    }

    public static final /* synthetic */ URI $anonfun$listContents$5(String uri$1, long name) {
        return URI.create(uri$1 + name);
    }

    public LocalStorage(LocalStorageConfig config) {
        this.config = config;
        this.createDirectory(null);
    }

    private class UriExtension {
        private final URI uri;
        public final /* synthetic */ LocalStorage $outer;

        public Path getFullPath(LocalStorageConfig config) {
            Path path;
            String[] pathChunks = this.uri.getPath().split("/");
            Path path2 = path = this.uri.getPath().matches("^/[a-zA-Z]:.*") ? Paths.get("", pathChunks) : Paths.get("/", pathChunks);
            if (path.startsWith(((Object)config.basePath().toAbsolutePath()).toString())) {
                return path;
            }
            return Paths.get(((Object)config.basePath().toAbsolutePath()).toString(), ((Object)path).toString());
        }

        public String getAbsolutePathLocation(LocalStorageConfig config) {
            return ((Object)this.getFullPath(config).toAbsolutePath()).toString();
        }

        public /* synthetic */ LocalStorage com$xebialabs$xlrelease$storage$local$LocalStorage$UriExtension$$$outer() {
            return this.$outer;
        }

        public UriExtension(LocalStorage $outer, URI uri) {
            this.uri = uri;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

