/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.storage.local;

import com.xebialabs.xlrelease.storage.Storage;
import com.xebialabs.xlrelease.storage.local.LocalStorageConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.util.StreamUtils;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tc\u0001\u0011\t\u0011)A\u0005[!)!\u0007\u0001C\u0001g!)a\u0007\u0001C\u0006Y!)q\u0007\u0001C!q!)1\n\u0001C!\u0019\")a\n\u0001C!\u001f\")A\u000b\u0001C!+\")!\f\u0001C\u00057\")\u0011\r\u0001C!E\u001a!a\u000eA\u0003p\u0011!\u00115B!A!\u0002\u0013I\u0004\"\u0002\u001a\f\t\u0003\u0001\b\"\u0002;\f\t\u0003)\bBB@\f\t\u0003\t\t\u0001C\u0005\u0002\u0006\u0001\t\t\u0011b\u0003\u0002\b!9\u00111\u0002\u0001\u0005\n\u00055\u0001bBA\u001b\u0001\u0011\u0005\u0013q\u0007\u0005\b\u0003w\u0001A\u0011IA\u001f\u00051aunY1m'R|'/Y4f\u0015\t1r#A\u0003m_\u000e\fGN\u0003\u0002\u00193\u000591\u000f^8sC\u001e,'B\u0001\u000e\u001c\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001d;\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002=\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tA\u0013&D\u0001\u0018\u0013\tQsCA\u0004Ti>\u0014\u0018mZ3\u0002\r\r|gNZ5h+\u0005i\u0003C\u0001\u00180\u001b\u0005)\u0012B\u0001\u0019\u0016\u0005IaunY1m'R|'/Y4f\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u00051A(\u001b8jiz\"\"\u0001N\u001b\u0011\u00059\u0002\u0001\"B\u0016\u0004\u0001\u0004i\u0013AD5na2L7-\u001b;D_:4\u0017nZ\u0001\u0004aV$HcA\u001dB\u0007B\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0004]\u0016$(\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u00121!\u0016*J\u0011\u0015\u0011U\u00011\u0001:\u0003\r)(/\u001b\u0005\u0006\t\u0016\u0001\r!R\u0001\u0005I\u0006$\u0018\r\u0005\u0002G\u00136\tqI\u0003\u0002I{\u0005\u0011\u0011n\\\u0005\u0003\u0015\u001e\u00131\"\u00138qkR\u001cFO]3b[\u0006\u0019q-\u001a;\u0015\u0005\u0015k\u0005\"\u0002\"\u0007\u0001\u0004I\u0014\u0001B:ju\u0016$\"\u0001U*\u0011\u0005\t\n\u0016B\u0001*$\u0005\u0011auN\\4\t\u000b\t;\u0001\u0019A\u001d\u0002\r\u0011,G.\u001a;f)\t1\u0016\f\u0005\u0002#/&\u0011\u0001l\t\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011\u0005\u00021\u0001:\u0003=\u0019'/Z1uK\u0012K'/Z2u_JLHC\u0001/`!\t\u0011S,\u0003\u0002_G\t!QK\\5u\u0011\u0015\u0001\u0017\u00021\u0001:\u0003\u0019\t\u0007\u000f]3oI\u0006IQO]5TG\",W.Z\u000b\u0002GB\u0011Am\u001b\b\u0003K&\u0004\"AZ\u0012\u000e\u0003\u001dT!\u0001[\u0010\u0002\rq\u0012xn\u001c;?\u0013\tQ7%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016$\u00051)&/[#yi\u0016t7/[8o'\tY\u0011\u0005\u0006\u0002rgB\u0011!oC\u0007\u0002\u0001!)!)\u0004a\u0001s\u0005Yq-\u001a;Gk2d\u0007+\u0019;i)\t1h\u0010\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006!a-\u001b7f\u0015\tYX(A\u0002oS>L!! =\u0003\tA\u000bG\u000f\u001b\u0005\u0006W9\u0001\u001d!L\u0001\u0018O\u0016$\u0018IY:pYV$X\rU1uQ2{7-\u0019;j_:$2aYA\u0002\u0011\u0015Ys\u0002q\u0001.\u00031)&/[#yi\u0016t7/[8o)\r\t\u0018\u0011\u0002\u0005\u0006\u0005B\u0001\r!O\u0001\rY&\u001cHoQ8oi\u0016tGo\u001d\u000b\u0007\u0003\u001f\t\t#a\u000b\u0011\u000b\u0005E\u00111D\u001d\u000f\t\u0005M\u0011q\u0003\b\u0004M\u0006U\u0011\"\u0001\u0013\n\u0007\u0005e1%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0011q\u0004\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u001a\rBq!a\t\u0012\u0001\u0004\t)#A\u0005eSJ,7\r^8ssB\u0019a)a\n\n\u0007\u0005%rI\u0001\u0003GS2,\u0007bBA\u0017#\u0001\u0007\u0011qF\u0001\u000fM&dWM\\1nK\u001aKG\u000e^3s!\r1\u0015\u0011G\u0005\u0004\u0003g9%A\u0004$jY\u0016t\u0017-\\3GS2$XM]\u0001\u0010Y&\u001cH\u000fR5sK\u000e$xN]5fgR!\u0011qBA\u001d\u0011\u0015\u0011%\u00031\u0001:\u0003%a\u0017n\u001d;GS2,7\u000f\u0006\u0003\u0002\u0010\u0005}\u0002\"\u0002\"\u0014\u0001\u0004I\u0004")
public class LocalStorage
implements Storage {
    private final LocalStorageConfig config;

    public LocalStorageConfig config() {
        return this.config;
    }

    private LocalStorageConfig implicitConfig() {
        return this.config();
    }

    @Override
    public URI put(URI uri, InputStream data) {
        this.createDirectory(uri);
        Using$.MODULE$.resource((Object)new FileOutputStream(this.UriExtension(uri).getFullPath(this.implicitConfig()).toFile()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)LocalStorage.$anonfun$put$1(data, x$1)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return URI.create(new StringBuilder(3).append(this.uriScheme()).append("://").append(uri.getPath()).toString());
    }

    @Override
    public InputStream get(URI uri) {
        return new BufferedInputStream(new FileInputStream(this.UriExtension(URI.create(uri.getPath())).getAbsolutePathLocation(this.implicitConfig())));
    }

    @Override
    public long size(URI uri) {
        long l;
        try {
            l = Files.size(this.UriExtension(URI.create(uri.getPath())).getFullPath(this.implicitConfig()));
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new FileNotFoundException(new StringBuilder(25).append("Unable to find file at '").append(uri).append("'").toString());
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(30).append("Unable to find file size at '").append(uri).append("'").toString(), e);
        }
        return l;
    }

    @Override
    public boolean delete(URI uri) {
        File file = this.UriExtension(URI.create(uri.getPath())).getFullPath(this.implicitConfig()).toFile();
        return file.exists() && file.delete();
    }

    private void createDirectory(URI append) {
        File file;
        File file2;
        if (append != null) {
            Path path = Paths.get(((Object)this.config().basePath().toAbsolutePath()).toString(), append.getPath());
            file2 = path.getParent().toFile();
        } else {
            file2 = file = new File(this.config().basePath().toUri());
        }
        if (!(file.exists() || file.mkdirs() || file.exists())) {
            throw new RuntimeException(new StringBuilder(25).append("Cannot create directory: ").append(file.getAbsolutePath()).toString());
        }
    }

    @Override
    public String uriScheme() {
        return this.config().uriScheme();
    }

    private UriExtension UriExtension(URI uri) {
        return new UriExtension(this, uri);
    }

    private List<URI> listContents(File directory, FilenameFilter filenameFilter) {
        List dirItems;
        String path = directory.getPath();
        return directory.isDirectory() ? ((dirItems = Predef$.MODULE$.wrapRefArray((Object[])directory.list(filenameFilter)).toList()).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LocalStorage.$anonfun$listContents$1(x$2))) ? ((List)dirItems.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)name -> URI.create(new StringBuilder(4).append(this.uriScheme()).append("://").append(path).append("/").append((String)name).toString())) : ((List)dirItems.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$3)))).sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)name -> LocalStorage.$anonfun$listContents$5(this, path, BoxesRunTime.unboxToLong((Object)name)))) : package$.MODULE$.List().empty();
    }

    @Override
    public List<URI> listDirectories(URI uri) {
        File file = this.UriExtension(URI.create(uri.getPath())).getFullPath(this.implicitConfig()).toFile();
        return this.listContents(file, (dir, name) -> new File(dir, name).isDirectory());
    }

    @Override
    public List<URI> listFiles(URI uri) {
        File file = this.UriExtension(URI.create(uri.getPath())).getFullPath(this.implicitConfig()).toFile();
        return this.listContents(file, (dir, name) -> new File(dir, name).isFile());
    }

    public static final /* synthetic */ int $anonfun$put$1(InputStream data$1, FileOutputStream x$1) {
        return StreamUtils.copy((InputStream)data$1, (OutputStream)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$listContents$2(char x$1) {
        return Character.isDigit(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$listContents$1(String x$2) {
        return !StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(x$2), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LocalStorage.$anonfun$listContents$2(BoxesRunTime.unboxToChar((Object)x$1))));
    }

    public static final /* synthetic */ URI $anonfun$listContents$5(LocalStorage $this, String path$1, long name) {
        return URI.create(new StringBuilder(4).append($this.uriScheme()).append("://").append(path$1).append("/").append(name).toString());
    }

    public LocalStorage(LocalStorageConfig config) {
        this.config = config;
        this.createDirectory(null);
    }

    private class UriExtension {
        private final URI uri;
        public final /* synthetic */ LocalStorage $outer;

        public Path getFullPath(LocalStorageConfig config) {
            return this.uri.getPath().startsWith(((Object)config.basePath().toAbsolutePath()).toString()) ? Paths.get(this.uri.getPath(), new String[0]) : Paths.get(((Object)config.basePath().toAbsolutePath()).toString(), this.uri.getPath());
        }

        public String getAbsolutePathLocation(LocalStorageConfig config) {
            return ((Object)this.getFullPath(config).toAbsolutePath()).toString();
        }

        public /* synthetic */ LocalStorage com$xebialabs$xlrelease$storage$local$LocalStorage$UriExtension$$$outer() {
            return this.$outer;
        }

        public UriExtension(LocalStorage $outer, URI uri) {
            this.uri = uri;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

