/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.ExecutionOutputWriter;
import com.xebialabs.deployit.plumbing.PollingExecutionOutputHandler;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.platform.script.jython.JythonSupport$;
import com.xebialabs.platform.script.jython.ThreadLocalWriterDecorator;
import com.xebialabs.xlrelease.api.internal.ReleaseServerUrlDecorator;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.recover.TaskRecoverOp;
import com.xebialabs.xlrelease.domain.variables.ScriptValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.script.AwaitFacetCheckResult;
import com.xebialabs.xlrelease.script.CustomScriptTaskResult;
import com.xebialabs.xlrelease.script.EncryptionHelper;
import com.xebialabs.xlrelease.script.ExceptionPreconditionResult;
import com.xebialabs.xlrelease.script.FacetCheckResult;
import com.xebialabs.xlrelease.script.FailureCustomScriptTaskResult;
import com.xebialabs.xlrelease.script.FailureFacetCheckResult;
import com.xebialabs.xlrelease.script.FailureFailureHandlerResult;
import com.xebialabs.xlrelease.script.FailureHandlerResult;
import com.xebialabs.xlrelease.script.FailureScriptTaskResult;
import com.xebialabs.xlrelease.script.InvalidPreconditionResult;
import com.xebialabs.xlrelease.script.OutputHandler;
import com.xebialabs.xlrelease.script.PreconditionResult;
import com.xebialabs.xlrelease.script.RestartCustomScriptTaskResult;
import com.xebialabs.xlrelease.script.RestartScriptTaskResult;
import com.xebialabs.xlrelease.script.ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.script.ScriptServiceHelper;
import com.xebialabs.xlrelease.script.ScriptTaskResult;
import com.xebialabs.xlrelease.script.ScriptVariables;
import com.xebialabs.xlrelease.script.SuccessCustomScriptTaskResult;
import com.xebialabs.xlrelease.script.SuccessFacetCheckResult;
import com.xebialabs.xlrelease.script.SuccessFailureHandlerResult;
import com.xebialabs.xlrelease.script.SuccessScriptTaskResult;
import com.xebialabs.xlrelease.script.TruncatingCommentUpdater;
import com.xebialabs.xlrelease.script.ValidPreconditionResult;
import com.xebialabs.xlrelease.script.VariablesHolderForScriptContext;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.RestartPhasesException;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.python.core.PyException;
import org.python.core.PyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StreamUtils;
import scala.Option;

public abstract class DefaultScriptService
implements ScriptService {
    private static final String MDC_KEY_TASK = "task";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScriptVariables scriptVariables;
    protected Scheduler scheduler;
    protected ScriptLifeCycle scriptLifeCycle;
    protected ScriptExecutor scriptExecutor;
    protected ThreadLocalWriterDecorator executionLog = JythonSupport$.MODULE$.outWriterDecorator();
    protected AuthenticationService authenticationService;
    private ReleaseService releaseService;
    protected PermissionChecker permissions;
    protected CommentService commentService;
    protected XlrConfig xlrConfig;
    protected TaskRepository taskRepository;
    protected ServerConfiguration serverConfiguration;
    private AttachmentService attachmentService;

    protected DefaultScriptService(Scheduler scheduler, ScriptLifeCycle scriptLifeCycle, ScriptExecutor scriptExecutor, AuthenticationService authenticationService, ReleaseService releaseService, ScriptVariables scriptVariables, PermissionChecker permissions, CommentService commentService, XlrConfig xlrConfig, TaskRepository taskRepository, ServerConfiguration serverConfiguration, AttachmentService attachmentService) {
        this.scheduler = scheduler;
        this.scriptLifeCycle = scriptLifeCycle;
        this.scriptExecutor = scriptExecutor;
        this.authenticationService = authenticationService;
        this.releaseService = releaseService;
        this.permissions = permissions;
        this.commentService = commentService;
        this.xlrConfig = xlrConfig;
        this.taskRepository = taskRepository;
        this.scriptVariables = scriptVariables;
        this.serverConfiguration = serverConfiguration;
        this.attachmentService = attachmentService;
    }

    @Override
    public CompletableFuture<ScriptTaskResult> executeScriptTask(ResolvableScriptTask task, SensitiveValueScrubber scrubber) {
        this.scriptLifeCycle.register(task.getExecutionId());
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        return this.scheduler.supplyAsync(() -> {
            this.registerWriterForTask((Task)task, scrubber);
            VariablesHolderForScriptContext variablesHolderForScriptContext = new VariablesHolderForScriptContext(this.scriptVariables.initialReleaseVariables(task.getRelease()), this.scriptVariables.initialFolderVariable(task.getRelease().findFolderId()), this.scriptVariables.initialGlobalVariables(), this.variablesSynchronizationCallback((Task)task));
            try {
                this.authenticationService.loginScriptUser((Task)task, variablesHolderForScriptContext);
                XlrScriptContext scriptContext = this.prepareScriptTaskContext((Task)task, (Writer)this.executionLog, this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousGlobalVariables()), this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousFolderVariables()), this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousReleaseVariables()));
                variablesHolderForScriptContext.setScriptContext(scriptContext);
                this.executeScript(task.getScript(), scriptContext, (Task)task, true);
                SuccessScriptTaskResult successScriptTaskResult = new SuccessScriptTaskResult(taskId, executionId, this.executionLog.toString(), this.getAttachmentIdFromExecutionLog(this.executionLog), variablesHolderForScriptContext.createScriptTaskResults(), this.getCurrentAuthentication());
                return successScriptTaskResult;
            }
            catch (ScriptException exception) {
                ScriptTaskResults scriptTaskResults = variablesHolderForScriptContext.createScriptTaskResults();
                try {
                    if (this.isSystemExit0(exception)) {
                        SuccessScriptTaskResult successScriptTaskResult = new SuccessScriptTaskResult(taskId, executionId, this.executionLog.toString(), this.getAttachmentIdFromExecutionLog(this.executionLog), scriptTaskResults, this.getCurrentAuthentication());
                        return successScriptTaskResult;
                    }
                    if (this.isRestartPhasesException(exception)) {
                        ScriptTaskResult scriptTaskResult = this.onRestartPhasesException((RestartPhasesException)((Object)((Object)ExceptionUtils.getRootCause((Throwable)exception))), this.executionLog, (BaseScriptTask)task, scriptTaskResults);
                        return scriptTaskResult;
                    }
                    FailureScriptTaskResult failureScriptTaskResult = this.onScriptTaskException(exception.getMessage(), exception, executionId, this.executionLog, scriptTaskResults, taskId);
                    return failureScriptTaskResult;
                }
                catch (Exception resultsException) {
                    FailureScriptTaskResult failureScriptTaskResult = this.onScriptTaskException("Exception saving script results of script task '{}':", resultsException, executionId, this.executionLog, scriptTaskResults, taskId);
                    return failureScriptTaskResult;
                }
            }
            catch (Exception exception) {
                FailureScriptTaskResult failureScriptTaskResult = this.onScriptTaskException("Unexpected exception during execution of script task '{}':", exception, executionId, this.executionLog, null, taskId);
                return failureScriptTaskResult;
            }
            finally {
                this.closeWriter();
                this.authenticationService.logoutScriptUser();
                this.finishScript(task.getExecutionId());
            }
        });
    }

    @Override
    public CompletableFuture<CustomScriptTaskResult> executeCustomScriptTask(CustomScriptTask task, SensitiveValueScrubber scrubber) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.fixVariableMapping(task);
        return this.scheduler.supplyAsync(() -> {
            String script;
            this.registerWriterForTask((Task)task, scrubber);
            String taskId = task.getId();
            String executionId = task.getExecutionId();
            try {
                script = task.isAbortScriptInProgress() ? task.getPythonScript().getAbortScript() : task.getPythonScript().getScript();
            }
            catch (IOException exception) {
                this.addExceptionToExecutionLog(exception, this.executionLog, "Error while loading script on task '{}':", taskId);
                FailureCustomScriptTaskResult result = new FailureCustomScriptTaskResult(taskId, executionId, this.executionLog.toString(), this.getAttachmentIdFromExecutionLog(this.executionLog), this.getCurrentAuthentication());
                this.finishScript(executionId);
                return result;
            }
            XlrScriptContext scriptContext = null;
            try {
                scriptContext = this.prepareCustomScriptTaskContext(task, (Writer)this.executionLog);
                this.doExecuteScript(task, scriptContext, script);
                CustomScriptTaskResults customScriptTaskResults = this.createCustomScriptTaskResults(task, scrubber, scriptContext);
                SuccessCustomScriptTaskResult successCustomScriptTaskResult = new SuccessCustomScriptTaskResult(taskId, executionId, this.executionLog.toString(), this.getAttachmentIdFromExecutionLog(this.executionLog), customScriptTaskResults, this.getCurrentAuthentication());
                return successCustomScriptTaskResult;
            }
            catch (ScriptException exception) {
                try {
                    if (this.isSystemExit0(exception)) {
                        CustomScriptTaskResults customScriptTaskResults = this.createCustomScriptTaskResults(task, scrubber, scriptContext);
                        SuccessCustomScriptTaskResult successCustomScriptTaskResult = new SuccessCustomScriptTaskResult(taskId, executionId, this.executionLog.toString(), this.getAttachmentIdFromExecutionLog(this.executionLog), customScriptTaskResults, this.getCurrentAuthentication());
                        return successCustomScriptTaskResult;
                    }
                    if (this.isRestartPhasesException(exception)) {
                        CustomScriptTaskResult customScriptTaskResults = this.onRestartPhasesExceptionCustomScript((RestartPhasesException)((Object)((Object)ExceptionUtils.getRootCause((Throwable)exception))), this.executionLog, (BaseScriptTask)task);
                        return customScriptTaskResults;
                    }
                    FailureCustomScriptTaskResult customScriptTaskResults = this.onCustomScriptException(exception.getMessage(), exception, executionId, this.executionLog, taskId);
                    return customScriptTaskResults;
                }
                catch (Exception resultsException) {
                    FailureCustomScriptTaskResult failureCustomScriptTaskResult = this.onCustomScriptException("Exception saving script results of custom script task '{}':", resultsException, executionId, this.executionLog, taskId);
                    return failureCustomScriptTaskResult;
                }
            }
            catch (Exception exception) {
                FailureCustomScriptTaskResult failureCustomScriptTaskResult = this.onCustomScriptException("Unexpected exception during execution of task '{}':", exception, executionId, this.executionLog, taskId);
                return failureCustomScriptTaskResult;
            }
            finally {
                this.closeWriter();
                this.authenticationService.logoutScriptUser();
                this.finishScript(executionId);
            }
        });
    }

    private CustomScriptTaskResults createCustomScriptTaskResults(CustomScriptTask task, SensitiveValueScrubber scrubber, XlrScriptContext scriptContext) {
        return new CustomScriptTaskResults(ScriptServiceHelper.extractTransitionalAndOutputPropertyValues(task, scriptContext, scrubber), task.getExecutionId(), task.getStatusLine(), task.getNextScriptPath(), task.getInterval());
    }

    private void finishScript(String executionId) {
        this.removeWriter();
        this.scriptLifeCycle.unregister(executionId);
    }

    private void fixVariableMapping(CustomScriptTask task) {
        Collection outputProperties = task.getPythonScript().getOutputProperties();
        boolean updated = false;
        for (PropertyDescriptor propertyDescriptor : outputProperties) {
            String propertyName = propertyDescriptor.getName();
            String fqPropertyName = "pythonScript." + propertyName;
            Object propertyValue = task.getPythonScript().getProperty(propertyName);
            if (!(propertyValue instanceof String) || !VariableHelper.containsOnlyVariable((String)((String)propertyValue)) || task.getVariableMapping().containsKey(fqPropertyName)) continue;
            this.logger.debug("adding variable pre 5.0 [{}] with value [{}]", (Object)fqPropertyName, propertyValue);
            task.getVariableMapping().put(fqPropertyName, (String)propertyValue);
            updated = true;
        }
        if (updated) {
            this.taskRepository.update((Task)task);
        }
    }

    @Override
    public Object executeScript(String script, XlrScriptContext scriptContext) {
        scriptContext.setWriter((Writer)this.executionLog);
        return this.executeScriptWithWriter(script, scriptContext, false, false);
    }

    public Object executeScriptWithWriter(String script, XlrScriptContext scriptContext) {
        return this.executeScriptWithWriter(script, scriptContext, false, false);
    }

    /*
     * Exception decompiling
     */
    public Object executeScriptWithWriter(String script, XlrScriptContext scriptContext, boolean checkPolicyPermissions, boolean withApi) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public CompletableFuture<PreconditionResult> executePrecondition(Task task) {
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        this.scriptLifeCycle.register(executionId);
        return this.scheduler.supplyAsync(() -> {
            this.registerWriterForTask(task, SensitiveValueScrubber.disabled());
            String script = task.getPrecondition();
            try {
                this.authenticationService.loginScriptUser(task);
                XlrScriptContext scriptContext = this.prepareScriptTaskContext(task, (Writer)this.executionLog);
                Object statementResult = this.executeScript(script, scriptContext, task, true);
                Object resultVariable = scriptContext.getAttribute("result");
                if (statementResult == null && resultVariable == null) {
                    this.executionLog.append((CharSequence)"Precondition did not return anything\n");
                    ExceptionPreconditionResult exceptionPreconditionResult = new ExceptionPreconditionResult(taskId, executionId, this.executionLog.toString(), (Option<String>)Option.empty(), this.getCurrentAuthentication());
                    return exceptionPreconditionResult;
                }
                if (this.isTrue(statementResult) || this.isTrue(resultVariable)) {
                    this.executionLog.append((CharSequence)"Precondition is valid (returned True)\n");
                    ValidPreconditionResult validPreconditionResult = new ValidPreconditionResult(taskId, executionId, this.executionLog.toString(), (Option<String>)Option.empty(), this.getCurrentAuthentication());
                    return validPreconditionResult;
                }
                this.executionLog.append((CharSequence)"Precondition is invalid (returned a value that is not True)\n");
                InvalidPreconditionResult invalidPreconditionResult = new InvalidPreconditionResult(taskId, executionId, this.executionLog.toString(), (Option<String>)Option.empty(), this.getCurrentAuthentication());
                return invalidPreconditionResult;
            }
            catch (Exception exception) {
                this.addExceptionToExecutionLog(exception, this.executionLog, "Unexpected exception during precondition check of script task '{}':", taskId);
                ExceptionPreconditionResult exceptionPreconditionResult = new ExceptionPreconditionResult(taskId, executionId, this.executionLog.toString(), this.getAttachmentIdFromExecutionLog(this.executionLog), this.getCurrentAuthentication());
                return exceptionPreconditionResult;
            }
            finally {
                this.closeWriter();
                this.authenticationService.logoutScriptUser();
                this.finishScript(executionId);
            }
        });
    }

    @Override
    public CompletableFuture<FacetCheckResult> executeFacetCheck(Task task) {
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        this.scriptLifeCycle.register(executionId);
        return this.scheduler.supplyAsync(() -> {
            this.registerWriterForTask(task, SensitiveValueScrubber.disabled());
            try {
                Object object;
                List facetsWithScript = task.getFacets().stream().filter(f -> f.hasProperty("scriptLocation")).collect(Collectors.toList());
                boolean executeSuccessful = false;
                Date nextDate = null;
                for (Facet facetWithScript : facetsWithScript) {
                    String script = ScriptHelper.getScript((ConfigurationItem)facetWithScript);
                    this.authenticationService.loginScriptUser(task);
                    XlrScriptContext scriptContext = this.prepareScriptTaskContext(task, (Writer)this.executionLog);
                    scriptContext.setAttribute("currentFacet", facetWithScript, 100);
                    Object statementResult = this.executeScript(script, scriptContext, task, true);
                    Object resultVariable = scriptContext.getAttribute("result");
                    if (statementResult == null && resultVariable == null) {
                        this.executionLog.append((CharSequence)"Environment is not available: script did not return anything\n");
                        executeSuccessful = false;
                        break;
                    }
                    if (this.isTrue(statementResult) || this.isTrue(resultVariable)) {
                        executeSuccessful = true;
                        continue;
                    }
                    if (this.isDate(statementResult) || this.isDate(resultVariable)) {
                        executeSuccessful = true;
                        nextDate = this.pickNearestDate(nextDate, statementResult, resultVariable);
                        continue;
                    }
                    this.executionLog.append((CharSequence)"Environment is not available: script returned a value that is not True\n");
                    executeSuccessful = false;
                    break;
                }
                if (executeSuccessful) {
                    if (nextDate == null || nextDate.before(new Date())) {
                        this.executionLog.append((CharSequence)"Environment is available: script is valid (returned True or date that is in the past)\n");
                        object = new SuccessFacetCheckResult(taskId, executionId, this.executionLog.toString(), (Option<String>)Option.empty(), this.getCurrentAuthentication());
                        return object;
                    }
                    this.executionLog.append((CharSequence)String.format("Environment(s) are going to be available at %s\n", nextDate.toString()));
                    object = new AwaitFacetCheckResult(taskId, executionId, this.executionLog.toString(), (Option<String>)Option.empty(), nextDate, this.getCurrentAuthentication());
                    return object;
                }
                object = new FailureFacetCheckResult(taskId, executionId, this.executionLog.toString(), (Option<String>)Option.empty(), this.getCurrentAuthentication());
                return object;
            }
            catch (Exception exception) {
                this.addExceptionToExecutionLog(exception, this.executionLog, "Unexpected exception during attribute check of task '{}':", taskId);
                FailureFacetCheckResult failureFacetCheckResult = new FailureFacetCheckResult(taskId, executionId, this.executionLog.toString(), (Option<String>)Option.empty(), this.getCurrentAuthentication());
                return failureFacetCheckResult;
            }
            finally {
                this.closeWriter();
                this.authenticationService.logoutScriptUser();
                this.finishScript(executionId);
            }
        });
    }

    @Override
    public Collection<Object> executeScriptValueProvider(ScriptValueProviderConfiguration valueProviderConfiguration) {
        CompletableFuture future = new CompletableFuture();
        Variable variable = valueProviderConfiguration.getVariable();
        String releaseId = Ids.releaseIdFrom((String)variable.getId());
        Release release = this.releaseService.findById(releaseId);
        this.scheduler.submit(() -> {
            this.authenticationService.loginScriptUser(release);
            XlrScriptContext scriptContext = this.prepareScriptValueProviderContext(release, valueProviderConfiguration);
            DefaultResourceLoader loader = new DefaultResourceLoader();
            Resource resource = loader.getResource(valueProviderConfiguration.getScript());
            Collection<Object> res = null;
            try (InputStream is = resource.getInputStream();){
                String script = StreamUtils.copyToString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                this.executeScriptWithApi(script, scriptContext, false);
                res = scriptContext.getValueProviderResult();
            }
            catch (Exception e) {
                this.logger.error("unknown exception: ", (Throwable)e);
            }
            finally {
                this.authenticationService.logoutScriptUser();
            }
            future.complete(res);
        });
        long releaseActionTimeoutSeconds = this.xlrConfig.timeoutSettings().releaseActionResponse().toSeconds();
        try {
            return (Collection)future.get(releaseActionTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            future.cancel(true);
            String message = String.format("Execution of value provider for variable [%s] with release id [%s] was terminated due to timeout of [%s] seconds. Consider to increase 'xl.timeouts.releaseActionResponse' property", variable.getKey(), release.getId(), releaseActionTimeoutSeconds);
            this.logger.warn(message);
            return Collections.emptyList();
        }
    }

    @Override
    public CompletableFuture<FailureHandlerResult> executeFailureHandler(Task task) {
        this.scriptLifeCycle.register(task.getExecutionId());
        return this.scheduler.supplyAsync(() -> {
            this.registerWriterForTask(task, SensitiveValueScrubber.disabled());
            XlrScriptContext scriptContext = null;
            VariablesHolderForScriptContext variablesHolderForScriptContext = new VariablesHolderForScriptContext(this.scriptVariables.initialReleaseVariables(task.getRelease()), this.scriptVariables.initialFolderVariable(task.getRelease().findFolderId()), this.scriptVariables.initialGlobalVariables(), this.variablesSynchronizationCallback(task));
            String taskId = task.getId();
            try {
                this.authenticationService.loginScriptUser(task, variablesHolderForScriptContext);
                scriptContext = this.prepareScriptTaskContext(task, (Writer)this.executionLog, this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousGlobalVariables()), this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousFolderVariables()), this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousReleaseVariables()));
                variablesHolderForScriptContext.setScriptContext(scriptContext);
                String failureHandlerScript = task.getFailureHandler();
                if (this.isScriptRunnable(task, failureHandlerScript)) {
                    this.executeScript(failureHandlerScript, scriptContext, task, true);
                }
                if (task.isFailureHandlerEnabled()) {
                    SuccessFailureHandlerResult successFailureHandlerResult = new SuccessFailureHandlerResult(taskId, variablesHolderForScriptContext.createScriptTaskResults());
                    return successFailureHandlerResult;
                }
                try {
                    throw new IllegalStateException(String.format("task failure for task [%s] is not enabled", taskId));
                }
                catch (ScriptException exception) {
                    this.logger.warn("ScriptException: ", (Throwable)exception);
                    ScriptTaskResults scriptTasksResults = variablesHolderForScriptContext.createScriptTaskResults();
                    try {
                        if (this.isSystemExit0(exception)) {
                            SuccessFailureHandlerResult successFailureHandlerResult = new SuccessFailureHandlerResult(taskId, scriptTasksResults);
                            return successFailureHandlerResult;
                        }
                        FailureFailureHandlerResult failureFailureHandlerResult = new FailureFailureHandlerResult(taskId, scriptTasksResults, exception);
                        return failureFailureHandlerResult;
                    }
                    catch (Exception resultsException) {
                        FailureFailureHandlerResult failureFailureHandlerResult = new FailureFailureHandlerResult(taskId, scriptTasksResults, exception);
                        return failureFailureHandlerResult;
                    }
                }
                catch (Exception exception) {
                    this.logger.warn("unknown exception: ", (Throwable)exception);
                    FailureFailureHandlerResult failureFailureHandlerResult = new FailureFailureHandlerResult(taskId, variablesHolderForScriptContext.createScriptTaskResults(), exception);
                    return failureFailureHandlerResult;
                }
            }
            finally {
                this.closeWriter();
                this.authenticationService.logoutScriptUser();
                this.finishScript(task.getExecutionId());
            }
        });
    }

    private void doExecuteScript(CustomScriptTask task, XlrScriptContext scriptContext, String script) throws Exception {
        this.authenticationService.loginScriptUser((Task)task);
        this.executeScript(script, scriptContext, (Task)task, false);
    }

    private boolean isScriptRunnable(Task task, String script) {
        return Strings.isNotBlank((String)script) && task.isTaskFailureHandlerEnabled() && task.isFailureHandlerEnabled() && TaskRecoverOp.RUN_SCRIPT == task.getTaskRecoverOp();
    }

    XlrScriptContext prepareScriptTaskContext(Task task, Writer log, Map<String, Object> globalVariables, Map<String, Object> folderVariables, Map<String, Object> releaseVariables) {
        XlrScriptContext scriptContext = this.makeScriptContext(log);
        if (!this.xlrConfig.isScriptSandboxDecryptPasswords()) {
            Release clonedRelease = CiCloneHelper.cloneCi(task.getRelease());
            String serverUrl = ReleaseServerUrlDecorator.SERVER_URL();
            clonedRelease.get$metadata().put(serverUrl, task.getRelease().get$metadata().get(serverUrl));
            scriptContext.addDomainObjects(clonedRelease.getTask(task.getId()));
        } else {
            scriptContext.addDomainObjects(task);
        }
        EncryptionHelper.decrypt((ConfigurationItem)task.getRelease());
        scriptContext.addReleaseVariables(task.getRelease(), this.permissions, releaseVariables);
        scriptContext.addGlobalVariables(this.permissions, globalVariables);
        this.addFolderVariables(task.getRelease(), scriptContext, folderVariables);
        scriptContext.addApi();
        scriptContext.addScriptLogger();
        return scriptContext;
    }

    XlrScriptContext prepareScriptTaskContext(Task task, Writer log) {
        String maybeFolderId = task.getRelease().findFolderId();
        Map<String, Object> folderVariables = Ids.isFolderId((String)maybeFolderId) ? this.scriptVariables.folderVariables(maybeFolderId) : null;
        Map<String, Object> globalVariables = this.scriptVariables.globalVariables();
        Map<String, Object> releaseVariables = this.scriptVariables.releaseVariables(task.getRelease());
        return this.prepareScriptTaskContext(task, log, globalVariables, folderVariables, releaseVariables);
    }

    XlrScriptContext prepareCustomScriptTaskContext(CustomScriptTask task, Writer log) {
        EncryptionHelper.decrypt((ConfigurationItem)task.getRelease());
        EncryptionHelper.decrypt((ConfigurationItem)task.getPythonScript());
        XlrScriptContext scriptContext = this.makeCustomScriptContext(log, task);
        scriptContext.addDomainObjects((Task)task);
        scriptContext.addCustomScriptApi();
        return scriptContext;
    }

    XlrScriptContext prepareScriptValueProviderContext(Release release, ScriptValueProviderConfiguration configuration) {
        EncryptionHelper.decrypt((ConfigurationItem)release);
        EncryptionHelper.decrypt((ConfigurationItem)configuration);
        XlrScriptContext scriptContext = new XlrScriptContext();
        scriptContext.setAttribute("release", release, 100);
        scriptContext.setAttribute("_valueProvider", (Object)configuration, 100);
        scriptContext.addReleaseVariables(release, this.permissions, this.scriptVariables.releaseVariables(release));
        scriptContext.addGlobalVariables(this.permissions, this.scriptVariables.globalVariables());
        this.addFolderVariables(release, scriptContext, this.scriptVariables.folderVariables(release.findFolderId()));
        scriptContext.addApi();
        scriptContext.addScriptLogger();
        return scriptContext;
    }

    private void addFolderVariables(Release release, XlrScriptContext scriptContext, Map<String, Object> folderVariables) {
        String maybeFolderId = release.findFolderId();
        if (Ids.isFolderId((String)maybeFolderId)) {
            scriptContext.addFolderVariables(maybeFolderId, this.permissions, folderVariables);
        }
    }

    private void registerWriterForTask(Task task, SensitiveValueScrubber scrubber) {
        String taskId = task.getId();
        MDC.put((String)MDC_KEY_TASK, (String)taskId);
        int maxCommentSize = task.getMaxCommentSize();
        TruncatingCommentUpdater commentUpdater = new TruncatingCommentUpdater(this.commentService, task, maxCommentSize);
        long pollingInterval = this.xlrConfig.durations_scriptOutputPollingInterval().toMillis();
        PollingExecutionOutputHandler pollingHandler = PollingExecutionOutputHandler.pollingHandler(this.scheduler, commentUpdater, true, pollingInterval, pollingInterval);
        ScriptTaskOutputWriter scriptOutputWriter = new ScriptTaskOutputWriter(this.attachmentService, task);
        this.registerWriterWithHandlers(scrubber, scriptOutputWriter, OutputHandler.debug(this.logger), pollingHandler);
    }

    private void registerWriterWithHandlers(SensitiveValueScrubber scrubber, Writer writer, OverthereExecutionOutputHandler ... handlers) {
        this.executionLog.registerWriter((Writer)new ExecutionOutputWriter(scrubber, writer, handlers));
    }

    private void closeWriter() {
        try {
            this.executionLog.getWriter().close();
        }
        catch (IOException e) {
            this.logger.warn("Error closing script output logger", (Throwable)e);
        }
    }

    private void removeWriter() {
        this.closeWriter();
        this.executionLog.removeWriter();
        MDC.remove((String)MDC_KEY_TASK);
    }

    boolean isSystemExit0(ScriptException exception) {
        if (!(exception.getCause() instanceof PyException)) {
            return false;
        }
        PyException pyE = (PyException)exception.getCause();
        String pyEtoString = pyE.toString();
        PyType pyET = (PyType)pyE.type;
        String pyETName = pyET.getName();
        return pyETName.equals("SystemExit") && pyEtoString.contains("SystemExit: 0");
    }

    private XlrScriptContext makeScriptContext(Writer output) {
        XlrScriptContext context = new XlrScriptContext();
        context.setWriter(output);
        return context;
    }

    private XlrScriptContext makeCustomScriptContext(Writer executionLog, CustomScriptTask task) {
        XlrScriptContext scriptContext = this.makeScriptContext(executionLog);
        PythonScript pythonScript = task.getPythonScript();
        List<PropertyDescriptor> ctxProperties = Stream.concat(pythonScript.getInputProperties().stream(), pythonScript.getTransitionalProperties().stream()).collect(Collectors.toList());
        if (task.hasNextScriptToExecute()) {
            ctxProperties.addAll(pythonScript.getOutputProperties());
            task.resetSchedule();
        }
        scriptContext.setScriptPathForLog(task.getScriptPath());
        scriptContext.addProperties((ConfigurationItem)pythonScript, ctxProperties);
        scriptContext.addPropertyBindings(pythonScript.getTransitionalAndOutputProperties());
        return scriptContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object executeScript(String script, XlrScriptContext scriptContext, Task task, boolean checkPolicyPermissions) throws Exception {
        this.scriptLifeCycle.start(task.getExecutionId());
        try {
            Object object = this.scriptExecutor.evalScriptWithApi(script, scriptContext, checkPolicyPermissions);
            return object;
        }
        finally {
            this.scriptLifeCycle.end(task.getExecutionId());
            String logMessage = this.executionLog.toString();
            this.logger.debug("Script '{}' output : {}", (Object)scriptContext.getScriptPathForLog(), (Object)logMessage);
        }
    }

    Object executeScript(String script, XlrScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.scriptExecutor.evalScript(script, scriptContext, checkPolicyPermissions);
    }

    Object executeScriptWithApi(String script, XlrScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.scriptExecutor.evalScriptWithApi(script, scriptContext, checkPolicyPermissions);
    }

    protected String sanitizeServerPath(String message) {
        return message == null ? null : message.replace(System.getProperty("user.dir"), "{ServerWorkingDirectory}");
    }

    private boolean isRestartPhasesException(ScriptException exception) {
        return ExceptionUtils.getRootCause((Throwable)exception) instanceof RestartPhasesException;
    }

    private ScriptTaskResult onRestartPhasesException(RestartPhasesException ex, ThreadLocalWriterDecorator executionLog, BaseScriptTask task, ScriptTaskResults scriptTaskResults) {
        List<String> runningAutomatedTaskIds = this.getRunningAutomatedTasks(ex);
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        if (!runningAutomatedTaskIds.contains(taskId)) {
            return this.onScriptTaskException("You can not restart phases in another release when an automated task is running", (Exception)((Object)ex), executionId, executionLog, scriptTaskResults, taskId);
        }
        if (runningAutomatedTaskIds.size() > 1) {
            return this.onScriptTaskException("You can not restart phases when there are other automated task running", (Exception)((Object)ex), executionId, executionLog, scriptTaskResults, taskId);
        }
        return new RestartScriptTaskResult(taskId, executionId, "", (Option<String>)Option.empty(), scriptTaskResults, ex, this.getCurrentAuthentication());
    }

    private FailureScriptTaskResult onScriptTaskException(String message, Exception ex, String executionId, ThreadLocalWriterDecorator executionLog, ScriptTaskResults scriptTaskResults, String taskId) {
        this.addExceptionToExecutionLog(ex, executionLog, message, taskId);
        return new FailureScriptTaskResult(taskId, executionId, executionLog.toString(), this.getAttachmentIdFromExecutionLog(executionLog), scriptTaskResults, this.getCurrentAuthentication());
    }

    private CustomScriptTaskResult onRestartPhasesExceptionCustomScript(RestartPhasesException ex, ThreadLocalWriterDecorator executionLog, BaseScriptTask task) {
        List<String> runningAutomatedTaskIds = this.getRunningAutomatedTasks(ex);
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        if (!runningAutomatedTaskIds.contains(taskId)) {
            return this.onCustomScriptException("You can not restart phases in another release when an automated task is running", (Exception)((Object)ex), executionId, executionLog, taskId);
        }
        if (runningAutomatedTaskIds.size() > 1) {
            return this.onCustomScriptException("You can not restart phases when there are other automated task running", (Exception)((Object)ex), executionId, executionLog, taskId);
        }
        return new RestartCustomScriptTaskResult(taskId, executionId, "", (Option<String>)Option.empty(), ex, this.getCurrentAuthentication());
    }

    private List<String> getRunningAutomatedTasks(RestartPhasesException ex) {
        Release release = this.releaseService.findById(ex.getReleaseId());
        return release.getActiveTasks().stream().filter(Task::isAutomated).map(BaseConfigurationItem::getId).collect(Collectors.toList());
    }

    private FailureCustomScriptTaskResult onCustomScriptException(String message, Exception ex, String executionId, ThreadLocalWriterDecorator executionLog, String taskId) {
        this.addExceptionToExecutionLog(ex, executionLog, message, taskId);
        return new FailureCustomScriptTaskResult(taskId, executionId, executionLog.toString(), this.getAttachmentIdFromExecutionLog(executionLog), this.getCurrentAuthentication());
    }

    private Option<String> getAttachmentIdFromExecutionLog(ThreadLocalWriterDecorator executionLog) {
        ExecutionOutputWriter executionOutputWriter = (ExecutionOutputWriter)executionLog.getWriter();
        ScriptTaskOutputWriter scriptWriter = (ScriptTaskOutputWriter)executionOutputWriter.getWriter();
        return Option.apply((Object)scriptWriter.getAttachmentId());
    }

    private void addExceptionToExecutionLog(Exception exception, ThreadLocalWriterDecorator executionLog, String logMessage, String taskId) {
        this.logger.warn(logMessage, (Object)taskId, (Object)exception);
        String defaultMessage = Objects.toString(this.sanitizeServerPath(exception.toString()), "");
        try {
            executionLog.append((CharSequence)"Exception during execution:\n");
            executionLog.append((CharSequence)defaultMessage);
            executionLog.flush();
            this.closeWriter();
        }
        catch (Exception e) {
            this.logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)e);
        }
    }

    private Function<VariablesUpdateHolder, ScriptTaskResults> variablesSynchronizationCallback(Task task) {
        return v -> {
            this.logger.debug("Synchronizing variables from script execution of task '{}'", (Object)task.getTitle());
            return new ScriptTaskResults(this.scriptVariables.detectReleaseVariablesChanges(task, (VariablesUpdateHolder)v), this.scriptVariables.detectGlobalVariablesChanges(task, (VariablesUpdateHolder)v), this.scriptVariables.detectFolderVariablesChanges(task, (VariablesUpdateHolder)v));
        };
    }

    private Authentication getCurrentAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private boolean isTrue(Object result) {
        return result instanceof Boolean && (Boolean)result != false;
    }

    private boolean isDate(Object result) {
        return result instanceof Date;
    }

    private Date pickNearestDate(Object ... dates) {
        Date result = null;
        for (int i = 0; i < dates.length; ++i) {
            if (dates[i] == null || !(dates[i] instanceof Date) || result != null && !result.before((Date)dates[i])) continue;
            result = (Date)dates[i];
        }
        return result;
    }

    static class RingWriter
    extends Writer {
        private CircularFifoQueue<Character> queue;

        public RingWriter(int size) {
            this.queue = new CircularFifoQueue(size);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = off; i < len; ++i) {
                this.queue.add((Object)Character.valueOf(cbuf[i]));
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return this.queue.stream().collect(Collector.of(StringBuilder::new, StringBuilder::append, StringBuilder::append, StringBuilder::toString, new Collector.Characteristics[0]));
        }
    }

    class ScriptTaskOutputWriter
    extends Writer {
        boolean closed = false;
        private final AttachmentService attachmentService;
        private final DeferredFileOutputStream dfos;
        private final OutputStreamWriter writer;
        private final RingWriter ringWriter;
        private final Task task;
        private final WorkDir workDir;
        private String attachmentId;

        public ScriptTaskOutputWriter(AttachmentService attachmentService, Task task) {
            this.attachmentService = attachmentService;
            int maxCommentSize = task.getMaxCommentSize();
            this.task = task;
            this.ringWriter = new RingWriter(maxCommentSize);
            WorkDirContext.initWorkdir();
            this.workDir = WorkDirContext.get();
            File workDirFile = new File(this.workDir.getPath());
            this.dfos = new DeferredFileOutputStream(maxCommentSize, task.getName(), ".log", workDirFile);
            this.writer = new OutputStreamWriter((OutputStream)this.dfos, StandardCharsets.UTF_8);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.writer.write(cbuf, off, len);
            this.ringWriter.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
            if (!this.closed) {
                this.saveArtifact();
            }
            this.workDir.delete();
            this.closed = true;
        }

        private void saveArtifact() {
            if (this.contentLength() > 0L) {
                try {
                    InputStream content = this.getContent();
                    String artifactName = new SimpleDateFormat("'script_output_'yyyyMMddHHmmss'.log'").format(new Date());
                    this.attachmentId = this.attachmentService.insertArtifact(this.task.getRelease(), artifactName, content);
                }
                catch (FileNotFoundException e) {
                    String msg = String.format("Unable to fetch script log file of a task '%s'", this.task.getId());
                    DefaultScriptService.this.logger.warn(msg, (Throwable)e);
                    DefaultScriptService.this.commentService.appendComment(this.task, null, msg);
                }
                catch (Exception e) {
                    DefaultScriptService.this.logger.error("Unable to save attachment of a task '{}'.", (Object)this.task.getId(), (Object)e);
                    DefaultScriptService.this.commentService.appendComment(this.task, null, "Unable to save attachment. Please check `xl-release.log`");
                }
            }
        }

        private long contentLength() {
            return this.dfos.getByteCount();
        }

        private InputStream getContent() throws FileNotFoundException {
            InputStream content = this.dfos.isInMemory() ? new ByteArrayInputStream(this.dfos.getData()) : new FileInputStream(this.dfos.getFile());
            return content;
        }

        public String toString() {
            return this.ringWriter.toString();
        }

        public String getAttachmentId() {
            return this.attachmentId;
        }
    }

    public static class VariablesUpdateHolder {
        private Map<String, Object> releaseVariables;
        private Map<String, Object> globalVariables;
        private Map<String, Object> folderVariables;
        private Map<String, Variable> initialReleaseVariables;
        private Map<String, Variable> initialGlobalVariables;
        private Map<String, Variable> initialFolderVariables;

        public VariablesUpdateHolder(Map<String, Object> releaseVariables, Map<String, Object> globalVariables, Map<String, Object> folderVariables, Map<String, Variable> initialReleaseVariables, Map<String, Variable> initialGlobalVariables, Map<String, Variable> initialFolderVariables) {
            this.releaseVariables = releaseVariables;
            this.globalVariables = globalVariables;
            this.folderVariables = folderVariables;
            this.initialReleaseVariables = initialReleaseVariables;
            this.initialGlobalVariables = initialGlobalVariables;
            this.initialFolderVariables = initialFolderVariables;
        }

        public Map<String, Object> getReleaseVariables() {
            return this.releaseVariables;
        }

        public Map<String, Object> getGlobalVariables() {
            return this.globalVariables;
        }

        public Map<String, Variable> getInitialReleaseVariables() {
            return this.initialReleaseVariables;
        }

        public Map<String, Variable> getInitialGlobalVariables() {
            return this.initialGlobalVariables;
        }

        public Map<String, Object> getFolderVariables() {
            return this.folderVariables;
        }

        public Map<String, Variable> getInitialFolderVariables() {
            return this.initialFolderVariables;
        }
    }

    public static class ScriptTaskResults
    implements BaseScriptTaskResults {
        private Changes.VariablesChanges releaseVariablesChanges;
        private Changes.VariablesChanges globalVariablesChanges;
        private Changes.VariablesChanges folderVariablesChanges;

        public ScriptTaskResults(Changes.VariablesChanges releaseVariablesChanges, Changes.VariablesChanges globalVariablesChanges, Changes.VariablesChanges folderVariablesChanges) {
            this.releaseVariablesChanges = releaseVariablesChanges;
            this.globalVariablesChanges = globalVariablesChanges;
            this.folderVariablesChanges = folderVariablesChanges;
        }

        public Changes.VariablesChanges getReleaseVariablesChanges() {
            return this.releaseVariablesChanges;
        }

        public Changes.VariablesChanges getGlobalVariablesChanges() {
            return this.globalVariablesChanges;
        }

        public Changes.VariablesChanges getFolderVariablesChanges() {
            return this.folderVariablesChanges;
        }
    }

    public static class CustomScriptTaskResults
    implements BaseScriptTaskResults {
        private Map<String, Object> outputVariables;
        private String scriptExecutionId;
        private String statusLine;
        private String nextScriptPath;
        private Integer interval;

        public CustomScriptTaskResults(Map<String, Object> outputVariables, String scriptExecutionId, String statusLine, String nextScriptPath, Integer interval) {
            this.outputVariables = outputVariables;
            this.scriptExecutionId = scriptExecutionId;
            this.statusLine = statusLine;
            this.nextScriptPath = nextScriptPath;
            this.interval = interval;
        }

        public Map<String, Object> getOutputVariables() {
            return this.outputVariables;
        }

        public String getScriptExecutionId() {
            return this.scriptExecutionId;
        }

        public String getStatusLine() {
            return this.statusLine;
        }

        public String getNextScriptPath() {
            return this.nextScriptPath;
        }

        public Integer getInterval() {
            return this.interval;
        }
    }

    public static interface BaseScriptTaskResults
    extends Serializable {
    }
}

