/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script.jython;

import com.google.common.collect.Lists;
import com.xebialabs.platform.script.jython.Syntactic;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.script.Jsr223ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptPermissionsProvider;
import com.xebialabs.xlrelease.script.jython.JythonEngineInstance;
import com.xebialabs.xlrelease.script.jython.JythonScriptHelper;
import com.xebialabs.xlrelease.script.jython.JythonScriptValidator;
import java.security.AccessControlContext;
import java.util.Collection;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.collection.Iterable;
import scala.collection.JavaConverters;

@Component
public class JythonScriptExecutor
extends Jsr223ScriptExecutor {
    private static final List<String> PYTHON_UTILITIES = Lists.newArrayList((Object[])new String[]{"xlrelease/XLRequest.py", "xlrelease/XLResponse.py", "xlrelease/CredentialsFallback.py", "xlrelease/HttpRequest.py", "xlrelease/HttpResponse.py"});
    private JythonScriptValidator scriptValidator;

    @Autowired
    public JythonScriptExecutor(JythonEngineInstance jythonEngineInstance, ScriptPermissionsProvider scriptPermissionsProvider, XlrConfig xlrConfig, JythonScriptValidator scriptValidator) {
        super(jythonEngineInstance, scriptPermissionsProvider, xlrConfig);
        this.scriptValidator = scriptValidator;
    }

    @Override
    public Object evalScript(String script, ScriptContext scriptContext) throws Exception {
        return this.evalScript(script, scriptContext, true);
    }

    @Override
    public Object evalScript(String script, ScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.evalScriptWithUtilities(script, scriptContext, checkPolicyPermissions);
    }

    @Override
    public Object evalScriptWithApi(String script, ScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        this.evalUtilityScript(Syntactic.wrapperLib().scriptContent(), scriptContext, checkPolicyPermissions);
        this.loadAndEval("xlrelease/globals.py", scriptContext, checkPolicyPermissions);
        this.loadAndEval("xlrelease/XLReleaseApi.py", scriptContext, checkPolicyPermissions);
        this.wrapBindings(scriptContext, checkPolicyPermissions);
        Object result = this.evalScriptWithUtilities(script, scriptContext, checkPolicyPermissions);
        this.unwrapBindings(scriptContext, checkPolicyPermissions);
        return result;
    }

    @Override
    protected Object evalScriptPrivileged(String script, ScriptContext scriptContext, AccessControlContext accessControlContext) throws Exception {
        if (this.isRestricted(accessControlContext != null)) {
            this.scriptValidator.validate(script, "UTF-8");
        }
        try {
            return this.doPrivileged(script, scriptContext, accessControlContext);
        }
        catch (ClassNotFoundException e) {
            throw new ScriptException(new SecurityException(e.getMessage()));
        }
    }

    private Object evalScriptWithUtilities(String script, ScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        this.evalUtilityScript(Syntactic.loggerLib().scriptContent(), scriptContext, checkPolicyPermissions);
        for (String pythonFile : PYTHON_UTILITIES) {
            this.loadAndEval(pythonFile, scriptContext, checkPolicyPermissions);
        }
        return this.evalScriptPrivileged(script, scriptContext, checkPolicyPermissions ? this.getAccessControlContext() : null);
    }

    private void wrapBindings(ScriptContext scriptContext, boolean checkPolicyPermissions) {
        List bindingsToWrap = (List)scriptContext.getAttribute("_contextBindingsToWrap");
        if (bindingsToWrap != null) {
            this.evalUtilityScript(JythonScriptHelper.wrapBindings((Iterable<String>)JavaConverters.collectionAsScalaIterable((Collection)bindingsToWrap)).scriptContent(), scriptContext, checkPolicyPermissions);
        }
    }

    private void unwrapBindings(ScriptContext scriptContext, boolean checkPolicyPermissions) {
        List bindingsToUnwrap = (List)scriptContext.getAttribute("_contextBindingsToUnwrap");
        if (bindingsToUnwrap != null) {
            this.evalUtilityScript(JythonScriptHelper.unwrapBindings((Iterable<String>)JavaConverters.collectionAsScalaIterable((Collection)bindingsToUnwrap)).scriptContent(), scriptContext, checkPolicyPermissions);
        }
    }
}

