/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import com.xebialabs.xlplatform.coc.service.PersistenceParams;
import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalAndFolderVariablesDecorator;
import com.xebialabs.xlrelease.api.internal.ReleaseServerUrlDecorator;
import com.xebialabs.xlrelease.api.v1.forms.CreateRelease;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.RoleIdExtension;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.CreatedFromTemplate;
import com.xebialabs.xlrelease.domain.events.CreatedFromTemplateByTrigger;
import com.xebialabs.xlrelease.domain.events.CreatedWithoutTemplate;
import com.xebialabs.xlrelease.domain.events.Imported;
import com.xebialabs.xlrelease.domain.events.PermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseDuplicatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseOverdueEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TemplateDeletingAction;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.planner.Planner;
import com.xebialabs.xlrelease.planner.PlannerReleaseItem;
import com.xebialabs.xlrelease.planner.PlannerReleaseTree;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.PhaseService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option;
import scala.util.Either;

@Service
public class ReleaseService {
    static final Duration MIN_RELEASE_DURATION = Duration.standardHours((long)8L);
    private static final Logger logger = LoggerFactory.getLogger(ReleaseService.class);
    private ReleaseRepository releaseRepository;
    private CiIdService ciIdService;
    private ArchivingService archivingService;
    private VariableService variableService;
    private InternalMetadataDecoratorService decoratorService;
    private XLReleaseEventBus eventBus;
    private ReleaseSearchService releaseSearchService;
    private PhaseService phaseService;
    private TeamService teamService;
    private RoleService roleService;
    private PermissionChecker permissionChecker;
    private SecuredCis securedCis;
    private SCMTraceabilityService scmTraceabilityService;

    @Autowired
    public ReleaseService(ReleaseRepository releaseRepository, CiIdService ciIdService, ArchivingService archivingService, VariableService variableService, InternalMetadataDecoratorService decoratorService, XLReleaseEventBus eventBus, ReleaseSearchService releaseSearchService, PhaseService phaseService, TeamService teamService, RoleService roleService, PermissionChecker permissionChecker, SecuredCis securedCis, SCMTraceabilityService scmTraceabilityService) {
        this.releaseRepository = releaseRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        this.variableService = variableService;
        this.decoratorService = decoratorService;
        this.eventBus = eventBus;
        this.releaseSearchService = releaseSearchService;
        this.phaseService = phaseService;
        this.teamService = teamService;
        this.roleService = roleService;
        this.permissionChecker = permissionChecker;
        this.securedCis = securedCis;
        this.scmTraceabilityService = scmTraceabilityService;
    }

    @Timed
    public boolean exists(String id) {
        return this.releaseRepository.exists(id);
    }

    @Timed
    public Release createWithoutTemplate(Release release) {
        return this.createWithoutTemplate(release, null);
    }

    @Timed
    public Release createWithoutTemplate(Release release, @Nullable String folderId) {
        release.checkDatesValidityForRelease();
        String parentId = Ids.ROOT_FOLDER_ID;
        if (folderId != null) {
            if (!Ids.isFolderId((String)folderId)) {
                throw new IllegalArgumentException("FolderId is not a valid folder id: " + folderId);
            }
            parentId = folderId;
        }
        String releaseId = this.ciIdService.getUniqueId(release.getType(), parentId);
        release.setId(releaseId);
        release.setStatus(ReleaseStatus.PLANNED);
        release.updateRealFlagStatus();
        this.initReleaseCalendar(release);
        logger.info("Creating empty release " + releaseId);
        VariablePersistenceHelper.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService);
        if (Ids.isInRootFolder((String)release.getId())) {
            this.addDefaultTeam(release, "Release Admin", XLReleasePermissions.getReleasePermissions(), false, true);
        }
        this.addFirstBlankPhase(release);
        Release created = this.releaseRepository.create(release, (ReleaseCreationSource)new CreatedWithoutTemplate());
        this.saveTeams(release);
        this.teamService.decorateWithEffectiveTeams(created);
        this.decoratorService.decorate((ConfigurationItem)created, Arrays.asList(ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY(), ReleaseServerUrlDecorator.SERVER_URL()), DecoratorsCache.NO_CACHE());
        this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(created, null));
        return created;
    }

    @Timed
    public Release createFromTemplate(String templateId, Release releaseMetadata) {
        return this.createFromTemplate(templateId, releaseMetadata, null);
    }

    @Timed
    public Release createFromTemplate(String templateId, Release releaseMetadata, @Nullable String folderId) {
        return this.createFromTemplate(templateId, releaseMetadata, null, folderId);
    }

    @Timed
    public Release createFromTemplate(String templateId, CreateRelease createRelease) {
        String releaseTitle = createRelease.getReleaseTitle();
        Map<String, Object> variableValues = createRelease.getVariables();
        Date scheduledStartDate = createRelease.getScheduledStartDate();
        boolean autoStart = createRelease.getAutoStart();
        String folderId = createRelease.getFolderId();
        return this.createFromTemplate(templateId, folderId, releaseTitle, variableValues, Collections.emptyList(), autoStart, scheduledStartDate, null, createRelease.getStartedFromTaskId());
    }

    public Release createFromTemplate(String templateId, String folderId, String releaseTitle, Map<String, Object> variableValues, List<String> releaseTags, boolean autoStart, @Nullable Date scheduledStartDate, @Nullable String triggerId, @Nullable String startedFromTaskId) {
        Release template = this.findById(templateId, ResolveOptions.MINIMAL());
        Checks.checkArgument((boolean)template.isTemplate(), (String)String.format("%s is not a template", templateId), (Object[])new Object[0]);
        if (releaseTitle == null || releaseTitle.isEmpty()) {
            throw new IllegalArgumentException(String.format("a release title is required when creating a release from a template. Template ID: %s", templateId));
        }
        templateId = template.getId();
        Release createdRelease = null;
        if (triggerId == null || template.canTriggerReleases()) {
            Release releaseMetadata = this.getReleaseParams(template, releaseTitle, releaseTags, variableValues, scheduledStartDate == null ? LocalDateTime.now() : new LocalDateTime((Object)scheduledStartDate), autoStart, startedFromTaskId);
            createdRelease = this.createFromTemplate(templateId, releaseMetadata, triggerId, folderId);
            if (triggerId != null) {
                template.incrementRunningTriggeredReleasesCount();
            }
            this.updateReleaseProperties(null, template);
        } else {
            int runningReleases = template.getRunningTriggeredReleasesCount();
            logger.warn("Trigger tried to create a release from template '{}' while '{}' release were already running", (Object)templateId, (Object)runningReleases);
        }
        return createdRelease;
    }

    private Release getReleaseParams(Release originalTemplate, String releaseTitle, Collection<String> releaseTags, Map<String, Object> variableValues, LocalDateTime scheduledStartDate, boolean autostart, String startedFromTaskId) {
        Release clonedTemplate = CiCloneHelper.cloneCi(originalTemplate);
        clonedTemplate.setId(null);
        clonedTemplate.setTitle(releaseTitle);
        clonedTemplate.setOriginTemplateId(originalTemplate.getId());
        clonedTemplate.getTags().addAll(releaseTags);
        if (startedFromTaskId != null) {
            clonedTemplate.setStartedFromTaskId(startedFromTaskId);
            clonedTemplate.setRootReleaseId(Ids.releaseIdFrom((String)startedFromTaskId));
        }
        Map variablesByKeys = clonedTemplate.getVariablesByKeys();
        variableValues.forEach((k, v) -> Optional.ofNullable(variablesByKeys.get(VariableHelper.withoutVariableSyntax((String)k))).ifPresent(variable -> variable.setUntypedValue(v)));
        clonedTemplate.setAutoStart(autostart);
        this.setDatesFromTemplate(clonedTemplate, clonedTemplate, scheduledStartDate);
        return clonedTemplate;
    }

    private Release createFromTemplate(String templateId, Release releaseMetadata, @Nullable String triggerId, @Nullable String folderId) {
        releaseMetadata.checkDatesValidityForRelease();
        WorkDirContext.initWorkdir((String)"artifact");
        return (Release)WorkDirTemplate.cleanOnFinally(workDir -> {
            String releaseId;
            Release template = this.releaseRepository.findById(templateId);
            this.teamService.decorateWithStoredTeams(template);
            this.resolveAttachmentFiles(template);
            Date templateReferenceDate = template.getScheduledStartDate();
            Release release = this.copyPropertiesFromMetatadataAndMakeTemplateAnActualRelease(template, releaseMetadata, templateId, triggerId != null);
            this.checkRequiredOnReleaseStartVariables(release);
            if (!(Strings.isNullOrEmpty((String)folderId) || Ids.isFolderId((String)folderId) || Ids.isRoot((String)folderId))) {
                throw new IllegalArgumentException("FolderId is not null and is not a valid folder id: " + folderId);
            }
            if (!Strings.isNullOrEmpty((String)folderId) && !Ids.isRoot((String)folderId)) {
                SecuredCi source = this.securedCis.getEffectiveSecuredCi(release.getId());
                SecuredCi destination = this.securedCis.getEffectiveSecuredCi(folderId);
                if (!source.getSecurityUid().equals(destination.getSecurityUid())) {
                    release = this.removeMissingTeamsFromTasks(release, this.teamService.getEffectiveTeams(folderId));
                }
                releaseId = this.rewriteWithNewId(release, folderId);
            } else {
                releaseId = this.rewriteWithNewId(release);
            }
            if (templateReferenceDate == null) {
                templateReferenceDate = this.findFirstStartDate(release);
            }
            if (templateReferenceDate != null) {
                int offsetSeconds = Seconds.secondsBetween((ReadableInstant)new DateTime((Object)templateReferenceDate), (ReadableInstant)new DateTime((Object)release.getScheduledStartDate())).getSeconds();
                release.moveChildren(offsetSeconds);
            }
            this.removeTemplateOwnerTeams(release);
            Optional<Team> teamToBeUpdated = this.configureAdminTeam(release);
            release.clearComments();
            release.updateRealFlagStatus();
            logger.info("Creating new release " + releaseId + " from template " + templateId);
            Release created = this.releaseRepository.create(release, (ReleaseCreationSource)new CreatedFromTemplate(templateId));
            teamToBeUpdated.ifPresent(team -> this.eventBus.publish((XLReleaseEvent)TeamUpdatedEvent.apply((Release)created, (Team)team, (Team)created.getAdminTeam())));
            release.getTeams().forEach(team -> team.setId(null));
            this.teamService.saveTeamsToPlatform(release);
            this.decoratorService.decorate((ConfigurationItem)release, Arrays.asList(ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY(), ReleaseServerUrlDecorator.SERVER_URL()), DecoratorsCache.NO_CACHE());
            if (triggerId == null) {
                this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(release, (ReleaseCreationSource)new CreatedFromTemplate(templateId)));
            } else {
                this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(release, (ReleaseCreationSource)new CreatedFromTemplateByTrigger(templateId, triggerId)));
            }
            this.eventBus.publish((XLReleaseEvent)new PermissionsUpdatedEvent(release.getTeams()));
            return release;
        });
    }

    private Release removeMissingTeamsFromTasks(Release release, List<Team> destinationTeams) {
        release.getAllTasks().forEach(task -> {
            if (task.getTeam() != null && destinationTeams.stream().noneMatch(team -> team.getTeamName().equals(task.getTeam()))) {
                task.setTeam(null);
            }
        });
        return release;
    }

    private void resolveAttachmentFiles(Release release) {
        if (release.getAttachments() != null) {
            for (Attachment attachment : release.getAttachments()) {
                if (attachment.getFile() == null) continue;
                attachment.getFile().getPath();
            }
        }
    }

    private Optional<Team> configureAdminTeam(Release release) {
        Team team = release.getAdminTeam();
        if (team != null && release.getOwner() != null) {
            Team teamToBeUpdated = CiCloneHelper.cloneCi(team);
            team.addMember(release.getOwner());
            return Optional.of(teamToBeUpdated);
        }
        return Optional.empty();
    }

    private void removeTemplateOwnerTeams(Release release) {
        release.getTeams().removeIf(team -> com.google.common.base.Objects.equal((Object)team.getTeamName(), (Object)"Template Owner"));
    }

    private void checkRequiredOnReleaseStartVariables(Release release) {
        for (Variable variable : release.getVariables()) {
            if (!variable.getRequiresValue() || !variable.getShowOnReleaseStart()) continue;
            Preconditions.checkArgument((!variable.isValueEmpty() ? 1 : 0) != 0, (Object)String.format("Variable ${%s} is not provided", variable.getKey()));
        }
    }

    private Date findFirstStartDate(Release template) {
        Date result = null;
        List children = template.getChildren();
        for (PlanItem item : children) {
            Date itemStartDate = item.getScheduledStartDate();
            if (result != null && (itemStartDate == null || !itemStartDate.before(result))) continue;
            result = itemStartDate;
        }
        return result;
    }

    @Timed
    public Release createTemplate(Release templateData) {
        return this.createTemplate(templateData, null);
    }

    @Timed
    public Release createTemplate(Release templateData, String parentId) {
        templateData.checkDatesValidityForTemplate();
        Release template = templateData;
        template.setId(this.ciIdService.getUniqueId(template.getType(), parentId != null ? parentId : Ids.ROOT_FOLDER_ID));
        template.setStatus(ReleaseStatus.TEMPLATE);
        this.addFirstBlankPhase(template);
        if (parentId == null) {
            ArrayList adminTeamPermissions = Lists.newArrayList((Object[])new String[]{XLReleasePermissions.VIEW_TEMPLATE.getPermissionName()});
            adminTeamPermissions.addAll(XLReleasePermissions.getReleasePermissions());
            adminTeamPermissions.addAll(XLReleasePermissions.getTriggerPermissions());
            this.addDefaultTeam(template, "Release Admin", adminTeamPermissions, false, false);
            this.addDefaultTeam(template, "Template Owner", XLReleasePermissions.getTemplateOnlyPermissions(), true, false);
        }
        VariablePersistenceHelper.scanAndBuildNewVariables(template, (VisitableItem)template, this.ciIdService);
        PasswordVerificationUtils.replacePasswordPropertiesInCiIfNeededJava(Optional.empty(), (ConfigurationItem)template);
        template = this.releaseRepository.create(template, null);
        this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(template, null));
        this.saveTeams(template);
        this.teamService.decorateWithEffectiveTeams(template);
        this.decoratorService.decorate((ConfigurationItem)template, Arrays.asList(ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY(), ReleaseServerUrlDecorator.SERVER_URL()), DecoratorsCache.NO_CACHE());
        return template;
    }

    @Timed
    public Release copyTemplate(String templateId, String title, String description) {
        WorkDirContext.initWorkdir((String)"artifact");
        return (Release)WorkDirTemplate.cleanOnFinally(workDir -> {
            Release newTemplate = this.findById(templateId);
            boolean userHasPermissionToEditTemplate = this.permissionChecker.hasPermission(XLReleasePermissions.EDIT_TEMPLATE, newTemplate);
            this.rewriteWithNewId(newTemplate);
            newTemplate.setTitle(title);
            newTemplate.setDescription(description);
            newTemplate.setRunningTriggeredReleasesCount(0);
            VariablePersistenceHelper.scanAndBuildNewVariables(newTemplate, (VisitableItem)newTemplate, this.ciIdService);
            if (!userHasPermissionToEditTemplate) {
                this.clearPasswordVariables(newTemplate);
                newTemplate.setScriptUserPassword(null);
                this.clearPasswordFields(newTemplate);
            }
            newTemplate.getTeams().stream().filter(team -> team.getTeamName().equals("Template Owner")).forEach(ownerTeam -> ownerTeam.addMember(Permissions.getAuthenticatedUserName()));
            newTemplate.getTeams().forEach(t -> t.setId(null));
            Release savedTemplate = this.releaseRepository.create(newTemplate, (ReleaseCreationSource)new CreatedFromTemplate(templateId));
            savedTemplate.getTeams().forEach(team -> team.setId(null));
            this.saveTeams(savedTemplate);
            this.teamService.decorateWithStoredTeams(savedTemplate);
            this.decoratorService.decorate((ConfigurationItem)savedTemplate, Arrays.asList(ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES(), ReleaseServerUrlDecorator.SERVER_URL()), DecoratorsCache.NO_CACHE());
            this.eventBus.publish((XLReleaseEvent)new ReleaseDuplicatedEvent(savedTemplate));
            return savedTemplate;
        });
    }

    private void clearPasswordVariables(Release release) {
        ArrayList copiedVariables = new ArrayList(release.getVariables());
        copiedVariables.stream().filter(Variable::isPassword).forEach(variable -> ((PasswordStringVariable)variable).setValue(null));
    }

    private void clearPasswordFields(Release release) {
        Changes changes = new Changes();
        String flagComment = "Password was cleared when this template was copied.";
        release.getAllTasks().forEach(task -> {
            task.getTaskType().getDescriptor().getPropertyDescriptors().stream().filter(PropertyDescriptor::isPassword).forEach(pd -> {
                if (null != pd.get((ConfigurationItem)task)) {
                    task.setProperty(pd.getName(), (Object)"");
                    task.setFlagStatus(FlagStatus.ATTENTION_NEEDED);
                    task.setFlagComment("Password was cleared when this template was copied.");
                    changes.update((ConfigurationItem)task);
                }
            });
            if (task instanceof CustomScriptTask) {
                PythonScript pythonScript = ((CustomScriptTask)task).getPythonScript();
                pythonScript.getInputProperties().stream().filter(PropertyDescriptor::isPassword).forEach(pd -> {
                    if (null != pd.get((ConfigurationItem)pythonScript)) {
                        pythonScript.setProperty(pd.getName(), (Object)"");
                        task.setFlagStatus(FlagStatus.ATTENTION_NEEDED);
                        task.setFlagComment("Password was cleared when this template was copied.");
                        changes.update((ConfigurationItem)pythonScript);
                        changes.update((ConfigurationItem)task);
                    }
                });
            }
        });
    }

    private Release copyPropertiesFromMetatadataAndMakeTemplateAnActualRelease(Release template, Release releaseMetadata, String originTemplateId, boolean createdFromTrigger) {
        Release release = CiCloneHelper.cloneCi(template);
        release.setStatus(ReleaseStatus.PLANNED);
        release.setDescription(releaseMetadata.getDescription());
        release.setTitle(releaseMetadata.getTitle());
        release.setScheduledStartDate(releaseMetadata.getScheduledStartDate());
        release.setDueDate(releaseMetadata.getDueDate());
        release.setPlannedDuration(releaseMetadata.getPlannedDuration());
        release.setOwner(releaseMetadata.hasOwner() ? releaseMetadata.getOwner() : Permissions.getAuthenticatedUserName());
        release.setAutoStart(releaseMetadata.isAutoStart());
        release.setAbortOnFailure(releaseMetadata.isAbortOnFailure());
        release.setAllowPasswordsInAllFields(releaseMetadata.isAllowPasswordsInAllFields());
        release.setAttachments(template.getAttachments());
        if (releaseMetadata.getTags() != null) {
            release.setTags(releaseMetadata.getTags());
        }
        release.setFlagStatus(releaseMetadata.getFlagStatus());
        release.setFlagComment(releaseMetadata.getFlagComment());
        release.setOriginTemplateId(originTemplateId);
        release.setCreatedFromTrigger(createdFromTrigger);
        release.setScriptUsername(releaseMetadata.getScriptUsername());
        release.setScriptUserPassword(PasswordVerificationUtils.replacePasswordIfNeeded(release.getScriptUserPassword(), releaseMetadata.getScriptUserPassword()));
        release.setStartedFromTaskId(releaseMetadata.getStartedFromTaskId());
        release.setRootReleaseId(releaseMetadata.getRootReleaseId());
        this.initReleaseCalendar(release);
        this.copyReleaseVariablesFromMetadata(release, releaseMetadata);
        release.scanAndAddNewVariables();
        VariablePersistenceHelper.fixUpVariableIds(originTemplateId, release.getVariables(), this.ciIdService);
        if (releaseMetadata.hasProperty("riskProfile") && release.hasProperty("riskProfile") && releaseMetadata.getProperty("riskProfile") != null) {
            release.setProperty("riskProfile", releaseMetadata.getProperty("riskProfile"));
        }
        return release;
    }

    private void copyReleaseVariablesFromMetadata(Release release, Release releaseMetadata) {
        Map variableMap = release.getVariablesByKeys();
        ArrayList newVariables = new ArrayList();
        releaseMetadata.getVariables().forEach(metadataVariable -> {
            String variableKey = metadataVariable.getKey();
            if (variableMap.containsKey(variableKey)) {
                Variable releaseVariable = (Variable)variableMap.get(variableKey);
                Checks.checkArgument((boolean)releaseVariable.getType().equals((Object)metadataVariable.getType()), (String)"Provided variable '%s' has type '%s', but expected type is '%s'.", (Object[])new Object[]{metadataVariable.getKey(), metadataVariable.getType(), releaseVariable.getType()});
                if (releaseVariable.isPassword()) {
                    Object passwordValue = release.isCreatedFromTrigger() ? metadataVariable.getValue() : PasswordVerificationUtils.replacePasswordIfNeeded(releaseVariable.getValue(), metadataVariable.getValue());
                    releaseVariable.setUntypedValue(Objects.isNull(passwordValue) ? null : PasswordEncrypter.getInstance().ensureEncrypted(passwordValue.toString()));
                } else {
                    releaseVariable.setUntypedValue(metadataVariable.getValue());
                }
            } else {
                logger.warn("Variable {} not found on a template ${}. It will be added.", (Object)variableKey, (Object)release.getOriginTemplateId());
                newVariables.add(metadataVariable);
            }
        });
        ArrayList allVariables = new ArrayList(release.getVariables());
        allVariables.addAll(newVariables);
        release.setVariables(allVariables);
    }

    private void initReleaseCalendar(Release newRelease) {
        Long token = UUID.randomUUID().getMostSignificantBits();
        newRelease.setCalendarLinkToken(token.toString());
        newRelease.setCalendarPublished(false);
    }

    @Timed
    public Release findById(String releaseId) {
        Release release = this.releaseRepository.findById(releaseId);
        return this.decorate(release);
    }

    @Timed
    public Release findById(String releaseId, boolean includeRoleIds) {
        Release release = this.findById(releaseId);
        if (includeRoleIds) {
            return this.decorateWithRoleIdExtension(release);
        }
        return release;
    }

    private Release decorateWithRoleIdExtension(Release release) {
        Set roleNames = this.teamService.getEffectiveTeams(release).stream().flatMap(team -> team.getRoles().stream()).collect(Collectors.toSet());
        Map<String, String> idsToNames = roleNames.stream().map(name -> this.roleService.getRoleForRoleName(name)).collect(Collectors.toMap(Role::getId, Role::getName));
        if (!idsToNames.isEmpty()) {
            RoleIdExtension roleIdsExtension = new RoleIdExtension(release.getId(), idsToNames);
            ArrayList<RoleIdExtension> updatedExtensions = new ArrayList<RoleIdExtension>(release.getExtensions());
            updatedExtensions.add(roleIdsExtension);
            release.setExtensions(updatedExtensions);
        }
        return release;
    }

    @Timed
    public Release findById(String releaseId, ResolveOptions resolveOptions) {
        Release release = this.releaseRepository.findById(releaseId, resolveOptions);
        if (resolveOptions.hasDecorators()) {
            return this.decorate(release);
        }
        return release;
    }

    @Timed
    public Release findByIdInArchive(String releaseId) {
        Release release = this.archivingService.getRelease(releaseId);
        this.decoratorService.decorate((ConfigurationItem)release, Arrays.asList(ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY(), ReleaseServerUrlDecorator.SERVER_URL()), DecoratorsCache.NO_CACHE());
        return release;
    }

    @Timed
    public Release findByIdIncludingArchived(String releaseId) {
        return this.findByIdIncludingArchived(releaseId, ResolveOptions.EVERYTHING());
    }

    @Timed
    public Release findByIdIncludingArchived(String releaseId, ResolveOptions resolveOptions) {
        if (this.exists(releaseId)) {
            return this.findById(releaseId, resolveOptions);
        }
        if (this.archivingService.exists(releaseId)) {
            return this.findByIdInArchive(releaseId);
        }
        throw new LogFriendlyNotFoundException(String.format("Release [%s] does not exist in the repository or archive. It may have been moved or deleted", releaseId), new Object[0]);
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Release release = this.releaseRepository.findByCalendarToken(calendarToken);
        if (release != null) {
            this.decoratorService.decorate((ConfigurationItem)release, Collections.singletonList(ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES()), DecoratorsCache.NO_CACHE());
        }
        return release;
    }

    @Timed
    public boolean templateExistsWithTitle(String title) {
        Page queryPage = new Page(0L, 1L, 1, false);
        ReleaseStatus[] statuses = new ReleaseStatus[]{ReleaseStatus.TEMPLATE};
        List<Release> templates = this.releaseRepository.search(new ReleaseSearchByParams(queryPage, null, statuses, title, null, false));
        return !templates.isEmpty();
    }

    @Timed
    public List<Release> findTemplatesByTitle(String folderId, String templateTitle, int page, int resultsPerPage, int depth) {
        Page queryPage = new Page(page, resultsPerPage, depth, false);
        ReleaseStatus[] templates = new ReleaseStatus[]{ReleaseStatus.TEMPLATE};
        return this.releaseRepository.search(new ReleaseSearchByParams(queryPage, (Either<String, String>)ReleaseSearchByParams.byParent(folderId), templates, templateTitle, null, false));
    }

    @Timed
    public List<Release> findReleasesByTitle(String folderId, String templateTitle, int page, int resultsPerPage, int depth) {
        Page queryPage = new Page(page, resultsPerPage, depth, false);
        ReleaseStatus[] activeOrPlannedReleases = EnumSet.of(ReleaseStatus.PLANNED, ReleaseStatus.ACTIVE_STATUSES).toArray(new ReleaseStatus[0]);
        List<Release> releases = this.releaseRepository.search(new ReleaseSearchByParams(queryPage, (Either<String, String>)ReleaseSearchByParams.byParent(folderId), activeOrPlannedReleases, templateTitle, null, false));
        this.decoratorService.decorate(releases, Arrays.asList(ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY(), ReleaseServerUrlDecorator.SERVER_URL()), new DecoratorsCache(new HashMap<String, Object>()));
        return releases;
    }

    @Timed
    public List<Release> findSpawnedReleases(String rootReleaseId, int maxConcurrency) {
        Page queryPage = new Page(0L, maxConcurrency + 2, 0, false);
        ReleaseStatus[] finishedReleases = EnumSet.complementOf(EnumSet.of(ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED)).toArray(new ReleaseStatus[2]);
        return this.releaseRepository.search(new ReleaseSearchByParams(queryPage, null, finishedReleases, null, rootReleaseId, false));
    }

    @Timed
    public void importTemplate(Release template, String parentId) {
        String realParentId;
        String string = realParentId = Ids.isNullId((String)parentId) ? Ids.ROOT_FOLDER_ID : parentId;
        if (this.canKeepImportedId(template.getId(), realParentId)) {
            logger.debug("Kept imported template ID {} because it does not exist in the repository", (Object)template.getId());
        } else {
            String originalId = template.getId();
            this.rewriteWithNewId(template, realParentId);
            logger.debug("Rewritten imported template ID {} to {} because the original ID already exists in the repository or was not in the same folder", (Object)originalId, (Object)template.getId());
        }
        VariablePersistenceHelper.scanAndBuildNewVariables(template, (VisitableItem)template, this.ciIdService);
        Release createdTemplate = this.releaseRepository.create(template, (ReleaseCreationSource)new Imported());
        if (Ids.isRoot((String)realParentId)) {
            createdTemplate.getTeams().forEach(team -> team.setId(null));
            this.teamService.saveTeamsToPlatform(createdTemplate);
        }
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new ReleaseCreatedEvent(createdTemplate, (ReleaseCreationSource)new Imported()));
    }

    @VisibleForTesting
    boolean canKeepImportedId(String templateId, String parentId) {
        if (Ids.isNullId((String)templateId) || !Ids.isReleaseId((String)templateId)) {
            return false;
        }
        if (!Ids.getParentId((String)templateId).equals(parentId)) {
            return false;
        }
        String name = Ids.getName((String)templateId);
        return !this.releaseSearchService.existsByName(name) && !this.archivingService.existsByName(name);
    }

    @Timed
    public void importTemplate(Release template) {
        this.importTemplate(template, null);
    }

    @Timed
    public void deleteTemplate(String templateId) {
        Preconditions.checkArgument((boolean)Ids.isReleaseId((String)templateId), (Object)"You must provide a template id");
        Release template = this.releaseRepository.findById(templateId);
        Preconditions.checkArgument((boolean)template.isTemplate(), (Object)"You must provide a template id");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TemplateDeletingAction(templateId));
        this.delete(templateId, template);
    }

    @Timed
    public void delete(String releaseId) {
        Preconditions.checkArgument((boolean)Ids.isReleaseId((String)releaseId), (Object)"You must provide a release id");
        Release releaseWithStatus = this.releaseRepository.findById(releaseId);
        Preconditions.checkArgument((boolean)releaseWithStatus.isDefunct(), (Object)("Release " + releaseId + " must be in a final state if it needs to be deleted"));
        logger.trace(String.format("Archiving incoming dependencies for release [%s]", releaseId));
        this.archivingService.archiveAllIncomingDependencies(releaseId);
        this.delete(releaseId, releaseWithStatus);
    }

    private void delete(String releaseId, Release release) {
        this.releaseRepository.delete(releaseId);
        this.eventBus.publish((XLReleaseEvent)new ReleaseDeletedEvent(release));
    }

    private String rewriteWithNewId(Release release) {
        return this.rewriteWithNewId(release, Ids.getParentId((String)release.getId()));
    }

    private String rewriteWithNewId(Release release, String withParentId) {
        String newReleaseId = this.ciIdService.getUniqueId(release.getType(), withParentId);
        CiHelper.rewriteWithNewId((ConfigurationItem)release, (String)newReleaseId);
        return newReleaseId;
    }

    @Timed
    public void checkNotArchived(String ciId) {
        this.archivingService.checkNotArchived(ciId);
    }

    @Timed
    public boolean isArchived(String releaseId) {
        return this.archivingService.exists(releaseId);
    }

    @Timed
    public ReleaseStatus getStatus(String releaseId) {
        return this.releaseRepository.getStatus(releaseId);
    }

    @Timed
    public boolean isTemplate(String releaseId) {
        return this.releaseRepository.isTemplate(releaseId);
    }

    @Timed
    public String getTitle(String id) {
        try {
            return this.releaseRepository.getTitle(id);
        }
        catch (NotFoundException ignored) {
            if (this.archivingService.exists(id)) {
                return this.archivingService.getReleaseTitle(id);
            }
            throw new LogFriendlyNotFoundException(String.format("Release [%s] does not exist in the repository or archive. It may have been moved or deleted", id), new Object[0]);
        }
    }

    @Timed
    public void notifyOverdueRelease(Release release) {
        this.eventBus.publish((XLReleaseEvent)new ReleaseOverdueEvent(release));
        Release original = CiCloneHelper.cloneCi(release);
        release.setOverdueNotified(true);
        this.releaseRepository.update(original, release);
    }

    @Timed
    public void updateReleaseProperties(Release original, Release updated) {
        this.releaseRepository.update(original, updated);
    }

    @Timed
    public void decrementRunningTriggeredReleasesCount(Release template) {
        Release original = CiCloneHelper.cloneCi(template);
        template.decrementRunningTriggeredReleasesCount();
        this.updateReleaseProperties(original, template);
    }

    @Timed
    public Release updateRelease(String releaseId, Release toUpdate) {
        Release updated = this.findById(releaseId);
        Preconditions.checkArgument((boolean)updated.isUpdatable(), (String)"Can't update release '%s' because it is %s.", (Object)updated.getTitle(), (Object)updated.getStatus());
        Preconditions.checkArgument((boolean)this.isScheduledStartDateUpdatable(updated, toUpdate), (String)"Can't update scheduled start date on a release '%s' because it has already started.", (Object)updated.getTitle());
        Preconditions.checkArgument((boolean)this.isStartAtScheduledStartDateUpdatable(updated, toUpdate), (String)"Can't set start on scheduled start date on release '%s' because it has already started.", (Object)updated.getTitle());
        Release original = CiCloneHelper.cloneCi(updated);
        if (toUpdate.getTitle() != null) {
            Preconditions.checkArgument((!toUpdate.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Release title is required.");
            updated.setTitle(toUpdate.getTitle());
        }
        updated.setAutoStart(toUpdate.isAutoStart());
        if (toUpdate.getDescription() != null) {
            updated.setDescription(toUpdate.getDescription());
        }
        updated.updateDatesForRelease(toUpdate.getScheduledStartDate(), toUpdate.getDueDate(), toUpdate.getPlannedDuration());
        if (toUpdate.getDueDate() != null) {
            updated.setDueDate(toUpdate.getDueDate());
        }
        if (toUpdate.getScheduledStartDate() != null) {
            updated.setScheduledStartDate(toUpdate.getScheduledStartDate());
        }
        if (toUpdate.hasOwner()) {
            Preconditions.checkArgument((!toUpdate.getOwner().isEmpty() ? 1 : 0) != 0, (Object)"Release owner is required.");
            updated.setOwner(toUpdate.getOwner());
        }
        updated.setScriptUsername(toUpdate.getScriptUsername());
        updated.setScriptUserPassword(PasswordVerificationUtils.replacePasswordIfNeeded(updated.getScriptUserPassword(), toUpdate.getScriptUserPassword()));
        if (toUpdate.getTags() != null) {
            updated.setTags(toUpdate.getTags());
        }
        if (toUpdate.getFlagStatus() != null) {
            updated.setFlagStatus(toUpdate.getFlagStatus());
        }
        if (toUpdate.getFlagComment() != null) {
            updated.setFlagComment(toUpdate.getFlagComment());
        }
        updated.updateRealFlagStatus();
        updated.setCalendarPublished(toUpdate.isCalendarPublished());
        updated.setAbortOnFailure(toUpdate.isAbortOnFailure());
        updated.setAllowPasswordsInAllFields(toUpdate.isAllowPasswordsInAllFields());
        updated.setAllowConcurrentReleasesFromTrigger(toUpdate.isAllowConcurrentReleasesFromTrigger());
        if (original.getDueDate() != toUpdate.getDueDate() && original.isOverdueNotified() && !updated.isOverdue()) {
            updated.setOverdueNotified(false);
        }
        this.updateVariables(toUpdate, updated);
        if (updated.hasProperty("riskProfile")) {
            updated.setProperty("riskProfile", toUpdate.getProperty("riskProfile"));
        }
        this.releaseRepository.update(original, updated);
        this.updateReleaseTeams(original, updated);
        this.eventBus.publish((XLReleaseEvent)new ReleaseUpdatedEvent(original, updated));
        return updated;
    }

    private void updateVariables(Release toUpdate, Release updated) {
        updated.scanAndAddNewVariables();
        PasswordVerificationUtils.replacePasswordPropertiesInCiIfNeededJava(Optional.of(updated), (ConfigurationItem)toUpdate);
        Map isPasswordPartitioned = toUpdate.getVariablesByKeys().entrySet().stream().collect(Collectors.partitioningBy(e -> ((Variable)e.getValue()).isPassword(), com.xebialabs.xlrelease.utils.Collectors.toMap(Map.Entry::getKey, r -> ((Variable)r.getValue()).getValue())));
        updated.setVariableValues((Map)isPasswordPartitioned.get(false));
        updated.setPasswordVariableValues((Map)isPasswordPartitioned.get(true));
        VariablePersistenceHelper.fixUpVariableIds(updated.getId(), updated.getVariables(), this.ciIdService);
    }

    private boolean isScheduledStartDateUpdatable(Release original, Release updated) {
        return !original.hasBeenStarted() || Objects.equals(original.getScheduledStartDate(), updated.getScheduledStartDate());
    }

    private boolean isStartAtScheduledStartDateUpdatable(Release original, Release updated) {
        return !original.hasBeenStarted() || original.isAutoStart() == updated.isAutoStart();
    }

    @Timed
    public Release updateTemplate(String templateId, Release toUpdate) {
        Release updated = this.findById(templateId);
        Release original = CiCloneHelper.cloneCi(updated);
        if (toUpdate.getTitle() != null) {
            Preconditions.checkArgument((!toUpdate.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Template title is required.");
            updated.setTitle(toUpdate.getTitle());
        }
        if (toUpdate.getDescription() != null) {
            updated.setDescription(toUpdate.getDescription());
        }
        updated.setTags(toUpdate.getTags());
        updated.updateDatesForTemplate(toUpdate.getScheduledStartDate(), toUpdate.getDueDate(), toUpdate.getPlannedDuration());
        updated.setAbortOnFailure(toUpdate.isAbortOnFailure());
        updated.setAllowPasswordsInAllFields(toUpdate.isAllowPasswordsInAllFields());
        updated.setAllowConcurrentReleasesFromTrigger(toUpdate.isAllowConcurrentReleasesFromTrigger());
        updated.setScriptUsername(toUpdate.getScriptUsername());
        updated.setScriptUserPassword(PasswordVerificationUtils.replacePasswordIfNeeded(updated.getScriptUserPassword(), toUpdate.getScriptUserPassword()));
        updated.scanAndAddNewVariables();
        VariablePersistenceHelper.fixUpVariableIds(updated.getId(), updated.getVariables(), this.ciIdService);
        if (updated.hasProperty("riskProfile")) {
            updated.setProperty("riskProfile", toUpdate.getProperty("riskProfile"));
        }
        this.releaseRepository.update(original, updated);
        this.eventBus.publish((XLReleaseEvent)new ReleaseUpdatedEvent(original, updated));
        return updated;
    }

    @Timed
    public Release updateVariables(String releaseId, List<Variable> variableList) {
        Release release = this.findById(releaseId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't update release '%s' because it is %s.", (Object)release.getTitle(), (Object)release.getStatus());
        return this.variableService.updateReleaseVariables(release, variableList);
    }

    private void addFirstBlankPhase(Release release) {
        this.phaseService.build(release, null, null);
    }

    public Duration getDurationOf(Release release) {
        Duration duration;
        if (release.getPlannedDuration() != null) {
            duration = Duration.standardSeconds((long)release.getPlannedDuration().longValue());
        } else if (release.getDueDate() != null) {
            duration = Duration.millis((long)(release.getDueDate().getTime() - release.getScheduledStartDate().getTime()));
        } else {
            Release templateRelease = CiCloneHelper.cloneCi(release);
            PlannerReleaseTree releaseTree = PlannerReleaseTree.apply((PlannerReleaseItem)PlannerReleaseItem.transform((PlanItem)templateRelease));
            Planner.makePlan((PlannerReleaseTree)releaseTree, (DateTime)new DateTime((Object)release.getScheduledStartDate()));
            duration = releaseTree.root().getDuration();
        }
        if (!duration.isLongerThan((ReadableDuration)Duration.ZERO)) {
            duration = MIN_RELEASE_DURATION;
        }
        return duration;
    }

    public void setDatesFromTemplate(Release release, Release template) {
        this.setDatesFromTemplate(release, template, LocalDateTime.now());
    }

    public void setDatesFromTemplate(Release release, Release template, LocalDateTime now) {
        release.setScheduledStartDate(now.toDate());
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)timeZone);
        DateTime dateTime = now.toDateTime(dateTimeZone);
        int minutes = this.getDurationOf(template).toStandardMinutes().getMinutes();
        release.setDueDate(dateTime.plusMinutes(minutes).toDate());
    }

    public Set<String> getAllTags(int limitNumber) {
        return this.releaseRepository.getAllTags(limitNumber);
    }

    public Set<String> getAllArchivedTags(int limitNumber) {
        return this.archivingService.getAllTags(limitNumber);
    }

    @VisibleForTesting
    void addDefaultTeam(Release release, String teamName, List<String> permissions, boolean includeCurrentUser, boolean includeOwner) {
        boolean isCreation;
        Team team = null;
        if (teamName.equals("Release Admin")) {
            team = release.getAdminTeam();
        }
        boolean bl = isCreation = team == null;
        if (isCreation) {
            team = (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
            team.setTeamName(teamName);
            release.addTeam(team);
        }
        team.setPermissions(permissions);
        if (includeCurrentUser) {
            team.addMember(Permissions.getAuthenticatedUserName());
        }
        if (includeOwner) {
            team.addMember(release.getOwner());
        }
    }

    @Timed
    public SCMTraceabilityData createSCMData(String templateId, SCMTraceabilityData scmData) {
        if (scmData != null) {
            Release toUpdate = this.findById(templateId);
            Option scmId = this.scmTraceabilityService.persistOrDelete(new PersistenceParams(Option.empty(), Option.apply((Object)scmData)));
            toUpdate.get$ciAttributes().setScmTraceabilityDataId((Integer)scmId.getOrElse(null));
            this.releaseRepository.update(null, toUpdate);
        }
        return scmData;
    }

    private void saveTeams(Release release) {
        if (!release.getTeams().isEmpty()) {
            this.teamService.updateTeams(release.getId(), release.getTeams());
            this.eventBus.publish((XLReleaseEvent)new PermissionsUpdatedEvent(release.getTeams()));
        }
    }

    private void updateReleaseTeams(Release original, Release updated) {
        if (original.getOwner() != null && updated.getOwner() != null && !original.getOwner().equals(updated.getOwner()) && !original.getTeams().isEmpty()) {
            Team releaseAdminTeam = original.getTeams().stream().filter(team -> team.getTeamName().equals("Release Admin")).findFirst().get();
            ArrayList<String> members = new ArrayList<String>(releaseAdminTeam.getMembers());
            int idx = members.indexOf(original.getOwner());
            if (idx >= 0) {
                members.remove(idx);
            }
            if (!members.contains(updated.getOwner())) {
                members.add(updated.getOwner());
            }
            Team team2 = updated.getTeams().stream().filter(t -> t.getTeamName().equals("Release Admin")).findFirst().get();
            team2.setMembers(members);
            this.teamService.updateTeam(team2.getId(), team2);
            this.eventBus.publish((XLReleaseEvent)new PermissionsUpdatedEvent(updated.getTeams()));
        }
    }

    public void decorateRemovingUnnecessaryFields(Release release) {
        release.get$ciAttributes().setScmTraceabilityDataId(null);
    }

    private Release decorate(Release release) {
        this.teamService.decorateWithStoredTeams(release);
        this.decoratorService.decorate((ConfigurationItem)release, Arrays.asList(ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY(), ReleaseServerUrlDecorator.SERVER_URL()), DecoratorsCache.NO_CACHE());
        return release;
    }
}

