/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.scheduler;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private final ScheduledExecutorService scheduler;
    private final ExecutorService executorService;
    private int awaitTerminationSeconds;
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);

    public Scheduler(ScheduledExecutorService scheduler, ExecutorService executorService, int awaitTerminationSeconds) {
        this.awaitTerminationSeconds = awaitTerminationSeconds;
        this.scheduler = MoreExecutors.listeningDecorator((ScheduledExecutorService)scheduler);
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
    }

    public synchronized ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduler.scheduleAtFixedRate(Scheduler.withLoggedExceptions(command), initialDelay, delay, unit);
    }

    public synchronized ScheduledFuture<?> scheduleOnce(Runnable command, long delay, TimeUnit unit) {
        return this.scheduler.schedule(command, delay, unit);
    }

    public void execute(Runnable command) {
        this.executorService.execute(Scheduler.withLoggedExceptions(command));
    }

    public Future<?> submit(Runnable command) {
        return this.executorService.submit(Scheduler.withLoggedExceptions(command));
    }

    public <U> CompletableFuture<U> supplyAsync(Supplier<U> command) {
        return CompletableFuture.supplyAsync(command, this.executorService);
    }

    public void shutdown() {
        LOG.info("Initiating Scheduler shutdown.");
        this.shutdownAndAwaitTermination(this.scheduler);
        if (this.scheduler != this.executorService) {
            this.shutdownAndAwaitTermination(this.executorService);
        }
        LOG.info("Scheduler shutdown finished");
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    private void shutdownAndAwaitTermination(ExecutorService executorService) {
        try {
            executorService.shutdown();
            boolean terminated = executorService.awaitTermination(this.awaitTerminationSeconds, TimeUnit.SECONDS);
            if (!terminated) {
                LOG.warn("Could not finish termination of executorService. There are still active threads.");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Could not finish termination of executorService.", (Throwable)e);
        }
    }

    private static Runnable withLoggedExceptions(Runnable command) {
        return () -> {
            try {
                command.run();
            }
            catch (Exception e) {
                LOG.error("Error while running a scheduled task.", (Throwable)e);
                throw e;
            }
        };
    }
}

