/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.facet.ConfigurationFacet;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.FacetPermissionChecker;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.FacetService;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/facets/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
public class FacetApi
implements ApiService {
    private final FacetService facetService;
    private final PermissionChecker permissions;
    private final FacetPermissionChecker facetPermissions;

    @Autowired
    public FacetApi(FacetService facetService, PermissionChecker permissions, FacetPermissionChecker facetPermissions) {
        this.facetService = facetService;
        this.permissions = permissions;
        this.facetPermissions = facetPermissions;
    }

    @GET
    @Path(value="{facetId:.*Facet[^/-]*}")
    @PublicApiMember
    @Timed
    public Facet getFacet(@PathParam(value="facetId") String facetId) {
        Facet facet = this.facetService.get(facetId);
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(Ids.releaseIdFrom((String)facet.getTargetId()), () -> this.permissions.checkView(Ids.releaseIdFrom((String)facet.getTargetId())));
        this.checkIsConfigurationFacet(facet, "Cannot fetch facet of this type (" + facet.getType() + ")");
        return facet;
    }

    @POST
    @PublicApiMember
    @Timed
    public Facet createFacet(ConfigurationFacet configurationFacet) {
        this.performConfigurationFacetPermissionChecks((Facet)configurationFacet);
        return this.facetService.create((Facet)configurationFacet);
    }

    @PublicApiMember
    public Facet newFacet(String type) {
        Facet facet = (Facet)Type.valueOf((String)type).getDescriptor().newInstance("");
        this.checkIsConfigurationFacet(facet, "You can only create Configuration type facets.");
        return facet;
    }

    @PUT
    @Path(value="{facetId:.*Facet[^/]*}")
    @PublicApiMember
    @Timed
    public Facet updateFacet(@PathParam(value="facetId") String facetId, ConfigurationFacet configurationFacet) {
        this.performConfigurationFacetPermissionChecks((Facet)configurationFacet);
        configurationFacet.setId(facetId);
        return this.facetService.update((Facet)configurationFacet);
    }

    @DELETE
    @Path(value="{facetId:.*Facet[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteFacet(@PathParam(value="facetId") String facetId) {
        Facet facet = this.facetService.get(facetId);
        this.performConfigurationFacetPermissionChecks(facet);
        this.checkIsConfigurationFacet(facet, "You can only remove Configuration facets");
        this.facetService.delete(facetId);
    }

    @POST
    @Path(value="search")
    @PublicApiMember
    @Timed
    public List<Facet> searchFacets(FacetFilters facetFilters) {
        facetFilters.validate();
        String containerId = facetFilters.getParentId() != null ? facetFilters.getParentId() : facetFilters.getTargetId();
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(Ids.releaseIdFrom((String)containerId), () -> this.permissions.checkView(Ids.releaseIdFrom((String)containerId)));
        this.checkFiltersOnlyContainSearchableTypes(facetFilters);
        return this.facetService.search(facetFilters);
    }

    @GET
    @Path(value="types")
    @PublicApiMember
    @Timed
    public List<Descriptor> getFacetTypes(@QueryParam(value="baseType") String baseType) {
        return this.facetService.getFacetTypes(baseType);
    }

    public String serviceName() {
        return "facetApi";
    }

    private void performConfigurationFacetPermissionChecks(Facet facet) {
        String releaseId = Ids.releaseIdFrom((String)facet.getTargetId());
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(releaseId, () -> this.permissions.checkEditTaskConfigurationFacet(releaseId));
    }

    private void checkIsConfigurationFacet(Facet facet, String exceptionMsg) {
        if (!facet.getType().instanceOf(Type.valueOf(ConfigurationFacet.class))) {
            throw new IllegalArgumentException(exceptionMsg);
        }
    }

    private void checkFiltersOnlyContainSearchableTypes(FacetFilters facetFilters) {
        if (facetFilters.getTypes() == null || facetFilters.getTypes().isEmpty()) {
            facetFilters.setTypes(Lists.newArrayList((Object[])new Type[]{Type.valueOf(ConfigurationFacet.class)}));
        } else if (facetFilters.getTypes().stream().anyMatch(facetType -> facetType.instanceOf(Type.valueOf(TaskReportingRecord.class)))) {
            throw new IllegalArgumentException("Facet filters contain type not searchable by this API");
        }
    }
}

