/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.actors;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$GetWatchedGates$;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$JobDone$;
import com.xebialabs.xlrelease.actors.StuckGateDetectorActor$Tick$;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r\u001dx\u0001CA\u0001\u0003\u0007A\t!!\u0006\u0007\u0011\u0005e\u00111\u0001E\u0001\u00037Aq!!\u000b\u0002\t\u0003\tY\u0003C\u0004\u0002.\u0005!\t!a\f\t\u000f\u0005\u0015\u0015\u0001\"\u0001\u0002\b\"9\u0011\u0011T\u0001\u0005\u0002\u0005\u001d\u0005bBAN\u0003\u0011\u0005\u0011q\u0011\u0004\n\u0003;\u000b\u0001\u0013aI\u0011\u0003?3\u0011\"a)\u0002!\u0003\r\n#!*\u0007\r\t-\u0011\u0001\u0011B\u0007\u0011)\u0011y!\u0003BK\u0002\u0013\u0005!\u0011\u0003\u0005\u000b\u0005OI!\u0011#Q\u0001\n\tM\u0001B\u0003B\u0015\u0013\tU\r\u0011\"\u0001\u0003,!Q!\u0011I\u0005\u0003\u0012\u0003\u0006IA!\f\t\u000f\u0005%\u0012\u0002\"\u0001\u0003D!I!1J\u0005\u0002\u0002\u0013\u0005!Q\n\u0005\n\u0005'J\u0011\u0013!C\u0001\u0005+B\u0011Ba\u001b\n#\u0003%\tA!\u001c\t\u0013\u0005\r\u0017\"!A\u0005B\u0005\u001d\u0005\"CAc\u0013\u0005\u0005I\u0011AAd\u0011%\ty-CA\u0001\n\u0003\u0011\t\bC\u0005\u0002^&\t\t\u0011\"\u0011\u0002`\"I\u0011Q^\u0005\u0002\u0002\u0013\u0005!Q\u000f\u0005\n\u0003sL\u0011\u0011!C!\u0003wD\u0011\"!@\n\u0003\u0003%\t%a@\t\u0013\te\u0014\"!A\u0005B\tmt!\u0003Bv\u0003\u0005\u0005\t\u0012\u0001Bw\r%\u0011Y!AA\u0001\u0012\u0003\u0011y\u000fC\u0004\u0002*m!\tA!@\t\u0013\u0005u8$!A\u0005F\u0005}\b\"\u0003B\u00007\u0005\u0005I\u0011QB\u0001\u0011%\u00199aGA\u0001\n\u0003\u001bI\u0001C\u0005\u0003\u0002m\t\t\u0011\"\u0003\u0003\u0004\u00191!qP\u0001A\u0005\u0003C!Ba\u0004\"\u0005+\u0007I\u0011\u0001B\t\u0011)\u00119#\tB\tB\u0003%!1\u0003\u0005\b\u0003S\tC\u0011\u0001BB\u0011%\u0011Y%IA\u0001\n\u0003\u0011I\tC\u0005\u0003T\u0005\n\n\u0011\"\u0001\u0003V!I\u00111Y\u0011\u0002\u0002\u0013\u0005\u0013q\u0011\u0005\n\u0003\u000b\f\u0013\u0011!C\u0001\u0003\u000fD\u0011\"a4\"\u0003\u0003%\tA!$\t\u0013\u0005u\u0017%!A\u0005B\u0005}\u0007\"CAwC\u0005\u0005I\u0011\u0001BI\u0011%\tI0IA\u0001\n\u0003\nY\u0010C\u0005\u0002~\u0006\n\t\u0011\"\u0011\u0002\u0000\"I!\u0011P\u0011\u0002\u0002\u0013\u0005#QS\u0004\n\u0007/\t\u0011\u0011!E\u0001\u000731\u0011Ba \u0002\u0003\u0003E\taa\u0007\t\u000f\u0005%\u0002\u0007\"\u0001\u0004$!I\u0011Q \u0019\u0002\u0002\u0013\u0015\u0013q \u0005\n\u0005\u007f\u0004\u0014\u0011!CA\u0007KA\u0011ba\u00021\u0003\u0003%\ti!\u000b\t\u0013\t\u0005\u0001'!A\u0005\n\t\rqaBB\u0018\u0003!\u0005\u0015\u0011\u0019\u0004\b\u0003[\u000b\u0001\u0012QAX\u0011\u001d\tIc\u000eC\u0001\u0003\u007fC\u0011\"a18\u0003\u0003%\t%a\"\t\u0013\u0005\u0015w'!A\u0005\u0002\u0005\u001d\u0007\"CAho\u0005\u0005I\u0011AAi\u0011%\tinNA\u0001\n\u0003\ny\u000eC\u0005\u0002n^\n\t\u0011\"\u0001\u0002p\"I\u0011\u0011`\u001c\u0002\u0002\u0013\u0005\u00131 \u0005\n\u0003{<\u0014\u0011!C!\u0003\u007fD\u0011B!\u00018\u0003\u0003%IAa\u0001\u0007\r\te\u0015\u0001\u0011BN\u0011)\u0011i*\u0011BK\u0002\u0013\u0005!q\u0014\u0005\u000b\u0005O\u000b%\u0011#Q\u0001\n\t\u0005\u0006bBA\u0015\u0003\u0012\u0005!\u0011\u0016\u0005\n\u0005\u0017\n\u0015\u0011!C\u0001\u0005_C\u0011Ba\u0015B#\u0003%\tAa-\t\u0013\u0005\r\u0017)!A\u0005B\u0005\u001d\u0005\"CAc\u0003\u0006\u0005I\u0011AAd\u0011%\ty-QA\u0001\n\u0003\u00119\fC\u0005\u0002^\u0006\u000b\t\u0011\"\u0011\u0002`\"I\u0011Q^!\u0002\u0002\u0013\u0005!1\u0018\u0005\n\u0003s\f\u0015\u0011!C!\u0003wD\u0011\"!@B\u0003\u0003%\t%a@\t\u0013\te\u0014)!A\u0005B\t}v!CB\u0019\u0003\u0005\u0005\t\u0012AB\u001a\r%\u0011I*AA\u0001\u0012\u0003\u0019)\u0004C\u0004\u0002*A#\ta!\u000f\t\u0013\u0005u\b+!A\u0005F\u0005}\b\"\u0003B\u0000!\u0006\u0005I\u0011QB\u001e\u0011%\u00199\u0001UA\u0001\n\u0003\u001by\u0004C\u0005\u0003\u0002A\u000b\t\u0011\"\u0003\u0003\u0004\u0019I!1Y\u0001\u0011\u0002G\u0005\"QY\u0004\b\u0007\u000b\n\u0001\u0012\u0011Bq\r\u001d\u0011Y.\u0001EA\u0005;Dq!!\u000bY\t\u0003\u0011y\u000eC\u0005\u0002Db\u000b\t\u0011\"\u0011\u0002\b\"I\u0011Q\u0019-\u0002\u0002\u0013\u0005\u0011q\u0019\u0005\n\u0003\u001fD\u0016\u0011!C\u0001\u0005GD\u0011\"!8Y\u0003\u0003%\t%a8\t\u0013\u00055\b,!A\u0005\u0002\t\u001d\b\"CA}1\u0006\u0005I\u0011IA~\u0011%\ti\u0010WA\u0001\n\u0003\ny\u0010C\u0005\u0003\u0002a\u000b\t\u0011\"\u0003\u0003\u0004\u001d91qI\u0001\t\u0002\nEga\u0002Be\u0003!\u0005%1\u001a\u0005\b\u0003S\u0019G\u0011\u0001Bh\u0011%\t\u0019mYA\u0001\n\u0003\n9\tC\u0005\u0002F\u000e\f\t\u0011\"\u0001\u0002H\"I\u0011qZ2\u0002\u0002\u0013\u0005!1\u001b\u0005\n\u0003;\u001c\u0017\u0011!C!\u0003?D\u0011\"!<d\u0003\u0003%\tAa6\t\u0013\u0005e8-!A\u0005B\u0005m\b\"CA\u007fG\u0006\u0005I\u0011IA\u0000\u0011%\u0011\taYA\u0001\n\u0013\u0011\u0019AB\u0004\u0002\u001a\u0005\r\u0001a!\u0013\t\u0015\u0005\rSN!A!\u0002\u0013\t)\u0005\u0003\u0006\u0002T5\u0014\t\u0011)A\u0005\u0003+B!\"!\u0018n\u0005\u0003\u0005\u000b\u0011BA0\u0011)\t\t(\u001cB\u0001B\u0003%\u00111\u000f\u0005\u000b\u0003wj'\u0011!Q\u0001\n\u0005u\u0004bBA\u0015[\u0012\u00051q\u000b\u0005\n\u0007Kj'\u0019!C\u0006\u0007OB\u0001ba\u001cnA\u0003%1\u0011\u000e\u0005\n\u0007cj\u0007\u0019!C\u0005\u0007gB\u0011b! n\u0001\u0004%Iaa \t\u0011\r%U\u000e)Q\u0005\u0007kBqaa#n\t\u0003\u001ai\tC\u0004\u0004\u00106$\te!$\t\u000f\rEU\u000e\"\u0001\u0004\u0014\"91QT7\u0005\n\r}\u0005bBBT[\u0012%1\u0011\u0016\u0005\b\u0007gkG\u0011BB[\u0011\u001d\u0019i-\u001cC\u0005\u0007\u001f\fac\u0015;vG.<\u0015\r^3EKR,7\r^8s\u0003\u000e$xN\u001d\u0006\u0005\u0003\u000b\t9!\u0001\u0004bGR|'o\u001d\u0006\u0005\u0003\u0013\tY!A\u0005yYJ,G.Z1tK*!\u0011QBA\b\u0003%AXMY5bY\u0006\u00147O\u0003\u0002\u0002\u0012\u0005\u00191m\\7\u0004\u0001A\u0019\u0011qC\u0001\u000e\u0005\u0005\r!AF*uk\u000e\\w)\u0019;f\t\u0016$Xm\u0019;pe\u0006\u001bGo\u001c:\u0014\u0007\u0005\ti\u0002\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\t\t\u0019#A\u0003tG\u0006d\u0017-\u0003\u0003\u0002(\u0005\u0005\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003+\tQ\u0001\u001d:paN$B\"!\r\u0002B\u0005E\u00131LA8\u0003s\u0002B!a\r\u0002>5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0003bGR|'O\u0003\u0002\u0002<\u0005!\u0011m[6b\u0013\u0011\ty$!\u000e\u0003\u000bA\u0013x\u000e]:\t\u000f\u0005\r3\u00011\u0001\u0002F\u0005YA/Y:l'\u0016\u0014h/[2f!\u0011\t9%!\u0014\u000e\u0005\u0005%#\u0002BA&\u0003\u000f\tqa]3sm&\u001cW-\u0003\u0003\u0002P\u0005%#a\u0003+bg.\u001cVM\u001d<jG\u0016Dq!a\u0015\u0004\u0001\u0004\t)&A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u0003\u0002\u0018\u0005]\u0013\u0002BA-\u0003\u0007\u00111CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016Dq!!\u0018\u0004\u0001\u0004\ty&A\u0007he\u0006\u001cW\rR;sCRLwN\u001c\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003!!WO]1uS>t'\u0002BA5\u0003C\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\ti'a\u0019\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"9\u0011\u0011O\u0002A\u0002\u0005M\u0014aD;ogR,8m[%oi\u0016\u0014h/\u00197\u0011\r\u0005}\u0011QOA0\u0013\u0011\t9(!\t\u0003\r=\u0003H/[8o\u0011\u001d\tYh\u0001a\u0001\u0003{\nq\u0003\u001d:pG\u0016\u001c8/\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\t\u0005}\u0014\u0011Q\u0007\u0003\u0003OJA!a!\u0002h\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0005]\u0006lW-\u0006\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015\u0001\u00027b]\u001eT!!a%\u0002\t)\fg/Y\u0005\u0005\u0003/\u000biI\u0001\u0004TiJLgnZ\u0001\rg\u000eDW\rZ;mK:\u000bW.Z\u0001\u0012G>l\u0007\u000f\\3uS>t7i\\7nK:$(\u0001G*uk\u000e\\w)\u0019;f\t\u0016$Xm\u0019;pe6+7o]1hKN\u0019q!!\b*\u0007\u001dAaKA\rTiV\u001c7nR1uK\u0012+G/Z2u_J,\u0005\u0010^3s]\u0006d7#\u0002\u0005\u0002\u001e\u0005\u001d\u0006cAAU\u000f5\t\u0011!K\u0003\to%\t\u0013IA\bHKR<\u0016\r^2iK\u0012<\u0015\r^3t'%9\u0014QDAY\u0003g\u000bI\fE\u0002\u0002*\"\u0001B!a\b\u00026&!\u0011qWA\u0011\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\b\u0002<&!\u0011QXA\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\t\t\rE\u0002\u0002*^\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAAe!\u0011\ty\"a3\n\t\u00055\u0017\u0011\u0005\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003'\fI\u000e\u0005\u0003\u0002 \u0005U\u0017\u0002BAl\u0003C\u00111!\u00118z\u0011%\tYnOA\u0001\u0002\u0004\tI-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003C\u0004b!a9\u0002j\u0006MWBAAs\u0015\u0011\t9/!\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002l\u0006\u0015(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!=\u0002xB!\u0011qDAz\u0013\u0011\t)0!\t\u0003\u000f\t{w\u000e\\3b]\"I\u00111\\\u001f\u0002\u0002\u0003\u0007\u00111[\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011Z\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011R\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0006A!\u00111\u0012B\u0004\u0013\u0011\u0011I!!$\u0003\r=\u0013'.Z2u\u00055\u0019F/\u0019:u/\u0006$8\r[5oONI\u0011\"!\b\u00022\u0006M\u0016\u0011X\u0001\u0007O\u0006$X-\u00133\u0016\u0005\tM\u0001\u0003\u0002B\u000b\u0005GqAAa\u0006\u0003 A!!\u0011DA\u0011\u001b\t\u0011YB\u0003\u0003\u0003\u001e\u0005M\u0011A\u0002\u001fs_>$h(\u0003\u0003\u0003\"\u0005\u0005\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0018\n\u0015\"\u0002\u0002B\u0011\u0003C\tqaZ1uK&#\u0007%A\u0005ti\u0006\u0014H\u000fV5nKV\u0011!Q\u0006\t\u0005\u0005_\u0011i$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003\u0011!\u0018.\\3\u000b\t\t]\"\u0011H\u0001\u0005U>$\u0017M\u0003\u0002\u0003<\u0005\u0019qN]4\n\t\t}\"\u0011\u0007\u0002\t\t\u0006$X\rV5nK\u0006Q1\u000f^1siRKW.\u001a\u0011\u0015\r\t\u0015#q\tB%!\r\tI+\u0003\u0005\b\u0005\u001fq\u0001\u0019\u0001B\n\u0011\u001d\u0011IC\u0004a\u0001\u0005[\tAaY8qsR1!Q\tB(\u0005#B\u0011Ba\u0004\u0010!\u0003\u0005\rAa\u0005\t\u0013\t%r\u0002%AA\u0002\t5\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005/RCAa\u0005\u0003Z-\u0012!1\f\t\u0005\u0005;\u00129'\u0004\u0002\u0003`)!!\u0011\rB2\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003f\u0005\u0005\u0012AC1o]>$\u0018\r^5p]&!!\u0011\u000eB0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yG\u000b\u0003\u0003.\teC\u0003BAj\u0005gB\u0011\"a7\u0015\u0003\u0003\u0005\r!!3\u0015\t\u0005E(q\u000f\u0005\n\u000374\u0012\u0011!a\u0001\u0003'\fa!Z9vC2\u001cH\u0003BAy\u0005{B\u0011\"a7\u001a\u0003\u0003\u0005\r!a5\u0003\u0019M#x\u000e],bi\u000eD\u0017N\\4\u0014\u0013\u0005\ni\"!-\u00024\u0006eF\u0003\u0002BC\u0005\u000f\u00032!!+\"\u0011\u001d\u0011y\u0001\na\u0001\u0005'!BA!\"\u0003\f\"I!qB\u0013\u0011\u0002\u0003\u0007!1\u0003\u000b\u0005\u0003'\u0014y\tC\u0005\u0002\\&\n\t\u00111\u0001\u0002JR!\u0011\u0011\u001fBJ\u0011%\tYnKA\u0001\u0002\u0004\t\u0019\u000e\u0006\u0003\u0002r\n]\u0005\"CAn]\u0005\u0005\t\u0019AAj\u000519\u0016\r^2iK\u0012<\u0015\r^3t'%\t\u0015QDAY\u0003g\u000bI,A\u0003hCR,7/\u0006\u0002\u0003\"BA!Q\u0003BR\u0005'\u0011i#\u0003\u0003\u0003&\n\u0015\"aA'ba\u00061q-\u0019;fg\u0002\"BAa+\u0003.B\u0019\u0011\u0011V!\t\u000f\tuE\t1\u0001\u0003\"R!!1\u0016BY\u0011%\u0011i*\u0012I\u0001\u0002\u0004\u0011\t+\u0006\u0002\u00036*\"!\u0011\u0015B-)\u0011\t\u0019N!/\t\u0013\u0005m\u0017*!AA\u0002\u0005%G\u0003BAy\u0005{C\u0011\"a7L\u0003\u0003\u0005\r!a5\u0015\t\u0005E(\u0011\u0019\u0005\n\u00037t\u0015\u0011!a\u0001\u0003'\u0014\u0011d\u0015;vG.<\u0015\r^3EKR,7\r^8s\u0013:$XM\u001d8bYN)a+!\b\u0002(&\u001aak\u0019-\u0003\u000f){'\rR8oKNI1-!\b\u0003N\u0006M\u0016\u0011\u0018\t\u0004\u0003S3FC\u0001Bi!\r\tIk\u0019\u000b\u0005\u0003'\u0014)\u000eC\u0005\u0002\\\u001e\f\t\u00111\u0001\u0002JR!\u0011\u0011\u001fBm\u0011%\tY.[A\u0001\u0002\u0004\t\u0019N\u0001\u0003US\u000e\\7#\u0003-\u0002\u001e\t5\u00171WA])\t\u0011\t\u000fE\u0002\u0002*b#B!a5\u0003f\"I\u00111\u001c/\u0002\u0002\u0003\u0007\u0011\u0011\u001a\u000b\u0005\u0003c\u0014I\u000fC\u0005\u0002\\z\u000b\t\u00111\u0001\u0002T\u0006i1\u000b^1si^\u000bGo\u00195j]\u001e\u00042!!+\u001c'\u0015Y\"\u0011_A]!)\u0011\u0019P!?\u0003\u0014\t5\"QI\u0007\u0003\u0005kTAAa>\u0002\"\u00059!/\u001e8uS6,\u0017\u0002\u0002B~\u0005k\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011i/A\u0003baBd\u0017\u0010\u0006\u0004\u0003F\r\r1Q\u0001\u0005\b\u0005\u001fq\u0002\u0019\u0001B\n\u0011\u001d\u0011IC\ba\u0001\u0005[\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\f\rM\u0001CBA\u0010\u0003k\u001ai\u0001\u0005\u0005\u0002 \r=!1\u0003B\u0017\u0013\u0011\u0019\t\"!\t\u0003\rQ+\b\u000f\\33\u0011%\u0019)bHA\u0001\u0002\u0004\u0011)%A\u0002yIA\nAb\u0015;pa^\u000bGo\u00195j]\u001e\u00042!!+1'\u0015\u00014QDA]!!\u0011\u0019pa\b\u0003\u0014\t\u0015\u0015\u0002BB\u0011\u0005k\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0019I\u0002\u0006\u0003\u0003\u0006\u000e\u001d\u0002b\u0002B\bg\u0001\u0007!1\u0003\u000b\u0005\u0007W\u0019i\u0003\u0005\u0004\u0002 \u0005U$1\u0003\u0005\n\u0007+!\u0014\u0011!a\u0001\u0005\u000b\u000bqbR3u/\u0006$8\r[3e\u000f\u0006$Xm]\u0001\r/\u0006$8\r[3e\u000f\u0006$Xm\u001d\t\u0004\u0003S\u00036#\u0002)\u00048\u0005e\u0006\u0003\u0003Bz\u0007?\u0011\tKa+\u0015\u0005\rMB\u0003\u0002BV\u0007{AqA!(T\u0001\u0004\u0011\t\u000b\u0006\u0003\u0004B\r\r\u0003CBA\u0010\u0003k\u0012\t\u000bC\u0005\u0004\u0016Q\u000b\t\u00111\u0001\u0003,\u0006!A+[2l\u0003\u001dQuN\u0019#p]\u0016\u001cr!\\A\u000f\u0007\u0017\u001a\t\u0006\u0005\u0003\u00024\r5\u0013\u0002BB(\u0003k\u0011Q!Q2u_J\u0004B!a\r\u0004T%!1QKA\u001b\u00051\t5\r^8s\u0019><w-\u001b8h)1\u0019Ifa\u0017\u0004^\r}3\u0011MB2!\r\t9\"\u001c\u0005\b\u0003\u0007\u001a\b\u0019AA#\u0011\u001d\t\u0019f\u001da\u0001\u0003+Bq!!\u0018t\u0001\u0004\ty\u0006C\u0004\u0002rM\u0004\r!a\u001d\t\u000f\u0005m4\u000f1\u0001\u0002~\u0005\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0003\u0007S\u0002B!a \u0004l%!1QNA4\u0005a)\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0013aC:dQ\u0016$W\u000f\\3K_\n,\"a!\u001e\u0011\r\u0005}\u0011QOB<!\u0011\t\u0019d!\u001f\n\t\rm\u0014Q\u0007\u0002\f\u0007\u0006t7-\u001a7mC\ndW-A\btG\",G-\u001e7f\u0015>\u0014w\fJ3r)\u0011\u0019\tia\"\u0011\t\u0005}11Q\u0005\u0005\u0007\u000b\u000b\tC\u0001\u0003V]&$\b\"CAno\u0006\u0005\t\u0019AB;\u00031\u00198\r[3ek2,'j\u001c2!\u0003!\u0001(/Z*uCJ$HCABA\u0003!\u0001xn\u001d;Ti>\u0004\u0018a\u0002:fG\u0016Lg/Z\u000b\u0003\u0007+\u0003Baa&\u0004\u001a6\tQ.\u0003\u0003\u0004\u001c\u000e5#a\u0002*fG\u0016Lg/Z\u0001\n_:lUm]:bO\u0016$ba!&\u0004\"\u000e\r\u0006b\u0002BOy\u0002\u0007!\u0011\u0015\u0005\b\u0007Kc\b\u0019AAy\u0003)\u0001(o\\2fgNLgnZ\u0001\baJ|7-Z:t)\u0011\u0019Yk!-\u0011\r\u0005}4QVBA\u0013\u0011\u0019y+a\u001a\u0003\r\u0019+H/\u001e:f\u0011\u001d\u0011i* a\u0001\u0005C\u000bA\"\u001e8tiV\u001c7nR1uKN$Ba!!\u00048\"9!Q\u0014@A\u0002\t\u0005\u0006f\u0001@\u0004<B!1QXBe\u001b\t\u0019yL\u0003\u0003\u0003f\r\u0005'\u0002BBb\u0007\u000b\fq!\\3ue&\u001c7O\u0003\u0003\u0004H\u0006=\u0011\u0001C2pI\u0006D\u0017\r\\3\n\t\r-7q\u0018\u0002\u0006)&lW\rZ\u0001\u0019e\u0016\fGm\u0015;biV\u001cxJ]*u_B<\u0016\r^2iS:<G\u0003BBi\u0007G\u0004b!a\b\u0002v\rM\u0007\u0003BBk\u0007?l!aa6\u000b\t\re71\\\u0001\u0007gR\fG/^:\u000b\t\ru\u0017qA\u0001\u0007I>l\u0017-\u001b8\n\t\r\u00058q\u001b\u0002\u000b)\u0006\u001c8n\u0015;biV\u001c\bbBBs\u007f\u0002\u0007!1C\u0001\u0007i\u0006\u001c8.\u00133")
public class StuckGateDetectorActor
implements Actor,
ActorLogging {
    private final TaskService taskService;
    private final ReleaseActorService releaseActorService;
    private final FiniteDuration graceDuration;
    private final Option<FiniteDuration> unstuckInterval;
    private final ExecutionContext processExecutionContext;
    private final ExecutionContextExecutor executionContext;
    private Option<Cancellable> scheduleJob;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public static String completionComment() {
        return StuckGateDetectorActor$.MODULE$.completionComment();
    }

    public static String scheduleName() {
        return StuckGateDetectorActor$.MODULE$.scheduleName();
    }

    public static String name() {
        return StuckGateDetectorActor$.MODULE$.name();
    }

    public static Props props(TaskService taskService, ReleaseActorService releaseActorService, FiniteDuration finiteDuration, Option<FiniteDuration> option, ExecutionContext executionContext) {
        return StuckGateDetectorActor$.MODULE$.props(taskService, releaseActorService, finiteDuration, option, executionContext);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    private ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    private Option<Cancellable> scheduleJob() {
        return this.scheduleJob;
    }

    private void scheduleJob_$eq(Option<Cancellable> x$1) {
        this.scheduleJob = x$1;
    }

    public void preStart() {
        Actor.preStart$((Actor)this);
        this.scheduleJob_$eq((Option<Cancellable>)this.unstuckInterval.map((Function1 & Serializable & scala.Serializable)duration -> {
            this.log().info(new StringBuilder(35).append("Scheduling StuckGateDetector every ").append(duration.toString()).toString());
            return this.context().system().scheduler().schedule(duration, duration, this.self(), (Object)StuckGateDetectorActor$Tick$.MODULE$, (ExecutionContext)this.executionContext(), this.self());
        }));
    }

    public void postStop() {
        this.scheduleJob().foreach((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)StuckGateDetectorActor.$anonfun$postStop$1(this, job)));
        Actor.postStop$((Actor)this);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((Map<String, DateTime>)Predef$.MODULE$.Map().empty(), false);
    }

    public PartialFunction<Object, BoxedUnit> com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage(Map<String, DateTime> gates, boolean processing) {
        return new scala.Serializable(this, gates, processing){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StuckGateDetectorActor $outer;
            private final Map gates$1;
            private final boolean processing$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (StuckGateDetectorActor$GetWatchedGates$.MODULE$.equals(A1)) {
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)new WatchedGates((Map<String, DateTime>)this.gates$1), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof StartWatching) {
                    StartWatching startWatching = (StartWatching)A1;
                    String gateId = startWatching.gateId();
                    DateTime startTime = startWatching.startTime();
                    this.$outer.log().debug("Start watching GateTask: {}", (Object)gateId);
                    this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((Map<String, DateTime>)this.gates$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)gateId), (Object)startTime)), this.processing$1));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof StopWatching) {
                    StopWatching stopWatching = (StopWatching)A1;
                    String gateId = stopWatching.gateId();
                    this.$outer.log().debug("Stop watching GateTask: {}", (Object)gateId);
                    this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((Map<String, DateTime>)((Map)this.gates$1.$minus((Object)gateId)), this.processing$1));
                    object = BoxedUnit.UNIT;
                } else if (StuckGateDetectorActor$Tick$.MODULE$.equals(A1) && !this.processing$1) {
                    BoxedUnit boxedUnit;
                    this.$outer.log().debug("Processing {} potentially stuck GateTasks", (Object)BoxesRunTime.boxToInteger((int)this.gates$1.size()));
                    if (this.gates$1.nonEmpty()) {
                        this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((Map<String, DateTime>)this.gates$1, true));
                        this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$process((Map<String, DateTime>)this.gates$1);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else if (StuckGateDetectorActor$JobDone$.MODULE$.equals(A1) && this.processing$1) {
                    this.$outer.log().debug("Done processing stuck GateTasks. Now watching {} gates", (Object)BoxesRunTime.boxToInteger((int)this.gates$1.size()));
                    this.$outer.context().become(this.$outer.com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$onMessage((Map<String, DateTime>)this.gates$1, false));
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = StuckGateDetectorActor$GetWatchedGates$.MODULE$.equals(object) ? true : (object instanceof StartWatching ? true : (object instanceof StopWatching ? true : (StuckGateDetectorActor$Tick$.MODULE$.equals(object) && !this.processing$1 ? true : StuckGateDetectorActor$JobDone$.MODULE$.equals(object) && this.processing$1)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.gates$1 = gates$1;
                this.processing$1 = processing$1;
            }
        };
    }

    public Future<BoxedUnit> com$xebialabs$xlrelease$actors$StuckGateDetectorActor$$process(Map<String, DateTime> gates) {
        ExecutionContext ec = this.processExecutionContext;
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.unstuckGates(gates), (ExecutionContext)this.executionContext()).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StuckGateDetectorActor $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.log().error(A12, "Exception while completing stuck GateTasks: {}", (Object)A12.getMessage());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.executionContext()).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            StuckGateDetectorActor.$anonfun$process$2(this, x$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.executionContext());
    }

    @Timed
    private void unstuckGates(Map<String, DateTime> gates) {
        DateTime graceTime = DateTime.now().minus(this.graceDuration.toMillis());
        ((TraversableLike)gates.map((Function1 & Serializable & scala.Serializable)gateAndTime -> {
            Tuple2 tuple2 = gateAndTime;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String gateId = (String)tuple2._1();
            DateTime timestamp = (DateTime)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)gateId, (Object)timestamp);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$6 = (Tuple2)tuple32._1();
            String gateId2 = (String)tuple32._2();
            DateTime timestamp2 = (DateTime)tuple32._3();
            return new Tuple2(gateAndTime, (Object)x$6);
        }, Map$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StuckGateDetectorActor.$anonfun$unstuckGates$2(graceTime, x$8))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            StuckGateDetectorActor.$anonfun$unstuckGates$3(this, x$9);
            return BoxedUnit.UNIT;
        });
    }

    private Option<TaskStatus> readStatusOrStopWatching(String taskId) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.taskService.getStatus(taskId)).recoverWith((PartialFunction)new scala.Serializable(this, taskId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StuckGateDetectorActor $outer;
            private final String taskId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.log().warning(A12.getMessage());
                    package$.MODULE$.actorRef2Scala(this.$outer.self()).$bang((Object)new StopWatching(this.taskId$1), this.$outer.self());
                    object = new Failure(A12);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.taskId$1 = taskId$1;
            }
        }).toOption();
    }

    public static final /* synthetic */ boolean $anonfun$postStop$1(StuckGateDetectorActor $this, Cancellable job) {
        $this.log().info("Stopping StuckGateDetector job");
        return job.cancel();
    }

    public static final /* synthetic */ void $anonfun$process$2(StuckGateDetectorActor $this, BoxedUnit x$1) {
        package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)StuckGateDetectorActor$JobDone$.MODULE$, $this.self());
    }

    public static final /* synthetic */ boolean $anonfun$unstuckGates$2(DateTime graceTime$1, Tuple2 x$8) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x$8;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        DateTime timestamp = (DateTime)tuple2._2();
        boolean bl = timestamp.isBefore((ReadableInstant)graceTime$1);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$unstuckGates$4(StuckGateDetectorActor $this, String gateId$1, TaskStatus status) {
        TaskStatus taskStatus = status;
        TaskStatus taskStatus2 = TaskStatus.IN_PROGRESS;
        if (taskStatus == null ? taskStatus2 != null : !taskStatus.equals(taskStatus2)) {
            $this.log().debug("Stop watching {} (status: {})", (Object)gateId$1, (Object)status);
            package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new StopWatching(gateId$1), $this.self());
        } else {
            $this.log().debug("Loading {}", (Object)gateId$1);
            GateTask gateTask = (GateTask)$this.taskService.findById(gateId$1);
            $this.log().debug(new StringBuilder(15).append("       status: ").append(gateTask.getStatus()).toString());
            $this.log().debug(new StringBuilder(15).append("   conditions: ").append(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getConditions()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isChecked()))).toString());
            $this.log().debug(new StringBuilder(15).append(" dependencies: ").append(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getDependencies()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDone()))).toString());
            if (((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getConditions()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isChecked())) && ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getDependencies()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDone()))) {
                $this.log().info("Completing stuck gate {}", (Object)gateId$1);
                $this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, gateId$1, StuckGateDetectorActor$.MODULE$.completionComment(), User.SYSTEM);
                package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new StopWatching(gateId$1), $this.self());
            } else {
                $this.log().debug("Conditions not met for {} (in progress)", (Object)gateId$1);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$unstuckGates$3(StuckGateDetectorActor $this, Tuple2 x$9) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x$9;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        String gateId = (String)tuple2._1();
        $this.readStatusOrStopWatching(gateId).foreach((Function1 & Serializable & scala.Serializable)status -> {
            StuckGateDetectorActor.$anonfun$unstuckGates$4($this, gateId, status);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public StuckGateDetectorActor(TaskService taskService, ReleaseActorService releaseActorService, FiniteDuration graceDuration, Option<FiniteDuration> unstuckInterval, ExecutionContext processExecutionContext) {
        this.taskService = taskService;
        this.releaseActorService = releaseActorService;
        this.graceDuration = graceDuration;
        this.unstuckInterval = unstuckInterval;
        this.processExecutionContext = processExecutionContext;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.executionContext = this.context().system().dispatcher();
        this.scheduleJob = None$.MODULE$;
    }

    public static class StartWatching
    implements StuckGateDetectorExternal,
    Product,
    scala.Serializable {
        private final String gateId;
        private final DateTime startTime;

        public String gateId() {
            return this.gateId;
        }

        public DateTime startTime() {
            return this.startTime;
        }

        public StartWatching copy(String gateId, DateTime startTime) {
            return new StartWatching(gateId, startTime);
        }

        public String copy$default$1() {
            return this.gateId();
        }

        public DateTime copy$default$2() {
            return this.startTime();
        }

        public String productPrefix() {
            return "StartWatching";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = this.gateId();
                    break;
                }
                case 1: {
                    string = this.startTime();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return string;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StartWatching;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StartWatching)) return false;
            boolean bl = true;
            if (!bl) return false;
            StartWatching startWatching = (StartWatching)x$1;
            String string = this.gateId();
            String string2 = startWatching.gateId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            DateTime dateTime = this.startTime();
            DateTime dateTime2 = startWatching.startTime();
            if (dateTime == null) {
                if (dateTime2 != null) {
                    return false;
                }
            } else if (!dateTime.equals(dateTime2)) return false;
            if (!startWatching.canEqual(this)) return false;
            return true;
        }

        public StartWatching(String gateId, DateTime startTime) {
            this.gateId = gateId;
            this.startTime = startTime;
            Product.$init$((Product)this);
        }
    }

    public static class StopWatching
    implements StuckGateDetectorExternal,
    Product,
    scala.Serializable {
        private final String gateId;

        public String gateId() {
            return this.gateId;
        }

        public StopWatching copy(String gateId) {
            return new StopWatching(gateId);
        }

        public String copy$default$1() {
            return this.gateId();
        }

        public String productPrefix() {
            return "StopWatching";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.gateId();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StopWatching;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StopWatching)) return false;
            boolean bl = true;
            if (!bl) return false;
            StopWatching stopWatching = (StopWatching)x$1;
            String string = this.gateId();
            String string2 = stopWatching.gateId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!stopWatching.canEqual(this)) return false;
            return true;
        }

        public StopWatching(String gateId) {
            this.gateId = gateId;
            Product.$init$((Product)this);
        }
    }

    public static interface StuckGateDetectorExternal
    extends StuckGateDetectorMessage {
    }

    public static interface StuckGateDetectorInternal
    extends StuckGateDetectorMessage {
    }

    public static interface StuckGateDetectorMessage {
    }

    public static class WatchedGates
    implements StuckGateDetectorExternal,
    Product,
    scala.Serializable {
        private final Map<String, DateTime> gates;

        public Map<String, DateTime> gates() {
            return this.gates;
        }

        public WatchedGates copy(Map<String, DateTime> gates) {
            return new WatchedGates(gates);
        }

        public Map<String, DateTime> copy$default$1() {
            return this.gates();
        }

        public String productPrefix() {
            return "WatchedGates";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.gates();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof WatchedGates;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof WatchedGates)) return false;
            boolean bl = true;
            if (!bl) return false;
            WatchedGates watchedGates = (WatchedGates)x$1;
            Map<String, DateTime> map = this.gates();
            Map<String, DateTime> map2 = watchedGates.gates();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!watchedGates.canEqual(this)) return false;
            return true;
        }

        public WatchedGates(Map<String, DateTime> gates) {
            this.gates = gates;
            Product.$init$((Product)this);
        }
    }
}

