/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.EventBus;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.gate.TargetIdResolutionFailedException;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers$PhaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$ReleaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$TaskId$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions$;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t5f\u0001B\u0014)\u0001EB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003S\u0011!1\u0006A!b\u0001\n\u00039\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011q\u0003!Q1A\u0005\u0002uC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tE\u0002\u0011)\u0019!C\u0001G\"AA\u000e\u0001B\u0001B\u0003%A\r\u0003\u0005n\u0001\t\u0015\r\u0011\"\u0001o\u0011!\u0011\bA!A!\u0002\u0013y\u0007\u0002C:\u0001\u0005\u000b\u0007I\u0011\u0001;\t\u0011a\u0004!\u0011!Q\u0001\nUD\u0001\"\u001f\u0001\u0003\u0006\u0004%\tA\u001f\u0005\t}\u0002\u0011\t\u0011)A\u0005w\"1q\u0010\u0001C\u0001\u0003\u0003A\u0011\"a\r\u0001\u0005\u0004%\t!!\u000e\t\u0011\u0005}\u0003\u0001)A\u0005\u0003oAq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002\u0010\u0002!\t!!%\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006bBAg\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0003;\u0004A\u0011AAp\u0011\u001d\t)\u000f\u0001C\u0005\u0003ODq!a;\u0001\t\u0003\ti\u000fC\u0004\u0002v\u0002!I!a>\t\u0013\t-\u0001!%A\u0005\n\t5\u0001\"\u0003B\u0011\u0001E\u0005I\u0011\u0002B\u0012\u0011\u001d\u00119\u0003\u0001C\u0001\u0005SAqA!\r\u0001\t\u0003\u0011\u0019\u0004C\u0004\u0003F\u0001!\tAa\u0012\t\u000f\te\u0003\u0001\"\u0001\u0003\\!9!Q\r\u0001\u0005\u0002\t\u001d\u0004b\u0002BA\u0001\u0011%!1\u0011\u0005\b\u0005'\u0003A\u0011\u0003BK\u0011\u001d\u0011I\n\u0001C\t\u00057\u0013\u0011\u0003R3qK:$WM\\2z'\u0016\u0014h/[2f\u0015\tI#&A\u0004tKJ4\u0018nY3\u000b\u0005-b\u0013!\u0003=me\u0016dW-Y:f\u0015\tic&A\u0005yK\nL\u0017\r\\1cg*\tq&A\u0002d_6\u001c\u0001aE\u0003\u0001eabt\b\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004B]f\u0014VM\u001a\t\u0003sij\u0011\u0001K\u0005\u0003w!\u0012!CU3mK\u0006\u001cX\r\u0016:fK\n+\u0018\u000e\u001c3feB\u0011\u0011(P\u0005\u0003}!\u0012A\u0004R3qK:$WM\\2z\u0007\u0006tG-\u001b3bi\u0016\u001cu\u000e\u001c7fGR|'\u000f\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006)1\u000f\u001c45U*\tA)\u0001\u0005he&T(\u0010\\3e\u0013\t1\u0015IA\u0004M_\u001e<\u0017N\\4\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u00180F\u0001J!\tQU*D\u0001L\u0015\ta%&\u0001\u0006sKB|7/\u001b;pefL!AT&\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\nsK2,\u0017m]3SKB|7/\u001b;pef\u0004\u0013\u0001\u0006:fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-F\u0001S!\tI4+\u0003\u0002UQ\t!\"+\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\fQC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,\u0007%\u0001\nqY\u0006t\u0017\n^3n%\u0016\u0004xn]5u_JLX#\u0001-\u0011\u0005)K\u0016B\u0001.L\u0005I\u0001F.\u00198Ji\u0016l'+\u001a9pg&$xN]=\u0002'Ad\u0017M\\%uK6\u0014V\r]8tSR|'/\u001f\u0011\u0002)\u0011,\u0007/\u001a8eK:\u001c\u0017PU3q_NLGo\u001c:z+\u0005q\u0006C\u0001&`\u0013\t\u00017J\u0001\u000bEKB,g\u000eZ3oGf\u0014V\r]8tSR|'/_\u0001\u0016I\u0016\u0004XM\u001c3f]\u000eL(+\u001a9pg&$xN]=!\u0003!)g/\u001a8u\u0005V\u001cX#\u00013\u0011\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017AB3wK:$8O\u0003\u0002jU\u00051Am\\7bS:L!a\u001b4\u0003\u0011\u00153XM\u001c;CkN\f\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\u001dQ\f7o\u001b*fa>\u001c\u0018\u000e^8ssV\tq\u000e\u0005\u0002Ka&\u0011\u0011o\u0013\u0002\u000f)\u0006\u001c8NU3q_NLGo\u001c:z\u0003=!\u0018m]6SKB|7/\u001b;pef\u0004\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012!\u001e\t\u0003sYL!a\u001e\u0015\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\rG&LEmU3sm&\u001cW\rI\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016,\u0012a\u001f\t\u0003sqL!! \u0015\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0017!E1sG\"Lg/\u001b8h'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"\"#a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014A\u0011\u0011\b\u0001\u0005\u0006\u000fF\u0001\r!\u0013\u0005\u0006!F\u0001\rA\u0015\u0005\u0006-F\u0001\r\u0001\u0017\u0005\u00069F\u0001\rA\u0018\u0005\u0006EF\u0001\r\u0001\u001a\u0005\u0006[F\u0001\ra\u001c\u0005\u0006gF\u0001\r!\u001e\u0005\u0006sF\u0001\ra\u001f\u0015\u0004#\u0005]\u0001\u0003BA\r\u0003_i!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u0011\u0003G\tqAZ1di>\u0014\u0018P\u0003\u0003\u0002&\u0005\u001d\u0012!\u00022fC:\u001c(\u0002BA\u0015\u0003W\tqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003[\t1a\u001c:h\u0013\u0011\t\t$a\u0007\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001G1di&4X\rR3qK:$WM\\2z'R\fG/^:fgV\u0011\u0011q\u0007\t\u0007\u0003s\tI%a\u0014\u000f\t\u0005m\u0012Q\t\b\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0014bAA$i\u00059\u0001/Y2lC\u001e,\u0017\u0002BA&\u0003\u001b\u00121aU3r\u0015\r\t9\u0005\u000e\t\u0005\u0003#\nIF\u0004\u0003\u0002T\u0005U\u0003cAA\u001fi%\u0019\u0011q\u000b\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\tY&!\u0018\u0003\rM#(/\u001b8h\u0015\r\t9\u0006N\u0001\u001aC\u000e$\u0018N^3EKB,g\u000eZ3oGf\u001cF/\u0019;vg\u0016\u001c\b%\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003K\ni'a\u001e\u0011\t\u0005\u001d\u0014\u0011N\u0007\u0002Q&\u0019\u00111\u000e5\u0003\u0015\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010C\u0004\u0002pQ\u0001\r!!\u001d\u0002\t\u001d\fG/\u001a\t\u0005\u0003O\n\u0019(C\u0002\u0002v!\u0014\u0001bR1uKR\u000b7o\u001b\u0005\b\u0003s\"\u0002\u0019AA(\u0003I!\u0018M]4fi&#wJ\u001d,be&\f'\r\\3)\u0007Q\ti\b\u0005\u0003\u0002\u0000\u0005-UBAAA\u0015\u0011\ti\"a!\u000b\t\u0005\u0015\u0015qQ\u0001\b[\u0016$(/[2t\u0015\r\tIIL\u0001\tG>$\u0017\r[1mK&!\u0011QRAA\u0005\u0015!\u0016.\\3e\u00031)\b\u000fZ1uKR\u000b'oZ3u)\u0019\t)'a%\u0002\u0018\"9\u0011QS\u000bA\u0002\u0005=\u0013\u0001\u00043fa\u0016tG-\u001a8ds&#\u0007bBA=+\u0001\u0007\u0011q\n\u0015\u0004+\u0005u\u0014A\u00023fY\u0016$X\r\u0006\u0003\u0002 \u0006\u0015\u0006cA\u001a\u0002\"&\u0019\u00111\u0015\u001b\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003O3\u0002\u0019AA(\u0003\tIG\rK\u0002\u0017\u0003{\nQcZ3u\u0007>l\u0007\u000f\\3uC\ndWmR1uK&#7\u000f\u0006\u0003\u00020\u0006}\u0006CBAY\u0003w\u000by%\u0004\u0002\u00024*!\u0011QWA\\\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0016\u0001\u00026bm\u0006LA!!0\u00024\nQ1i\u001c7mK\u000e$\u0018n\u001c8\t\u000f\u0005\u0005w\u00031\u0001\u0002D\u00069A/\u0019:hKR\u001c\bCBAY\u0003w\u000b)\r\u0005\u0003\u0002h\u0005\u001d\u0017bAAeQ\nA\u0001\u000b\\1o\u0013R,W\u000eK\u0002\u0018\u0003{\n\u0011DZ5oI\u0006\u001bG/\u001b<f\u0013:\u001cw.\\5oO\u001e\u000bG/Z%egR!\u0011\u0011[Al!\u0019\t\t,a5\u0002P%!\u0011Q[AZ\u0005\u0011a\u0015n\u001d;\t\u000f\u0005e\u0007\u00041\u0001\u0002P\u0005A\u0001/\u0019:f]RLE\rK\u0002\u0019\u0003{\n1FZ5oI\u0006\u001bG/\u001b<f\u0013:\u001cw.\\5oO\u001e\u000bG/Z%eg^KG\u000f[8vi\u0016C\u0018n\u001d;t\u0007\",7m\u001b\u000b\u0005\u0003o\t\t\u000fC\u0004\u0002Zf\u0001\r!a\u0014)\u0007e\ti(A\u000ee_\u001aKg\u000eZ!di&4X-\u00138d_6LgnZ$bi\u0016LEm\u001d\u000b\u0005\u0003o\tI\u000fC\u0004\u0002Zj\u0001\r!a\u0014\u0002%\u001d,GOR1jY\u0006\u0014G.Z$bi\u0016LEm\u001d\u000b\u0005\u0003_\u000by\u000fC\u0004\u0002rn\u0001\r!a1\u0002\u001d\u0005\u0014wN\u001d;fIR\u000b'oZ3ug\"\u001a1$! \u00029\u0019Lg\u000eZ!mY&s7m\\7j]\u001e$U\r]3oI\u0016t7-_%egRA\u0011qGA}\u0003{\u0014\t\u0001C\u0004\u0002|r\u0001\r!a\u000e\u0002\u0013Q\f'oZ3u\u0013\u0012\u001c\b\"CA\u00009A\u0005\t\u0019AA\u001c\u0003!\u0019H/\u0019;vg\u0016\u001c\b\"\u0003B\u00029A\u0005\t\u0019\u0001B\u0003\u0003M\u0011XMZ3sK:\u001c\u0017N\\4DQ&dGM]3o!\r\u0019$qA\u0005\u0004\u0005\u0013!$a\u0002\"p_2,\u0017M\\\u0001'M&tG-\u00117m\u0013:\u001cw.\\5oO\u0012+\u0007/\u001a8eK:\u001c\u00170\u00133tI\u0011,g-Y;mi\u0012\u0012TC\u0001B\bU\u0011\t9D!\u0005,\u0005\tM\u0001\u0003\u0002B\u000b\u0005;i!Aa\u0006\u000b\t\te!1D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\b5\u0013\u0011\u0011yBa\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0014gS:$\u0017\t\u001c7J]\u000e|W.\u001b8h\t\u0016\u0004XM\u001c3f]\u000eL\u0018\nZ:%I\u00164\u0017-\u001e7uIM*\"A!\n+\t\t\u0015!\u0011C\u0001\u001cM&tG-Q2uSZ,w*\u001e;h_&tw\rV1sO\u0016$\u0018\nZ:\u0015\t\u0005E'1\u0006\u0005\b\u0005[y\u0002\u0019AA(\u0003%\u0011X\r\\3bg\u0016LE\rK\u0002 \u0003{\nabZ3u%\u0016dW-Y:f)J,W\r\u0006\u0003\u00036\t\u0005\u0003\u0003\u0002B\u001c\u0005{i!A!\u000f\u000b\u0007\tm\"&A\u0003wS\u0016<8/\u0003\u0003\u0003@\te\"a\u0003*fY\u0016\f7/\u001a+sK\u0016DqA!\f!\u0001\u0004\ty\u0005K\u0002!\u0003{\n1$\u001e9eCR,w)\u0019;f%\u00164WM]3oG&tw\r\u00155bg\u0016\u001cHCBAP\u0005\u0013\u0012i\u0005C\u0004\u0003L\u0005\u0002\r!a\u0014\u0002\r\u001d\fG/Z%e\u0011\u001d\u0011y%\ta\u0001\u0005#\n\u0001c\u001c:jO&tGk\u001c*fgR|'/\u001a3\u0011\u0011\u0005E&1KAc\u0003\u000bLAA!\u0016\u00024\n\u0019Q*\u00199)\u0007\u0005\ni(A\nbe\u000eD\u0017N^3EKB,g\u000eZ3oG&,7\u000f\u0006\u0004\u0002 \nu#q\f\u0005\b\u0005[\u0011\u0003\u0019AA(\u0011\u001d\u0011\tG\ta\u0001\u0003o\tQ\u0002Z3qK:$WM\\2z\u0013\u0012\u001c\bf\u0001\u0012\u0002~\u0005qb-\u001b8e\t\u0016\u0004XM\u001c3f]\u000eLH+\u0019:hKR\u0014\u0015\u0010V1sO\u0016$\u0018\nZ\u000b\u0005\u0005S\u0012y\u0007\u0006\u0003\u0003l\tm\u0004\u0003\u0002B7\u0005_b\u0001\u0001B\u0004\u0003r\r\u0012\rAa\u001d\u0003\u0003Q\u000bBA!\u001e\u0002FB\u00191Ga\u001e\n\u0007\teDGA\u0004O_RD\u0017N\\4\t\u000f\tu4\u00051\u0001\u0002P\u0005AA/\u0019:hKRLE\rK\u0002$\u0003{\n\u0001CZ5oIBc\u0017M\\%uK6\u0014\u00150\u00133\u0016\t\t\u0015%q\u0012\u000b\u0005\u0005\u000f\u0013\t\nE\u00034\u0005\u0013\u0013i)C\u0002\u0003\fR\u0012aa\u00149uS>t\u0007\u0003\u0002B7\u0005\u001f#qA!\u001d%\u0005\u0004\u0011\u0019\bC\u0004\u0003~\u0011\u0002\r!a\u0014\u0002;\u0019Lg\u000eZ%o!J|wM]3tg&s7m\\7j]\u001e<\u0015\r^3JIN$B!a\u000e\u0003\u0018\"9\u00111`\u0013A\u0002\u0005]\u0012AC5t)\u0016l\u0007\u000f\\1uKR!!Q\u0001BO\u0011\u001d\t)J\na\u0001\u0003\u001fB3\u0001\u0001BQ!\u0011\u0011\u0019K!+\u000e\u0005\t\u0015&\u0002\u0002BT\u0003O\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011YK!*\u0003\u000fM+'O^5dK\u0002")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final EventBus eventBus;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    @Timed
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        void var3_3;
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return var3_3;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(String id) {
        Dependency dependency = this.dependencyRepository().findById(id);
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public Collection<String> getCompletableGateIds(Collection<PlanItem> targets) {
        Seq doneTargetIds = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(targets).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone()))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Iterable$.MODULE$.canBuildFrom())).toSeq();
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("getCompletableGateIds doneTargetIds: ").append(doneTargetIds.mkString(", ")).toString());
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.findInProgressIncomingGateIds((Seq<String>)doneTargetIds).map((Function1 & Serializable & scala.Serializable)id -> {
            void var2_2;
            GateTask item = (GateTask)this.taskRepository().findById((String)id);
            this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("getCompletableGateIds item ").append(item.getId()).append(": hasConditions = ").append(item.hasConditions()).append(", hasDependencies = ").append(item.hasDependencies()).append(", isOpen = ").append(item.isOpen()).append(", status = ").append(item.getStatus()).toString());
            return var2_2;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isCompletable()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    public List<String> findActiveIncomingGateIds(String parentId) {
        Seq seq;
        if (this.planItemRepository().exists(parentId)) {
            seq = this.doFindActiveIncomingGateIds(parentId);
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Plan item ").append(parentId).append(" not found. It is either archived, or does not exist. Returning no dependencies").toString());
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava();
    }

    @Timed
    public Seq<String> findActiveIncomingGateIdsWithoutExistsCheck(String parentId) {
        return this.doFindActiveIncomingGateIds(parentId);
    }

    private Seq<String> doFindActiveIncomingGateIds(String parentId) {
        return (Seq)((SeqLike)((TraversableLike)this.findAllIncomingDependencyIds((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable & scala.Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    @Timed
    public Collection<String> getFailableGateIds(Collection<PlanItem> abortedTargets) {
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.findInProgressIncomingGateIds((Seq<String>)((Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(abortedTargets).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getId(), Seq$.MODULE$.canBuildFrom())))).asJava();
    }

    private Seq<String> findAllIncomingDependencyIds(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren) {
        return (Seq)this.dependencyRepository().findAllIncomingDependencies(targetIds, statuses, referencingChildren).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getId(), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> findAllIncomingDependencyIds$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private boolean findAllIncomingDependencyIds$default$3() {
        return false;
    }

    @Timed
    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.dependencyRepository().findByReleaseId(releaseId)).asScala()).filter((Function1 & Serializable & scala.Serializable)dep -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$findActiveOutgoingTargetIds$1(dep)))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getTargetId(), Buffer$.MODULE$.canBuildFrom())).distinct()).asJava();
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.archivingService().exists(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = Map$.MODULE$.empty();
            Release release = this.releaseRepository().findById(releaseId);
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    @Timed
    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                Dependency updatedDependency = this.dependencyRepository().update(release, (Dependency)dependency);
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, updatedDependency));
            }
        });
    }

    @Timed
    public void archiveDependencies(String releaseId, Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(referencingRelease.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$9.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (Seq<Dependency>)dependenciesToArchive);
    }

    @Timed
    public <T extends PlanItem> T findDependencyTargetByTargetId(String targetId) {
        PlanItem planItem;
        String string = targetId;
        Option<String> option = IdMatchers$ReleaseId$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.archivingService().getRelease(targetId));
        } else {
            Option<String> option2 = IdMatchers$PhaseId$.MODULE$.unapply(string);
            if (!option2.isEmpty()) {
                planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.archivingService().getPhase(targetId));
            } else {
                Option<String> option3 = IdMatchers$TaskId$.MODULE$.unapply(string);
                if (!option3.isEmpty()) {
                    planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.archivingService().getTask(targetId));
                } else {
                    throw new TargetIdResolutionFailedException(new StringBuilder(35).append("Target is not plan item, targetId= ").append(targetId).toString());
                }
            }
        }
        return (T)planItem;
    }

    private <T extends PlanItem> Option<T> findPlanItemById(String targetId) {
        Some some;
        try {
            some = new Some(this.planItemRepository().findById(targetId, ResolveOptions$.MODULE$.MINIMAL()));
        }
        catch (NotFoundException notFoundException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public Seq<String> findInProgressIncomingGateIds(Seq<String> targetIds) {
        return (Seq)((SeqLike)this.findAllIncomingDependencyIds(targetIds, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$findActiveOutgoingTargetIds$1(Dependency dep) {
        return dep.hasResolvedTarget() && !dep.isDone();
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, EventBus eventBus, TaskRepository taskRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (Seq)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).toSeq().$colon$plus((Object)TaskStatus.PLANNED, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom());
    }
}

