/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.doc;

import com.google.common.collect.ImmutableSet;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.doc.MarkdownWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class CiReferenceGenerator {
    private final boolean xebialabsMarkdown;
    private static final Set<String> PREFIX_BLACKLIST;
    private File docDir;
    private int filesWritten = 0;

    public CiReferenceGenerator(File directory) {
        this(directory, false);
    }

    public CiReferenceGenerator(File directory, boolean xebialabsMarkdown) {
        this.docDir = directory;
        this.xebialabsMarkdown = xebialabsMarkdown;
    }

    public void writeAll() {
        System.out.format("Writing to %s\n\n", this.docDir.getAbsolutePath());
        this.writeOverviewFile();
        this.writeCiFiles();
        System.out.format("\n%d files written to %s\n", this.filesWritten, this.docDir.getAbsolutePath());
    }

    public void writeOverviewFile() {
        File overviewFile = new File(this.docDir, "index.md");
        try (PrintStream out = new PrintStream(new FileOutputStream(overviewFile));){
            MarkdownWriter markdown = new MarkdownWriter(out);
            this.writeOverviewFile(markdown);
            ++this.filesWritten;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeOverviewFile(MarkdownWriter markdown) {
        this.writeHeader("XL Release CI Reference overview", "Overview", markdown);
        Set<String> prefixes = this.getPrefixes();
        for (String prefix : prefixes) {
            markdown.writeHeader2(prefix);
            markdown.writeTableHeader("Type", "Description");
            Set<Type> types = this.getTypes(prefix);
            for (Type type : types) {
                markdown.writeTableRow(this.typeLink(".", type), CiReferenceGenerator.extractFirstSentence(type.getDescriptor().getDescription()));
            }
        }
    }

    private void writeCiFiles() {
        for (String prefix : this.getPrefixes()) {
            File prefixDir = new File(this.docDir, prefix);
            prefixDir.mkdir();
            this.writeCiFiles(prefix, prefixDir);
        }
    }

    private void writeCiFiles(String prefix, File prefixDir) {
        for (Type type : this.getTypes(prefix)) {
            File ciFile = new File(prefixDir, type.getName() + ".md");
            try {
                PrintStream out = new PrintStream(new FileOutputStream(ciFile));
                Throwable throwable = null;
                try {
                    System.out.println(String.format("Writing %s", type));
                    MarkdownWriter markdown = new MarkdownWriter(out);
                    this.writeCi(type, markdown);
                    ++this.filesWritten;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void writeCi(Type type, MarkdownWriter markdown) {
        this.writeHeader(type, type.getPrefix(), markdown);
        markdown.write(type.getDescriptor().getDescription());
        markdown.writeEmptyLine();
        this.writeTypeHierarchy(type, markdown);
        markdown.writeItem("Label", type.getDescriptor().getLabel());
        if (type.getDescriptor().isVirtual()) {
            markdown.writeItem("Virtual", type.getDescriptor().isVirtual());
        }
        markdown.writeEmptyLine();
        this.writePropertyDetails("Properties", this.getProperties(type, false), markdown);
        this.writePropertyDetails("Hidden properties", this.getProperties(type, true), markdown);
    }

    private void writeHeader(Object title, String subject, MarkdownWriter markdown) {
        if (this.xebialabsMarkdown) {
            markdown.write("---");
            markdown.write(String.format("title: %s", title.toString()));
            markdown.write("product:");
            markdown.write("- xl-release");
            markdown.write("category:");
            markdown.write("- CI Reference");
            markdown.write("subject:");
            markdown.write(String.format("- %s", subject));
            markdown.write("---");
            markdown.writeEmptyLine();
        } else {
            markdown.writeHeader1(title.toString());
        }
    }

    private void writeTypeHierarchy(Type startType, MarkdownWriter markdown) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        typeHierarchy.add(startType);
        typeHierarchy.addAll(startType.getDescriptor().getSuperClasses());
        StringBuilder hierarchyText = new StringBuilder();
        for (Type someType : typeHierarchy) {
            if (!someType.equals((Object)startType)) {
                hierarchyText.append(" > ");
            }
            String typeText = this.typeLink("..", someType);
            if (PREFIX_BLACKLIST.contains(someType.getPrefix())) {
                hierarchyText.append(someType);
                continue;
            }
            hierarchyText.append(this.typeLink("..", someType));
        }
        markdown.writeItem("Type hierarchy", hierarchyText);
    }

    private void writerPropertySummary(Collection<PropertyDescriptor> properties, MarkdownWriter markdown) {
        if (properties.isEmpty()) {
            return;
        }
        markdown.writeTableHeader("Property", "Kind", "Description");
        for (PropertyDescriptor property : properties) {
            markdown.writeTableRow(MarkdownWriter.link(property.getName(), MarkdownWriter.anchor(property.getName())), this.getKindText(property), property.getDescription());
        }
        markdown.writeEmptyLine();
    }

    private void writePropertyDetails(String title, Collection<PropertyDescriptor> properties, MarkdownWriter markdown) {
        if (properties.isEmpty()) {
            return;
        }
        markdown.writeHeader2(title);
        this.writerPropertySummary(properties, markdown);
        for (PropertyDescriptor property : properties) {
            this.writeCiProperty(property, markdown);
        }
    }

    private String getKindText(PropertyDescriptor property) {
        switch (property.getKind()) {
            case BOOLEAN: {
                return "Boolean";
            }
            case INTEGER: {
                return "Integer";
            }
            case STRING: {
                if (property.isPassword()) {
                    return "Password";
                }
                return "String";
            }
            case ENUM: {
                return "Enum";
            }
            case DATE: {
                return "Date";
            }
            case CI: {
                if (property.getReferencedType() != null) {
                    return this.typeLink("..", property.getReferencedType(), property.isAsContainment() ? " (parent)" : "");
                }
                return "CI reference";
            }
            case SET_OF_STRING: {
                return "Set of string";
            }
            case SET_OF_CI: {
                return "Set of " + this.typeLink("..", property.getReferencedType(), property.isAsContainment() ? " (contained)" : "");
            }
            case LIST_OF_STRING: {
                return "List of string";
            }
            case LIST_OF_CI: {
                return "List of " + this.typeLink("..", property.getReferencedType(), property.isAsContainment() ? " (contained)" : "");
            }
            case MAP_STRING_STRING: {
                if (property.isPassword()) {
                    return "Password map";
                }
                return "Map";
            }
        }
        return "";
    }

    private void writeCiProperty(PropertyDescriptor property, MarkdownWriter markdown) {
        markdown.writeHeader3(property.getName());
        markdown.write(property.getDescription());
        markdown.writeEmptyLine();
        if (property.isHidden()) {
            markdown.writeBulletPoint("Key", MarkdownWriter.code(property.getFqn()));
        } else {
            markdown.writeBulletPoint("Label", property.getLabel());
        }
        markdown.writeBulletPoint("Kind", this.getKindText(property));
        if (property.getKind() == PropertyKind.ENUM) {
            String enumValues = property.getEnumValues().toString().replace("_", "\\_").replace("[", "").replace("]", "");
            markdown.writeBulletPoint("Allowed values", enumValues);
        }
        if (Objects.nonNull(property.getDefaultValue())) {
            markdown.writeBulletPoint("Default value", property.getDefaultValue());
        }
        if (property.isPassword()) {
            markdown.writeBulletPoint("Password", property.isPassword());
        }
        if (property.getSize() != Property.Size.DEFAULT) {
            markdown.writeBulletPoint("Size", property.getSize());
        }
        if (!property.isHidden()) {
            markdown.writeBulletPoint("Required", property.isRequired());
        }
        if (Strings.isNotBlank((String)property.getCategory()) && !property.getCategory().equals("Common")) {
            markdown.writeBulletPoint("Category", property.getCategory());
        }
        if (property.getReferencedType() != null) {
            markdown.writeBulletPoint("Reference type", property.getReferencedType());
        }
        if (property.isAsContainment()) {
            markdown.writeBulletPoint("As containment", property.isAsContainment());
        }
        if (property.isTransient() && !property.isHidden()) {
            markdown.writeBulletPoint("Transient", property.isTransient());
        }
        if (property.isReadonly()) {
            markdown.writeBulletPoint("Read-only", property.isReadonly());
        }
        if (property.isHidden()) {
            markdown.writeBulletPoint("Hidden", property.isHidden());
        }
        markdown.writeEmptyLine();
    }

    private String typeLink(String rootPath, Type type) {
        return this.typeLink(rootPath, type, "");
    }

    private String typeLink(String rootPath, Type type, String extraInfo) {
        return MarkdownWriter.link(type.toString(), String.format("%s/%s/%s.html", rootPath, type.getPrefix(), type.getName())) + extraInfo;
    }

    private Collection<PropertyDescriptor> getProperties(Type type, boolean hidden) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor property : type.getDescriptor().getPropertyDescriptors()) {
            if (hidden != property.isHidden()) continue;
            properties.add(property);
        }
        return properties;
    }

    private Set<String> getPrefixes() {
        TreeSet<String> prefixes = new TreeSet<String>();
        for (Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
            String prefix = descriptor.getType().getPrefix();
            if (PREFIX_BLACKLIST.contains(prefix)) continue;
            prefixes.add(prefix);
        }
        return prefixes;
    }

    private Set<Type> getTypes(String prefix) {
        TreeSet<Type> types = new TreeSet<Type>(new TypeComparator());
        for (Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
            if (!prefix.equals(descriptor.getType().getPrefix())) continue;
            types.add(descriptor.getType());
        }
        return types;
    }

    private static String extractFirstSentence(String text) {
        if (text == null || text.equals("Description unavailable")) {
            return "";
        }
        if (text.contains(".")) {
            return text.substring(0, text.indexOf("."));
        }
        return text;
    }

    public static void main(String[] args) {
        System.out.println("Generating CI reference documentation\n");
        try {
            File directory = null;
            directory = args.length == 0 ? Files.createTempDirectory("xl-release-ci-docs-", new FileAttribute[0]).toFile() : new File(args[0]);
            directory.mkdirs();
            CiReferenceGenerator generator = new CiReferenceGenerator(directory);
            generator.writeAll();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        LocalBooter.bootWithoutGlobalContext();
        PREFIX_BLACKLIST = ImmutableSet.of((Object)"api", (Object)"core", (Object)"credentials", (Object)"internal", (Object)"lookup", (Object)"overthere", (Object[])new String[]{"udm", "xl"});
    }

    private static class TypeComparator
    implements Comparator<Type> {
        private TypeComparator() {
        }

        @Override
        public int compare(Type o1, Type o2) {
            return o1.toString().compareTo(o2.toString());
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof TypeComparator;
        }
    }
}

