/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import java.util.Map;
import java.util.function.Function;

public class VariablesHolderForScriptContext {
    private XlrScriptContext scriptContext;
    private Map<String, Variable> previousReleaseVariables;
    private Map<String, Variable> previousFolderVariables;
    private Map<String, Variable> previousGlobalVariables;
    private Function<VariablesHolderForScriptContext, DefaultScriptService.UpdatedVariables> synchronizeCallback;

    public VariablesHolderForScriptContext(Map<String, Variable> previousReleaseVariables, Map<String, Variable> previousFolderVariables, Map<String, Variable> previousGlobalVariables, Function<VariablesHolderForScriptContext, DefaultScriptService.UpdatedVariables> synchronizeCallback) {
        this.previousReleaseVariables = previousReleaseVariables;
        this.previousFolderVariables = previousFolderVariables;
        this.previousGlobalVariables = previousGlobalVariables;
        this.synchronizeCallback = synchronizeCallback;
    }

    public Map<String, Variable> getPreviousReleaseVariables() {
        return this.previousReleaseVariables;
    }

    public Map<String, Variable> getPreviousFolderVariables() {
        return this.previousFolderVariables;
    }

    public Map<String, Variable> getPreviousGlobalVariables() {
        return this.previousGlobalVariables;
    }

    public VariablesHolderForScriptContext setPreviousReleaseVariables(Map<String, Variable> previousReleaseVariables) {
        this.previousReleaseVariables = previousReleaseVariables;
        return this;
    }

    public VariablesHolderForScriptContext setPreviousFolderVariables(Map<String, Variable> previousFolderVariables) {
        this.previousFolderVariables = previousFolderVariables;
        return this;
    }

    public VariablesHolderForScriptContext setPreviousGlobalVariables(Map<String, Variable> previousGlobalVariables) {
        this.previousGlobalVariables = previousGlobalVariables;
        return this;
    }

    public XlrScriptContext getScriptContext() {
        return this.scriptContext;
    }

    public VariablesHolderForScriptContext setScriptContext(XlrScriptContext scriptContext) {
        this.scriptContext = scriptContext;
        return this;
    }

    public void synchronize() {
        DefaultScriptService.UpdatedVariables updatedVariables = this.synchronizeCallback.apply(this);
        this.previousGlobalVariables = updatedVariables.getGlobalVariables();
        this.previousFolderVariables = updatedVariables.getFolderVariables();
        this.previousReleaseVariables = updatedVariables.getReleaseVariables();
    }
}

