/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u000f\u001f\u0001\u001dB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A!\t\u0001B\u0001B\u0003%1\tC\u0003J\u0001\u0011\u0005!\nC\u0004P\u0001\u0001\u0007I\u0011\u0002)\t\u000fm\u0003\u0001\u0019!C\u00059\"1!\r\u0001Q!\nECqa\u0019\u0001A\u0002\u0013%A\rC\u0004i\u0001\u0001\u0007I\u0011B5\t\r-\u0004\u0001\u0015)\u0003f\u0011\u001da\u0007\u00011A\u0005\n\u0011Dq!\u001c\u0001A\u0002\u0013%a\u000e\u0003\u0004q\u0001\u0001\u0006K!\u001a\u0005\u0006c\u0002!\t\u0001\u001a\u0005\u0006e\u0002!\ta\u001d\u0005\u0006i\u0002!\t!\u001e\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\tY\u0002\u0001C\t\u0003;A\u0011\"!\u0012\u0001#\u0003%\t\"a\u0012\t\r\u0005m\u0003\u0001\"\u0005t\u0011\u001d\ti\u0006\u0001C\u0005\u0003?B\u0011\"!\u001e\u0001#\u0003%I!a\u001e\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~!9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u00033\u0004A\u0011AAn\u0011\u0019\ti\u000e\u0001C\u0001g\"1\u0011q\u001c\u0001\u0005\nA\u0013\u0011\u0003\u0015:f\u0003J\u001c\u0007.\u001b<f'\u0016\u0014h/[2f\u0015\ty\u0002%A\u0004tKJ4\u0018nY3\u000b\u0005\u0005\u0012\u0013!\u0003=me\u0016dW-Y:f\u0015\t\u0019C%A\u0005yK\nL\u0017\r\\1cg*\tQ%A\u0002d_6\u001c\u0001aE\u0002\u0001Q9\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0007CA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0019\u0014\u0001C4sSjTH.\u001a3\n\u0005U\u0002$a\u0002'pO\u001eLgnZ\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\"\u0001O\u001d\u000e\u0003yI!A\u000f\u0010\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0017!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011Q\bQ\u0007\u0002})\u0011q\bI\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA!?\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0010CJ\u001c\u0007.\u001b<j]\u001e\u001cuN\u001c4jOB\u0011AiR\u0007\u0002\u000b*\u0011a\tI\u0001\u0007G>tg-[4\n\u0005!+%\u0001G!sG\"Lg/\u001b8h'\u0016$H/\u001b8hg6\u000bg.Y4fe\u00061A(\u001b8jiz\"Ba\u0013'N\u001dB\u0011\u0001\b\u0001\u0005\u0006m\u0011\u0001\ra\u000e\u0005\u0006w\u0011\u0001\r\u0001\u0010\u0005\u0006\u0005\u0012\u0001\raQ\u0001\u0005a>|G.F\u0001R!\t\u0011\u0016,D\u0001T\u0015\t!V+\u0001\u0006d_:\u001cWO\u001d:f]RT!AV,\u0002\tU$\u0018\u000e\u001c\u0006\u00021\u0006!!.\u0019<b\u0013\tQ6K\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0001\u0002]8pY~#S-\u001d\u000b\u0003;\u0002\u0004\"!\u000b0\n\u0005}S#\u0001B+oSRDq!\u0019\u0004\u0002\u0002\u0003\u0007\u0011+A\u0002yIE\nQ\u0001]8pY\u0002\nq!\u001a8bE2,G-F\u0001f!\tIc-\u0003\u0002hU\t9!i\\8mK\u0006t\u0017aC3oC\ndW\rZ0%KF$\"!\u00186\t\u000f\u0005L\u0011\u0011!a\u0001K\u0006AQM\\1cY\u0016$\u0007%\u0001\u0006dCR\u001c\u0007.\u001b8h+B\fabY1uG\"LgnZ+q?\u0012*\u0017\u000f\u0006\u0002^_\"9\u0011\rDA\u0001\u0002\u0004)\u0017aC2bi\u000eD\u0017N\\4Va\u0002\n\u0011\"[:F]\u0006\u0014G.\u001a3\u0002\u000bM$\u0018M\u001d;\u0015\u0003u\u000b!\u0004\u001d:f\u0003J\u001c\u0007.\u001b<f\u0007>l\u0007\u000f\\3uK\u0012\u0014V\r\\3bg\u0016$\"!\u0018<\t\u000b]\u0004\u0002\u0019\u0001=\u0002\u000b\u00154XM\u001c;\u0011\u0005etX\"\u0001>\u000b\u0005md\u0018AB3wK:$8O\u0003\u0002~A\u00051Am\\7bS:L!a >\u0003+I+G.Z1tK\u000e{W\u000e\u001d7fi\u0016$WI^3oi\"\u001a\u0001#a\u0001\u0011\t\u0005\u0015\u0011\u0011B\u0007\u0003\u0003\u000fQ!a\u001f\u0011\n\t\u0005-\u0011q\u0001\u0002\n'V\u00147o\u0019:jE\u0016\f\u0001\u0004\u001d:f\u0003J\u001c\u0007.\u001b<f\u0003\n|'\u000f^3e%\u0016dW-Y:f)\ri\u0016\u0011\u0003\u0005\u0007oF\u0001\r!a\u0005\u0011\u0007e\f)\"C\u0002\u0002\u0018i\u00141CU3mK\u0006\u001cX-\u00112peR,G-\u0012<f]RD3!EA\u0002\u0003)\u0001(/Z!sG\"Lg/\u001a\u000b\u0006;\u0006}\u00111\u0006\u0005\b\u0003C\u0011\u0002\u0019AA\u0012\u0003\u001d\u0011X\r\\3bg\u0016\u0004B!!\n\u0002(5\tA0C\u0002\u0002*q\u0014qAU3mK\u0006\u001cX\r\u0003\u0005\u0002.I\u0001\n\u00111\u0001f\u00031\u0019\u0007.Z2l\u000b:\f'\r\\3eQ\r\u0011\u0012\u0011\u0007\t\u0005\u0003g\t\t%\u0004\u0002\u00026)!\u0011qGA\u001d\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003w\ti$A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005}B%\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t\u0019%!\u000e\u0003\u000bQKW.\u001a3\u0002)A\u0014X-\u0011:dQ&4X\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tIEK\u0002f\u0003\u0017Z#!!\u0014\u0011\t\u0005=\u0013qK\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003oQ\u0013\u0002BA-\u0003#\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0019\u0002(/Z!sG\"Lg/Z%oC\u000e$\u0018N^3SK2,\u0017m]3t\u0013:\u0014\u0015mY6he>,h\u000eZ\u0001\u001baJ,\u0017I]2iSZ,\u0017J\\1di&4XMU3mK\u0006\u001cXm\u001d\u000b\u0004;\u0006\u0005\u0004\"CA2+A\u0005\t\u0019AA3\u0003\u0011\u0001\u0018mZ3\u0011\u0007%\n9'C\u0002\u0002j)\u00121!\u00138uQ\r)\u0012Q\u000e\t\u0005\u0003_\n\t(\u0004\u0002\u0002V%!\u00111OA+\u0005\u001d!\u0018-\u001b7sK\u000e\fA\u0005\u001d:f\u0003J\u001c\u0007.\u001b<f\u0013:\f7\r^5wKJ+G.Z1tKN$C-\u001a4bk2$H%M\u000b\u0003\u0003sRC!!\u001a\u0002L\u0005y1/\u001e2nSR<\u0016\u000e\u001e5EK2\f\u0017\u0010\u0006\u0003\u0002\u0000\u0005-EcA/\u0002\u0002\"9\u00111Q\fA\u0002\u0005\u0015\u0015a\u00016pEB!\u0011&a\"^\u0013\r\tII\u000b\u0002\n\rVt7\r^5p]BBq!!$\u0018\u0001\u0004\ty)A\u0003eK2\f\u0017\u0010\u0005\u0003\u0002\u0012\u0006eUBAAJ\u0015\u0011\t)*a&\u0002\u0011\u0011,(/\u0019;j_:T!\u0001\u0016\u0016\n\t\u0005m\u00151\u0013\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003\u0019\u0019XOY7jiV!\u0011\u0011UAV)\ri\u00161\u0015\u0005\b\u0003\u0007C\u0002\u0019AAS!\u0015I\u0013qQAT!\u0011\tI+a+\r\u0001\u00119\u0011Q\u0016\rC\u0002\u0005=&!A+\u0012\t\u0005E\u0016q\u0017\t\u0004S\u0005M\u0016bAA[U\t9aj\u001c;iS:<\u0007cA\u0015\u0002:&\u0019\u00111\u0018\u0016\u0003\u0007\u0005s\u00170\u0001\u0005sk:t\u0017M\u00197f+\u0011\t\t-a6\u0015\t\u0005\r\u0017q\u001a\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*\u0019\u0011\u0011Z,\u0002\t1\fgnZ\u0005\u0005\u0003\u001b\f9M\u0001\u0005Sk:t\u0017M\u00197f\u0011\u001d\t\t.\u0007a\u0001\u0003'\fAAY8esB)\u0011&a\"\u0002VB!\u0011\u0011VAl\t\u001d\ti+\u0007b\u0001\u0003_\u000bq\u0001Z5tC\ndW\rF\u0001f\u0003\u0019)g.\u00192mK\u0006Q1M]3bi\u0016\u0004vn\u001c7)\u0007\u0001\t\u0019\u000f\u0005\u0003\u0002\u0006\u0005\u0015\u0018\u0002BAt\u0003\u000f\u0011Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\bf\u0001\u0001\u0002lB!\u0011Q^A~\u001b\t\tyO\u0003\u0003\u0002r\u0006M\u0018AC:uKJ,w\u000e^=qK*!\u0011Q_A|\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA}\u0003\ry'oZ\u0005\u0005\u0003{\fyOA\u0004TKJ4\u0018nY3")
public class PreArchiveService
implements Logging {
    private final ArchivingService archivingService;
    private final ReleaseRepository releaseRepository;
    private final ArchivingSettingsManager archivingConfig;
    private ScheduledExecutorService pool;
    private boolean enabled;
    private boolean catchingUp;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private ScheduledExecutorService pool() {
        return this.pool;
    }

    private void pool_$eq(ScheduledExecutorService x$1) {
        this.pool = x$1;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private boolean catchingUp() {
        return this.catchingUp;
    }

    private void catchingUp_$eq(boolean x$1) {
        this.catchingUp = x$1;
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public void start() {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "PreArchiveService is starting...");
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "Setting preArchivingEnabled callback...");
        this.archivingConfig.subscribeToPreArchivingEnabledChanges(becomesEnabled -> {
            PreArchiveService preArchiveService = this;
            synchronized (preArchiveService) {
                if (Predef$.MODULE$.Boolean2boolean(becomesEnabled)) {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "disabled -> enabled");
                    this.enabled_$eq(true);
                    this.preArchiveInactiveReleasesInBackground();
                } else {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "enabled -> disabled");
                    this.enabled_$eq(false);
                }
            }
        });
        this.enabled_$eq(this.archivingConfig.getPreArchivingEnabled());
        if (this.enabled()) {
            this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
        }
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "PreArchiveService started.");
    }

    @Subscribe
    public void preArchiveCompletedRelease(ReleaseCompletedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2());
    }

    @Subscribe
    public void preArchiveAbortedRelease(ReleaseAbortedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2());
    }

    @Timed
    public void preArchive(Release release, boolean checkEnabled) {
        if (!checkEnabled || this.enabled() && !this.catchingUp()) {
            if (!release.isTutorial()) {
                this.submit((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    try {
                        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Pre-archiving ").append(release).toString());
                        $this.archivingService.preArchiveRelease(release);
                        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Pre-archived ").append(release).toString());
                    }
                    catch (Exception e) {
                        this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Something went wrong while pre-archiving", (Function0 & Serializable & scala.Serializable)() -> e);
                    }
                });
            }
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Pre-archiving is disabled");
        }
    }

    public boolean preArchive$default$2() {
        return true;
    }

    public synchronized void preArchiveInactiveReleasesInBackground() {
        block0: {
            if (this.catchingUp()) break block0;
            this.catchingUp_$eq(true);
            this.submit((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
                this.catchingUp_$eq(false);
            });
        }
    }

    private void preArchiveInactiveReleases(int page) {
        while (true) {
            Integer pageSize = this.archivingConfig.getSearchPageSize();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Fetching page ").append(page).append(" (").append(pageSize).append(" releases) for pre-archiving...").toString());
            Seq<Release> found = this.releaseRepository.findPreArchivableReleases(page, Predef$.MODULE$.Integer2int(pageSize));
            found.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                this.preArchive(x$1, false);
                return BoxedUnit.UNIT;
            });
            if (!this.enabled() || !BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)found.size()), (Object)pageSize)) break;
            ++page;
        }
    }

    private int preArchiveInactiveReleases$default$1() {
        return 0;
    }

    private void submitWithDelay(FiniteDuration delay, Function0<BoxedUnit> job) {
        this.pool().schedule(this.runnable(job), delay.toSeconds(), TimeUnit.SECONDS);
    }

    private <U> void submit(Function0<U> job) {
        this.pool().submit(this.runnable(job));
    }

    private <U> Runnable runnable(Function0<U> body) {
        return () -> body.apply();
    }

    public boolean disable() {
        this.pool().shutdown();
        return this.pool().awaitTermination(10L, TimeUnit.SECONDS);
    }

    public void enable() {
        block0: {
            if (!this.pool().isShutdown() && !this.pool().isTerminated()) break block0;
            this.pool_$eq(this.createPool());
        }
    }

    private ScheduledExecutorService createPool() {
        return Executors.newScheduledThreadPool(4, new PrefixedThreadFactory("pre-archiving", Predef$.MODULE$.boolean2Boolean(true)));
    }

    public PreArchiveService(ArchivingService archivingService, ReleaseRepository releaseRepository, ArchivingSettingsManager archivingConfig) {
        this.archivingService = archivingService;
        this.releaseRepository = releaseRepository;
        this.archivingConfig = archivingConfig;
        Logging.$init$((Logging)this);
        this.pool = this.createPool();
        this.enabled = false;
        this.catchingUp = false;
    }
}

