/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001\u0002\u0010 \u0001!B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\tC\u0003K\u0001\u0011\u00051\nC\u0004Q\u0001\u0001\u0007I\u0011B)\t\u000fq\u0003\u0001\u0019!C\u0005;\"11\r\u0001Q!\nICq\u0001\u001a\u0001A\u0002\u0013%Q\rC\u0004j\u0001\u0001\u0007I\u0011\u00026\t\r1\u0004\u0001\u0015)\u0003g\u0011\u001di\u0007\u00011A\u0005\n\u0015DqA\u001c\u0001A\u0002\u0013%q\u000e\u0003\u0004r\u0001\u0001\u0006KA\u001a\u0005\u0006e\u0002!\t!\u001a\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0006k\u0002!\tA\u001e\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\ti\u0002\u0001C\t\u0003?A\u0011\"a\u0013\u0001#\u0003%\t\"!\u0014\t\u0013\u0005\u0005\u0004!%A\u0005\u0012\u00055\u0003BBA2\u0001\u0011EA\u000fC\u0004\u0002f\u0001!I!a\u001a\t\u0013\u0005u\u0004!%A\u0005\n\u0005}\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003K\u0003A\u0011BAT\u0011\u001d\t)\r\u0001C\u0005\u0003\u000fDq!!9\u0001\t\u0003\t\u0019\u000f\u0003\u0004\u0002f\u0002!\t\u0001\u001e\u0005\u0007\u0003O\u0004A\u0011B)\u0003#A\u0013X-\u0011:dQ&4XmU3sm&\u001cWM\u0003\u0002!C\u000591/\u001a:wS\u000e,'B\u0001\u0012$\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002%K\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002M\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g!\t\u0001T'D\u00012\u0015\t\u00114'A\u0003tY\u001a$$NC\u00015\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001c2\u0005\u001daunZ4j]\u001e\f\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0011\u0005eRT\"A\u0010\n\u0005mz\"\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0006\n!B]3q_NLGo\u001c:z\u0013\t\u0011uHA\tSK2,\u0017m]3SKB|7/\u001b;pef\fq\"\u0019:dQ&4\u0018N\\4D_:4\u0017n\u001a\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u0006\naaY8oM&<\u0017BA%G\u0005a\t%o\u00195jm&twmU3ui&twm]'b]\u0006<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1kej\u0014\t\u0003s\u0001AQa\u000e\u0003A\u0002aBQ\u0001\u0010\u0003A\u0002uBQa\u0011\u0003A\u0002\u0011\u000bA\u0001]8pYV\t!\u000b\u0005\u0002T56\tAK\u0003\u0002V-\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005]C\u0016\u0001B;uS2T\u0011!W\u0001\u0005U\u00064\u0018-\u0003\u0002\\)\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0011A|w\u000e\\0%KF$\"AX1\u0011\u0005)z\u0016B\u00011,\u0005\u0011)f.\u001b;\t\u000f\t4\u0011\u0011!a\u0001%\u0006\u0019\u0001\u0010J\u0019\u0002\u000bA|w\u000e\u001c\u0011\u0002\u000f\u0015t\u0017M\u00197fIV\ta\r\u0005\u0002+O&\u0011\u0001n\u000b\u0002\b\u0005>|G.Z1o\u0003-)g.\u00192mK\u0012|F%Z9\u0015\u0005y[\u0007b\u00022\n\u0003\u0003\u0005\rAZ\u0001\tK:\f'\r\\3eA\u0005Q1-\u0019;dQ&tw-\u00169\u0002\u001d\r\fGo\u00195j]\u001e,\u0006o\u0018\u0013fcR\u0011a\f\u001d\u0005\bE2\t\t\u00111\u0001g\u0003-\u0019\u0017\r^2iS:<W\u000b\u001d\u0011\u0002\u0013%\u001cXI\\1cY\u0016$\u0017!B:uCJ$H#\u00010\u00025A\u0014X-\u0011:dQ&4XmQ8na2,G/\u001a3SK2,\u0017m]3\u0015\u0005y;\b\"\u0002=\u0011\u0001\u0004I\u0018!B3wK:$\bC\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003\u0019)g/\u001a8ug*\u0011a0I\u0001\u0007I>l\u0017-\u001b8\n\u0007\u0005\u00051PA\u000bSK2,\u0017m]3D_6\u0004H.\u001a;fI\u00163XM\u001c;)\u0007A\t)\u0001\u0005\u0003\u0002\b\u0005-QBAA\u0005\u0015\ta\u0018%\u0003\u0003\u0002\u000e\u0005%!!C*vEN\u001c'/\u001b2f\u0003a\u0001(/Z!sG\"Lg/Z!c_J$X\r\u001a*fY\u0016\f7/\u001a\u000b\u0004=\u0006M\u0001B\u0002=\u0012\u0001\u0004\t)\u0002E\u0002{\u0003/I1!!\u0007|\u0005M\u0011V\r\\3bg\u0016\f%m\u001c:uK\u0012,e/\u001a8uQ\r\t\u0012QA\u0001\u000baJ,\u0017I]2iSZ,Gc\u00020\u0002\"\u00055\u0012\u0011\u0007\u0005\b\u0003G\u0011\u0002\u0019AA\u0013\u0003\u001d\u0011X\r\\3bg\u0016\u0004B!a\n\u0002*5\tQ0C\u0002\u0002,u\u0014qAU3mK\u0006\u001cX\r\u0003\u0005\u00020I\u0001\n\u00111\u0001g\u00031\u0019\u0007.Z2l\u000b:\f'\r\\3e\u0011!\t\u0019D\u0005I\u0001\u0002\u00041\u0017a\u0004:fG>4XM]%g\u000bbL7\u000f^:)\u0007I\t9\u0004\u0005\u0003\u0002:\u0005\u001dSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002B\u0005\r\u0013aB7fiJL7m\u001d\u0006\u0004\u0003\u000b*\u0013\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005%\u00131\b\u0002\u0006)&lW\rZ\u0001\u0015aJ,\u0017I]2iSZ,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005=#f\u00014\u0002R-\u0012\u00111\u000b\t\u0005\u0003+\ni&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003%)hn\u00195fG.,GMC\u0002\u0002>-JA!a\u0018\u0002X\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)A\u0014X-\u0011:dQ&4X\r\n3fM\u0006,H\u000e\u001e\u00134\u0003\u0019\u0002(/Z!sG\"Lg/Z%oC\u000e$\u0018N^3SK2,\u0017m]3t\u0013:\u0014\u0015mY6he>,h\u000eZ\u0001\u001baJ,\u0017I]2iSZ,\u0017J\\1di&4XMU3mK\u0006\u001cXm\u001d\u000b\u0004=\u0006%\u0004\"CA6-A\u0005\t\u0019AA7\u0003\u0011\u0001\u0018mZ3\u0011\u0007)\ny'C\u0002\u0002r-\u00121!\u00138uQ\r1\u0012Q\u000f\t\u0005\u0003o\nI(\u0004\u0002\u0002\\%!\u00111PA.\u0005\u001d!\u0018-\u001b7sK\u000e\fA\u0005\u001d:f\u0003J\u001c\u0007.\u001b<f\u0013:\f7\r^5wKJ+G.Z1tKN$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0003SC!!\u001c\u0002R\u0005y1/\u001e2nSR<\u0016\u000e\u001e5EK2\f\u0017\u0010\u0006\u0003\u0002\b\u0006MEc\u00010\u0002\n\"9\u00111\u0012\rA\u0002\u00055\u0015a\u00016pEB!!&a$_\u0013\r\t\tj\u000b\u0002\n\rVt7\r^5p]BBq!!&\u0019\u0001\u0004\t9*A\u0003eK2\f\u0017\u0010\u0005\u0003\u0002\u001a\u0006\u0005VBAAN\u0015\u0011\ti*a(\u0002\u0011\u0011,(/\u0019;j_:T!!V\u0016\n\t\u0005\r\u00161\u0014\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003\u0019\u0019XOY7jiV!\u0011\u0011VAZ)\rq\u00161\u0016\u0005\b\u0003\u0017K\u0002\u0019AAW!\u0015Q\u0013qRAX!\u0011\t\t,a-\r\u0001\u00119\u0011QW\rC\u0002\u0005]&!A+\u0012\t\u0005e\u0016q\u0018\t\u0004U\u0005m\u0016bAA_W\t9aj\u001c;iS:<\u0007c\u0001\u0016\u0002B&\u0019\u00111Y\u0016\u0003\u0007\u0005s\u00170\u0001\u0005sk:t\u0017M\u00197f+\u0011\tI-a8\u0015\t\u0005-\u0017q\u001b\t\u0005\u0003\u001b\f\u0019.\u0004\u0002\u0002P*\u0019\u0011\u0011\u001b-\u0002\t1\fgnZ\u0005\u0005\u0003+\fyM\u0001\u0005Sk:t\u0017M\u00197f\u0011\u001d\tIN\u0007a\u0001\u00037\fAAY8esB)!&a$\u0002^B!\u0011\u0011WAp\t\u001d\t)L\u0007b\u0001\u0003o\u000bq\u0001Z5tC\ndW\rF\u0001g\u0003\u0019)g.\u00192mK\u0006Q1M]3bi\u0016\u0004vn\u001c7)\u0007\u0001\tY\u000f\u0005\u0003\u0002\b\u00055\u0018\u0002BAx\u0003\u0013\u0011Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\bf\u0001\u0001\u0002tB!\u0011Q\u001fB\u0002\u001b\t\t9P\u0003\u0003\u0002z\u0006m\u0018AC:uKJ,w\u000e^=qK*!\u0011Q`A\u0000\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'B\u0001B\u0001\u0003\ry'oZ\u0005\u0005\u0005\u000b\t9PA\u0004TKJ4\u0018nY3")
public class PreArchiveService
implements Logging {
    private final ArchivingService archivingService;
    private final ReleaseRepository releaseRepository;
    private final ArchivingSettingsManager archivingConfig;
    private ScheduledExecutorService pool;
    private boolean enabled;
    private boolean catchingUp;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private ScheduledExecutorService pool() {
        return this.pool;
    }

    private void pool_$eq(ScheduledExecutorService x$1) {
        this.pool = x$1;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private boolean catchingUp() {
        return this.catchingUp;
    }

    private void catchingUp_$eq(boolean x$1) {
        this.catchingUp = x$1;
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public void start() {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "PreArchiveService is starting...");
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "Setting preArchivingEnabled callback...");
        this.archivingConfig.subscribeToPreArchivingEnabledChanges(becomesEnabled -> {
            PreArchiveService preArchiveService = this;
            synchronized (preArchiveService) {
                if (Predef$.MODULE$.Boolean2boolean(becomesEnabled)) {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "disabled -> enabled");
                    this.enabled_$eq(true);
                    this.preArchiveInactiveReleasesInBackground();
                } else {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "enabled -> disabled");
                    this.enabled_$eq(false);
                }
            }
        });
        this.enabled_$eq(this.archivingConfig.getPreArchivingEnabled());
        if (this.enabled()) {
            this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
        }
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "PreArchiveService started.");
    }

    @Subscribe
    public void preArchiveCompletedRelease(ReleaseCompletedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2(), this.preArchive$default$3());
    }

    @Subscribe
    public void preArchiveAbortedRelease(ReleaseAbortedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2(), this.preArchive$default$3());
    }

    @Timed
    public void preArchive(Release release, boolean checkEnabled, boolean recoverIfExists) {
        if (!checkEnabled || this.enabled() && !this.catchingUp()) {
            if (!release.isTutorial()) {
                this.submit((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    try {
                        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Pre-archiving ").append(release).toString());
                        $this.archivingService.preArchiveRelease(release);
                        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Pre-archived ").append(release).toString());
                    }
                    catch (Exception e) {
                        this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Something went wrong while pre-archiving", (Function0 & Serializable & scala.Serializable)() -> e);
                        if (!recoverIfExists) {
                            throw e;
                        }
                        if ($this.archivingService.exists(release.getId())) {
                            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removing ").append(release).append(" from Archive Database").toString());
                            if ($this.archivingService.deletePreArchiveRelease(release.getId())) {
                                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Pre-archiving again ").append(release).toString());
                                this.preArchive(release, checkEnabled, false);
                            } else {
                                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Removing failed ").append(release).append(" from Archive Database").toString());
                            }
                        }
                        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Release ").append(release).append(" does not exist in Archive Database").toString(), (Function0 & Serializable & scala.Serializable)() -> e);
                        throw e;
                    }
                });
            }
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Pre-archiving is disabled");
        }
    }

    public boolean preArchive$default$2() {
        return true;
    }

    public boolean preArchive$default$3() {
        return true;
    }

    public synchronized void preArchiveInactiveReleasesInBackground() {
        block0: {
            if (this.catchingUp()) break block0;
            this.catchingUp_$eq(true);
            this.submit((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
                this.catchingUp_$eq(false);
            });
        }
    }

    private void preArchiveInactiveReleases(int page) {
        while (true) {
            Integer pageSize = this.archivingConfig.getSearchPageSize();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Fetching page ").append(page).append(" (").append(pageSize).append(" releases) for pre-archiving...").toString());
            Seq<Release> found = this.releaseRepository.findPreArchivableReleases(page, Predef$.MODULE$.Integer2int(pageSize));
            found.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                this.preArchive(x$1, false, this.preArchive$default$3());
                return BoxedUnit.UNIT;
            });
            if (!this.enabled() || !BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)found.size()), (Object)pageSize)) break;
            ++page;
        }
    }

    private int preArchiveInactiveReleases$default$1() {
        return 0;
    }

    private void submitWithDelay(FiniteDuration delay, Function0<BoxedUnit> job) {
        this.pool().schedule(this.runnable(job), delay.toSeconds(), TimeUnit.SECONDS);
    }

    private <U> void submit(Function0<U> job) {
        this.pool().submit(this.runnable(job));
    }

    private <U> Runnable runnable(Function0<U> body) {
        return () -> body.apply();
    }

    public boolean disable() {
        this.pool().shutdown();
        return this.pool().awaitTermination(10L, TimeUnit.SECONDS);
    }

    public void enable() {
        block0: {
            if (!this.pool().isShutdown() && !this.pool().isTerminated()) break block0;
            this.pool_$eq(this.createPool());
        }
    }

    private ScheduledExecutorService createPool() {
        return Executors.newScheduledThreadPool(4, new PrefixedThreadFactory("pre-archiving", Predef$.MODULE$.boolean2Boolean(true)));
    }

    public PreArchiveService(ArchivingService archivingService, ReleaseRepository releaseRepository, ArchivingSettingsManager archivingConfig) {
        this.archivingService = archivingService;
        this.releaseRepository = releaseRepository;
        this.archivingConfig = archivingConfig;
        Logging.$init$((Logging)this);
        this.pool = this.createPool();
        this.enabled = false;
        this.catchingUp = false;
    }
}

