/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.task;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateValidator;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdater;
import com.xebialabs.xlrelease.security.TaskGranularPermissions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultTaskUpdater
implements TaskUpdater {
    @Autowired(required=false)
    private List<TaskUpdateValidator> validators = Collections.emptyList();
    @Autowired
    private TaskGranularPermissions taskGranularPermissions;

    @Override
    public Class<? extends Task> getTaskClass() {
        return Task.class;
    }

    @Override
    public Changes update(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        return this.updateAll(original, updated, updateDirectives);
    }

    private Changes updateAll(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        this.validators.forEach(v -> v.checkTask(original, updated));
        Changes changes = new Changes();
        boolean didUpdateHappen = false;
        if (this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            original.setCheckAttributes(updated.isCheckAttributes());
            original.setPhaseRecoverOp(updated.getPhaseRecoverOp());
            original.setOverdueNotified(false);
            original.setDueSoonNotified(false);
            original.setTeam(updated.getTeam());
            original.setWaitForScheduledStartDate(updated.isWaitForScheduledStartDate());
            original.getVariableMapping().keySet().removeIf(k -> !updated.getVariableMapping().containsKey(k));
            original.getVariableMapping().putAll(updated.getVariableMapping());
            if (!Objects.equals(original.getOwner(), updated.getOwner())) {
                original.setOwner(updated.getOwner());
            }
            didUpdateHappen = true;
        }
        didUpdateHappen = this.updateTaskTags(original, updated, updateDirectives) || didUpdateHappen;
        didUpdateHappen = this.updateTaskDates(original, updated, updateDirectives) || didUpdateHappen;
        didUpdateHappen = this.updateTaskFlag(original, updated, updateDirectives) || didUpdateHappen;
        didUpdateHappen = this.updateTaskDescriptionAndTitle(original, updated, updateDirectives) || didUpdateHappen;
        didUpdateHappen = this.updateTaskFailureHandler(original, updated, updateDirectives) || didUpdateHappen;
        didUpdateHappen = this.updateTaskPrecondition(original, updated, updateDirectives) || didUpdateHappen;
        boolean bl = didUpdateHappen = this.updateTaskPostponeDuringBlackout(original, updated, updateDirectives) || didUpdateHappen;
        if (didUpdateHappen) {
            changes.update((ConfigurationItem)original);
        }
        return changes;
    }

    private boolean updateTaskPrecondition(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        if (!original.getRelease().isTemplate() && updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_PRECONDITION) || original.getRelease().isTemplate() && updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TEMPLATE_TASK_PRECONDITION) || this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            original.setPrecondition(updated.getPrecondition());
            return true;
        }
        return false;
    }

    private boolean updateTaskFailureHandler(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        if (!original.getRelease().isTemplate() && updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_FAILURE_HANDLER) || original.getRelease().isTemplate() && updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TEMPLATE_TASK_FAILURE_HANDLER) || this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            original.setFailureHandler(updated.getFailureHandler());
            original.setTaskFailureHandlerEnabled(updated.isTaskFailureHandlerEnabled());
            original.setTaskRecoverOp(updated.getTaskRecoverOp());
            return true;
        }
        return false;
    }

    protected boolean hasDirectiveToUpdateAllProperties(Task original, Set<TaskUpdateDirective> updateDirectives) {
        return this.taskGranularPermissions.hasDirectiveToUpdateAllProperties(original.getRelease(), updateDirectives);
    }

    private boolean updateTaskTags(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        if (updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_TAGS) || this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            original.setTags(updated.getTags());
            return true;
        }
        return false;
    }

    private boolean updateTaskDates(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        if (updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_DATES) || this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            original.updateDates(updated.getScheduledStartDate(), updated.getDueDate(), updated.getPlannedDuration());
            return true;
        }
        return false;
    }

    private boolean updateTaskFlag(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        if (updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_FLAG) || this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            original.setFlagStatus(updated.getFlagStatus());
            original.setFlagComment(updated.getFlagComment());
            return true;
        }
        return false;
    }

    private boolean updateTaskDescriptionAndTitle(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        if (updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_DESCRIPTION_AND_TITLE) || this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            original.setTitle(updated.getTitle());
            original.setDescription(updated.getDescription());
            return true;
        }
        return false;
    }

    private boolean updateTaskPostponeDuringBlackout(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        if (updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_BLACKOUT_POSTPONE) || this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            original.setDelayDuringBlackout(updated.isDelayDuringBlackout());
            return true;
        }
        return false;
    }
}

