/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.notification;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.tasks.task.DefaultTaskUpdater;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class NotificationTaskUpdater
extends DefaultTaskUpdater {
    @Override
    public Class<? extends Task> getTaskClass() {
        return NotificationTask.class;
    }

    @Override
    public Changes update(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        Changes changes = super.update(original, updated, updateDirectives);
        NotificationTask updatedNotificationTask = (NotificationTask)updated;
        NotificationTask originalNotificationTask = (NotificationTask)original;
        if (this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            this.updateNotificationConfiguration(updatedNotificationTask, originalNotificationTask);
        } else if (updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_CONFIGURATION)) {
            changes.update((ConfigurationItem)original);
            this.updateNotificationConfiguration(updatedNotificationTask, originalNotificationTask);
        }
        return changes;
    }

    private void updateNotificationConfiguration(NotificationTask updatedNotificationTask, NotificationTask originalNotificationTask) {
        originalNotificationTask.setAddresses(updatedNotificationTask.getAddresses());
        originalNotificationTask.setSubject(updatedNotificationTask.getSubject());
        originalNotificationTask.setBody(updatedNotificationTask.getBody());
        originalNotificationTask.setBcc(updatedNotificationTask.getBcc());
        originalNotificationTask.setCc(updatedNotificationTask.getCc());
        originalNotificationTask.setReplyTo(updatedNotificationTask.getReplyTo());
        originalNotificationTask.setFrom(updatedNotificationTask.getFrom());
        originalNotificationTask.setSenderUsername(updatedNotificationTask.getSenderUsername());
        originalNotificationTask.setSenderPassword(updatedNotificationTask.getSenderPassword());
        originalNotificationTask.setPriority(updatedNotificationTask.getPriority());
    }
}

