/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.createrelease;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.tasks.task.DefaultTaskUpdater;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.Collection;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateReleaseTaskUpdater
extends DefaultTaskUpdater {
    private CiIdService ciIdService;

    @Autowired
    public CreateReleaseTaskUpdater(CiIdService ciIdService) {
        this.ciIdService = ciIdService;
    }

    @Override
    public Class<? extends Task> getTaskClass() {
        return CreateReleaseTask.class;
    }

    @Override
    public Changes update(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        Changes changes = super.update(original, updated, updateDirectives);
        if (this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            this.updateCreateReleaseTaskConfiguration((CreateReleaseTask)original, (CreateReleaseTask)updated, changes);
        } else if (updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_CONFIGURATION)) {
            changes.update((ConfigurationItem)original);
            this.updateCreateReleaseTaskConfiguration((CreateReleaseTask)original, (CreateReleaseTask)updated, changes);
        }
        return changes;
    }

    private void updateCreateReleaseTaskConfiguration(CreateReleaseTask original, CreateReleaseTask updated, Changes changes) {
        original.setNewReleaseTitle(updated.getNewReleaseTitle());
        original.setTemplateId(updated.getTemplateId());
        original.setFolderId(updated.getFolderId());
        original.setCreatedReleaseId(updated.getCreatedReleaseId());
        original.setStartRelease(updated.getStartRelease());
        original.setReleaseTags(updated.getReleaseTags());
        original.getTemplateVariables().stream().filter(v -> !updated.getTemplateVariables().contains(v)).forEach(v -> changes.remove(v.getId()));
        original.setTemplateVariables(updated.getTemplateVariables());
        VariablePersistenceHelper.fixUpVariableIds(original.getId(), original.getTemplateVariables(), this.ciIdService);
        changes.updateAll((Collection)original.getTemplateVariables());
        if (original.hasProperty("riskProfile")) {
            original.setProperty("riskProfile", updated.getProperty("riskProfile"));
        }
    }
}

