/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.forms.UserAccount;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.SessionService;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.service.Users;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.UserView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/users")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class UserAccountResource {
    private UserService userService;
    private Users users;
    private UserProfileService userProfileService;
    private PermissionChecker permissionChecker;
    private SessionService sessionService;
    private static final Function<UserProfile, String> BY_NAME = new Function<UserProfile, String>(){

        public String apply(UserProfile profile) {
            return this.extractName(profile.getId());
        }

        private String extractName(String id) {
            return id.replace(UserProfileService.ROOT + "/", "");
        }
    };

    @Autowired
    public UserAccountResource(UserService userService, Users users, UserProfileService userProfileService, PermissionChecker permissionChecker, SessionService sessionService) {
        this.userService = userService;
        this.users = users;
        this.userProfileService = userProfileService;
        this.permissionChecker = permissionChecker;
        this.sessionService = sessionService;
    }

    @GET
    public List<UserAccount> find() {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        return this.getUserAccounts();
    }

    @GET
    @Timed
    @Path(value="names")
    public List<UserView> getUsernames() {
        return this.getUserAccounts().stream().map(user -> new UserView(user.getUsername(), user.getFullName())).collect(Collectors.toList());
    }

    private List<UserAccount> getUserAccounts() {
        ImmutableMap profiles = Maps.uniqueIndex(this.userProfileService.findAll(), BY_NAME);
        List<String> internalNames = this.users.getRepositoryUsernames();
        TreeSet<Object> allNames = new TreeSet<Object>(Collator.getInstance());
        allNames.addAll(profiles.keySet());
        ArrayList<UserAccount> accounts = new ArrayList<UserAccount>(allNames.size());
        for (String string : allNames) {
            accounts.add(new UserAccount(string, (UserProfile)profiles.get(string), this.isInternalUser(internalNames, string)));
        }
        return accounts;
    }

    private boolean isInternalUser(List<String> internalNames, String name) {
        for (String internalName : internalNames) {
            if (!name.equalsIgnoreCase(internalName)) continue;
            return true;
        }
        return false;
    }

    @POST
    public void create(UserAccount account) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        Checks.checkNotNull((Object)account, (String)"User Account can not be null.", (Object[])new Object[]{""});
        account.validate();
        boolean created = this.insertUser(account);
        if (!created) {
            throw new UserAlreadyExistsException(account.getUsername());
        }
        this.userProfileService.save(account.toUserProfile());
    }

    @PUT
    @Timed
    public Response update(UserAccount account) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        String username = account.getUsername();
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)username), (Object)"User name cannot be empty.");
        UserProfile profile = this.userProfileService.findByUsername(username);
        if (profile == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        profile.setEmail(account.getEmail());
        profile.setFullName(account.getFullName());
        profile.setLoginAllowed(account.isLoginAllowed());
        this.userProfileService.updateProfile(profile);
        if (account.hasPassword() && this.users.userExistsInRepository(username)) {
            if (this.isUsernameLoggedIn(username)) {
                this.userService.modifyPassword(username, account.getPassword(), account.getPreviousPassword());
            } else {
                this.userService.modifyPassword(username, account.getPassword());
            }
        }
        return Response.ok().build();
    }

    @DELETE
    @Timed
    public void delete(UserAccount account) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        String username = account.getUsername();
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)username), (Object)"User name cannot be empty.");
        Preconditions.checkArgument((!XLReleasePermissions.isAdmin((String)username) ? 1 : 0) != 0, (Object)"Admin user cannot be deleted.");
        this.userService.delete(username);
        this.userProfileService.deleteByUsername(username);
        this.sessionService.disconnect(username);
    }

    private boolean isUsernameLoggedIn(String username) {
        return username.equalsIgnoreCase(User.AUTHENTICATED_USER.getName());
    }

    private boolean insertUser(UserAccount account) {
        try {
            this.userService.create(account.getUsername(), account.getPassword());
        }
        catch (UserAlreadyExistsException e) {
            return false;
        }
        return true;
    }
}

