/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.script.CommentUpdater;

class TruncatingCommentUpdater
implements CommentUpdater {
    private ReleaseActorService releaseActorService;
    private final String taskId;
    private final int maxCommentSize;
    private String commentId;
    private long currentCommentSize = 0L;

    public TruncatingCommentUpdater(ReleaseActorService releaseActorService, String taskId, int maxCommentSize) {
        this.releaseActorService = releaseActorService;
        this.taskId = taskId;
        this.maxCommentSize = maxCommentSize;
    }

    @Override
    public Object apply(String commentUpdateText) {
        if (this.updateCommentAllowed()) {
            String commentText = commentUpdateText;
            if (this.maxCommentSize > 0 && commentUpdateText.length() > this.maxCommentSize) {
                commentText = commentUpdateText.substring(0, this.maxCommentSize + 1);
            }
            this.commentId = this.releaseActorService.appendComment(this.taskId, this.commentId, commentText);
            this.currentCommentSize += (long)commentText.length();
        }
        return this.commentId;
    }

    private boolean updateCommentAllowed() {
        return this.maxCommentSize < 0 || this.maxCommentSize > 0 && this.currentCommentSize <= (long)this.maxCommentSize;
    }
}

