/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.CommentView;
import com.xebialabs.xlrelease.views.converters.CommentViewConverter;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/comments")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class CommentResource {
    private ReleaseActorService releaseActorService;
    private TaskRepository taskRepository;
    private PermissionChecker permissions;
    private CommentViewConverter commentViewConverter;

    @Autowired
    public CommentResource(ReleaseActorService releaseActorService, TaskRepository taskRepository, PermissionChecker permissions, CommentViewConverter commentViewConverter) {
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        this.permissions = permissions;
        this.commentViewConverter = commentViewConverter;
    }

    @PUT
    @Timed
    @Path(value="{commentId}")
    public CommentView updateComment(@PathParam(value="commentId") @IdParam String commentId, CommentView commentView) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)commentId));
        String taskId = Ids.getParentId((String)commentId);
        Object task = this.taskRepository.findById(taskId, new ResolveOptionsBuilder().build());
        Preconditions.checkNotNull(task, (String)"Task %s can not be found", (Object)taskId);
        this.permissions.checkIsAllowedToCommentOnTask(task.getId());
        Comment comment = this.releaseActorService.updateComment(commentId, commentView.getText());
        return this.commentViewConverter.toFullView(comment);
    }
}

