/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.tasks.gate.TargetIdResolutionFailedException;
import com.xebialabs.xlrelease.repository.IdMatchers$PhaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$ReleaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$TaskId$;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0001%4AAB\u0004\u0001!!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0011\u00159\u0004\u0001\"\u00019\u0011\u0015q\u0005\u0001\"\u0003P\u0005a!U\r]3oI\u0016t7-\u001f+be\u001e,GOU3t_24XM\u001d\u0006\u0003\u0011%\t!B]3q_NLGo\u001c:z\u0015\tQ1\"A\u0005yYJ,G.Z1tK*\u0011A\"D\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AD\u0001\u0004G>l7\u0001A\n\u0003\u0001E\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0017A\u00059mC:LE/Z7SKB|7/\u001b;pef\u0004\"!\u0007\u000e\u000e\u0003\u001dI!aG\u0004\u0003%Ac\u0017M\\%uK6\u0014V\r]8tSR|'/_\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\"AH\u0011\u000e\u0003}Q!\u0001I\u0005\u0002\u000fM,'O^5dK&\u0011!e\b\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtDcA\u0013'OA\u0011\u0011\u0004\u0001\u0005\u0006/\r\u0001\r\u0001\u0007\u0005\u00069\r\u0001\r!\b\u0015\u0003\u0007%\u0002\"AK\u001b\u000e\u0003-R!\u0001L\u0017\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002/_\u00059a-Y2u_JL(B\u0001\u00192\u0003\u0015\u0011W-\u00198t\u0015\t\u00114'A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005!\u0014aA8sO&\u0011ag\u000b\u0002\n\u0003V$xn^5sK\u0012\fQB]3t_24X\rV1sO\u0016$HCA\u001d=!\t\u0011\"(\u0003\u0002<'\t!QK\\5u\u0011\u0015iD\u00011\u0001?\u0003)!W\r]3oI\u0016t7-\u001f\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003&\ta\u0001Z8nC&t\u0017BA\"A\u0005)!U\r]3oI\u0016t7-\u001f\u0015\u0003\t\u0015\u0003\"A\u0012'\u000e\u0003\u001dS!\u0001\f%\u000b\u0005%S\u0015aB7fiJL7m\u001d\u0006\u0003\u00176\t\u0001bY8eC\"\fG.Z\u0005\u0003\u001b\u001e\u0013Q\u0001V5nK\u0012\fQC]3t_24X-\u0011:dQ&4X\r\u001a+be\u001e,G\u000fF\u0002Q'\u0002\u0004\"aP)\n\u0005I\u0003%\u0001\u0003)mC:LE/Z7\t\u000bQ+\u0001\u0019A+\u0002\u0011Q\f'oZ3u\u0013\u0012\u0004\"AV/\u000f\u0005][\u0006C\u0001-\u0014\u001b\u0005I&B\u0001.\u0010\u0003\u0019a$o\\8u}%\u0011AlE\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]'!)\u0011-\u0002a\u0001+\u0006aA-\u001a9f]\u0012,gnY=JI\"\u0012\u0001a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003MF\n!b\u001d;fe\u0016|G/\u001f9f\u0013\tAWMA\u0005D_6\u0004xN\\3oi\u0002")
public class DependencyTargetResolver {
    private final PlanItemRepository planItemRepository;
    private final ArchivingService archivingService;

    @Timed
    public void resolveTarget(Dependency dependency) {
        String targetId = dependency.getTargetId();
        if (Strings.isNotEmpty((String)targetId) && !VariableHelper$.MODULE$.containsVariables(targetId) && !dependency.isArchived()) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.planItemRepository.findById(targetId));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                PlanItem planItem = (PlanItem)success.value();
                dependency.setTarget(planItem);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit = (BoxedUnit)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.resolveArchivedTarget(targetId, dependency.getId())).map((Function1 & Serializable & scala.Serializable)target -> {
                    DependencyTargetResolver.$anonfun$resolveTarget$3(dependency, target);
                    return BoxedUnit.UNIT;
                }).recoverWith((PartialFunction)new scala.Serializable(null, dependency, targetId){
                    public static final long serialVersionUID = 0L;
                    private final Dependency dependency$1;
                    private final String targetId$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Object object = A1 instanceof NotFoundException ? new Failure((Throwable)new TargetIdResolutionFailedException(new StringBuilder(43).append("Could not find target on dependency ").append(this.dependency$1.getId()).append(" by ID ").append(this.targetId$1).toString())) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof NotFoundException;
                        return bl;
                    }
                    {
                        this.dependency$1 = dependency$1;
                        this.targetId$1 = targetId$1;
                    }
                }).get();
            } else {
                throw new MatchError((Object)try_);
            }
        }
    }

    private PlanItem resolveArchivedTarget(String targetId, String dependencyId) {
        Release release;
        String string = targetId;
        Option<String> option = IdMatchers$ReleaseId$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            release = this.archivingService.getRelease(targetId);
        } else {
            Option<String> option2 = IdMatchers$PhaseId$.MODULE$.unapply(string);
            if (!option2.isEmpty()) {
                release = this.archivingService.getPhase(targetId);
            } else {
                Option<String> option3 = IdMatchers$TaskId$.MODULE$.unapply(string);
                if (!option3.isEmpty()) {
                    release = this.archivingService.getTask(targetId);
                } else {
                    throw new TargetIdResolutionFailedException(new StringBuilder(40).append("Invalid archived target on dependency ").append(dependencyId).append(", ").append(new StringBuilder(23).append("it is not a plan item: ").append(targetId).toString()).toString());
                }
            }
        }
        return release;
    }

    public static final /* synthetic */ void $anonfun$resolveTarget$3(Dependency dependency$1, PlanItem target) {
        dependency$1.setTarget(target);
        dependency$1.archive();
    }

    @Autowired
    public DependencyTargetResolver(PlanItemRepository planItemRepository, ArchivingService archivingService) {
        this.planItemRepository = planItemRepository;
        this.archivingService = archivingService;
    }
}

