/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.FacetCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FacetDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FacetUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.facet.FacetScope;
import com.xebialabs.xlrelease.domain.facet.ImmutableTaskFacet;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseVariableRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.TypeHelper$;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u000b\u0017\u0001}A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!)\u0005A!A!\u0002\u00131\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\u00061\u0002!\t!\u0017\u0005\u0006e\u0002!\ta\u001d\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0005bBAE\u0001\u0011%\u00111\u0012\u0005\b\u00037\u0003A\u0011AAO\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!!7\u0001\t\u0013\tYN\u0001\u0007GC\u000e,GoU3sm&\u001cWM\u0003\u0002\u00181\u000591/\u001a:wS\u000e,'BA\r\u001b\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001c9\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002;\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9C&D\u0001)\u0015\tI#&A\u0003tY\u001a$$NC\u0001,\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0017)\u0005\u001daunZ4j]\u001e\fqBZ1dKR\u0014V\r]8tSR|'/\u001f\t\u0003aMj\u0011!\r\u0006\u0003ea\t!B]3q_NLGo\u001c:z\u0013\t!\u0014GA\bGC\u000e,GOU3q_NLGo\u001c:z\u00039!\u0018m]6SKB|7/\u001b;pef\u0004\"\u0001M\u001c\n\u0005a\n$A\u0004+bg.\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u00111HP\u0007\u0002y)\u0011Q\bG\u0001\u0007KZ,g\u000e^:\n\u0005}b$!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\u0001\u0012M]2iSZLgnZ*feZL7-\u001a\t\u0003\u0005\u000ek\u0011AF\u0005\u0003\tZ\u0011\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00021\u000f&\u0011\u0001*\r\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"AQ&\n\u000513\"aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\f!C^1sS\u0006\u0014G.\u001a*fa>\u001c\u0018\u000e^8ssB\u0011\u0001gT\u0005\u0003!F\u0012\u0011DU3mK\u0006\u001cXMV1sS\u0006\u0014G.\u001a*fa>\u001c\u0018\u000e^8ss\u0006\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKB\u00111KV\u0007\u0002)*\u0011Q\u000bG\u0001\u0007C\u000e$xN]:\n\u0005]#&a\u0005*fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u0005[7rkfl\u00181bEB\u0011!\t\u0001\u0005\u0006]%\u0001\ra\f\u0005\u0006k%\u0001\rA\u000e\u0005\u0006s%\u0001\rA\u000f\u0005\u0006\u0001&\u0001\r!\u0011\u0005\u0006\u000b&\u0001\rA\u0012\u0005\u0006\u0013&\u0001\rA\u0013\u0005\u0006\u001b&\u0001\rA\u0014\u0005\u0006#&\u0001\rA\u0015\u0015\u0003\u0013\u0011\u0004\"!\u001a9\u000e\u0003\u0019T!a\u001a5\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002jU\u00069a-Y2u_JL(BA6m\u0003\u0015\u0011W-\u00198t\u0015\tig.A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005y\u0017aA8sO&\u0011\u0011O\u001a\u0002\n\u0003V$xn^5sK\u0012\f1aZ3u)\t!H\u0010\u0005\u0002vu6\taO\u0003\u0002xq\u0006)a-Y2fi*\u0011\u0011\u0010G\u0001\u0007I>l\u0017-\u001b8\n\u0005m4(!\u0002$bG\u0016$\b\"B?\u000b\u0001\u0004q\u0018a\u00024bG\u0016$\u0018\n\u001a\t\u0004\u007f\u00065a\u0002BA\u0001\u0003\u0013\u00012!a\u0001#\u001b\t\t)AC\u0002\u0002\by\ta\u0001\u0010:p_Rt\u0014bAA\u0006E\u00051\u0001K]3eK\u001aLA!a\u0004\u0002\u0012\t11\u000b\u001e:j]\u001eT1!a\u0003#Q\rQ\u0011Q\u0003\t\u0005\u0003/\t\u0019#\u0004\u0002\u0002\u001a)\u0019q-a\u0007\u000b\t\u0005u\u0011qD\u0001\b[\u0016$(/[2t\u0015\r\t\t\u0003H\u0001\tG>$\u0017\r[1mK&!\u0011QEA\r\u0005\u0015!\u0016.\\3e\u0003\u0019\u0019'/Z1uKR\u0019A/a\u000b\t\u000b]\\\u0001\u0019\u0001;)\u0007-\t)\"\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003g\tI\u0004E\u0002\"\u0003kI1!a\u000e#\u0005\u0011)f.\u001b;\t\u000bud\u0001\u0019\u0001@)\u00071\t)\"\u0001\u0004va\u0012\fG/\u001a\u000b\u0004i\u0006\u0005\u0003\"B<\u000e\u0001\u0004!\bfA\u0007\u0002\u0016\u0005Y\u0011n]%n[V$\u0018M\u00197f)\u0011\tI%a\u0014\u0011\u0007\u0005\nY%C\u0002\u0002N\t\u0012qAQ8pY\u0016\fg\u000eC\u0003x\u001d\u0001\u0007A\u000fK\u0002\u000f\u0003+\taa]3be\u000eDG\u0003BA,\u0003O\u0002R!!\u0017\u0002dQl!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0005kRLGN\u0003\u0002\u0002b\u0005!!.\u0019<b\u0013\u0011\t)'a\u0017\u0003\t1K7\u000f\u001e\u0005\b\u0003Sz\u0001\u0019AA6\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!!\u001c\u0002|5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(A\u0003g_Jl7O\u0003\u0003\u0002v\u0005]\u0014A\u0001<2\u0015\r\tI\bG\u0001\u0004CBL\u0017\u0002BA?\u0003_\u0012ABR1dKR4\u0015\u000e\u001c;feND3aDA\u000b\u0003\u0019)\u00070[:ugR!\u0011\u0011JAC\u0011\u0015i\b\u00031\u0001\u007fQ\r\u0001\u0012QC\u0001\u0013GJ,\u0017\r^3OK^4\u0016M]5bE2,7\u000f\u0006\u0004\u00024\u00055\u0015\u0011\u0014\u0005\b\u0003\u001f\u000b\u0002\u0019AAI\u0003\u001d\u0011X\r\\3bg\u0016\u0004B!a%\u0002\u00166\t\u00010C\u0002\u0002\u0018b\u0014qAU3mK\u0006\u001cX\rC\u0003x#\u0001\u0007A/A\u0007hKR4\u0015mY3u)f\u0004Xm\u001d\u000b\u0005\u0003?\u000b9\f\u0005\u0004\u0002Z\u0005\r\u0014\u0011\u0015\t\u0005\u0003G\u000b\u0019,\u0004\u0002\u0002&*!\u0011qUAU\u0003\u001d\u0011XM\u001a7fGRTA!!\u001f\u0002,*!\u0011QVAX\u0003\u0019\u0001H.^4j]*\u0019\u0011\u0011\u0017\u000e\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!.\u0002&\nQA)Z:de&\u0004Ho\u001c:\t\r\u0005e&\u00031\u0001\u007f\u0003!\u0011\u0017m]3UsB,\u0007f\u0001\n\u0002\u0016\u000592/Z1sG\"Le.\u0011:dQ&4X\r\u001a*fY\u0016\f7/\u001a\u000b\u0007\u0003\u0003\f\u0019.a6\u0011\u000b\u0005\r\u0017Q\u001a;\u000f\t\u0005\u0015\u0017\u0011\u001a\b\u0005\u0003\u0007\t9-C\u0001$\u0013\r\tYMI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty-!5\u0003\u0007M+\u0017OC\u0002\u0002L\nBa!!6\u0014\u0001\u0004q\u0018!\u0003:fY\u0016\f7/Z%e\u0011\u001d\tIg\u0005a\u0001\u0003W\n\u0001B^1mS\u0012\fG/\u001a\u000b\u0005\u0003g\ti\u000eC\u0003x)\u0001\u0007A\u000fK\u0002\u0001\u0003C\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0004\u0003Od\u0017AC:uKJ,w\u000e^=qK&!\u00111^As\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class FacetService
implements Logging {
    private final FacetRepository facetRepository;
    private final TaskRepository taskRepository;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private final CiIdService ciIdService;
    private final ReleaseActorService releaseActorService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FacetService facetService = this;
        synchronized (facetService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Facet get(String facetId) {
        return this.facetRepository.get(facetId);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Facet create(Facet facet) {
        void var2_2;
        this.validate(facet);
        Facet createdFacet = this.facetRepository.create(facet);
        Object task = this.taskRepository.findById(facet.getTargetId());
        this.createNewVariables(task.getRelease(), createdFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetCreatedEvent(createdFacet));
        return var2_2;
    }

    @Timed
    public void delete(String facetId) {
        Facet facet = this.facetRepository.get(facetId);
        this.facetRepository.delete(facetId);
        this.eventBus.publish((XLReleaseEvent)new FacetDeletedEvent(facet));
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Facet update(Facet facet) {
        void var3_3;
        this.validate(facet);
        Facet originalFacet = this.facetRepository.get(facet.getId());
        Facet updatedFacet = this.facetRepository.update(facet);
        Object task = this.taskRepository.findById(facet.getTargetId());
        this.createNewVariables(task.getRelease(), updatedFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetUpdatedEvent(originalFacet, updatedFacet));
        return var3_3;
    }

    @Timed
    public boolean isImmutable(Facet facet) {
        return facet.getType().isSubTypeOf(Type.valueOf(ImmutableTaskFacet.class));
    }

    @Timed
    public List<Facet> search(FacetFilters filters) {
        filters.setTypes((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Option$.MODULE$.apply(filters.getTypes()).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).flatMap((Function1 & Serializable & scala.Serializable)ciType -> TypeHelper$.MODULE$.getAllSubtypesOf(ciType), Buffer$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty())).asJava());
        String containerId = filters.getParentId() != null ? filters.getParentId() : filters.getTargetId();
        return this.archivingService.exists(Ids.releaseIdFrom((String)containerId)) ? (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.searchInArchivedRelease(Ids.releaseIdFrom((String)containerId), filters)).asJava() : (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.facetRepository.search(filters)).asJava();
    }

    @Timed
    public boolean exists(String facetId) {
        return this.facetRepository.exists(facetId);
    }

    private void createNewVariables(Release release, Facet facet) {
        block0: {
            Buffer newVariables = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)facet, this.ciIdService)).asScala();
            if (!newVariables.nonEmpty()) break block0;
            newVariables.foreach((Function1 & Serializable & scala.Serializable)v -> $this.releaseActorService.createVariable((Variable)v, release.getId()));
        }
    }

    @Timed
    public List<Descriptor> getFacetTypes(String baseType) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf((String)baseType))).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getDescriptor(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$getFacetTypes$2(desc)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getLabel(), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    private Seq<Facet> searchInArchivedRelease(String releaseId, FacetFilters filters) {
        Release release = this.archivingService.getRelease(releaseId);
        return ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$searchInArchivedRelease$1(filters, x$4)))).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$5.getFacets()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)facet -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$searchInArchivedRelease$3(filters, facet)))).toList();
    }

    private void validate(Facet facet) {
        FacetScope facetScope = facet.getScope();
        if (!FacetScope.TASK.equals(facetScope)) {
            throw new IllegalArgumentException(new StringBuilder(30).append("Target type ").append(facet.getScope()).append(" is not supported.").toString());
        }
        Checks.checkArgument((boolean)Ids.isTaskId((String)facet.getTargetId()), (String)"Target ID is not a valid task ID.", (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(facet.getTargetId()), (String)new StringBuilder(56).append("Task with the ID '").append(facet.getTargetId()).append("' does not exist or has been archived.").toString(), (Object[])new Object[0]);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getFacetTypes$2(Descriptor desc) {
        return !desc.isVirtual();
    }

    public static final /* synthetic */ boolean $anonfun$searchInArchivedRelease$1(FacetFilters filters$1, Task x$4) {
        String string = x$4.getId();
        String string2 = filters$1.getTargetId();
        return !(string == null ? string2 != null : !string.equals(string2)) || !filters$1.hasTargetId();
    }

    public static final /* synthetic */ boolean $anonfun$searchInArchivedRelease$3(FacetFilters filters$1, Facet facet) {
        return filters$1.getTypes().isEmpty() || filters$1.getTypes().contains(facet.getType());
    }

    @Autowired
    public FacetService(FacetRepository facetRepository, TaskRepository taskRepository, XLReleaseEventBus eventBus, ArchivingService archivingService, ReleaseRepository releaseRepository, CiIdService ciIdService, ReleaseVariableRepository variableRepository, ReleaseActorService releaseActorService) {
        this.facetRepository = facetRepository;
        this.taskRepository = taskRepository;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.releaseActorService = releaseActorService;
        Logging.$init$((Logging)this);
    }
}

