/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.ExecutionOutputWriter;
import com.xebialabs.deployit.plumbing.PollingExecutionOutputHandler;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.platform.script.jython.JythonSupport$;
import com.xebialabs.platform.script.jython.ThreadLocalWriterDecorator;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.triggers.TriggerExecutionSupport;
import com.xebialabs.xlrelease.actors.triggers.TriggerExecutionSupport$;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.recover.TaskRecoverOp;
import com.xebialabs.xlrelease.domain.utils.PythonScriptCiHelper;
import com.xebialabs.xlrelease.domain.variables.ScriptValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.ReleaseVariablesUpdateOperation;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperation;
import com.xebialabs.xlrelease.events.XLReleaseOperations;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.script.EncryptionHelper;
import com.xebialabs.xlrelease.script.ExecuteRecoverCallback;
import com.xebialabs.xlrelease.script.OutputHandler;
import com.xebialabs.xlrelease.script.ScriptCallback;
import com.xebialabs.xlrelease.script.ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.script.ScriptServiceHelper;
import com.xebialabs.xlrelease.script.ScriptVariables;
import com.xebialabs.xlrelease.script.TruncatingCommentUpdater;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.security.FacetPermissionChecker;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.FacetService;
import com.xebialabs.xlrelease.service.FolderVariableService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.RestartPhasesException;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.python.core.PyException;
import org.python.core.PyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

public abstract class DefaultScriptService
implements ScriptService,
ExecuteRecoverCallback {
    private static final String MDC_KEY_TASK = "task";
    private static final String MDC_KEY_TRIGGER = "trigger";
    public static final String OUTPUT_TOO_LONG_MESSAGE = "This value was too long and has been cut off at the end. ";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScriptVariables scriptVariables;
    protected Scheduler scheduler;
    protected ReleaseActorService releaseActorService;
    protected ScriptLifeCycle scriptLifeCycle;
    protected ScriptExecutor scriptExecutor;
    protected ThreadLocalWriterDecorator executionLog = JythonSupport$.MODULE$.outWriterDecorator();
    protected AuthenticationService authenticationService;
    private ReleaseService releaseService;
    protected PermissionChecker permissions;
    protected CiIdService ciIdService;
    protected CommentService commentService;
    protected XlrConfig xlrConfig;
    private XLReleaseEventBus eventBus;
    protected TaskRepository taskRepository;
    private FacetService facetService;
    private FacetPermissionChecker facetPermissions;
    protected ServerConfiguration serverConfiguration;

    protected DefaultScriptService(Scheduler scheduler, ReleaseActorService releaseActorService, ScriptLifeCycle scriptLifeCycle, ScriptExecutor scriptExecutor, AuthenticationService authenticationService, ReleaseService releaseService, VariableService variableService, FolderVariableService folderVariableService, PermissionChecker permissions, CiIdService ciIdService, CommentService commentService, XlrConfig xlrConfig, PasswordEncrypter passwordEncrypter, XLReleaseEventBus eventBus, TaskRepository taskRepository, ServerConfiguration serverConfiguration, FacetService facetService, FacetPermissionChecker facetPermissions) {
        this.scheduler = scheduler;
        this.releaseActorService = releaseActorService;
        this.scriptLifeCycle = scriptLifeCycle;
        this.scriptExecutor = scriptExecutor;
        this.authenticationService = authenticationService;
        this.releaseService = releaseService;
        this.permissions = permissions;
        this.ciIdService = ciIdService;
        this.commentService = commentService;
        this.xlrConfig = xlrConfig;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.facetService = facetService;
        this.facetPermissions = facetPermissions;
        this.scriptVariables = new ScriptVariables(variableService, folderVariableService, passwordEncrypter, ciIdService, eventBus, permissions);
        this.serverConfiguration = serverConfiguration;
    }

    @Override
    public void executeScriptTask(ResolvableScriptTask task, ScriptCallback onSuccess, ScriptCallback onFailure) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.scheduler.execute(() -> {
            block11: {
                this.registerWriterForTask((Task)task);
                XlrScriptContext scriptContext = null;
                Map<String, Variable> previousReleaseVariables = this.scriptVariables.initialReleaseVariables(task.getRelease());
                Map<String, Variable> previousGlobalVariables = this.scriptVariables.initialGlobalVariables();
                Map<String, Variable> previousFolderVariables = this.scriptVariables.initialFolderVariable(task.getRelease().findFolderId());
                try {
                    this.authenticationService.loginScriptUser((Task)task);
                    scriptContext = this.prepareScriptTaskContext((Task)task, (Writer)this.executionLog);
                    this.executeScript(task.getScript(), scriptContext, (Task)task, true);
                    this.releaseActorService.saveScriptResults(task.getId(), new ScriptTaskResults(ScriptServiceHelper.extractReleaseVariables(scriptContext), ScriptServiceHelper.extractGlobalVariables(scriptContext), ScriptServiceHelper.extractFolderVariables(scriptContext), previousReleaseVariables, previousGlobalVariables, previousFolderVariables));
                    this.runScriptCallback((Writer)this.executionLog, onSuccess, task.getId());
                }
                catch (ScriptException exception) {
                    try {
                        this.releaseActorService.saveScriptResults(task.getId(), new ScriptTaskResults(ScriptServiceHelper.extractReleaseVariables(scriptContext), ScriptServiceHelper.extractGlobalVariables(scriptContext), ScriptServiceHelper.extractFolderVariables(scriptContext), previousReleaseVariables, previousGlobalVariables, previousFolderVariables));
                        if (this.isSystemExit0(exception)) {
                            this.runScriptCallback((Writer)this.executionLog, onSuccess, task.getId());
                            break block11;
                        }
                        if (this.isRestartPhasesException(exception)) {
                            this.onRestartPhasesException((RestartPhasesException)((Object)((Object)ExceptionUtils.getRootCause((Throwable)exception))), (Writer)this.executionLog, onFailure, (BaseScriptTask)task);
                            break block11;
                        }
                        this.onScriptException(exception, (Writer)this.executionLog, onFailure, task.getId());
                    }
                    catch (Exception resultsException) {
                        this.onException(resultsException, (Writer)this.executionLog, onFailure, task.getId(), exception.toString() + "\n", "Exception saving script results of script task '{}':");
                    }
                }
                catch (Exception exception) {
                    this.onException(exception, (Writer)this.executionLog, onFailure, task.getId(), "Exception during execution:\n", "Unexpected exception during execution of script task '{}':");
                }
                finally {
                    this.authenticationService.logoutScriptUser();
                    this.removeWriter();
                    this.scriptLifeCycle.unregister(task.getExecutionId());
                }
            }
        });
    }

    @Override
    public void executeCustomScriptTask(CustomScriptTask task, ScriptCallback onSuccess, ScriptCallback onFailure) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.fixVariableMapping(task);
        this.scheduler.execute(() -> {
            block13: {
                String script;
                this.registerWriterForTask((Task)task);
                try {
                    script = task.getPythonScript().getScript();
                }
                catch (IOException exception) {
                    this.onException(exception, (Writer)this.executionLog, onFailure, task.getId(), "Exception while loading script:\n", "Error while loading script on task '{}':");
                    this.removeWriter();
                    this.scriptLifeCycle.unregister(task.getExecutionId());
                    return;
                }
                XlrScriptContext scriptContext = null;
                try {
                    this.authenticationService.loginScriptUser((Task)task);
                    scriptContext = this.prepareCustomScriptTaskContext(task, (Writer)this.executionLog);
                    this.executeScript(script, scriptContext, (Task)task, false);
                    this.releaseActorService.saveCustomScriptResults(task.getId(), new CustomScriptTaskResults(ScriptServiceHelper.extractTransitionalAndOutputPropertyValues(task, scriptContext), task.getExecutionId(), task.getStatusLine(), task.getNextScriptPath(), task.getInterval()));
                    this.runScriptCallback((Writer)this.executionLog, onSuccess, task.getId());
                }
                catch (ScriptException exception) {
                    try {
                        if (this.isSystemExit0(exception)) {
                            this.releaseActorService.saveCustomScriptResults(task.getId(), new CustomScriptTaskResults(ScriptServiceHelper.extractTransitionalAndOutputPropertyValues(task, scriptContext), task.getExecutionId(), task.getStatusLine(), task.getNextScriptPath(), task.getInterval()));
                            this.runScriptCallback((Writer)this.executionLog, onSuccess, task.getId());
                            break block13;
                        }
                        if (this.isRestartPhasesException(exception)) {
                            this.onRestartPhasesException((RestartPhasesException)((Object)((Object)ExceptionUtils.getRootCause((Throwable)exception))), (Writer)this.executionLog, onFailure, (BaseScriptTask)task);
                            break block13;
                        }
                        this.onScriptException(exception, (Writer)this.executionLog, onFailure, task.getId());
                    }
                    catch (Exception resultsException) {
                        this.onException(resultsException, (Writer)this.executionLog, onFailure, task.getId(), exception.toString() + "\n", "Exception saving script results of custom script task '{}':");
                    }
                }
                catch (Exception exception) {
                    this.onException(exception, (Writer)this.executionLog, onFailure, task.getId(), "Exception during execution:\n", "Unexpected exception during execution of task '{}':");
                }
                finally {
                    this.authenticationService.logoutScriptUser();
                    this.removeWriter();
                    this.scriptLifeCycle.unregister(task.getExecutionId());
                }
            }
        });
    }

    private void fixVariableMapping(CustomScriptTask task) {
        Collection outputProperties = task.getPythonScript().getOutputProperties();
        boolean updated = false;
        for (PropertyDescriptor propertyDescriptor : outputProperties) {
            String propertyName = propertyDescriptor.getName();
            String fqPropertyName = "pythonScript." + propertyName;
            Object propertyValue = task.getPythonScript().getProperty(propertyName);
            if (!(propertyValue instanceof String) || !VariableHelper.containsOnlyVariable((String)((String)propertyValue)) || task.getVariableMapping().containsKey(fqPropertyName)) continue;
            this.logger.debug("adding variable pre 5.0 [{}] with value [{}]", (Object)fqPropertyName, propertyValue);
            task.getVariableMapping().put(fqPropertyName, (String)propertyValue);
            updated = true;
        }
        if (updated) {
            this.taskRepository.update((Task)task);
        }
    }

    public TriggerExecutionSupport.ReleaseTriggerResults executeTrigger(ReleaseTrigger releaseTrigger) {
        try {
            MDC.put((String)MDC_KEY_TRIGGER, (String)releaseTrigger.getId());
            XlrScriptContext scriptContext = this.makeScriptContext(releaseTrigger);
            this.executeScriptWithWriter(releaseTrigger.getScript(), scriptContext);
            return this.extractReleaseTriggerResults(scriptContext, releaseTrigger.getType());
        }
        catch (Exception e) {
            this.logger.error("Exception during trigger execution: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void executeScriptWithWriter(String script, XlrScriptContext scriptContext) {
        this.executeScriptWithWriter(script, scriptContext, false, false);
    }

    public void executeScriptWithWriter(String script, XlrScriptContext scriptContext, boolean checkPolicyPermissions, boolean withApi) {
        try {
            this.registerWriterWithHandlers(OutputHandler.debug(this.logger));
            if (withApi) {
                this.executeScriptWithApi(script, scriptContext, checkPolicyPermissions);
            } else {
                this.executeScript(script, scriptContext, checkPolicyPermissions);
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception during script execution: ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.removeWriter();
        }
    }

    @Override
    public void executePrecondition(final Task task, final ScriptCallback preconditionValidCallback, final ScriptCallback preconditionInvalidCallback, final ScriptCallback preconditionExceptionCallback) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.scheduler.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DefaultScriptService.this.registerWriterForTask(task);
                String script = task.getPrecondition();
                try {
                    DefaultScriptService.this.authenticationService.loginScriptUser(task);
                    XlrScriptContext scriptContext = DefaultScriptService.this.prepareScriptTaskContext(task, (Writer)DefaultScriptService.this.executionLog);
                    Object statementResult = DefaultScriptService.this.executeScript(script, scriptContext, task, true);
                    Object resultVariable = scriptContext.getAttribute("result");
                    if (statementResult == null && resultVariable == null) {
                        DefaultScriptService.this.executionLog.append((CharSequence)"Precondition did not return anything\n");
                        preconditionExceptionCallback.setExecutionLog(DefaultScriptService.this.executionLog.toString());
                        DefaultScriptService.this.closeWriter();
                        preconditionExceptionCallback.run();
                    } else if (this.isTrue(statementResult) || this.isTrue(resultVariable)) {
                        DefaultScriptService.this.executionLog.append((CharSequence)"Precondition is valid (returned True)\n");
                        preconditionValidCallback.setExecutionLog(DefaultScriptService.this.executionLog.toString());
                        DefaultScriptService.this.closeWriter();
                        preconditionValidCallback.run();
                    } else {
                        DefaultScriptService.this.executionLog.append((CharSequence)"Precondition is invalid (returned a value that is not True)\n");
                        preconditionInvalidCallback.setExecutionLog(DefaultScriptService.this.executionLog.toString());
                        DefaultScriptService.this.closeWriter();
                        preconditionInvalidCallback.run();
                    }
                }
                catch (Exception exception) {
                    DefaultScriptService.this.onException(exception, (Writer)DefaultScriptService.this.executionLog, preconditionExceptionCallback, task.getId(), "Exception during execution:\n", "Unexpected exception during precondition check of script task '{}':");
                }
                finally {
                    DefaultScriptService.this.authenticationService.logoutScriptUser();
                    DefaultScriptService.this.removeWriter();
                    DefaultScriptService.this.scriptLifeCycle.unregister(task.getExecutionId());
                }
            }

            private boolean isTrue(Object preconditionResult) {
                return preconditionResult instanceof Boolean && (Boolean)preconditionResult != false;
            }
        });
    }

    @Override
    public void executeFacetCheck(final Task task, final ScriptCallback validCallback, final ScriptCallback invalidCallback, final ScriptCallback exceptionCallback) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.scheduler.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DefaultScriptService.this.registerWriterForTask(task);
                try {
                    List facetsWithScript = task.getFacets().stream().filter(f -> f.hasProperty("scriptLocation")).collect(Collectors.toList());
                    boolean executeSuccessful = false;
                    for (Facet facetWithScript : facetsWithScript) {
                        String script = ScriptHelper.getScript((ConfigurationItem)facetWithScript);
                        DefaultScriptService.this.authenticationService.loginScriptUser(task);
                        XlrScriptContext scriptContext = DefaultScriptService.this.prepareScriptTaskContext(task, (Writer)DefaultScriptService.this.executionLog);
                        scriptContext.setAttribute("currentFacet", facetWithScript, 100);
                        Object statementResult = DefaultScriptService.this.executeScript(script, scriptContext, task, true);
                        Object resultVariable = scriptContext.getAttribute("result");
                        if (statementResult == null && resultVariable == null) {
                            DefaultScriptService.this.executionLog.append((CharSequence)"Environment is not available: script did not return anything\n");
                            exceptionCallback.setExecutionLog(DefaultScriptService.this.executionLog.toString());
                            DefaultScriptService.this.closeWriter();
                            exceptionCallback.run();
                            executeSuccessful = false;
                            break;
                        }
                        if (this.isTrue(statementResult) || this.isTrue(resultVariable)) {
                            executeSuccessful = true;
                            continue;
                        }
                        DefaultScriptService.this.executionLog.append((CharSequence)"Environment is not available: script returned a value that is not True\n");
                        invalidCallback.setExecutionLog(DefaultScriptService.this.executionLog.toString());
                        DefaultScriptService.this.closeWriter();
                        invalidCallback.run();
                        executeSuccessful = false;
                        break;
                    }
                    if (executeSuccessful) {
                        DefaultScriptService.this.executionLog.append((CharSequence)"Environment is available: script is valid (returned True)\n");
                        validCallback.setExecutionLog(DefaultScriptService.this.executionLog.toString());
                        DefaultScriptService.this.closeWriter();
                        validCallback.run();
                    }
                }
                catch (Exception exception) {
                    DefaultScriptService.this.onException(exception, (Writer)DefaultScriptService.this.executionLog, exceptionCallback, task.getId(), "Exception during execution:\n", "Unexpected exception during attribute check of task '{}':");
                }
                finally {
                    DefaultScriptService.this.authenticationService.logoutScriptUser();
                    DefaultScriptService.this.removeWriter();
                    DefaultScriptService.this.scriptLifeCycle.unregister(task.getExecutionId());
                }
            }

            private boolean isTrue(Object result) {
                return result instanceof Boolean && (Boolean)result != false;
            }
        });
    }

    @Override
    public Collection<Object> executeScriptValueProvider(ScriptValueProviderConfiguration valueProviderConfiguration) {
        CompletableFuture future = new CompletableFuture();
        Variable variable = valueProviderConfiguration.getVariable();
        String releaseId = Ids.releaseIdFrom((String)variable.getId());
        Release release = this.releaseService.findById(releaseId);
        this.scheduler.submit(() -> {
            this.authenticationService.loginScriptUser(release);
            XlrScriptContext scriptContext = this.prepareScriptValueProviderContext(release, valueProviderConfiguration);
            DefaultResourceLoader loader = new DefaultResourceLoader();
            Resource resource = loader.getResource(valueProviderConfiguration.getScript());
            Collection<Object> res = null;
            try (InputStream is = resource.getInputStream();){
                String script = StreamUtils.copyToString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                this.executeScriptWithApi(script, scriptContext, true);
                res = scriptContext.getValueProviderResult();
            }
            catch (Exception e) {
                this.logger.error("unknown exception: ", (Throwable)e);
            }
            finally {
                this.authenticationService.logoutScriptUser();
            }
            future.complete(res);
        });
        long releaseActionTimeoutSeconds = this.xlrConfig.timeoutSettings().releaseActionResponse().toSeconds();
        try {
            return (Collection)future.get(releaseActionTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            future.cancel(true);
            String message = String.format("Execution of value provider for variable [%s] with release id [%s] was terminated due to timeout of [%s] seconds. Consider to increase 'xl.timeouts.releaseActionResponse' property", variable.getKey(), release.getId(), releaseActionTimeoutSeconds);
            this.logger.warn(message);
            return Collections.emptyList();
        }
    }

    @Override
    public void executeFailureHandler(Task task) {
        this.scriptLifeCycle.register(task.getExecutionId());
        ScriptCallback callback = this.recoverCallback(task);
        Future<?> future = this.scheduler.submit(() -> {
            block12: {
                this.registerWriterForTask(task);
                XlrScriptContext scriptContext = null;
                Map<String, Variable> previousReleaseVariables = this.scriptVariables.initialReleaseVariables(task.getRelease());
                Map<String, Variable> previousGlobalVariables = this.scriptVariables.initialGlobalVariables();
                Map<String, Variable> previousFolderVariables = this.scriptVariables.initialFolderVariable(task.getRelease().findFolderId());
                try {
                    this.authenticationService.loginScriptUser(task);
                    scriptContext = this.prepareScriptTaskContext(task, (Writer)this.executionLog);
                    String script = task.getFailureHandler();
                    if (this.isScriptRunnable(task, script)) {
                        this.executeScript(script, scriptContext, task, true);
                        this.releaseActorService.saveScriptResults(task.getId(), new ScriptTaskResults(ScriptServiceHelper.extractReleaseVariables(scriptContext), ScriptServiceHelper.extractGlobalVariables(scriptContext), ScriptServiceHelper.extractFolderVariables(scriptContext), previousReleaseVariables, previousGlobalVariables, previousFolderVariables));
                    }
                    if (task.isFailureHandlerEnabled()) {
                        this.runScriptCallback((Writer)this.executionLog, callback, task.getId());
                    }
                }
                catch (ScriptException exception) {
                    this.logger.warn("ScriptException: ", (Throwable)exception);
                    try {
                        this.releaseActorService.saveScriptResults(task.getId(), new ScriptTaskResults(ScriptServiceHelper.extractReleaseVariables(scriptContext), ScriptServiceHelper.extractGlobalVariables(scriptContext), ScriptServiceHelper.extractFolderVariables(scriptContext), previousReleaseVariables, previousGlobalVariables, previousFolderVariables));
                        if (this.isSystemExit0(exception)) {
                            this.runScriptCallback((Writer)this.executionLog, callback, task.getId());
                            break block12;
                        }
                        this.onScriptException(exception, (Writer)this.executionLog, (ScriptCallback)this.fallbackCallback(task).apply((Object)exception), task.getId());
                    }
                    catch (Exception resultsException) {
                        this.onException(resultsException, (Writer)this.executionLog, (ScriptCallback)this.fallbackCallback(task).apply((Object)exception), task.getId(), exception.toString() + "\n", "Exception saving script results of task '{}':");
                    }
                }
                catch (Exception exception) {
                    this.logger.warn("unknown exception: ", (Throwable)exception);
                    this.onException(exception, (Writer)this.executionLog, (ScriptCallback)this.fallbackCallback(task).apply((Object)exception), task.getId(), "Exception during execution:\n", "Unexpected exception during execution of failure handler for task '{}':");
                }
                finally {
                    this.authenticationService.logoutScriptUser();
                    this.removeWriter();
                    this.scriptLifeCycle.unregister(task.getExecutionId());
                }
            }
        });
        this.scheduler.execute(() -> {
            long failureHandlerTimeoutSeconds = this.xlrConfig.timeoutSettings().failureHandlerTimeout().toSeconds();
            try {
                future.get(failureHandlerTimeoutSeconds, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                future.cancel(true);
                String message = String.format("Failure handler of task [%s] with script execution [%s] was terminated due to timeout of [%s] seconds. Consider to increase 'xl.timeouts.failureHandlerTimeout' property", task.getId(), task.getExecutionId(), failureHandlerTimeoutSeconds);
                this.logger.warn(message);
                this.releaseActorService.addCommentToTask(task.getId(), message);
            }
        });
    }

    private boolean isScriptRunnable(Task task, String script) {
        return Strings.isNotBlank((String)script) && task.isTaskFailureHandlerEnabled() && task.isFailureHandlerEnabled() && TaskRecoverOp.RUN_SCRIPT == task.getTaskRecoverOp();
    }

    XlrScriptContext prepareScriptTaskContext(Task task, Writer log) {
        EncryptionHelper.decrypt((ConfigurationItem)task.getRelease());
        XlrScriptContext scriptContext = this.makeScriptContext(log);
        scriptContext.addDomainObjects(task);
        scriptContext.addReleaseVariables(task.getRelease(), this.permissions, this.scriptVariables.releaseVariables(task.getRelease()));
        scriptContext.addGlobalVariables(this.permissions, this.scriptVariables.globalVariables());
        this.addFolderVariables(task.getRelease(), scriptContext);
        scriptContext.addApi();
        scriptContext.addScriptLogger();
        return scriptContext;
    }

    XlrScriptContext prepareCustomScriptTaskContext(CustomScriptTask task, Writer log) {
        EncryptionHelper.decrypt((ConfigurationItem)task.getRelease());
        EncryptionHelper.decrypt((ConfigurationItem)task.getPythonScript());
        XlrScriptContext scriptContext = this.makeCustomScriptContext(log, task);
        scriptContext.addDomainObjects((Task)task);
        scriptContext.addCustomScriptApi(this.facetService, this.permissions, this.facetPermissions);
        return scriptContext;
    }

    XlrScriptContext prepareScriptValueProviderContext(Release release, ScriptValueProviderConfiguration configuration) {
        EncryptionHelper.decrypt((ConfigurationItem)release);
        EncryptionHelper.decrypt((ConfigurationItem)configuration);
        XlrScriptContext scriptContext = new XlrScriptContext();
        scriptContext.setAttribute("release", release, 100);
        scriptContext.setAttribute("_valueProvider", (Object)configuration, 100);
        scriptContext.addReleaseVariables(release, this.permissions, this.scriptVariables.releaseVariables(release));
        scriptContext.addGlobalVariables(this.permissions, this.scriptVariables.globalVariables());
        this.addFolderVariables(release, scriptContext);
        scriptContext.addApi();
        scriptContext.addScriptLogger();
        return scriptContext;
    }

    private void addFolderVariables(Release release, XlrScriptContext scriptContext) {
        String maybeFolderId = release.findFolderId();
        if (Ids.isFolderId((String)maybeFolderId)) {
            scriptContext.addFolderVariables(maybeFolderId, this.permissions, this.scriptVariables.folderVariables(maybeFolderId));
        }
    }

    private void registerWriterForTask(Task task) {
        String taskId = task.getId();
        MDC.put((String)MDC_KEY_TASK, (String)taskId);
        int maxCommentSize = task.getMaxCommentSize();
        TruncatingCommentUpdater commentUpdater = new TruncatingCommentUpdater(this.commentService, taskId, maxCommentSize);
        long pollingInterval = this.xlrConfig.durations_scriptOutputPollingInterval().toMillis();
        this.registerWriterWithHandlers(OutputHandler.debug(this.logger), PollingExecutionOutputHandler.pollingHandler(this.scheduler, commentUpdater, true, pollingInterval, pollingInterval));
    }

    private void registerWriterWithHandlers(OverthereExecutionOutputHandler ... handlers) {
        this.executionLog.registerWriter((Writer)new ExecutionOutputWriter(new StringWriter(), handlers));
    }

    private void closeWriter() {
        try {
            this.executionLog.getWriter().close();
        }
        catch (IOException e) {
            this.logger.warn("Error closing script output logger", (Throwable)e);
        }
    }

    private void removeWriter() {
        try {
            this.executionLog.getWriter().close();
        }
        catch (IOException exception) {
            this.logger.warn("Error closing script output logger", (Throwable)exception);
        }
        this.executionLog.removeWriter();
        MDC.remove((String)MDC_KEY_TASK);
        MDC.remove((String)MDC_KEY_TRIGGER);
    }

    XlrScriptContext makeScriptContext(ReleaseTrigger releaseTrigger) {
        EncryptionHelper.decrypt((ConfigurationItem)releaseTrigger);
        XlrScriptContext scriptContext = this.makeScriptContext((Writer)this.executionLog);
        scriptContext.addProperties((ConfigurationItem)releaseTrigger, releaseTrigger.getType().getDescriptor().getPropertyDescriptors());
        return scriptContext;
    }

    boolean isSystemExit0(ScriptException exception) {
        if (!(exception.getCause() instanceof PyException)) {
            return false;
        }
        PyException pyE = (PyException)exception.getCause();
        String pyEtoString = pyE.toString();
        PyType pyET = (PyType)pyE.type;
        String pyETName = pyET.getName();
        return pyETName.equals("SystemExit") && pyEtoString.contains("SystemExit: 0");
    }

    private XlrScriptContext makeScriptContext(Writer output) {
        XlrScriptContext context = new XlrScriptContext();
        context.setWriter(output);
        return context;
    }

    private XlrScriptContext makeCustomScriptContext(Writer executionLog, CustomScriptTask task) {
        XlrScriptContext scriptContext = this.makeScriptContext(executionLog);
        PythonScript pythonScript = task.getPythonScript();
        List<PropertyDescriptor> ctxProperties = Stream.concat(pythonScript.getInputProperties().stream(), pythonScript.getTransitionalProperties().stream()).collect(Collectors.toList());
        if (task.hasNextScriptToExecute()) {
            ctxProperties.addAll(pythonScript.getOutputProperties());
            task.resetSchedule();
        }
        scriptContext.setScriptPathForLog(task.getScriptPath());
        scriptContext.addProperties((ConfigurationItem)pythonScript, ctxProperties);
        scriptContext.addPropertyBindings(pythonScript.getTransitionalAndOutputProperties());
        return scriptContext;
    }

    TriggerExecutionSupport.ReleaseTriggerResults extractReleaseTriggerResults(XlrScriptContext scriptContext, Type releaseTriggerType) {
        HashMap scriptVariables = Maps.newHashMap();
        String triggerState = null;
        for (PropertyDescriptor propertyDescriptor : releaseTriggerType.getDescriptor().getPropertyDescriptors()) {
            if (Objects.equal((Object)propertyDescriptor.getCategory(), (Object)"variables")) {
                scriptVariables.put(propertyDescriptor.getName(), scriptContext.getAttribute(propertyDescriptor.getName()));
            }
            if (!"triggerState".equals(propertyDescriptor.getName())) continue;
            triggerState = (String)scriptContext.getAttribute(propertyDescriptor.getName());
        }
        return TriggerExecutionSupport$.MODULE$.releaseTriggerResults(triggerState, scriptVariables);
    }

    public void saveScriptResults(String taskId, ScriptTaskResults scriptTaskResults) {
        Object task = this.taskRepository.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
        ScriptVariables.VariablesChanges releaseVariablesChanges = this.scriptVariables.detectReleaseVariablesChanges((Task)task, scriptTaskResults);
        ScriptVariables.VariablesChanges globalVariablesChanges = this.scriptVariables.detectGlobalVariablesChanges((Task)task, scriptTaskResults);
        ScriptVariables.VariablesChanges folderVariablesChanges = this.scriptVariables.detectFolderVariablesChanges((Task)task, scriptTaskResults);
        ArrayList<XLReleaseOperation> allOperations = new ArrayList<XLReleaseOperation>(releaseVariablesChanges.operations);
        allOperations.addAll(globalVariablesChanges.operations);
        allOperations.addAll(folderVariablesChanges.operations);
        XLReleaseOperations.runActionInterceptors(allOperations, this.eventBus);
        this.scriptVariables.processReleaseVariablesChanges(task.getRelease(), releaseVariablesChanges);
        this.scriptVariables.processGlobalVariablesChanges(globalVariablesChanges);
        this.scriptVariables.processFolderVariablesChanges(folderVariablesChanges);
    }

    public void saveCustomScriptResults(String taskId, CustomScriptTaskResults results) {
        CustomScriptTask task = (CustomScriptTask)this.taskRepository.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
        task.setNextScriptPath(results.getNextScriptPath());
        task.setStatusLine(results.getStatusLine());
        task.setInterval(results.getInterval());
        if (!task.isStillExecutingScript(results.getScriptExecutionId())) {
            this.logger.debug("Will not save script results of task: '{}' : it has been aborted.", (Object)task.getId());
            return;
        }
        Changes changes = this.processCustomScriptTaskResults(task, results.getOutputVariables());
        this.taskRepository.update((Task)task);
        changes.getCommentsByTask().get((Object)task).forEach(userAndComment -> this.commentService.create((Task)task, (String)userAndComment._2(), User.SYSTEM, false));
        XLReleaseOperations.publishEvents(changes.getOperations(), this.eventBus);
    }

    Changes processCustomScriptTaskResults(CustomScriptTask task, Map<String, Object> outputAttributes) {
        this.setTransitionalProperties(task, outputAttributes);
        return this.setOutputPropertiesAndVariables(task, outputAttributes);
    }

    private void setTransitionalProperties(CustomScriptTask task, Map<String, Object> outputAttributes) {
        task.getPythonScript().getTransitionalProperties().forEach(propertyDescriptor -> {
            String propertyName = propertyDescriptor.getName();
            Object value = outputAttributes.get(propertyName);
            if (value == null) {
                this.logger.debug("Python script task {} did not return a value for property {}", (Object)task.getId(), (Object)propertyDescriptor.getName());
            } else {
                task.getPythonScript().setProperty(propertyName, value);
            }
        });
    }

    private Changes setOutputPropertiesAndVariables(CustomScriptTask task, Map<String, Object> outputAttributes) {
        Changes changes = new Changes();
        Release release = task.getRelease();
        Collection outputProperties = task.getPythonScript().getOutputProperties();
        HashMap<String, Object> newVariableValues = new HashMap<String, Object>();
        HashMap<String, Object> newPasswordVariableValues = new HashMap<String, Object>();
        String taskId = task.getId();
        for (PropertyDescriptor propertyDescriptor : outputProperties) {
            String propertyName = propertyDescriptor.getName();
            String fqPropertyName = "pythonScript." + propertyName;
            String variableName = null;
            Object propertyValue = task.getPythonScript().getProperty(propertyName);
            if (propertyValue instanceof String && VariableHelper.containsOnlyVariable((String)((String)propertyValue))) {
                variableName = (String)propertyValue;
            }
            if (task.getVariableMapping().containsKey(fqPropertyName)) {
                variableName = (String)task.getVariableMapping().get(fqPropertyName);
                if (!task.hasNextScriptToExecute()) {
                    task.getVariableMapping().remove(fqPropertyName);
                }
            }
            Object value = outputAttributes.get(propertyName);
            if (task.isKeepPreviousOutputPropertiesOnRetry() && !PythonScriptCiHelper.isEmpty((Object)task.getPythonScript().getProperty(propertyName))) {
                value = task.getPythonScript().getProperty(propertyName);
                if (propertyDescriptor.getKind() == PropertyKind.STRING) {
                    value = VariableHelper.withoutVariableSyntax((String)((String)value));
                }
            }
            if (value == null) {
                this.logger.debug("Python script task {} did not return a value for property {}", (Object)taskId, (Object)propertyDescriptor.getName());
                continue;
            }
            if (propertyDescriptor.getKind() == PropertyKind.STRING) {
                value = this.truncateValue(task, propertyDescriptor.getLabel(), value.toString(), changes);
            }
            task.getPythonScript().setProperty(propertyName, value);
            if (com.google.common.base.Strings.isNullOrEmpty((String)variableName)) {
                this.logger.debug("Missing output variable on Python script task {} for property {}", (Object)taskId, (Object)propertyDescriptor.getName());
                continue;
            }
            if (propertyDescriptor.isPassword()) {
                newPasswordVariableValues.put(variableName, value);
                continue;
            }
            newVariableValues.put(variableName, value);
        }
        List oldVariables = CiCloneHelper.cloneCis(release.getVariables());
        release.setVariableValues(newVariableValues);
        release.setPasswordVariableValues(newPasswordVariableValues);
        VariablePersistenceHelper.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        changes.addOperation((XLReleaseOperation)new ReleaseVariablesUpdateOperation(oldVariables, release.getVariables(), true));
        return changes;
    }

    private String truncateValue(CustomScriptTask task, String propertyLabel, String value, Changes changes) {
        int maxOutputPropertySize = task.getPythonScript().getMaxOutputPropertySize();
        if (value.length() > maxOutputPropertySize) {
            value = OUTPUT_TOO_LONG_MESSAGE.concat(value.substring(0, maxOutputPropertySize));
            this.logger.warn("The content of the output property '{}' from task '{}' has been truncated to {} characters", new Object[]{propertyLabel, task.getName(), maxOutputPropertySize});
            changes.addComment((Task)task, String.format("*Warning*: the value for property '%s' has been truncated because it was too large", propertyLabel));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object executeScript(String script, XlrScriptContext scriptContext, Task task, boolean checkPolicyPermissions) throws Exception {
        this.scriptLifeCycle.start(task.getExecutionId());
        try {
            Object object = this.scriptExecutor.evalScriptWithApi(script, scriptContext, checkPolicyPermissions);
            return object;
        }
        finally {
            this.scriptLifeCycle.end(task.getExecutionId());
            String logMessage = this.executionLog.toString();
            this.logger.debug("Script '{}' output : {}", (Object)scriptContext.getScriptPathForLog(), (Object)logMessage);
        }
    }

    public Object executeScript(String script, XlrScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.scriptExecutor.evalScript(script, scriptContext, checkPolicyPermissions);
    }

    Object executeScriptWithApi(String script, XlrScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.scriptExecutor.evalScriptWithApi(script, scriptContext, checkPolicyPermissions);
    }

    private void runScriptCallback(Writer executionLog, ScriptCallback onSuccess, String taskId) {
        try {
            onSuccess.setExecutionLog(executionLog.toString());
            this.closeWriter();
        }
        catch (Exception exception) {
            this.logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)exception);
        }
        onSuccess.run();
    }

    private void onScriptException(ScriptException exception, Writer executionLog, ScriptCallback onFailure, String taskId) {
        this.logger.warn("Exception during execution", (Throwable)exception);
        try {
            executionLog.append("Exception during execution:\n");
            executionLog.append(this.sanitizeServerPath(exception.getMessage()));
            onFailure.setExecutionLog(executionLog.toString());
            this.closeWriter();
        }
        catch (Exception e) {
            this.logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)e);
        }
        onFailure.run();
    }

    private void onException(Exception exception, Writer executionLog, ScriptCallback onFailure, String taskId, String executionLogMessage, String logMessage) {
        this.logger.warn(logMessage, (Object)taskId, (Object)exception);
        try {
            executionLog.append(executionLogMessage);
            executionLog.append(this.sanitizeServerPath(exception.toString()));
            onFailure.setExecutionLog(executionLog.toString());
            this.closeWriter();
        }
        catch (Exception e) {
            this.logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)e);
        }
        onFailure.run();
    }

    protected String sanitizeServerPath(String message) {
        return message == null ? null : message.replace(System.getProperty("user.dir"), "{ServerWorkingDirectory}");
    }

    private boolean isRestartPhasesException(ScriptException exception) {
        return ExceptionUtils.getRootCause((Throwable)exception) instanceof RestartPhasesException;
    }

    private void onRestartPhasesException(RestartPhasesException ex, Writer executionLog, ScriptCallback onFailure, BaseScriptTask task) {
        Release release = this.releaseService.findById(ex.getReleaseId());
        List runningAutomatedTaskIds = release.getActiveTasks().stream().filter(Task::isAutomated).map(BaseConfigurationItem::getId).collect(Collectors.toList());
        if (!runningAutomatedTaskIds.contains(task.getId())) {
            this.onException((Exception)((Object)ex), executionLog, onFailure, task.getId(), "Exception during execution:\n", "You can not restart phases in another release when an automated task is running");
        } else if (runningAutomatedTaskIds.size() > 1) {
            this.onException((Exception)((Object)ex), executionLog, onFailure, task.getId(), "Exception during execution:\n", "You can not restart phases when there are other automated task running");
        } else {
            onFailure.run();
            this.releaseActorService.restartPhase(ex.getReleaseId(), ex.getPhaseId(), ex.getTaskId(), ex.getPhaseVersion(), ex.isResumeRelease());
        }
    }

    ThreadLocalWriterDecorator getExecutionLog() {
        return this.executionLog;
    }

    public static class ScriptTaskResults
    implements Serializable {
        private Map<String, Object> releaseVariables;
        private Map<String, Object> globalVariables;
        private Map<String, Object> folderVariables;
        private Map<String, Variable> initialReleaseVariables;
        private Map<String, Variable> initialGlobalVariables;
        private Map<String, Variable> initialFolderVariables;

        public ScriptTaskResults(Map<String, Object> releaseVariables, Map<String, Object> globalVariables, Map<String, Object> folderVariables, Map<String, Variable> initialReleaseVariables, Map<String, Variable> initialGlobalVariables, Map<String, Variable> initialFolderVariables) {
            this.releaseVariables = releaseVariables;
            this.globalVariables = globalVariables;
            this.folderVariables = folderVariables;
            this.initialReleaseVariables = initialReleaseVariables;
            this.initialGlobalVariables = initialGlobalVariables;
            this.initialFolderVariables = initialFolderVariables;
        }

        public Map<String, Object> getReleaseVariables() {
            return this.releaseVariables;
        }

        public Map<String, Object> getGlobalVariables() {
            return this.globalVariables;
        }

        public Map<String, Variable> getInitialReleaseVariables() {
            return this.initialReleaseVariables;
        }

        public Map<String, Variable> getInitialGlobalVariables() {
            return this.initialGlobalVariables;
        }

        public Map<String, Object> getFolderVariables() {
            return this.folderVariables;
        }

        public Map<String, Variable> getInitialFolderVariables() {
            return this.initialFolderVariables;
        }
    }

    public static class CustomScriptTaskResults
    implements Serializable {
        private Map<String, Object> outputVariables;
        private String scriptExecutionId;
        private String statusLine;
        private String nextScriptPath;
        private Integer interval;

        public CustomScriptTaskResults(Map<String, Object> outputVariables, String scriptExecutionId, String statusLine, String nextScriptPath, Integer interval) {
            this.outputVariables = outputVariables;
            this.scriptExecutionId = scriptExecutionId;
            this.statusLine = statusLine;
            this.nextScriptPath = nextScriptPath;
            this.interval = interval;
        }

        public Map<String, Object> getOutputVariables() {
            return this.outputVariables;
        }

        public String getScriptExecutionId() {
            return this.scriptExecutionId;
        }

        public String getStatusLine() {
            return this.statusLine;
        }

        public String getNextScriptPath() {
            return this.nextScriptPath;
        }

        public Integer getInterval() {
            return this.interval;
        }
    }
}

