/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.customscript;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.task.DefaultTaskUpdater;
import com.xebialabs.xlrelease.variable.VariableHelper;
import org.springframework.stereotype.Component;

@Component
public class CustomScriptTaskUpdater
extends DefaultTaskUpdater {
    @Override
    public Class<? extends Task> getTaskClass() {
        return CustomScriptTask.class;
    }

    @Override
    public Changes update(Task original, Task updated) {
        String name;
        Changes changes = super.update(original, updated);
        CustomScriptTask updatedCustomScriptTask = (CustomScriptTask)updated;
        PythonScript updatedPythonScript = updatedCustomScriptTask.getPythonScript();
        CustomScriptTask originalCustomScriptTask = (CustomScriptTask)original;
        PythonScript pythonScript = originalCustomScriptTask.getPythonScript();
        for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
            name = propertyDescriptor.getName();
            if (propertyDescriptor.getKind() == PropertyKind.CI) {
                Configuration configuration = (Configuration)updatedPythonScript.getProperty(name);
                if (configuration != null) {
                    Preconditions.checkArgument((boolean)configuration.getType().getDescriptor().isAssignableTo(propertyDescriptor.getReferencedType()), (Object)("Type of CI must be " + propertyDescriptor.getReferencedType().getName() + " got " + configuration.getType().getName()));
                }
                pythonScript.setProperty(propertyDescriptor.getName(), (Object)configuration);
                continue;
            }
            pythonScript.setProperty(propertyDescriptor.getName(), updatedPythonScript.getProperty(name));
        }
        for (PropertyDescriptor propertyDescriptor : pythonScript.getTransitionalAndOutputProperties()) {
            name = propertyDescriptor.getName();
            Object value = updatedPythonScript.getProperty(name);
            if (propertyDescriptor.getKind() == PropertyKind.STRING && "output".equals(propertyDescriptor.getCategory())) {
                value = VariableHelper.formatVariableIfNeeded((String)((String)value));
            }
            pythonScript.setProperty(name, value);
        }
        originalCustomScriptTask.setKeepPreviousOutputPropertiesOnRetry(updatedCustomScriptTask.isKeepPreviousOutputPropertiesOnRetry());
        changes.update((ConfigurationItem)pythonScript);
        return changes;
    }
}

