/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.AdaptiveReleaseId;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.FacetDecorator;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0001\u0011-s!B\u001c9\u0011\u0003\te!B\"9\u0011\u0003!\u0005\"B*\u0002\t\u0003!\u0006\"B+\u0002\t\u00031\u0006\"B:\u0002\t\u0003!h!B\"9\u0001\u0005\r\u0001BCA\u0003\u000b\t\u0015\r\u0011\"\u0001\u0002\b!Q\u0011QC\u0003\u0003\u0002\u0003\u0006I!!\u0003\t\u0015\u0005]QA!A!\u0002\u0013\tI\u0002\u0003\u0006\u0002 \u0015\u0011\t\u0011)A\u0005\u0003CA\u0011\"a\n\u0006\u0005\u0003\u0005\u000b\u0011\u00027\t\u0015\u0005%RA!A!\u0002\u0013\tY\u0003\u0003\u0006\u00022\u0015\u0011\t\u0011)A\u0005\u0003gA!\"!\u0010\u0006\u0005\u0003\u0005\u000b\u0011BA \u0011)\t)%\u0002B\u0001B\u0003%\u0011q\t\u0005\u000b\u0003'*!\u0011!Q\u0001\n\u0005U\u0003BCA.\u000b\t\u0005\t\u0015!\u0003\u0002^!Q\u00111M\u0003\u0003\u0002\u0003\u0006I!!\u001a\t\u0015\u0005-TA!A!\u0002\u0013\ti\u0007\u0003\u0006\u0002t\u0015\u0011\t\u0011)A\u0005\u0003kBaaU\u0003\u0005\u0002\u0005m\u0004bBAZ\u000b\u0011\u0005\u0011Q\u0017\u0005\b\u0003+,A\u0011BAl\u0011\u001d\ti.\u0002C\u0005\u0003?Dq!a9\u0006\t\u0003\t)\u000fC\u0004\u0002l\u0016!\t!!<\t\u000f\u0005-X\u0001\"\u0001\u0002r\"9!\u0011A\u0003\u0005\u0002\t\r\u0001b\u0002B\u0005\u000b\u0011\u0005!1\u0002\u0005\b\u00053)A\u0011\u0001B\u000e\u0011\u001d\u0011I#\u0002C\u0001\u0005WAqAa\u0010\u0006\t\u0003\u0011\t\u0005C\u0004\u0003J\u0015!\tAa\u0013\t\u000f\tES\u0001\"\u0001\u0003T!9!1L\u0003\u0005\u0002\tu\u0003b\u0002B2\u000b\u0011\u0005!Q\r\u0005\b\u0005[*A\u0011\u0001B8\u0011\u001d\u0011Y(\u0002C\u0001\u0005{BqA!#\u0006\t\u0003\u0011Y\tC\u0004\u0003\n\u0016!\tAa.\t\u000f\t-W\u0001\"\u0001\u0003N\"I1\u0011E\u0003\u0012\u0002\u0013\u000511\u0005\u0005\n\u0007o)\u0011\u0013!C\u0001\u0007GAqa!\u000f\u0006\t\u0003\u0019Y\u0004C\u0004\u0004Z\u0015!\taa\u0017\t\u000f\r\u0005T\u0001\"\u0001\u0004d!911Q\u0003\u0005\u0002\r\u0015\u0005bBBF\u000b\u0011\u00051Q\u0012\u0005\b\u0005\u0013+A\u0011BBN\u0011\u001d\u0019\u0019+\u0002C\u0001\u0007KCqa!,\u0006\t\u0013\u0019y\u000bC\u0005\u00048\u0016\t\n\u0011\"\u0003\u0004:\"91QX\u0003\u0005\n\r}\u0006bBBw\u000b\u0011%1q\u001e\u0005\b\u0007k,A\u0011BB|\u0003A\t%o\u00195jm&twmU3sm&\u001cWM\u0003\u0002:u\u000591/\u001a:wS\u000e,'BA\u001e=\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002>}\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u007f\u0005\u00191m\\7\u0004\u0001A\u0011!)A\u0007\u0002q\t\u0001\u0012I]2iSZLgnZ*feZL7-Z\n\u0004\u0003\u0015[\u0005C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%AB!osJ+g\r\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006)1\u000f\u001c45U*\t\u0001+\u0001\u0005he&T(\u0010\\3e\u0013\t\u0011VJA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\t\u0015A\u00073fg\u0016\u0014\u0018.\u00197ju\u0016\f%o\u00195jm\u0016$'+\u001a7fCN,GcA,^UB\u0011\u0001lW\u0007\u00023*\u0011!LO\u0001\u0007I>l\u0017-\u001b8\n\u0005qK&a\u0002*fY\u0016\f7/\u001a\u0005\u0006=\u000e\u0001\raX\u0001\fe\u0016dW-Y:f\u0015N|g\u000e\u0005\u0002aO:\u0011\u0011-\u001a\t\u0003E\u001ek\u0011a\u0019\u0006\u0003I\u0002\u000ba\u0001\u0010:p_Rt\u0014B\u00014H\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019<\u0005\"B6\u0004\u0001\u0004a\u0017A\u0003:fa>\u001c\u0018\u000e^8ssB\u0011Q.]\u0007\u0002]*\u00111n\u001c\u0006\u0003ar\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003e:\u0014\u0011CU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u000319W\r^'p]RD\u0017,Z1s)\tyV\u000fC\u0003w\t\u0001\u0007q/A\u0005ti\u0006\u0014H\u000fR1uKB\u0011\u0001p`\u0007\u0002s*\u0011!p_\u0001\u0005i&lWM\u0003\u0002}{\u0006!!n\u001c3b\u0015\u0005q\u0018aA8sO&\u0019\u0011\u0011A=\u0003\u0011\u0011\u000bG/\u001a+j[\u0016\u001c2!B#L\u0003A\t'o\u00195jm\u0016$'+\u001a7fCN,7/\u0006\u0002\u0002\nA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010i\n!\u0001\u001a2\n\t\u0005M\u0011Q\u0002\u0002\u0011\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN\f\u0011#\u0019:dQ&4X\r\u001a*fY\u0016\f7/Z:!\u0003Y\t'o\u00195jm\u0016$'+\u001a7fCN,7oU3be\u000eD\u0007\u0003BA\u0006\u00037IA!!\b\u0002\u000e\t1\u0012I]2iSZ,GMU3mK\u0006\u001cXm]*fCJ\u001c\u0007.\u0001\u0010be\u000eD\u0017N^3e\u0003\u000e$\u0018N^5us2{wm]*fe&\fG.\u001b>feB\u0019!)a\t\n\u0007\u0005\u0015\u0002H\u0001\u0010Be\u000eD\u0017N^3e\u0003\u000e$\u0018N^5us2{wm]*fe&\fG.\u001b>fe\u0006\t\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002=\r|W\u000e\u001d7fi\u0016$'+\u001a7fCN,7/\u0012=q_J$8+\u001a:wS\u000e,\u0007c\u0001\"\u0002.%\u0019\u0011q\u0006\u001d\u0003;\r{W\u000e\u001d7fi\u0016$'+\u001a7fCN,W\t\u001f9peR\u001cVM\u001d<jG\u0016\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\u0011\t)$!\u000f\u000e\u0005\u0005]\"BA6;\u0013\u0011\tY$a\u000e\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\u000beKB,g\u000eZ3oGf\u0014V\r]8tSR|'/\u001f\t\u0005\u0003k\t\t%\u0003\u0003\u0002D\u0005]\"\u0001\u0006#fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u00180A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\tiEO\u0001\u0007C\u000e$xN]:\n\t\u0005E\u00131\n\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u000fi\u0016\fWNU3q_NLGo\u001c:z!\u0011\t)$a\u0016\n\t\u0005e\u0013q\u0007\u0002\u000f)\u0016\fWNU3q_NLGo\u001c:z\u0003)\u0019XmY;sK\u0012\u001c\u0015n\u001d\t\u0005\u0003k\ty&\u0003\u0003\u0002b\u0005]\"AC*fGV\u0014X\rZ\"jg\u0006Y\"/\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef\u0004B!!\u000e\u0002h%!\u0011\u0011NA\u001c\u0005m\u0011V\r\\3bg\u0016,\u0005\u0010^3og&|gn\u001d*fa>\u001c\u0018\u000e^8ss\u0006q1m\\7nK:$8+\u001a:wS\u000e,\u0007c\u0001\"\u0002p%\u0019\u0011\u0011\u000f\u001d\u0003\u001d\r{W.\\3oiN+'O^5dK\u0006qa-Y2fi\u0012+7m\u001c:bi>\u0014\b\u0003BA\u001b\u0003oJA!!\u001f\u00028\tqa)Y2fi\u0012+7m\u001c:bi>\u0014H\u0003HA?\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0015\u0011RAF\u0003\u001b\u000by)!%\u0002\u0014\u0006U\u0015q\u0013\t\u0003\u0005\u0016Aq!!\u0002\u0015\u0001\u0004\tI\u0001C\u0004\u0002\u0018Q\u0001\r!!\u0007\t\u000f\u0005}A\u00031\u0001\u0002\"!1\u0011q\u0005\u000bA\u00021Dq!!\u000b\u0015\u0001\u0004\tY\u0003C\u0004\u00022Q\u0001\r!a\r\t\u000f\u0005uB\u00031\u0001\u0002@!9\u0011Q\t\u000bA\u0002\u0005\u001d\u0003bBA*)\u0001\u0007\u0011Q\u000b\u0005\b\u00037\"\u0002\u0019AA/\u0011\u001d\t\u0019\u0007\u0006a\u0001\u0003KBq!a\u001b\u0015\u0001\u0004\ti\u0007C\u0004\u0002tQ\u0001\r!!\u001e)\u0007Q\tY\n\u0005\u0003\u0002\u001e\u0006=VBAAP\u0015\u0011\t\t+a)\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002&\u0006\u001d\u0016a\u00024bGR|'/\u001f\u0006\u0005\u0003S\u000bY+A\u0003cK\u0006t7OC\u0002\u0002.v\fqb\u001d9sS:<gM]1nK^|'o[\u0005\u0005\u0003c\u000byJA\u0005BkR|w/\u001b:fI\u0006q\u0011M]2iSZ,'+\u001a7fCN,G\u0003BA\\\u0003{\u00032ARA]\u0013\r\tYl\u0012\u0002\u0005+:LG\u000f\u0003\u0004\u0002@V\u0001\raX\u0001\ne\u0016dW-Y:f\u0013\u0012D3!FAb!\u0011\t)-!5\u000e\u0005\u0005\u001d'\u0002BAQ\u0003\u0013TA!a3\u0002N\u00069Q.\u001a;sS\u000e\u001c(bAAh}\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002T\u0006\u001d'!\u0002+j[\u0016$\u0017AE1sG\"Lg/Z!ui\u0006\u001c\u0007.\\3oiN$B!a.\u0002Z\"1\u00111\u001c\fA\u0002]\u000bqA]3mK\u0006\u001cX-A\nbe\u000eD\u0017N^3EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u00028\u0006\u0005\bBBAn/\u0001\u0007q+A\tqe\u0016\f%o\u00195jm\u0016\u0014V\r\\3bg\u0016$B!a.\u0002h\"1\u00111\u001c\rA\u0002]C3\u0001GAb\u0003)9W\r\u001e*fY\u0016\f7/\u001a\u000b\u0004/\u0006=\bBBA`3\u0001\u0007q\fF\u0003X\u0003g\f)\u0010\u0003\u0004\u0002@j\u0001\ra\u0018\u0005\b\u0003oT\u0002\u0019AA}\u0003IIgn\u00197vI\u0016\u0004&/Z!sG\"Lg/\u001a3\u0011\u0007\u0019\u000bY0C\u0002\u0002~\u001e\u0013qAQ8pY\u0016\fg\u000eK\u0002\u001b\u0003\u0007\fqbZ3u%\u0016dW-Y:f)&$H.\u001a\u000b\u0004?\n\u0015\u0001BBA`7\u0001\u0007q\fK\u0002\u001c\u0003\u0007\f\u0001bZ3u!\"\f7/\u001a\u000b\u0005\u0005\u001b\u0011\u0019\u0002E\u0002Y\u0005\u001fI1A!\u0005Z\u0005\u0015\u0001\u0006.Y:f\u0011\u0019\u0011)\u0002\ba\u0001?\u00069\u0001\u000f[1tK&#\u0007f\u0001\u000f\u0002D\u00069q-\u001a;UCN\\G\u0003\u0002B\u000f\u0005G\u00012\u0001\u0017B\u0010\u0013\r\u0011\t#\u0017\u0002\u0005)\u0006\u001c8\u000e\u0003\u0004\u0003&u\u0001\raX\u0001\u0007i\u0006\u001c8.\u00133)\u0007u\t\u0019-A\u0006hKR4\u0016M]5bE2,G\u0003\u0002B\u0017\u0005s\u0001BAa\f\u000365\u0011!\u0011\u0007\u0006\u0004\u0005gI\u0016!\u0003<be&\f'\r\\3t\u0013\u0011\u00119D!\r\u0003\u0011Y\u000b'/[1cY\u0016DaAa\u000f\u001f\u0001\u0004y\u0016A\u0003<be&\f'\r\\3JI\"\u001aa$a1\u0002\r\u0015D\u0018n\u001d;t)\u0011\tIPa\u0011\t\r\t\u0015s\u00041\u0001`\u0003\u0011\u0019\u0017.\u00133)\u0007}\t\u0019-A\tfq&\u001cHo\u001d)sK\u0006\u00138\r[5wK\u0012$B!!?\u0003N!1!Q\t\u0011A\u0002}C3\u0001IAb\u00031)\u00070[:ug\nKh*Y7f)\u0011\tIP!\u0016\t\r\t]\u0013\u00051\u0001`\u0003-\u0011X\r\\3bg\u0016t\u0015-\\3)\u0007\u0005\n\u0019-\u0001\tdQ\u0016\u001c7NT8u\u0003J\u001c\u0007.\u001b<fIR!\u0011q\u0017B0\u0011\u0019\u0011)E\ta\u0001?\"\u001a!%a1\u0002!\u0005$H/Y2i[\u0016tG/\u0012=jgR\u001cH\u0003BA}\u0005OBaA!\u001b$\u0001\u0004y\u0016\u0001D1ui\u0006\u001c\u0007.\\3oi&#\u0007fA\u0012\u0002D\u0006iq-\u001a;BiR\f7\r[7f]R$BA!\u001d\u0003xA\u0019\u0001La\u001d\n\u0007\tU\u0014L\u0001\u0006BiR\f7\r[7f]RDaA!\u001b%\u0001\u0004y\u0006f\u0001\u0013\u0002D\u0006\u0019r-\u001a;BiR\f7\r[7f]R|\u0005\u000f^5p]R!!q\u0010BC!\u00151%\u0011\u0011B9\u0013\r\u0011\u0019i\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\r\t%T\u00051\u0001`Q\r)\u00131Y\u0001\u000fg\u0016\f'o\u00195SK2,\u0017m]3t)\u0011\u0011iI!(\u0011\u000b\t=%\u0011T,\u000e\u0005\tE%\u0002\u0002BJ\u0005+\u000bA!\u001e;jY*\u0011!qS\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u001c\nE%\u0001\u0002'jgRDqAa('\u0001\u0004\u0011\t+A\u0004gS2$XM]:\u0011\t\t\r&\u0011W\u0007\u0003\u0005KSAAa*\u0003*\u0006)am\u001c:ng*!!1\u0016BW\u0003\t1\u0018GC\u0002\u00030j\n1!\u00199j\u0013\u0011\u0011\u0019L!*\u0003\u001fI+G.Z1tKN4\u0015\u000e\u001c;feND3AJAb)!\u0011iI!/\u0003<\n\u0015\u0007b\u0002BPO\u0001\u0007!\u0011\u0015\u0005\b\u0005{;\u0003\u0019\u0001B`\u0003\u0015a\u0017.\\5u!\r1%\u0011Y\u0005\u0004\u0005\u0007<%\u0001\u0002'p]\u001eDqAa2(\u0001\u0004\u0011y,\u0001\u0004pM\u001a\u001cX\r\u001e\u0015\u0004O\u0005\r\u0017A\r4j]\u0012\u001c\u0006n\u001c:u%\u0016dW-Y:f\u0013\u0012\u001cx+\u001b;i\r>dG-\u001a:OC6,\u0017I\u001c3Pe\u0012,'o\u0011:ji\u0016\u0014\u0018n\u001c8\u0015\u0015\t='q_B\u0007\u00073\u0019i\u0002\u0005\u0004\u0003R\nm'q\u001c\b\u0005\u0005'\u00149ND\u0002c\u0005+L\u0011\u0001S\u0005\u0004\u00053<\u0015a\u00029bG.\fw-Z\u0005\u0005\u00057\u0013iNC\u0002\u0003Z\u001e\u0003rA\u0012Bq\u0005K\u0014\t0C\u0002\u0003d\u001e\u0013a\u0001V;qY\u0016\u0014\u0004\u0003\u0002Bt\u0005[l!A!;\u000b\u0007\t-\u0018,A\u0003vi&d7/\u0003\u0003\u0003p\n%(!E!eCB$\u0018N^3SK2,\u0017m]3JIB\u0019aIa=\n\u0007\tUxIA\u0002B]fDqAa()\u0001\u0004\u0011I\u0010\u0005\u0004\u0003R\nm(q`\u0005\u0005\u0005{\u0014iNA\u0002TKF\u0004Ba!\u0001\u0004\n5\u001111\u0001\u0006\u0005\u0005?\u001b)AC\u0002\u0004\bi\nqA]3q_J$8/\u0003\u0003\u0004\f\r\r!\u0001\u0004*fa>\u0014HOR5mi\u0016\u0014\bbBB\bQ\u0001\u00071\u0011C\u0001\u0006_J$WM\u001d\t\u0006\r\n\u000551\u0003\t\u0005\u0005G\u001b)\"\u0003\u0003\u0004\u0018\t\u0015&\u0001\u0005*fY\u0016\f7/Z(sI\u0016\u0014Xj\u001c3f\u0011%\u0011i\f\u000bI\u0001\u0002\u0004\u0019Y\u0002E\u0003G\u0005\u0003\u0013y\fC\u0005\u0003H\"\u0002\n\u00111\u0001\u0004\u001c!\u001a\u0001&a1\u0002y\u0019Lg\u000eZ*i_J$(+\u001a7fCN,\u0017\nZ:XSRDgi\u001c7eKJt\u0015-\\3B]\u0012|%\u000fZ3s\u0007JLG/\u001a:j_:$C-\u001a4bk2$HeM\u000b\u0003\u0007KQCaa\u0007\u0004(-\u00121\u0011\u0006\t\u0005\u0007W\u0019\u0019$\u0004\u0002\u0004.)!1qFB\u0019\u0003%)hn\u00195fG.,GMC\u0002\u0002\"\u001eKAa!\u000e\u0004.\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002y\u0019Lg\u000eZ*i_J$(+\u001a7fCN,\u0017\nZ:XSRDgi\u001c7eKJt\u0015-\\3B]\u0012|%\u000fZ3s\u0007JLG/\u001a:j_:$C-\u001a4bk2$H\u0005N\u0001\u0016G>,h\u000e\u001e*fY\u0016\f7/Z:CsN#\u0018\r^;t)\u0011\u0019id!\u0016\u0011\u000f\u0001\u001cyda\u0011\u0004P%\u00191\u0011I5\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0004F\r-SBAB$\u0015\r\u0019I%W\u0001\u0007gR\fG/^:\n\t\r53q\t\u0002\u000e%\u0016dW-Y:f'R\fG/^:\u0011\u0007\u0019\u001b\t&C\u0002\u0004T\u001d\u00131!\u00138u\u0011\u001d\u0011yj\u000ba\u0001\u0005CC3aKAb\u00035\u0019w.\u001e8u%\u0016dW-Y:fgR!1QHB/\u0011\u001d\u0011y\n\fa\u0001\u0005sD3\u0001LAb\u0003a1\u0017N\u001c3Be\u000eD\u0017N^1cY\u0016\u0014V\r\\3bg\u0016LEm\u001d\u000b\u0007\u0007K\u001a9g!\u001d\u0011\u000b\tE'1`0\t\u000f\r%T\u00061\u0001\u0004l\u0005!A-\u0019;f!\u0011\u0011yi!\u001c\n\t\r=$\u0011\u0013\u0002\u0005\t\u0006$X\rC\u0004\u0004t5\u0002\ra!\u001e\u0002\u0011A\fw-Z*ju\u0016\u0004Baa\u001e\u0004~5\u00111\u0011\u0010\u0006\u0005\u0007w\u0012)*\u0001\u0003mC:<\u0017\u0002BB@\u0007s\u0012q!\u00138uK\u001e,'\u000fK\u0002.\u0003\u0007\fa$\u0019:dQ&4X-\u00117m\u0013:\u001cw.\\5oO\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\u0005]6q\u0011\u0005\u0007\u0003\u007fs\u0003\u0019A0)\u00079\n\u0019-\u0001\u0006hKR\fE\u000e\u001c+bON$Baa$\u0004\u0016B)!qRBI?&!11\u0013BI\u0005\r\u0019V\r\u001e\u0005\b\u0007/{\u0003\u0019AB(\u0003-a\u0017.\\5u\u001dVl'-\u001a:)\u0007=\n\u0019\r\u0006\u0005\u0003\u000e\u000eu5qTBQ\u0011\u001d\u0011y\n\ra\u0001\u0005CCqA!01\u0001\u0004\u0019Y\u0002C\u0004\u0003HB\u0002\raa\u0007\u00025M,\u0017M]2i%\u0016dW-Y:fg\nK(+\u001a7fCN,\u0017\nZ:\u0015\t\r\u001d6\u0011\u0016\t\u0006\u0005#\u0014Yp\u0016\u0005\b\u0007W\u000b\u0004\u0019AB3\u0003)\u0011X\r\\3bg\u0016LEm]\u0001\u0011O\u0016$(+\u001a7fCN,w\n\u001d;j_:$ba!-\u00044\u000eU\u0006\u0003\u0002$\u0003\u0002^Ca!a03\u0001\u0004y\u0006\"CA|eA\u0005\t\u0019AA}\u0003i9W\r\u001e*fY\u0016\f7/Z(qi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019YL\u000b\u0003\u0002z\u000e\u001d\u0012AD4fiJ+G.Z1tK&#X-\\\u000b\u0005\u0007\u0003\u001cY\r\u0006\u0003\u0004D\u000e%H\u0003BBc\u0007;\u0004RA\u0012BA\u0007\u000f\u0004Ba!3\u0004L2\u0001AaBBgi\t\u00071q\u001a\u0002\u0002)F!1\u0011[Bl!\r151[\u0005\u0004\u0007+<%a\u0002(pi\"Lgn\u001a\t\u00041\u000ee\u0017bABn3\nA\u0001\u000b\\1o\u0013R,W\u000eC\u0004\u0004`R\u0002\ra!9\u0002\u000f\u001d,G/\u0013;f[B1aia9X\u0007OL1a!:H\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0004G\u0007G|6q\u0019\u0005\u0007\u0007W$\u0004\u0019A0\u0002\r%$X-\\%e\u0003E9W\r\u001e,be&\f'\r\\3PaRLwN\u001c\u000b\u0005\u0007c\u001c\u0019\u0010E\u0003G\u0005\u0003\u0013i\u0003\u0003\u0004\u0003<U\u0002\raX\u0001\u001fCJ\u001c\u0007.\u001b<f\u00032dw*\u001e;h_&tw\rR3qK:$WM\\2jKN$Ba!?\u0005\u0002A1!\u0011\u001bB~\u0007w\u00042\u0001WB\u007f\u0013\r\u0019y0\u0017\u0002\u000b\t\u0016\u0004XM\u001c3f]\u000eL\bBBAnm\u0001\u0007q\u000bK\n\u0006\t\u000b!\u0019\u0002\"\u0006\u0005\u001a\u0011mAQ\u0005C\u0014\tc!\u0019\u0004\u0005\u0003\u0005\b\u0011=QB\u0001C\u0005\u0015\u0011\t\t\u000bb\u0003\u000b\t\u00115\u00111V\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0005\u0012\u0011%!!\u0004+sC:\u001c\u0018m\u0019;j_:\fG.A\u0003wC2,X-\t\u0002\u0005\u0018\u0005Y\"/\u001a9peRLgn\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ\f1\u0002\u001d:pa\u0006<\u0017\r^5p]\u0012\u0012AQD\u0005\u0005\t?!\t#\u0001\u0005S\u000bF+\u0016JU#E\u0015\u0011!\u0019\u0003\"\u0003\u0002\u0017A\u0013x\u000e]1hCRLwN\\\u0001\nSN|G.\u0019;j_:$#\u0001\"\u000b\n\t\u0011-BQF\u0001\u000f%\u0016\u000bEiX\"P\u001b6KE\u000bV#E\u0015\u0011!y\u0003\"\u0003\u0002\u0013%\u001bx\u000e\\1uS>t\u0017a\u0003:pY2\u0014\u0017mY6G_Jd#\u0001\"\u000e$\u0005\u0011]\u0002\u0003\u0002Bi\tsIA\u0001b\u000f\u0003^\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0015\u0004\u000b\u0011}\u0002\u0003\u0002C!\t\u000fj!\u0001b\u0011\u000b\t\u0011\u0015\u00131V\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002C%\t\u0007\u0012qaU3sm&\u001cW\r")
public class ArchivingService
implements Logging {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentService commentService;
    private final FacetDecorator facetDecorator;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String getMonthYear(DateTime dateTime) {
        return ArchivingService$.MODULE$.getMonthYear(dateTime);
    }

    public static Release deserializeArchivedRelease(String string, RepositoryAdapter repositoryAdapter) {
        return ArchivingService$.MODULE$.deserializeArchivedRelease(string, repositoryAdapter);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Timed
    public void archiveRelease(String releaseId) {
        Release release = (Release)this.repositoryAdapter.read(releaseId);
        if (release == null) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Release '").append(releaseId).append("' cannot be read from active database, not archiving.").toString());
            if (!this.releaseRepository.exists(releaseId) && this.existsPreArchived(releaseId)) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Setting Release '").append(releaseId).append("' preArchived flag to false as it is no longer in the active database.").toString());
                this.archivedReleases().setPreArchived(releaseId, false);
            }
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES)).contains((Object)release.getStatus())) {
            if (this.existsPreArchived(releaseId)) {
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Archiving dependencies for '").append(releaseId).append("'").toString());
                this.facetDecorator.decorateWithAllFacets(release);
                this.releaseExtensionsRepository.decorate(release);
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
                    this.commentService.decorate(task);
                    return BoxedUnit.UNIT;
                });
                java.util.List<Team> updatedTeams = this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
                release.setTeams(updatedTeams);
                if (!release.isTutorial()) {
                    this.archiveAttachments(release);
                }
                this.archiveDependencies(release);
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Updating activity logs and releaseJson for '").append(releaseId).append("'").toString());
                String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
                String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
                if (!this.archivedReleases().update(releaseId, serializedRelease, activityLogsJson, false)) {
                    this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Could not update archived Release '").append(releaseId).append("'.").toString());
                } else {
                    this.archivedReleases().updateViewers(releaseId, (Seq<Team>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(updatedTeams).asScala()));
                }
                if (this.releaseRepository.exists(releaseId)) {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Deleting '").append(releaseId).append("' from active database").toString());
                    this.releaseRepository.delete(releaseId);
                }
            } else if (!release.isTutorial()) {
                throw new IllegalStateException("Only pre-archived releases can be archived");
            }
        } else {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Trying to pre-archive a release with invalid status ").append(release.getStatus()).toString());
            throw new IllegalStateException("Only inactive releases can be archived");
        }
    }

    private void archiveAttachments(Release release) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Archiving attachments for '").append(release.getId()).append("'").toString());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAttachments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)attachment -> {
            ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
            return BoxedUnit.UNIT;
        });
    }

    private void archiveDependencies(Release release) {
        Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append(release).append(" is already pre-archived, nothing to do").toString());
        } else {
            this.facetDecorator.decorateWithAllFacets(release);
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            if (!release.isTutorial()) {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("copying release ").append(release).append(" to archive database, marked as pre-archived").toString());
                this.archivedReleases().insert(release, serializedRelease, "", true);
                this.releaseRepository.setPreArchived(release.getId(), true);
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Running release ").append(release.getId()).append(" through export hooks").toString());
            } else {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Deleting tutorial release ").append(release).append(" instead of pre-archiving").toString());
                this.releaseRepository.delete(release.getId());
            }
            this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
        }
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable & scala.Serializable)x$12 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$12.getPhase(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)phaseId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable & scala.Serializable)x$2 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$2.getTask(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)taskId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)variableId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable & scala.Serializable)x$3 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$3.getPhase(x$1)).isDefined() : (Ids.isTaskId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable & scala.Serializable)x$4 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$4.getTask(x$1)).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().existsPreArchived(ciId) : false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases().exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringBuilder(56).append("You cannot perform this operation on archived release [").append(Ids.releaseIdFrom((String)ciId)).append("]").toString(), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(37).append("Could not find archived attachment [").append(attachmentId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable & scala.Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable & scala.Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public List<Tuple2<AdaptiveReleaseId, Object>> findShortReleaseIdsWithFolderNameAndOrderCriterion(Seq<ReportFilter> filters, Option<ReleaseOrderMode> order, Option<Object> limit, Option<Object> offset) {
        return this.archivedReleasesSearch.searchReleaseIdsAndOrderCriterion(filters, order, limit, offset);
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$4() {
        return None$.MODULE$;
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleases(Seq<ReportFilter> filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (Seq<String>)((Seq)Seq$.MODULE$.empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable & scala.Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter), List$.MODULE$.canBuildFrom())).asJava();
    }

    public Seq<Release> searchReleasesByReleaseIds(Seq<String> releaseIds) {
        Seq<String> releaseJsons = this.archivedReleasesSearch.searchReleasesByIds(releaseIds);
        return (Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter), Seq$.MODULE$.canBuildFrom());
    }

    private Option<Release> getReleaseOption(String releaseId, boolean includePreArchived) {
        return this.archivedReleases().getRelease(releaseId, includePreArchived).map((Function1 & Serializable & scala.Serializable)releaseJson -> {
            void var3_3;
            Release release = ArchivingService$.MODULE$.deserializeArchivedRelease((String)releaseJson, $this.repositoryAdapter);
            Map<String, String> attachmentsFileNames = this.archivedReleases().getAttachmentsFileNames(release.getId());
            release.getAttachments().forEach(attachment -> {
                Option option = attachmentsFileNames.get((Object)ArchivedReleases$.MODULE$.shortenId(attachment.getId()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String filename = (String)some.value();
                    attachment.setFile((OverthereFile)SourceArtifactFile.withNullableWorkDir((String)filename, (SourceArtifact)attachment, null));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Could not find attachment ").append(attachment.getId()).append(" of release ").append(releaseId).append(" in the attachments table").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            });
            return var3_3;
        });
    }

    private boolean getReleaseOption$default$2() {
        return false;
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)release -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$6))));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        void var2_2;
        Buffer dependencies = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$8)));
        dependencies.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.archive();
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$2, Attachment attachment$1, WorkDir workDir$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$2.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
            workDir$1.delete();
            WorkDirContext.clear();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$2, Attachment attachment) {
        WorkDirContext.initWorkdir();
        WorkDir workDir = WorkDirContext.get();
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable & scala.Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$2, attachment, workDir, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        Seq rawDependenciesToArchive = (Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (Seq<String>)((Seq)rawDependenciesToArchive.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Seq$.MODULE$.canBuildFrom())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$6) {
        String string = x$6.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$8) {
        return !x$8.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentService commentService, FacetDecorator facetDecorator) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentService = commentService;
        this.facetDecorator = facetDecorator;
        Logging.$init$((Logging)this);
    }
}

