/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.export.UnresolvedReferencesConfigurationItemConverter;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.TemplateContent;
import com.xebialabs.xlrelease.export.TemplateImportContext;
import com.xebialabs.xlrelease.export.TemplateImportProcessor;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.views.ImportResult;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=e!B\u0001\u0003\u0003\u0003Y!\u0001\u0006\"bg\u0016$V-\u001c9mCR,\u0017*\u001c9peR,'O\u0003\u0002\u0004\t\u00051Q\r\u001f9peRT!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001+\taqg\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001aD\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0012i\u0006\u001c8.Q2dKN\u001c8+\u001a:wS\u000e,\u0007C\u0001\f\u001a\u001b\u00059\"B\u0001\r\u0005\u0003\u001d\u0019XM\u001d<jG\u0016L!AG\f\u0003#Q\u000b7o[!dG\u0016\u001c8oU3sm&\u001cW\r\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016\u0004\"A\u0006\u0010\n\u0005}9\"A\u0004*fY\u0016\f7/Z*feZL7-\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u00059R.Y=cKR+W\u000e\u001d7bi\u0016\u0004&o\\2fgN|'o\u001d\t\u0004G!RS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001B;uS2T\u0011aJ\u0001\u0005U\u00064\u0018-\u0003\u0002*I\tAq\n\u001d;j_:\fG\u000eE\u0002$W5J!\u0001\f\u0013\u0003\t1K7\u000f\u001e\t\u0003]=j\u0011AA\u0005\u0003a\t\u0011q\u0003V3na2\fG/Z%na>\u0014H\u000f\u0015:pG\u0016\u001c8o\u001c:\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\u0011!\u0004)\u0011\"\u0011\u00079\u0002Q\u0007\u0005\u00027o1\u0001A!\u0002\u001d\u0001\u0005\u0004I$!\u0001+\u0012\u0005ij\u0004C\u0001\b<\u0013\tatBA\u0004O_RD\u0017N\\4\u0011\u00059r\u0014BA \u0003\u0005=!V-\u001c9mCR,7i\u001c8uK:$\b\"\u0002\u000b2\u0001\u0004)\u0002\"\u0002\u000f2\u0001\u0004i\u0002\"B\u00112\u0001\u0004\u0011\u0003b\u0002#\u0001\u0005\u0004%I!R\u0001\u0013i\u0016l\u0007\u000f\\1uKB\u0013xnY3tg>\u00148/F\u0001+\u0011\u00199\u0005\u0001)A\u0005U\u0005\u0019B/Z7qY\u0006$X\r\u0015:pG\u0016\u001c8o\u001c:tA!)\u0011\n\u0001D\u0001\u0015\u0006A1/\u001e9q_J$8/\u0006\u0002L%R\u0011Aj\u0014\t\u0003\u001d5K!AT\b\u0003\u000f\t{w\u000e\\3b]\")\u0001\u000b\u0013a\u0001#\u0006i\u0011.\u001c9peR\u001cuN\u001c;fqR\u0004\"A\u000e*\u0005\u000bMC%\u0019\u0001+\u0003\u0003U\u000b\"AO+\u0011\u000592\u0016BA,\u0003\u0005U!V-\u001c9mCR,\u0017*\u001c9peR\u001cuN\u001c;fqRDQ!\u0017\u0001\u0007\u0012i\u000bQ\u0003Z8SK\u0006$G+Z7qY\u0006$XmQ8oi\u0016tG\u000f\u0006\u000267\")A\f\u0017a\u0001;\u0006Y\u0011N\u001c9viN#(/Z1n!\tq\u0016-D\u0001`\u0015\t\u0001g%\u0001\u0002j_&\u0011!m\u0018\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003e\u0001\u0019EQ-\u0001\re_V\u0003xM]1eKR+W\u000e\u001d7bi\u0016\u001cuN\u001c;f]R$\"A\u001a:\u0011\u0007\rZs\r\u0005\u0002i_:\u0011\u0011.\u001c\t\u0003U>i\u0011a\u001b\u0006\u0003Y*\ta\u0001\u0010:p_Rt\u0014B\u00018\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001/\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059|\u0001\"B:d\u0001\u0004)\u0014a\u0004;f[Bd\u0017\r^3D_:$XM\u001c;\t\rU\u0004a\u0011\u0001\u0002w\u0003M!wnQ8om\u0016\u0014H\u000fV8UK6\u0004H.\u0019;f)\r9XP \t\u0003qnl\u0011!\u001f\u0006\u0003u\u0012\ta\u0001Z8nC&t\u0017B\u0001?z\u0005\u001d\u0011V\r\\3bg\u0016DQa\u001d;A\u0002UBQa ;A\u0002\u001d\f1\u0003Z3ti&t\u0017\r^5p]\u001a{G\u000eZ3s\u0013\u0012Dq!a\u0001\u0001\t\u0003\t)!\u0001\bj[B|'\u000f\u001e+f[Bd\u0017\r^3\u0015\r\u0005\u001d\u0011QCA\f!\u0011\u00193&!\u0003\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004\u0005\u0003\u00151\u0018.Z<t\u0013\u0011\t\u0019\"!\u0004\u0003\u0019%k\u0007o\u001c:u%\u0016\u001cX\u000f\u001c;\t\rq\u000b\t\u00011\u0001^\u0011\u0019y\u0018\u0011\u0001a\u0001O\"9\u00111\u0004\u0001\u0005\n\u0005u\u0011!F5na>\u0014H\u000fV3na2\fG/Z\"p]R,g\u000e\u001e\u000b\t\u0003\u000f\ty\"!\t\u0002$!11/!\u0007A\u0002UBaa`A\r\u0001\u00049\u0007bBA\u0013\u00033\u0001\rAZ\u0001\to\u0006\u0014h.\u001b8hg\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0012!\u0004:fg\u0016$H+Z7qY\u0006$X\r\u0006\u0003\u0002.\u0005M\u0002c\u0001\b\u00020%\u0019\u0011\u0011G\b\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003k\t9\u00031\u0001x\u0003\u001d\u0011X\r\\3bg\u0016Dq!!\u000f\u0001\t\u0013\tY$A\rsKN,G/\u00168eK\u000e\u0014\u0018\u0010\u001d;fIB\u000b7o]<pe\u0012\u001cHCBA\u0017\u0003{\t\t\u0005C\u0004\u0002@\u0005]\u0002\u0019A<\u0002\u0011Q,W\u000e\u001d7bi\u0016D\u0001\"!\n\u00028\u0001\u0007\u00111\t\t\u0005G\u0005\u0015s-C\u0002\u0002H\u0011\u0012!bQ8mY\u0016\u001cG/[8o\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001b\n\u0001D]3tKR,f\u000eZ3def\u0004H/\u001a3QCN\u001cxo\u001c:e)\u0015a\u0015qJA6\u0011!\t\t&!\u0013A\u0002\u0005M\u0013AA2j!\u0011\t)&a\u001a\u000e\u0005\u0005]#\u0002BA-\u00037\n1!\u001e3n\u0015\u0011\ti&a\u0018\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002b\u0005\r\u0014A\u00029mk\u001eLgNC\u0002\u0002f\u0019\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003S\n9FA\tD_:4\u0017nZ;sCRLwN\\%uK6D\u0001\"!\u001c\u0002J\u0001\u0007\u0011qN\u0001\u0013aJ|\u0007/\u001a:us\u0012+7o\u0019:jaR|'\u000f\u0005\u0003\u0002r\u0005]TBAA:\u0015\u0011\t)(a\u0017\u0002\u000fI,g\r\\3di&!\u0011\u0011PA:\u0005I\u0001&o\u001c9feRLH)Z:de&\u0004Ho\u001c:\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000\u0005i\"/Z7pm\u0016l\u0015n]:j]\u001e<\u0015\r^3EKB,g\u000eZ3oG&,7\u000f\u0006\u0004\u0002.\u0005\u0005\u00151\u0011\u0005\b\u0003\u007f\tY\b1\u0001x\u0011!\t)#a\u001fA\u0002\u0005\r\u0003bBAD\u0001\u0011%\u0011\u0011R\u0001\u0018i\u0016l\u0007\u000f\\1uK\u0016C\u0018n\u001d;t/&$\b\u000eV5uY\u0016$2\u0001TAF\u0011\u001d\ti)!\"A\u0002\u001d\fQ\u0001^5uY\u0016\u0004")
public abstract class BaseTemplateImporter<T extends TemplateContent> {
    private final TaskAccessService taskAccessService;
    private final ReleaseService releaseService;
    private final List<TemplateImportProcessor> templateProcessors;

    private List<TemplateImportProcessor> templateProcessors() {
        return this.templateProcessors;
    }

    public abstract <U extends TemplateImportContext> boolean supports(U var1);

    public abstract T doReadTemplateContent(InputStream var1);

    public abstract List<String> doUpgradeTemplateContent(T var1);

    public abstract Release doConvertToTemplate(T var1, String var2);

    public List<ImportResult> importTemplate(InputStream inputStream, String destinationFolderId) {
        T templateContent = this.doReadTemplateContent(inputStream);
        List<String> upgradeWarnings = this.doUpgradeTemplateContent(templateContent);
        return this.importTemplateContent(templateContent, destinationFolderId, upgradeWarnings);
    }

    private List<ImportResult> importTemplateContent(T templateContent, String destinationFolderId, List<String> warnings) {
        String destinationId = destinationFolderId == null ? Ids.ROOT_FOLDER_ID : destinationFolderId;
        Release template = this.doConvertToTemplate(templateContent, destinationId);
        template.getAttachments().forEach(attachment -> attachment.setFile((OverthereFile)templateContent.localFiles().get(attachment.getExportFilename())));
        Checks.checkArgument((boolean)template.isTemplate(), (String)"Only templates can be imported", (Object[])new Object[0]);
        this.taskAccessService.checkIfAuthenticatedUserCanUseTasks(template.getAllTasks());
        this.templateProcessors().forEach(processor -> warnings.addAll(processor.process(template, destinationId)));
        this.removeMissingGateDependencies(template, warnings);
        this.resetUndecryptedPasswords(template, warnings);
        this.resetTemplate(template);
        while (this.templateExistsWithTitle(template.getTitle())) {
            template.setTitle(RetryTitleGenerator.getNextTitle(template.getTitle()));
        }
        if (!template.hasScheduledStartDate()) {
            template.setScheduledStartDate(template.findFirstSetDate());
        }
        this.releaseService.importTemplate(template, destinationId);
        return Arrays.asList((Object[])new ImportResult[]{new ImportResult(template.getId(), template.getTitle(), warnings)});
    }

    private void resetTemplate(Release release) {
        release.setRunningTriggeredReleasesCount(0);
        release.getReleaseTriggers().forEach(releaseTrigger -> {
            releaseTrigger.setEnabled(false);
            releaseTrigger.resetExecutionId();
        });
    }

    private void resetUndecryptedPasswords(Release template, Collection<String> warnings) {
        block0: {
            BooleanRef issueWarning = BooleanRef.create((boolean)false);
            List configurationItems = CiHelper.getNestedCis((ConfigurationItem)template);
            configurationItems.forEach(configurationItem -> {
                Collection propertyDescriptors = configurationItem.getType().getDescriptor().getPropertyDescriptors();
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(propertyDescriptors).asScala()).foreach((Function1 & Serializable & scala.Serializable)propertyDescriptor -> {
                    BaseTemplateImporter.$anonfun$resetUndecryptedPasswords$2(this, issueWarning, configurationItem, propertyDescriptor);
                    return BoxedUnit.UNIT;
                });
            });
            if (!issueWarning.elem) break block0;
            warnings.add("Passwords could not be decrypted and have been reset.");
        }
    }

    private boolean resetUndecryptedPassword(ConfigurationItem ci, PropertyDescriptor propertyDescriptor) {
        PropertyKind propertyKind = propertyDescriptor.getKind();
        PropertyKind propertyKind2 = PropertyKind.STRING;
        if (!(propertyKind != null ? !propertyKind.equals(propertyKind2) : propertyKind2 != null) && propertyDescriptor.isPassword()) {
            String passwordValue;
            String string = passwordValue = (String)propertyDescriptor.get(ci);
            String string2 = UnresolvedReferencesConfigurationItemConverter.DECRYPTION_FAILED_VALUE;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                propertyDescriptor.set(ci, (Object)"");
                return true;
            }
        }
        return false;
    }

    private void removeMissingGateDependencies(Release template, Collection<String> warnings) {
        template.getAllGates().forEach(gateTask -> gateTask.getDependencies().removeIf(dependency -> {
            void var3_3;
            boolean shouldBeRemoved = !dependency.hasVariableTarget() && !dependency.hasResolvedTarget() && !dependency.isArchived();
            Object object = shouldBeRemoved ? BoxesRunTime.boxToBoolean((boolean)warnings.add(String.format("Gate Task '%s' has a dependency on an unknown Release/Phase/Task", gateTask.getTitle()))) : BoxedUnit.UNIT;
            return (boolean)var3_3;
        }));
    }

    private boolean templateExistsWithTitle(String title) {
        return this.releaseService.templateExistsWithTitle(title);
    }

    public static final /* synthetic */ void $anonfun$resetUndecryptedPasswords$2(BaseTemplateImporter $this, BooleanRef issueWarning$1, ConfigurationItem configurationItem$1, PropertyDescriptor propertyDescriptor) {
        block0: {
            boolean decryptionFailed = $this.resetUndecryptedPassword(configurationItem$1, propertyDescriptor);
            if (!decryptionFailed) break block0;
            issueWarning$1.elem = true;
        }
    }

    public BaseTemplateImporter(TaskAccessService taskAccessService, ReleaseService releaseService, Optional<List<TemplateImportProcessor>> maybeTemplateProcessors) {
        this.taskAccessService = taskAccessService;
        this.releaseService = releaseService;
        this.templateProcessors = maybeTemplateProcessors.orElse(Collections.emptyList());
    }
}

