/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.createrelease;

import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.task.DefaultTaskUpdater;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateReleaseTaskUpdater
extends DefaultTaskUpdater {
    private CiIdService ciIdService;

    @Autowired
    public CreateReleaseTaskUpdater(CiIdService ciIdService) {
        this.ciIdService = ciIdService;
    }

    @Override
    public Class<? extends Task> getTaskClass() {
        return CreateReleaseTask.class;
    }

    @Override
    public Changes update(Task original, Task updated) {
        Changes changes = super.update(original, updated);
        CreateReleaseTask updatedTask = (CreateReleaseTask)updated;
        CreateReleaseTask originalTask = (CreateReleaseTask)original;
        originalTask.setNewReleaseTitle(updatedTask.getNewReleaseTitle());
        originalTask.setTemplateId(updatedTask.getTemplateId());
        originalTask.setFolderId(updatedTask.getFolderId());
        originalTask.setCreatedReleaseId(updatedTask.getCreatedReleaseId());
        originalTask.setStartRelease(updatedTask.getStartRelease());
        originalTask.setReleaseTags(updatedTask.getReleaseTags());
        originalTask.getTemplateVariables().stream().filter(v -> !updatedTask.getTemplateVariables().contains(v)).forEach(v -> changes.remove(v.getId()));
        originalTask.setTemplateVariables(updatedTask.getTemplateVariables());
        VariablePersistenceHelper.fixUpVariableIds(originalTask.getId(), originalTask.getTemplateVariables(), this.ciIdService);
        changes.updateAll((Collection)originalTask.getTemplateVariables());
        if (originalTask.hasProperty("riskProfile")) {
            originalTask.setProperty("riskProfile", updated.getProperty("riskProfile"));
        }
        return changes;
    }
}

