/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.excel;

import com.google.common.base.Strings;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.excel.Export;
import com.xebialabs.xlrelease.planner.Planner;
import com.xebialabs.xlrelease.planner.PlannerReleaseItem;
import com.xebialabs.xlrelease.planner.PlannerReleaseTree;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.awt.Color;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class ReleaseExcel
extends Export {
    public static final int TITLE_COLUMN = 0;
    public static final int TASK_TYPE_COLUMN = 1;
    public static final int STATUS_COLUMN = 2;
    public static final int SCHEDULED_START_DATE_COLUMN = 3;
    public static final int DUE_DATE_COLUMN = 4;
    public static final int START_DATE_COLUMN = 5;
    public static final int END_DATE_COLUMN = 6;
    public static final int DURATION_COLUMN = 7;
    public static final int ASSIGNEE_COLUMN = 8;
    public static final int TEAM_COLUMN = 9;
    public static final int COMMENTS_COLUMN = 10;
    public static final int FLAG_COMMENT_COLUMN = 11;
    public static final int DELAYED_COLUMN = 12;
    public static final int FAILURE_COUNT_COLUMN = 13;
    private static final String SCHEDULED_START_DATE_HEADER = "Scheduled start date";
    private static final String DUE_DATE_HEADER = "Due date";
    private static final String START_DATE_HEADER = "Start date";
    private static final String END_DATE_HEADER = "End date";
    private static final String DURATION_HEADER = "Duration";
    private static final String ASSIGNEE_HEADER = "Assignee";
    private static final String TEAM_HEADER = "Team";
    private static final String COMMENTS_HEADER = "Task comments";
    private static final String FLAG_COMMENT_HEADER = "Status comment";
    private static final String DELAYED_HEADER = "Delayed";
    private static final String FAILURE_COUNT_HEADER = "Number of failure";
    private static final String DEFAULT_PHASE_COLOR = "#009CDB";
    private static final Integer MAXIMUM_CELL_LENGTH = Short.MAX_VALUE;
    private static final PeriodFormatter periodFormatter = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendSeparator(" ").appendHours().appendSuffix("h").appendSeparator(" ").appendMinutes().appendSuffix("m").appendSeparator(" ").appendSeconds().appendSuffix("s").toFormatter();
    private Release release;
    private PlannerReleaseTree tree;
    private UserInfoResolver userInfoResolver;
    private boolean isPhaseRow = false;
    private boolean isReleaseRow = false;
    private boolean isCommentsCell = false;
    private float defaultRowHeight = 0.0f;
    private XSSFCellStyle phaseStyle;
    private XSSFCellStyle dateStyle;

    public ReleaseExcel(Release release, UserInfoResolver userInfoResolver) {
        this.release = release;
        this.userInfoResolver = userInfoResolver;
    }

    @Override
    protected void addContent() {
        this.dateStyle = this.workBook.createCellStyle();
        this.dateStyle.setDataFormat(this.workBook.createDataFormat().getFormat("dd-MM-yy hh:mm"));
        this.tree = PlannerReleaseTree.apply((PlannerReleaseItem)PlannerReleaseItem.transform((PlanItem)this.release));
        Planner.makePlan((PlannerReleaseTree)this.tree, (DateTime)DateTime.now());
        this.addReleaseRow();
        for (PlannerReleaseItem phase : this.tree.root().getPhases()) {
            this.addPhaseRow(phase);
            for (PlannerReleaseItem task : phase.getAllTasks()) {
                this.addTaskRow(task);
            }
        }
    }

    @Override
    protected void setColumnsWidth() {
        this.sheet.setColumnWidth(0, this.numberOfCharacter(30));
        this.sheet.setColumnWidth(1, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(2, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(3, this.numberOfCharacter(16));
        this.sheet.setColumnWidth(4, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(5, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(6, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(7, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(8, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(9, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(10, this.numberOfCharacter(25));
        this.sheet.setColumnWidth(11, this.numberOfCharacter(20));
        this.sheet.setColumnWidth(12, this.numberOfCharacter(5));
        this.sheet.setColumnWidth(13, this.numberOfCharacter(5));
    }

    @Override
    protected void addHeaderRow() {
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        CellUtil.createCell((Row)row, (int)3, (String)SCHEDULED_START_DATE_HEADER);
        CellUtil.createCell((Row)row, (int)4, (String)DUE_DATE_HEADER);
        CellUtil.createCell((Row)row, (int)5, (String)START_DATE_HEADER);
        CellUtil.createCell((Row)row, (int)6, (String)END_DATE_HEADER);
        CellUtil.createCell((Row)row, (int)7, (String)DURATION_HEADER);
        CellUtil.createCell((Row)row, (int)8, (String)ASSIGNEE_HEADER);
        CellUtil.createCell((Row)row, (int)9, (String)TEAM_HEADER);
        CellUtil.createCell((Row)row, (int)10, (String)COMMENTS_HEADER);
        CellUtil.createCell((Row)row, (int)11, (String)FLAG_COMMENT_HEADER);
        CellUtil.createCell((Row)row, (int)12, (String)DELAYED_HEADER);
        CellUtil.createCell((Row)row, (int)13, (String)FAILURE_COUNT_HEADER);
        this.sheet.createRow(this.rowIndex++);
    }

    private void addReleaseRow() {
        this.isReleaseRow = true;
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        PlannerReleaseItem plannedRelease = this.tree.root();
        this.addTitleCell((PlanItem)this.release, row);
        CellUtil.createCell((Row)row, (int)2, (String)this.release.getStatus().toString(), (CellStyle)this.getDefaultStyle());
        this.addScheduledStartDateCell(this.tree.root(), row);
        this.addDueDateCell(plannedRelease, row);
        this.addStartDateCell(plannedRelease, row);
        this.addEndDateCell(plannedRelease, row);
        this.addDurationCell(plannedRelease, row);
        this.addFlagCommentCell((PlanItem)this.release, row);
        this.isReleaseRow = false;
        this.sheet.createRow(this.rowIndex++);
    }

    private void addPhaseRow(PlannerReleaseItem plannedPhase) {
        this.isPhaseRow = true;
        Phase phase = (Phase)plannedPhase.getItem();
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        this.applyPhaseColorToRow(phase, row);
        this.addTitleCell((PlanItem)phase, row);
        CellUtil.createCell((Row)row, (int)2, (String)phase.getStatus().toString(), (CellStyle)this.getDateStyle());
        this.addScheduledStartDateCell(plannedPhase, row);
        this.addDueDateCell(plannedPhase, row);
        this.addStartDateCell(plannedPhase, row);
        this.addEndDateCell(plannedPhase, row);
        this.addDurationCell(plannedPhase, row);
        this.isPhaseRow = false;
    }

    private void addTaskRow(PlannerReleaseItem plannedTask) {
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        Task task = (Task)plannedTask.getItem();
        this.addTitleCell(task, row);
        CellUtil.createCell((Row)row, (int)1, (String)this.getTaskType(task), (CellStyle)this.getDateStyle());
        CellUtil.createCell((Row)row, (int)2, (String)task.getStatus().toString(), (CellStyle)this.getDateStyle());
        this.addScheduledStartDateCell(plannedTask, row);
        this.addDueDateCell(plannedTask, row);
        this.addStartDateCell(plannedTask, row);
        this.addEndDateCell(plannedTask, row);
        this.addDurationCell(plannedTask, row);
        this.addAssigneeCell(task, row);
        this.addTeamCell(task, row);
        this.addTaskComments(task, row);
        this.addFlagCommentCell((PlanItem)task, row);
        this.addDelayedCell(task, row);
        this.addFailureCountCell(task, row);
    }

    private void applyPhaseColorToRow(Phase phase, XSSFRow row) {
        String phaseColor = phase.getColor();
        this.phaseStyle = this.workBook.createCellStyle();
        if (phaseColor == null) {
            phaseColor = DEFAULT_PHASE_COLOR;
        }
        Color color = Color.decode(phaseColor).brighter().brighter();
        this.phaseStyle.setFillForegroundColor(new XSSFColor(color));
        this.phaseStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        row.setRowStyle((CellStyle)this.phaseStyle);
    }

    private void addTitleCell(Task task, XSSFRow row) {
        String title = task.getTitle();
        TaskContainer container = task.getContainer();
        while (container instanceof TaskGroup) {
            title = ((TaskGroup)container).getTitle() + " / " + title;
            container = ((TaskGroup)container).getContainer();
        }
        this.addTitleCell(title, row);
    }

    private void addTitleCell(PlanItem item, XSSFRow row) {
        this.addTitleCell(item.getTitle(), row);
    }

    private void addTitleCell(String title, XSSFRow row) {
        title = VariableHelper.replaceAll((String)title, (Map)this.release.getAllStringVariableValues(), new HashSet(), (boolean)false);
        CellUtil.createCell((Row)row, (int)0, (String)title, (CellStyle)this.getDefaultStyle());
    }

    private void addScheduledStartDateCell(PlannerReleaseItem item, XSSFRow row) {
        Date date = item.getScheduledStartDate();
        if (date != null) {
            XSSFCell startDateCell = row.createCell(3);
            startDateCell.setCellValue(date);
            startDateCell.setCellStyle((CellStyle)this.getDateStyle());
        }
    }

    private void addDueDateCell(PlannerReleaseItem item, XSSFRow row) {
        Date date = item.getDueDate();
        if (date != null) {
            XSSFCell endDateCell = row.createCell(4);
            endDateCell.setCellValue(date);
            endDateCell.setCellStyle((CellStyle)this.getDateStyle());
        }
    }

    private void addStartDateCell(PlannerReleaseItem item, XSSFRow row) {
        Date date = item.getStartDate();
        if (date != null) {
            XSSFCell startDateCell = row.createCell(5);
            startDateCell.setCellValue(date);
            startDateCell.setCellStyle((CellStyle)this.getDateStyle());
        }
    }

    private void addEndDateCell(PlannerReleaseItem item, XSSFRow row) {
        Date date = item.getEndDate();
        if (date != null) {
            XSSFCell endDateCell = row.createCell(6);
            endDateCell.setCellValue(date);
            endDateCell.setCellStyle((CellStyle)this.getDateStyle());
        }
    }

    private void addDurationCell(PlannerReleaseItem item, XSSFRow row) {
        Duration duration = item.getDuration();
        if (duration != null) {
            XSSFCell durationCell = row.createCell(7);
            durationCell.setCellValue(periodFormatter.print((ReadablePeriod)duration.toPeriod().normalizedStandard(PeriodType.dayTime())));
            durationCell.setCellStyle((CellStyle)this.getDefaultStyle());
        }
    }

    private void addAssigneeCell(Task task, XSSFRow row) {
        String taskOwner = VariableHelper.replaceAll((String)task.getOwner(), (Map)this.release.getAllStringVariableValues(), new HashSet(), (boolean)false);
        CellUtil.createCell((Row)row, (int)8, (String)this.userInfoResolver.getFullNameOrUsernameOf(taskOwner), (CellStyle)this.getDefaultStyle());
    }

    private void addTeamCell(Task task, XSSFRow row) {
        CellUtil.createCell((Row)row, (int)9, (String)task.getTeam(), (CellStyle)this.getDefaultStyle());
    }

    private void addTaskComments(Task task, XSSFRow row) {
        this.isCommentsCell = true;
        this.defaultRowHeight = CellUtil.getRow((int)row.getRowNum(), (Sheet)this.sheet).getHeightInPoints();
        String comments = task.getComments().stream().map(entity -> entity.getAuthor() + ": " + entity.getText()).collect(Collectors.joining("\n"));
        if (comments.length() > MAXIMUM_CELL_LENGTH) {
            comments = comments.substring(0, MAXIMUM_CELL_LENGTH);
        }
        CellUtil.createCell((Row)row, (int)10, (String)comments, (CellStyle)this.getDefaultStyle());
        CellUtil.getRow((int)row.getRowNum(), (Sheet)this.sheet).setHeightInPoints(this.defaultRowHeight);
        this.isCommentsCell = false;
    }

    private void addFlagCommentCell(PlanItem item, XSSFRow row) {
        if (item.getFlagStatus() == FlagStatus.OK) {
            return;
        }
        XSSFColor backgroundColor = null;
        if (item.getFlagStatus() == FlagStatus.ATTENTION_NEEDED) {
            backgroundColor = new XSSFColor(Color.ORANGE);
        } else if (item.getFlagStatus() == FlagStatus.AT_RISK) {
            backgroundColor = new XSSFColor(Color.RED);
        }
        CellUtil.createCell((Row)row, (int)11, (String)item.getFlagComment(), (CellStyle)this.getStyle(false, backgroundColor));
    }

    private void addDelayedCell(Task task, XSSFRow row) {
        CellUtil.createCell((Row)row, (int)12, (String)(task.getDelayedCount() > 0 ? "Yes" : "No"), (CellStyle)this.getDefaultStyle());
    }

    private void addFailureCountCell(Task task, XSSFRow row) {
        CellUtil.createCell((Row)row, (int)13, (String)String.valueOf(task.getFailuresCount()), (CellStyle)this.getDefaultStyle());
    }

    private XSSFCellStyle getDefaultStyle() {
        return this.getStyle(false, null);
    }

    private XSSFCellStyle getDateStyle() {
        return this.getStyle(true, null);
    }

    private XSSFCellStyle getStyle(boolean isDate, XSSFColor backgroundColor) {
        XSSFCellStyle cellStyle = this.workBook.createCellStyle();
        if (isDate) {
            cellStyle.setDataFormat(this.dateStyle.getDataFormat());
        }
        if (backgroundColor != null) {
            cellStyle.setFillForegroundColor(backgroundColor);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        } else if (this.isPhaseRow) {
            cellStyle.setFillForegroundColor(this.phaseStyle.getFillForegroundXSSFColor());
            cellStyle.setFillPattern(this.phaseStyle.getFillPatternEnum());
        }
        if (this.isCommentsCell) {
            cellStyle.setWrapText(true);
        }
        if (this.isReleaseRow) {
            XSSFFont font = this.workBook.createFont();
            font.setBold(true);
            cellStyle.setFont((Font)font);
        }
        return cellStyle;
    }

    private String getTaskType(Task task) {
        String typeLabel = task.getType().getDescriptor().getLabel();
        return Strings.isNullOrEmpty((String)typeLabel) ? task.getType().getName() : typeLabel;
    }
}

