/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.domain.events.FolderVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderVariableDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.FolderVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FolderVariableRepository;
import com.xebialabs.xlrelease.repository.IdMatchers$FolderId$;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001-\u0011QCR8mI\u0016\u0014h+\u0019:jC\ndWmU3sm&\u001cWM\u0003\u0002\u0004\t\u000591/\u001a:wS\u000e,'BA\u0003\u0007\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\b\u0011\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011M\u0001!\u0011!Q\u0001\nQ\t\u0001CZ8mI\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011D\u0006\u0002\u0011\r>dG-\u001a:SKB|7/\u001b;pefD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0019M>dG-\u001a:WCJL\u0017M\u00197f%\u0016\u0004xn]5u_JL\bCA\u000b\u001e\u0013\tqbC\u0001\rG_2$WM\u001d,be&\f'\r\\3SKB|7/\u001b;pefD\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!I\u0001\tKZ,g\u000e\u001e\"vgB\u0011!%J\u0007\u0002G)\u0011A\u0005B\u0001\u0007KZ,g\u000e^:\n\u0005\u0019\u001a#!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\")\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"BA\u000b\u0017.]A\u00111\u0006A\u0007\u0002\u0005!)1c\na\u0001)!)1d\na\u00019!)\u0001e\na\u0001C!\u0012q\u0005\r\t\u0003cqj\u0011A\r\u0006\u0003gQ\n!\"\u00198o_R\fG/[8o\u0015\t)d'A\u0004gC\u000e$xN]=\u000b\u0005]B\u0014!\u00022fC:\u001c(BA\u001d;\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\u001e\u0002\u0007=\u0014x-\u0003\u0002>e\tI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\tM&tGMQ=JIR\u0011\u0011)\u0013\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000b\u0011B^1sS\u0006\u0014G.Z:\u000b\u0005\u0019#\u0011A\u00023p[\u0006Lg.\u0003\u0002I\u0007\nAa+\u0019:jC\ndW\rC\u0003K}\u0001\u00071*\u0001\u0006wCJL\u0017M\u00197f\u0013\u0012\u0004\"\u0001T*\u000f\u00055\u000b\u0006C\u0001(\u000f\u001b\u0005y%B\u0001)\u000b\u0003\u0019a$o\\8u}%\u0011!KD\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002S\u001d!\u0012ah\u0016\t\u00031zk\u0011!\u0017\u0006\u0003giS!a\u0017/\u0002\u000f5,GO]5dg*\u0011Q\fC\u0001\tG>$\u0017\r[1mK&\u0011q,\u0017\u0002\u0006)&lW\r\u001a\u0005\u0006C\u0002!\tAY\u0001\u0015GJ,\u0017\r^3G_2$WM\u001d,be&\f'\r\\3\u0015\u0005\u0005\u001b\u0007\"\u00023a\u0001\u0004\t\u0015\u0001\u0003<be&\f'\r\\3)\u0005\u0001<\u0006\"B4\u0001\t\u0003A\u0017!G4fi\u0006cGN\u0012:p[&kW.\u001a3jCR,\u0007+\u0019:f]R$\"!\u001b7\u0011\u0005\tS\u0017BA6D\u0005=1u\u000e\u001c3feZ\u000b'/[1cY\u0016\u001c\b\"B7g\u0001\u0004Y\u0015\u0001\u0005<be&\f'\r\\3QCJ,g\u000e^%eQ\t1w\u000bC\u0003q\u0001\u0011\u0005\u0011/\u0001\nhKR\fE\u000e\u001c$s_6\fenY3tiJLHCA5s\u0011\u0015iw\u000e1\u0001LQ\tyw\u000bC\u0003v\u0001\u0011\u0005a/\u0001\u000bva\u0012\fG/\u001a$pY\u0012,'OV1sS\u0006\u0014G.\u001a\u000b\u0004\u0003^D\b\"\u0002&u\u0001\u0004Y\u0005\"\u00023u\u0001\u0004\t\u0005F\u0001;X\u0011\u0015Y\b\u0001\"\u0001}\u0003Q!W\r\\3uK\u001a{G\u000eZ3s-\u0006\u0014\u0018.\u00192mKR\u0019Q0!\u0001\u0011\u00055q\u0018BA@\u000f\u0005\u0011)f.\u001b;\t\u000b)S\b\u0019A&)\u0005i<\u0006bBA\u0004\u0001\u0011%\u0011\u0011B\u0001\u000eG\",7m[*b[\u0016$\u0016\u0010]3\u0015\u000bu\fY!a\u0004\t\u000f\u00055\u0011Q\u0001a\u0001\u0003\u000691-\u001e:sK:$\bbBA\t\u0003\u000b\u0001\r!Q\u0001\bkB$\u0017\r^3eQ\r\u0001\u0011Q\u0003\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111\u0004\u001d\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002 \u0005e!aB*feZL7-\u001a")
public class FolderVariableService {
    private final FolderRepository folderRepository;
    private final FolderVariableRepository folderVariableRepository;
    private final XLReleaseEventBus eventBus;

    @Timed
    public Variable findById(String variableId) {
        return this.folderVariableRepository.findById(variableId);
    }

    @Timed
    public Variable createFolderVariable(Variable variable) {
        String string = variable.getFolderId();
        Option<String> option = IdMatchers$FolderId$.MODULE$.unapply(string);
        if (option.isEmpty()) {
            throw new Checks.IncorrectArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You can't add variable with id='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})), new Object[0]);
        }
        String folderId = (String)option.get();
        Checks.checkArgument((boolean)this.folderRepository.exists(folderId), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Folder with id='", "' doesn't exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})), (Object[])new Object[0]);
        variable.checkFolderVariableValidity();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Variable created = this.folderVariableRepository.create(variable);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableCreatedEvent(created, null));
        return created;
    }

    @Timed
    public FolderVariables getAllFromImmediateParent(String variableParentId) {
        return new FolderVariables(variableParentId, this.folderVariableRepository.getAllFromParent(variableParentId));
    }

    @Timed
    public FolderVariables getAllFromAncestry(String variableParentId) {
        return new FolderVariables(variableParentId, this.folderVariableRepository.getAllFromAncestry(variableParentId));
    }

    @Timed
    public Variable updateFolderVariable(String variableId, Variable variable) {
        variable.checkFolderVariableValidity();
        Variable current = this.folderVariableRepository.findById(variableId);
        this.checkSameType(current, variable);
        String string = current.getFolderId();
        String string2 = variable.getFolderId();
        Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Cannot change folderId", (Object[])new Object[0]);
        Variable updated = this.folderVariableRepository.update(variable);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableUpdatedEvent(variable, updated, null));
        return updated;
    }

    @Timed
    public void deleteFolderVariable(String variableId) {
        Variable variable = this.findById(variableId);
        this.folderVariableRepository.delete(variableId);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableDeletedEvent(variable, null));
    }

    private void checkSameType(Variable current, Variable updated) {
        if (!current.getType().equals((Object)updated.getType())) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot change type of variable ", " from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{updated.getId(), current.getType(), updated.getType()})));
        }
    }

    @Autowired
    public FolderVariableService(FolderRepository folderRepository, FolderVariableRepository folderVariableRepository, XLReleaseEventBus eventBus) {
        this.folderRepository = folderRepository;
        this.folderVariableRepository = folderVariableRepository;
        this.eventBus = eventBus;
    }
}

