/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.TeamFacade;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.FolderVariableService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/folders")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@AllCILevels
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class FolderApi
implements ApiService {
    private final String EXPRESSION_FOLDER_ID = "/{folderId:.*(Folder[^/]*|Applications)}";
    private final PermissionChecker permissions;
    private final FolderService folderService;
    private final TeamFacade teamFacade;
    private final FolderVariableService folderVariableService;

    @Autowired
    public FolderApi(PermissionChecker permissions, FolderService folderService, TeamFacade teamFacade, FolderVariableService folderVariableService) {
        this.permissions = permissions;
        this.folderService = folderService;
        this.teamFacade = teamFacade;
        this.folderVariableService = folderVariableService;
    }

    public String serviceName() {
        return "folderApi";
    }

    @GET
    @Path(value="/list")
    @PublicApiMember
    public List<Folder> listRoot(@QueryParam(value="page") Long page, @QueryParam(value="resultsPerPage") Long resultPerPage, @QueryParam(value="depth") Integer depth, @QueryParam(value="permissions") Boolean decorateWithPermissions) {
        return this.folderService.listViewableFolders(Folder.ROOT_FOLDER_ID, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultPerPage), Optional.ofNullable(depth)), Optional.ofNullable(decorateWithPermissions).orElse(true));
    }

    @PublicApiMember
    public List<Folder> listRoot() {
        return this.listRoot(null, null, null, null);
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/list")
    @PublicApiMember
    public List<Folder> list(@PathParam(value="folderId") String parentId, @QueryParam(value="page") Long page, @QueryParam(value="resultsPerPage") Long resultPerPage, @QueryParam(value="depth") Integer depth, @QueryParam(value="permissions") Boolean decorateWithPermissions) {
        return this.folderService.listViewableFolders(parentId, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultPerPage), Optional.ofNullable(depth)), Optional.ofNullable(decorateWithPermissions).orElse(true));
    }

    @GET
    @Path(value="/find")
    @PublicApiMember
    public Folder find(@QueryParam(value="byPath") String path, @QueryParam(value="depth") Integer depth) {
        return this.folderService.findByPath(path, Optional.ofNullable(depth).orElse(Page.DEFAULT_DEPTH()));
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}")
    @PublicApiMember
    public Folder getFolder(@PathParam(value="folderId") String folderId, @QueryParam(value="depth") Integer depth) {
        this.permissions.check(XLReleasePermissions.VIEW_FOLDER, folderId);
        return this.folderService.findById(folderId, Optional.ofNullable(depth).orElse(Page.DEFAULT_DEPTH()));
    }

    @PublicApiMember
    public Folder getFolder(String folderId) {
        return this.getFolder(folderId, null);
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/templates")
    @PublicApiMember
    public List<Release> getTemplates(@PathParam(value="folderId") String folderId, @QueryParam(value="page") Long page, @QueryParam(value="resultsPerPage") Long resultPerPage, @QueryParam(value="depth") Integer depth) {
        this.permissions.checkViewFolder(folderId);
        if (!Ids.isRoot((String)folderId)) {
            this.permissions.check(XLReleasePermissions.VIEW_TEMPLATE, folderId);
        }
        return this.folderService.searchTemplates(folderId, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultPerPage), Optional.ofNullable(depth)));
    }

    @PublicApiMember
    public List<Release> getTemplates(String folderId) {
        return this.getTemplates(folderId, null, null, null);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/releases")
    @PublicApiMember
    public List<Release> searchReleases(@PathParam(value="folderId") String folderId, @QueryParam(value="page") Long page, @QueryParam(value="numberbypage") Long resultPerPage, @QueryParam(value="depth") Integer depth, ReleasesFilters releasesFilters) {
        if (!Ids.isRoot((String)folderId)) {
            this.permissions.checkViewFolder(folderId);
            this.permissions.check(XLReleasePermissions.VIEW_RELEASE, folderId);
        }
        if (null == releasesFilters) {
            releasesFilters = new ReleasesFilters();
        }
        return this.folderService.searchReleases(folderId, releasesFilters, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultPerPage), Optional.ofNullable(depth))).getReleases();
    }

    @PublicApiMember
    public List<Release> searchReleases(String folderId, ReleasesFilters releasesFilters) {
        return this.searchReleases(folderId, null, null, null, releasesFilters);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/templates/{templateId:.*Release[^/]*}")
    @PublicApiMember
    public void moveTemplate(@PathParam(value="folderId") String folderId, @PathParam(value="templateId") String templateId, @QueryParam(value="mergePermissions") Boolean mergeTeams) {
        this.permissions.checkEdit(templateId);
        this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, folderId);
        boolean shouldMergeTeams = Optional.ofNullable(mergeTeams).orElse(false);
        if (shouldMergeTeams) {
            this.permissions.check(XLReleasePermissions.EDIT_FOLDER_SECURITY, folderId);
        }
        this.folderService.moveTemplate(folderId, templateId, shouldMergeTeams);
    }

    @PublicApiMember
    public void moveTemplate(String folderId, String templateId) {
        this.moveTemplate(folderId, templateId, null);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}")
    @PublicApiMember
    public Folder addFolder(@PathParam(value="folderId") String parentId, Folder folder) {
        if (Folder.ROOT_FOLDER_ID.equals(parentId)) {
            this.permissions.check(XLReleasePermissions.CREATE_TOP_LEVEL_FOLDER);
        } else {
            this.permissions.check(XLReleasePermissions.EDIT_FOLDER, parentId);
        }
        return this.folderService.create(parentId, folder);
    }

    @DELETE
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}")
    @PublicApiMember
    public void delete(@PathParam(value="folderId") String folderId) {
        Checks.checkArgument((!Folder.ROOT_FOLDER_ID.equals(folderId) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, folderId);
        this.folderService.delete(folderId);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/move")
    @PublicApiMember
    public void move(@PathParam(value="folderId") String folderId, @QueryParam(value="newParentId") String newParentId) {
        Checks.checkArgument((!Folder.ROOT_FOLDER_ID.equals(folderId) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, folderId);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, newParentId);
        this.folderService.move(folderId, newParentId);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/rename")
    @PublicApiMember
    public void rename(@PathParam(value="folderId") String folderId, @QueryParam(value="newName") String newName) {
        Checks.checkArgument((!Folder.ROOT_FOLDER_ID.equals(folderId) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, folderId);
        this.folderService.rename(folderId, newName);
    }

    @GET
    @Path(value="/permissions")
    @PublicApiMember
    public List<String> getPermissions() {
        ArrayList<String> folderPermissions = new ArrayList<String>();
        folderPermissions.addAll(XLReleasePermissions.getFolderPermissions());
        folderPermissions.addAll(XLReleasePermissions.getTemplatePermissions());
        return folderPermissions;
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams")
    @PublicApiMember
    public List<TeamView> getTeams(@PathParam(value="folderId") String folderId) {
        return this.teamFacade.getTeams(folderId);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams")
    @PublicApiMember
    public List<TeamView> setTeams(@PathParam(value="folderId") String folderId, List<TeamView> teamDtos) {
        return this.teamFacade.setTeams(folderId, teamDtos);
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/folderOwner")
    public boolean isFolderOwner(@PathParam(value="folderId") String folderId) {
        this.permissions.checkAny(folderId, XLReleasePermissions.EDIT_FOLDER_SECURITY, XLReleasePermissions.EDIT_FOLDER_TEAMS);
        return this.permissions.isCurrentUserAdmin() || this.permissions.getUserFolderTeams(folderId).stream().anyMatch(Team::isFolderOwnerTeam);
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/variables")
    @PublicApiMember
    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> listVariables(@PathParam(value="folderId") String folderId, @QueryParam(value="folderOnly") boolean folderOnly) {
        if (folderOnly) {
            return this.folderVariableService.getAllFromImmediateParent(folderId).getVariables();
        }
        return this.folderVariableService.getAllFromAncestry(folderId).getVariables();
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/variableValues")
    @PublicApiMember
    @Timed
    public Map<String, String> listVariableValues(@PathParam(value="folderId") String folderId, @QueryParam(value="folderOnly") boolean folderOnly) {
        return VariableHelper.getStringVariableValues(this.listVariables(folderId, folderOnly));
    }

    @POST
    @PublicApiMember
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/variables")
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(@PathParam(value="folderId") String folderId, Variable variable) {
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER_VARIABLES, folderId);
        com.xebialabs.xlrelease.domain.variables.Variable releaseVariable = variable.toReleaseVariable();
        releaseVariable.setFolderId(folderId);
        return this.folderVariableService.createFolderVariable(releaseVariable);
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{variableId:.*Variable[^/]*}")
    @PublicApiMember
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(@PathParam(value="folderId") String folderId, @PathParam(value="variableId") String variableId) {
        return this.folderVariableService.findById(variableId);
    }

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{variableId:.*Variable[^/]*}")
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(@PathParam(value="folderId") String folderId, @PathParam(value="variableId") String variableId, Variable variable) {
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER_VARIABLES, folderId);
        com.xebialabs.xlrelease.domain.variables.Variable releaseVariable = variable.toReleaseVariable();
        releaseVariable.setFolderId(folderId);
        return this.folderVariableService.updateFolderVariable(variableId, releaseVariable);
    }

    @PublicApiMember
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(@PathParam(value="folderId") String folderId, Variable variable) {
        return this.updateVariable(folderId, variable.getId(), variable);
    }

    @DELETE
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{variableId:.*Variable[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteVariable(@PathParam(value="folderId") String folderId, @PathParam(value="variableId") String variableId) {
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER_VARIABLES, folderId);
        this.folderVariableService.deleteFolderVariable(variableId);
    }
}

