/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.xebialabs.deployit.plumbing.PasswordDeserializer;
import com.xebialabs.deployit.plumbing.PasswordSerializer;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.VariableOrValueView;
import java.util.Map;

public class VariableOrPasswordView
extends VariableOrValueView {
    public VariableOrPasswordView() {
    }

    public VariableOrPasswordView(String variable, String password) {
        if (variable != null) {
            this.setVariable(VariableHelper.formatVariableIfNeeded((String)variable));
            this.setValue(password);
        } else if (VariableHelper.containsOnlyVariable((String)password)) {
            this.setVariable(password);
            this.setValue(null);
        } else {
            this.setVariable(null);
            this.setValue(password);
        }
    }

    public VariableOrPasswordView(String password) {
        this(null, password);
    }

    public VariableOrPasswordView(Map<String, String> deserializedView) {
        this(deserializedView.get("variable"), deserializedView.get("value"));
    }

    @JsonSerialize(using=PasswordSerializer.class)
    @JsonDeserialize(using=PasswordDeserializer.class)
    public String getValue() {
        return (String)this.value;
    }

    public void setValue(String password) {
        this.value = password;
    }

    public String variableOrValue() {
        return this.getVariable() != null ? VariableHelper.formatVariableIfNeeded((String)this.getVariable()) : this.getValue();
    }
}

