/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service.blackout;

import akka.actor.Actor;
import akka.actor.ActorRef;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.blackout.BlackoutPeriod;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.EventBus;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.blackout.BlackoutReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0001\u0003\u00015\u0011\u0001D\u00117bG.|W\u000f\u001e+bg.,e/\u001a8u\u0011\u0006tG\r\\3s\u0015\t\u0019A!\u0001\u0005cY\u0006\u001c7n\\;u\u0015\t)a!A\u0004tKJ4\u0018nY3\u000b\u0005\u001dA\u0011!\u0003=me\u0016dW-Y:f\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u001dQa\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005IQ\r\u001f;f]NLwN\u001c\u0006\u00033\u0019\ta!Y2u_J\u001c\u0018BA\u000e\u0017\u0005q\t5\r^8s\u000bb$XM\\:j_:D\u0015M\u001c3mKJ4\u0015m\u0019;pef\u0004\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\u000bMdg\r\u000e6\u000b\u0003\u0005\n\u0001b\u001a:jujdW\rZ\u0005\u0003Gy\u0011q\u0001T8hO&tw\r\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u0003!)g/\u001a8u\u0005V\u001cX#A\u0014\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013AB3wK:$8O\u0003\u0002-\r\u00051Am\\7bS:L!AL\u0015\u0003\u0011\u00153XM\u001c;CkND\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IaJ\u0001\nKZ,g\u000e\u001e\"vg\u0002B\u0001B\r\u0001\u0003\u0006\u0004%\taM\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u000b\u0002iA\u0011QGN\u0007\u00021%\u0011q\u0007\u0007\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\u0005\ts\u0001\u0011\t\u0011)A\u0005i\u0005!\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0002B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001P\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z+\u0005i\u0004C\u0001 B\u001b\u0005y$B\u0001!\u0007\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u0005~\u0012a\u0002V1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003>\u0003=!\u0018m]6SKB|7/\u001b;pef\u0004\u0003\"\u0002$\u0001\t\u00039\u0015A\u0002\u001fj]&$h\b\u0006\u0003I\u0015.c\u0005CA%\u0001\u001b\u0005\u0011\u0001\"B\u0013F\u0001\u00049\u0003\"\u0002\u001aF\u0001\u0004!\u0004\"B\u001eF\u0001\u0004i\u0004FA#O!\ty%,D\u0001Q\u0015\t\t&+\u0001\u0006b]:|G/\u0019;j_:T!a\u0015+\u0002\u000f\u0019\f7\r^8ss*\u0011QKV\u0001\u0006E\u0016\fgn\u001d\u0006\u0003/b\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u00023\u0006\u0019qN]4\n\u0005m\u0003&!C!vi><\u0018N]3e\u0011\u0015i\u0006\u0001\"\u0001_\u0003!\u0011XmZ5ti\u0016\u0014H#A0\u0011\u0005=\u0001\u0017BA1\u0011\u0005\u0011)f.\u001b;)\u0005q\u001b\u0007C\u00013i\u001b\u0005)'BA)g\u0015\u00059\u0017!\u00026bm\u0006D\u0018BA5f\u00055\u0001vn\u001d;D_:\u001cHO];di\")1\u000e\u0001C\u0001=\u0006QQO\u001c:fO&\u001cH/\u001a:)\u0005)l\u0007C\u00013o\u0013\tyWM\u0001\u0006Qe\u0016$Um\u001d;s_fDQ!\u001d\u0001\u0005\u0002I\f\u0011c\u001c8CY\u0006\u001c7n\\;u+B$\u0017\r^3e)\ty6\u000fC\u0003ua\u0002\u0007Q/A\u0003fm\u0016tG\u000f\u0005\u0002)m&\u0011q/\u000b\u0002\u0015\u00052\f7m[8viV\u0003H-\u0019;fI\u00163XM\u001c;)\u0005AL\bc\u0001>\u0002\u00025\t1P\u0003\u0002Ry*\u0011QP`\u0001\b[\u0016$(/[2t\u0015\ty(\"\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\r\t\u0019a\u001f\u0002\u0006)&lW\r\u001a\u0015\u0004a\u0006\u001d\u0001\u0003BA\u0005\u0003\u001bi!!a\u0003\u000b\u0005)2\u0011\u0002BA\b\u0003\u0017\u0011\u0011bU;cg\u000e\u0014\u0018NY3\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005\trN\u001c\"mC\u000e\\w.\u001e;EK2,G/\u001a3\u0015\u0007}\u000b9\u0002C\u0004u\u0003#\u0001\r!!\u0007\u0011\u0007!\nY\"C\u0002\u0002\u001e%\u0012AC\u00117bG.|W\u000f\u001e#fY\u0016$X\rZ#wK:$\bfAA\ts\"\"\u0011\u0011CA\u0004\u0011\u001d\t)\u0003\u0001C\u0005\u0003O\t\u0001#[:BM\u001a,7\r^5oOR\u000b7o[:\u0015\r\u0005%\u0012qFA\u0019!\ry\u00111F\u0005\u0004\u0003[\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007i\u0006\r\u0002\u0019A;\t\u0011\u0005M\u00121\u0005a\u0001\u0003k\t1A\\8x!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\tA!\u001e;jY*\u0011\u0011qH\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002D\u0005e\"\u0001\u0002#bi\u0016Dq!a\u0012\u0001\t\u0013\tI%\u0001\ntG\",G-\u001e7f)\u0006\u001c8.\u00169eCR,G#B0\u0002L\u0005\u0015\u0004\u0002CA'\u0003\u000b\u0002\r!a\u0014\u0002\rQ\f7o[%e!\u0011\t\t&a\u0018\u000f\t\u0005M\u00131\f\t\u0004\u0003+\u0002RBAA,\u0015\r\tI\u0006D\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005u\u0003#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\n\u0019G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;\u0002\u0002\u0002CA4\u0003\u000b\u0002\r!!\u001b\u0002\u000f\r|W.\\1oIB!\u00111NAA\u001d\u0011\ti'! \u000f\t\u0005=\u00141\u0010\b\u0005\u0003c\nIH\u0004\u0003\u0002t\u0005]d\u0002BA+\u0003kJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005e1\u0011bAA@1\u0005i\"+\u001a7fCN,W\t_3dkRLwN\\!di>\u0014X*Z:tC\u001e,7/\u0003\u0003\u0002\u0004\u0006\u0015%\u0001E#yi\u0016t7/[8o\u0007>lW.\u00198e\u0015\r\ty\b\u0007\u0005\b\u0003\u0013\u0003A\u0011IAF\u0003)9W\r\u001e%b]\u0012dWM\u001d\u000b\t\u0003\u001b\u000bY+a.\u0002BB!\u0011qRAS\u001d\u0011\t\t*a(\u000f\t\u0005M\u0015\u0011\u0014\b\u0005\u0003+\n)*\u0003\u0002\u0002\u0018\u0006!\u0011m[6b\u0013\u0011\tY*!(\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005\u0005]\u0015\u0002BAQ\u0003G\u000bQ!Q2u_JTA!a'\u0002\u001e&!\u0011qUAU\u0005\u001d\u0011VmY3jm\u0016TA!!)\u0002$\"A\u0011QVAD\u0001\u0004\ty+\u0001\u0003tK24\u0007\u0003BAY\u0003gk!!a)\n\t\u0005U\u00161\u0015\u0002\t\u0003\u000e$xN\u001d*fM\"A\u0011\u0011XAD\u0001\u0004\tY,\u0001\u0004tK:$WM\u001d\t\u0006\u001f\u0005u\u0016qV\u0005\u0004\u0003\u007f\u0003\"!\u0003$v]\u000e$\u0018n\u001c81\u0011!\t\u0019-a\"A\u0002\u0005=\u0013!\u0003:fY\u0016\f7/Z%e\u0011\u001d\t9\r\u0001C\u0005\u0003\u0013\fa\"\u001e9eCR,G+Y:l/&$\b\u000e\u0006\u0003\u0002L\u0006}GcA0\u0002N\"A\u0011qZAc\u0001\u0004\t\t.A\u0004va\u0012\fG/\u001a:\u0011\r=\t\u0019.a6`\u0013\r\t)\u000e\u0005\u0002\n\rVt7\r^5p]F\u0002B!!7\u0002\\6\t1&C\u0002\u0002^.\u0012A\u0001V1tW\"A\u0011QJAc\u0001\u0004\ty\u0005C\u0004\u0002d\u0002!I!!:\u00021U\u0004H-\u0019;f'\u000eDW\rZ;mK\u0012\u001cF/\u0019:u\t\u0006$X\rF\u0003`\u0003O\fY\u000f\u0003\u0005\u0002j\u0006\u0005\b\u0019AAl\u0003\u0011!\u0018m]6\t\u0011\u00055\u0018\u0011\u001da\u0001\u0003k\tQC\\3x'\u000eDW\rZ;mK\u0012\u001cF/\u0019:u\t\u0006$X\rC\u0004\u0002r\u0002!I!a=\u0002/I,7/\u001a;TG\",G-\u001e7fIN#\u0018M\u001d;ECR,GcA0\u0002v\"A\u0011\u0011^Ax\u0001\u0004\t9\u000eC\u0004\u0002z\u0002!\t%a?\u0002\u0011M,\b\u000f]8siN$B!!\u000b\u0002~\"A\u0011q`A|\u0001\u0004\u0011\t!A\u0003dY\u0006T(\u0010\r\u0003\u0003\u0004\t5\u0001CBA)\u0005\u000b\u0011I!\u0003\u0003\u0003\b\u0005\r$!B\"mCN\u001c\b\u0003\u0002B\u0006\u0005\u001ba\u0001\u0001\u0002\u0007\u0003\u0010\u0005u\u0018\u0011!A\u0001\u0006\u0003\u0011\tBA\u0002`IE\nBAa\u0005\u0003\u001aA\u0019qB!\u0006\n\u0007\t]\u0001CA\u0004O_RD\u0017N\\4\u0011\t\u0005E&1D\u0005\u0005\u0005;\t\u0019KA\u0003BGR|'\u000fK\u0002\u0001\u0005C\u0001BAa\t\u0003*5\u0011!Q\u0005\u0006\u0004\u0005O1\u0016AC:uKJ,w\u000e^=qK&!!1\u0006B\u0013\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class BlackoutTaskEventHandler
implements ActorExtensionHandlerFactory,
Logging {
    private final EventBus eventBus;
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public <T> void replyOrFail(Function0<ActorRef> sender, Function0<T> call) {
        ActorExtensionHandlerFactory.replyOrFail$(this, sender, call);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BlackoutTaskEventHandler blackoutTaskEventHandler = this;
        synchronized (blackoutTaskEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    @PostConstruct
    public void register() {
        this.eventBus().register((Object)this);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Blackout task event handler registered in event bus.");
    }

    @PreDestroy
    public void unregister() {
        this.eventBus().deregister((Object)this);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Blackout task event handler de-registered from event bus.");
    }

    @Subscribe
    @Timed
    public void onBlackoutUpdated(BlackoutUpdatedEvent event) {
        block0: {
            Date now = new Date();
            if (!this.isAffectingTasks(event, now)) break block0;
            Buffer taskIds = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.taskRepository().findAffectedByBlackout(event.original())).asScala();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " taskIds to be updated after blackout ", " update."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)taskIds.length()), event.original().getLabel()})));
            BlackoutMetadata metadata = BlackoutMetadata$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlackoutPeriod[]{new BlackoutPeriod(event.updated().getStartDate(), event.updated().getEndDate())})));
            boolean isInBlackout = metadata.isInBlackout(now);
            Date newScheduledStartDate = metadata.getEndOfBlackout(now);
            taskIds.foreach((Function1 & Serializable & scala.Serializable)taskId -> {
                this.scheduleTaskUpdate(taskId, isInBlackout ? new BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate(taskId, newScheduledStartDate) : new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
                return BoxedUnit.UNIT;
            });
        }
    }

    @Subscribe
    @Timed
    public void onBlackoutDeleted(BlackoutDeletedEvent event) {
        Buffer taskIds = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.taskRepository().findAffectedByBlackout(event.blackout())).asScala();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " taskIds to be started after blackout ", " removal."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)taskIds.length()), event.blackout().getLabel()})));
        taskIds.foreach((Function1 & Serializable & scala.Serializable)taskId -> {
            this.scheduleTaskUpdate(taskId, new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
            return BoxedUnit.UNIT;
        });
    }

    private boolean isAffectingTasks(BlackoutUpdatedEvent event, Date now) {
        Date date = event.original().getEndDate();
        Date date2 = event.updated().getEndDate();
        boolean endDateChanged = date == null ? date2 != null : !((Object)date).equals(date2);
        boolean startDateMovedIntoFuture = now.after(event.original().getStartDate()) && now.before(event.updated().getStartDate());
        return endDateChanged || startDateMovedIntoFuture;
    }

    private void scheduleTaskUpdate(String taskId, ReleaseExecutionActorMessages.ExtensionCommand command) {
        this.releaseActorService().executeCommandAsync(taskId, command);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> getHandler(ActorRef self, Function0<ActorRef> sender, String releaseId) {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlackoutTaskEventHandler $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate updateScheduledStartDate = (BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate)A1;
                    String taskId = updateScheduledStartDate.taskId();
                    Date newScheduledStartDate = updateScheduledStartDate.newScheduledStartDate();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$1(this, newScheduledStartDate, x$1);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate resetScheduledStartDate = (BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate)A1;
                    String taskId = resetScheduledStartDate.taskId();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable & scala.Serializable)task -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$2(this, task);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate ? true : object instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate;
                return bl;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$getHandler$1 $this, Date newScheduledStartDate$2, Task x$1) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(x$1, newScheduledStartDate$2);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2($anonfun$getHandler$1 $this, Task task) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(task);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 java.util.Date com.xebialabs.xlrelease.domain.Task ), $anonfun$applyOrElse$2$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 com.xebialabs.xlrelease.domain.Task )}, serializedLambda);
            }
        };
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(String taskId, Function1<Task, BoxedUnit> updater) {
        Object task = this.taskRepository().findById(taskId);
        Task original = (Task)CiCloneHelper.cloneCi(task);
        updater.apply(task);
        this.taskRepository().update((Task)task);
        this.eventBus().publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(Task task, Date newScheduledStartDate) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating task '", "' scheduled start date due to new blackout end date '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task.getId(), newScheduledStartDate})));
        Date originalScheduledStartDate = task.getOriginalScheduledStartDate();
        task.setScheduledStartDate(newScheduledStartDate);
        task.setPostponedDueToBlackout(true);
        task.setOriginalScheduledStartDate(originalScheduledStartDate);
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(Task task) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resetting task '", "' scheduled start date due to blackout not being applicable anymore."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task.getId()})));
        task.setScheduledStartDate(task.getOriginalScheduledStartDate());
        task.setPostponedDueToBlackout(false);
    }

    @Override
    public boolean supports(Class<? extends Actor> clazz) {
        return ReleaseExecutionActor.class.isAssignableFrom(clazz);
    }

    @Autowired
    public BlackoutTaskEventHandler(EventBus eventBus, ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.eventBus = eventBus;
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        ActorExtensionHandlerFactory.$init$(this);
        Logging.$init$((Logging)this);
    }
}

