/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0001\u0003\u0001-\u0011\u0011\u0003\u0015:f\u0003J\u001c\u0007.\u001b<f'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0012\u0001C4sSjTH.\u001a3\n\u0005e!\"a\u0002'pO\u001eLgn\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005\u0001\u0012M]2iSZLgnZ*feZL7-\u001a\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\n\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\t\u0019c%D\u0001%\u0015\t)C!\u0001\u0006sKB|7/\u001b;pefL!a\n\u0013\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003=\t'o\u00195jm&twmQ8oM&<\u0007CA\u0016/\u001b\u0005a#BA\u0017\u0005\u0003\u0019\u0019wN\u001c4jO&\u0011q\u0006\f\u0002\u0019\u0003J\u001c\u0007.\u001b<j]\u001e\u001cV\r\u001e;j]\u001e\u001cX*\u00198bO\u0016\u0014\b\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\b\u0006\u00034iU2\u0004CA\u000f\u0001\u0011\u0015Y\u0002\u00071\u0001\u001d\u0011\u0015\t\u0003\u00071\u0001#\u0011\u0015I\u0003\u00071\u0001+\u0011!A\u0004\u0001#b\u0001\n\u0013I\u0014\u0001\u00029p_2,\u0012A\u000f\t\u0003w\tk\u0011\u0001\u0010\u0006\u0003{y\n!bY8oGV\u0014(/\u001a8u\u0015\ty\u0004)\u0001\u0003vi&d'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007r\u0012\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u001d)\u0005\u00011A\u0005\n\u0019\u000bq!\u001a8bE2,G-F\u0001H!\ti\u0001*\u0003\u0002J\u001d\t9!i\\8mK\u0006t\u0007bB&\u0001\u0001\u0004%I\u0001T\u0001\fK:\f'\r\\3e?\u0012*\u0017\u000f\u0006\u0002N!B\u0011QBT\u0005\u0003\u001f:\u0011A!\u00168ji\"9\u0011KSA\u0001\u0002\u00049\u0015a\u0001=%c!11\u000b\u0001Q!\n\u001d\u000b\u0001\"\u001a8bE2,G\r\t\u0005\b+\u0002\u0001\r\u0011\"\u0003G\u0003)\u0019\u0017\r^2iS:<W\u000b\u001d\u0005\b/\u0002\u0001\r\u0011\"\u0003Y\u00039\u0019\u0017\r^2iS:<W\u000b]0%KF$\"!T-\t\u000fE3\u0016\u0011!a\u0001\u000f\"11\f\u0001Q!\n\u001d\u000b1bY1uG\"LgnZ+qA!)Q\f\u0001C\u0001\r\u0006I\u0011n]#oC\ndW\r\u001a\u0005\u0006?\u0002!\t\u0001Y\u0001\u0006gR\f'\u000f\u001e\u000b\u0002\u001b\")!\r\u0001C\u0001G\u0006Q\u0002O]3Be\u000eD\u0017N^3D_6\u0004H.\u001a;fIJ+G.Z1tKR\u0011Q\n\u001a\u0005\u0006K\u0006\u0004\rAZ\u0001\u0006KZ,g\u000e\u001e\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\fa!\u001a<f]R\u001c(BA6\u0005\u0003\u0019!w.\\1j]&\u0011Q\u000e\u001b\u0002\u0016%\u0016dW-Y:f\u0007>l\u0007\u000f\\3uK\u0012,e/\u001a8uQ\t\tw\u000e\u0005\u0002qe6\t\u0011O\u0003\u0002j\t%\u00111/\u001d\u0002\n'V\u00147o\u0019:jE\u0016DQ!\u001e\u0001\u0005\u0002Y\f\u0001\u0004\u001d:f\u0003J\u001c\u0007.\u001b<f\u0003\n|'\u000f^3e%\u0016dW-Y:f)\tiu\u000fC\u0003fi\u0002\u0007\u0001\u0010\u0005\u0002hs&\u0011!\u0010\u001b\u0002\u0014%\u0016dW-Y:f\u0003\n|'\u000f^3e\u000bZ,g\u000e\u001e\u0015\u0003i>DQ! \u0001\u0005\u0012y\f!\u0002\u001d:f\u0003J\u001c\u0007.\u001b<f)\u0011iu0a\u0003\t\u000f\u0005\u0005A\u00101\u0001\u0002\u0004\u00059!/\u001a7fCN,\u0007\u0003BA\u0003\u0003\u000fi\u0011A[\u0005\u0004\u0003\u0013Q'a\u0002*fY\u0016\f7/\u001a\u0005\t\u0003\u001ba\b\u0013!a\u0001\u000f\u0006a1\r[3dW\u0016s\u0017M\u00197fI\"\u001aA0!\u0005\u0011\t\u0005M\u0011\u0011E\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005m\u0011QD\u0001\b[\u0016$(/[2t\u0015\r\ty\u0002C\u0001\tG>$\u0017\r[1mK&!\u00111EA\u000b\u0005\u0015!\u0016.\\3e\u0011\u0019\t9\u0003\u0001C\tA\u00061\u0003O]3Be\u000eD\u0017N^3J]\u0006\u001cG/\u001b<f%\u0016dW-Y:fg&s')Y2lOJ|WO\u001c3\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\u0005Q\u0002O]3Be\u000eD\u0017N^3J]\u0006\u001cG/\u001b<f%\u0016dW-Y:fgR\u0019Q*a\f\t\u0015\u0005E\u0012\u0011\u0006I\u0001\u0002\u0004\t\u0019$\u0001\u0003qC\u001e,\u0007cA\u0007\u00026%\u0019\u0011q\u0007\b\u0003\u0007%sG\u000f\u000b\u0003\u0002*\u0005m\u0002\u0003BA\u001f\u0003\u0003j!!a\u0010\u000b\u0007\u0005]a\"\u0003\u0003\u0002D\u0005}\"a\u0002;bS2\u0014Xm\u0019\u0005\b\u0003\u000f\u0002A\u0011BA%\u0003=\u0019XOY7ji^KG\u000f\u001b#fY\u0006LH\u0003BA&\u0003/\"2!TA'\u0011!\ty%!\u0012A\u0002\u0005E\u0013a\u00016pEB!Q\"a\u0015N\u0013\r\t)F\u0004\u0002\n\rVt7\r^5p]BB\u0001\"!\u0017\u0002F\u0001\u0007\u00111L\u0001\u0006I\u0016d\u0017-\u001f\t\u0005\u0003;\n)'\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003!!WO]1uS>t'BA\u001f\u000f\u0013\u0011\t9'a\u0018\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"9\u00111\u000e\u0001\u0005\n\u00055\u0014AB:vE6LG/\u0006\u0003\u0002p\u0005eDcA'\u0002r!A\u0011qJA5\u0001\u0004\t\u0019\bE\u0003\u000e\u0003'\n)\b\u0005\u0003\u0002x\u0005eD\u0002\u0001\u0003\t\u0003w\nIG1\u0001\u0002~\t\tQ+\u0005\u0003\u0002\u0000\u0005\u0015\u0005cA\u0007\u0002\u0002&\u0019\u00111\u0011\b\u0003\u000f9{G\u000f[5oOB\u0019Q\"a\"\n\u0007\u0005%eBA\u0002B]fDq!!$\u0001\t\u0013\ty)\u0001\u0005sk:t\u0017M\u00197f+\u0011\t\t*a*\u0015\t\u0005M\u0015q\u0014\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014!\u0002\t1\fgnZ\u0005\u0005\u0003;\u000b9J\u0001\u0005Sk:t\u0017M\u00197f\u0011!\t\t+a#A\u0002\u0005\r\u0016\u0001\u00022pIf\u0004R!DA*\u0003K\u0003B!a\u001e\u0002(\u0012A\u00111PAF\u0005\u0004\ti\bC\u0005\u0002,\u0002\t\n\u0011\"\u0003\u0002.\u0006!\u0003O]3Be\u000eD\u0017N^3J]\u0006\u001cG/\u001b<f%\u0016dW-Y:fg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00020*\"\u00111GAYW\t\t\u0019\f\u0005\u0003\u00026\u0006mVBAA\\\u0015\u0011\tI,a\u0010\u0002\u0013Ut7\r[3dW\u0016$\u0017\u0002BA_\u0003o\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\t\rAI\u0001\n#\t\u0019-\u0001\u000bqe\u0016\f%o\u00195jm\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000bT3aRAYQ\r\u0001\u0011\u0011\u001a\t\u0004a\u0006-\u0017bAAgc\niQI^3oi2K7\u000f^3oKJD3\u0001AAi!\u0011\t\u0019.!9\u000e\u0005\u0005U'\u0002BAl\u00033\f!b\u001d;fe\u0016|G/\u001f9f\u0015\u0011\tY.!8\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!a8\u0002\u0007=\u0014x-\u0003\u0003\u0002d\u0006U'aB*feZL7-\u001a")
public class PreArchiveService
implements Logging {
    private ScheduledExecutorService pool;
    private final ArchivingService archivingService;
    private final ReleaseRepository releaseRepository;
    private final ArchivingSettingsManager archivingConfig;
    private boolean enabled;
    private boolean catchingUp;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile byte bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private ScheduledExecutorService pool$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.pool = Executors.newScheduledThreadPool(4, new PrefixedThreadFactory("pre-archiving", Predef$.MODULE$.boolean2Boolean(true)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.pool;
    }

    private ScheduledExecutorService pool() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.pool$lzycompute() : this.pool;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private boolean catchingUp() {
        return this.catchingUp;
    }

    private void catchingUp_$eq(boolean x$1) {
        this.catchingUp = x$1;
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public void start() {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "PreArchiveService is starting...");
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "Setting preArchivingEnabled callback...");
        this.archivingConfig.subscribeToPreArchivingEnabledChanges(becomesEnabled -> {
            PreArchiveService preArchiveService = this;
            synchronized (preArchiveService) {
                if (Predef$.MODULE$.Boolean2boolean(becomesEnabled)) {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "disabled -> enabled");
                    this.enabled_$eq(true);
                    this.preArchiveInactiveReleasesInBackground();
                } else {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "enabled -> disabled");
                    this.enabled_$eq(false);
                }
            }
        });
        this.enabled_$eq(this.archivingConfig.getPreArchivingEnabled());
        if (this.enabled()) {
            this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
        }
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "PreArchiveService started.");
    }

    @Subscribe
    public void preArchiveCompletedRelease(ReleaseCompletedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2());
    }

    @Subscribe
    public void preArchiveAbortedRelease(ReleaseAbortedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2());
    }

    @Timed
    public void preArchive(Release release, boolean checkEnabled) {
        if (!checkEnabled || this.enabled() && !this.catchingUp()) {
            FiniteDuration delay = release.isTutorial() ? new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds() : new package.DurationInt(package$.MODULE$.DurationInt(0)).seconds();
            this.submitWithDelay(delay, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                try {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pre-archiving ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release})));
                    $this.archivingService.preArchiveRelease(release);
                    this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pre-archived ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release})));
                }
                catch (Exception e) {
                    this.logger().warn((Function0 & Serializable & scala.Serializable)() -> e);
                }
            });
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pre-archiving is disabled"})).s((Seq)Nil$.MODULE$));
        }
    }

    public boolean preArchive$default$2() {
        return true;
    }

    public synchronized void preArchiveInactiveReleasesInBackground() {
        block0: {
            if (this.catchingUp()) break block0;
            this.catchingUp_$eq(true);
            this.submit((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
                this.catchingUp_$eq(false);
            });
        }
    }

    private void preArchiveInactiveReleases(int page) {
        while (true) {
            Integer pageSize = this.archivingConfig.getSearchPageSize();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching page ", " (", " releases) for pre-archiving..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)page), pageSize})));
            Seq<Release> found = this.releaseRepository.findPreArchivableReleases(page, Predef$.MODULE$.Integer2int(pageSize));
            found.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                this.preArchive(x$1, false);
                return BoxedUnit.UNIT;
            });
            if (!this.enabled() || !BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)found.size()), (Object)pageSize)) break;
            ++page;
        }
    }

    private int preArchiveInactiveReleases$default$1() {
        return 0;
    }

    private void submitWithDelay(FiniteDuration delay, Function0<BoxedUnit> job) {
        this.pool().schedule(this.runnable(job), delay.toSeconds(), TimeUnit.SECONDS);
    }

    private <U> void submit(Function0<U> job) {
        this.pool().submit(this.runnable(job));
    }

    private <U> Runnable runnable(Function0<U> body) {
        return () -> body.apply();
    }

    public PreArchiveService(ArchivingService archivingService, ReleaseRepository releaseRepository, ArchivingSettingsManager archivingConfig) {
        this.archivingService = archivingService;
        this.releaseRepository = releaseRepository;
        this.archivingConfig = archivingConfig;
        Logging.$init$((Logging)this);
        this.enabled = false;
        this.catchingUp = false;
    }
}

