/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.configuration.CustomLogoSettings;
import com.xebialabs.xlrelease.configuration.PollingSettings;
import com.xebialabs.xlrelease.configuration.ThemeColor;
import com.xebialabs.xlrelease.configuration.ThemeColors$;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u0001-\u0011AcQ8oM&<WO]1uS>t7+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012!B:mMRR'\"A\f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0007\u000b\u0003\u000f1{wmZ5oO\"A1\u0004\u0001B\u0001B\u0003%A$A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004B\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0011\u001f\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003!)g/\u001a8u\u0005V\u001c\bCA\u0013)\u001b\u00051#BA\u0014\u0005\u0003\u0019)g/\u001a8ug&\u0011\u0011F\n\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\b\"B\u0016\u0001\t\u0003a\u0013A\u0002\u001fj]&$h\bF\u0002._A\u0002\"A\f\u0001\u000e\u0003\tAQa\u0007\u0016A\u0002qAQa\t\u0016A\u0002\u0011BQA\r\u0001\u0005\u0002M\nab\u0019:fCR,wJ]+qI\u0006$X\rF\u00025u\u001d\u0003\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0003\u0002\r\u0011|W.Y5o\u0013\tIdGA\tCCN,7i\u001c8gS\u001e,(/\u0019;j_:DQaO\u0019A\u0002q\n!!\u001b3\u0011\u0005u\"eB\u0001 C!\tyd\"D\u0001A\u0015\t\t%\"\u0001\u0004=e>|GOP\u0005\u0003\u0007:\ta\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111I\u0004\u0005\u0006\u0011F\u0002\r\u0001N\u0001\u0012G>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007FA\u0019K!\tY%+D\u0001M\u0015\tie*\u0001\u0006b]:|G/\u0019;j_:T!a\u0014)\u0002\u000f5,GO]5dg*\u0011\u0011\u000bC\u0001\tG>$\u0017\r[1mK&\u00111\u000b\u0014\u0002\u0006)&lW\r\u001a\u0005\u0006e\u0001!\t!\u0016\u000b\u0003-f\u0003\"!D,\n\u0005as!\u0001B+oSRDQA\u0017+A\u0002Q\nQbY8oM&<WO]1uS>t\u0007F\u0001+K\u0011\u0015i\u0006\u0001\"\u0001_\u0003\u0011\u0011X-\u00193\u0015\u0005Qz\u0006\"B\u001e]\u0001\u0004a\u0004\"B1\u0001\t\u0003\u0011\u0017A\u00023fY\u0016$X\r\u0006\u0002WG\")1\b\u0019a\u0001y!\u0012\u0001M\u0013\u0005\u0006M\u0002!\taZ\u0001\u0011O\u0016$H\u000b[3nKN+G\u000f^5oON,\u0012\u0001\u001b\t\u0003S.l\u0011A\u001b\u0006\u00035\u0012I!\u0001\u001c6\u0003\u001bQCW-\\3TKR$\u0018N\\4tQ\t)'\nC\u0003p\u0001\u0011%\u0001/\u0001\fd_:4XM\u001d;D_2|'OT1nKR{7i\u001c3f)\tA\u0017\u000fC\u0003s]\u0002\u0007\u0001.A\u0007uQ\u0016lWmU3ui&twm\u001d\u0005\u0006i\u0002!\t!^\u0001\u000fg\u00064XmQ;ti>lGj\\4p)\t1\u0018\u0010\u0005\u0002jo&\u0011\u0001P\u001b\u0002\u0013\u0007V\u001cHo\\7M_\u001e|7+\u001a;uS:<7\u000fC\u0003{g\u0002\u0007a/\u0001\ndkN$x.\u001c'pO>\u001cV\r\u001e;j]\u001e\u001c\bFA:KQ\t\u0001Q\u0010E\u0002\u007f\u0003\u0017i\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!!\u0002\u0002\b\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\n\u0005\u0019qN]4\n\u0007\u00055qPA\u0004TKJ4\u0018nY3")
public class ConfigurationService
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ConfigurationService configurationService = this;
        synchronized (configurationService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public BaseConfiguration createOrUpdate(String id, BaseConfiguration configurationItem) {
        BaseConfiguration baseConfiguration = configurationItem;
        if (baseConfiguration instanceof ArchivingSettings) {
            ArchivingSettings archivingSettings = (ArchivingSettings)baseConfiguration;
            Predef$.MODULE$.require(Predef$.MODULE$.Integer2int(archivingSettings.getReleaseAgeToDeleteFromJcr()) >= 0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof PollingSettings) {
            PollingSettings pollingSettings = (PollingSettings)baseConfiguration;
            Predef$.MODULE$.require(Predef$.MODULE$.Integer2int(pollingSettings.getPollingInterval()) > 0, (Function0 & Serializable & scala.Serializable)() -> "Polling interval must be greater than 0 seconds.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof ThemeSettings) {
            ThemeSettings themeSettings = (ThemeSettings)baseConfiguration;
            themeSettings.setHeaderAccentColor(((Enum)ThemeColors$.MODULE$.themeColorFromCode().apply((Object)themeSettings.getHeaderAccentColor().toUpperCase())).name());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        configurationItem.setId(id);
        this.createOrUpdate(configurationItem);
        return this.read(id);
    }

    @Timed
    public void createOrUpdate(BaseConfiguration configuration) {
        if (!Ids.isNullId((String)configuration.getId()) && this.configurationRepository.exists(configuration.getId())) {
            this.configurationRepository.update(configuration);
            this.eventBus.publish((XLReleaseEvent)new ConfigurationUpdatedEvent(configuration));
        } else {
            this.configurationRepository.create(configuration);
            this.eventBus.publish((XLReleaseEvent)new ConfigurationCreatedEvent(configuration));
        }
    }

    public BaseConfiguration read(String id) {
        Object object;
        Object baseConfiguration = this.configurationRepository.read(id);
        Object t = baseConfiguration;
        if (t instanceof ThemeSettings) {
            ThemeSettings themeSettings = (ThemeSettings)((Object)t);
            object = this.convertColorNameToCode(themeSettings);
        } else {
            object = t;
        }
        return object;
    }

    @Timed
    public void delete(String id) {
        Object conf = this.configurationRepository.read(id);
        this.configurationRepository.delete(id);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationDeletedEvent(conf));
    }

    @Timed
    public ThemeSettings getThemeSettings() {
        ThemeSettings themeSettings = this.configurationRepository.getThemeSettings();
        return this.convertColorNameToCode(themeSettings);
    }

    private ThemeSettings convertColorNameToCode(ThemeSettings themeSettings) {
        themeSettings.setHeaderAccentColor(ThemeColors$.MODULE$.colorCode(ThemeColor.valueOf((String)themeSettings.getHeaderAccentColor().toUpperCase())));
        return themeSettings;
    }

    @Timed
    public CustomLogoSettings saveCustomLogo(CustomLogoSettings customLogoSettings) {
        customLogoSettings.validateContentType();
        return (CustomLogoSettings)this.createOrUpdate("Configuration/settings/CustomLogoSettings", customLogoSettings);
    }

    public ConfigurationService(ConfigurationRepository configurationRepository, XLReleaseEventBus eventBus) {
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

