/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.CommentBuilder;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CommentUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.CommentServiceHelper;
import com.xebialabs.xlrelease.user.User;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CommentService {
    public static final String COMMENT_PREFIX_SCRIPT = String.format("This comment was too long and has been cut off at the end. See the `script_output.log` attachment for the full log.%n%n---%n%n", new Object[0]);
    public static final String COMMENT_PREFIX_MANUAL = String.format("This comment was too long and has been cut off at the end.%n%n---%n%n", new Object[0]);
    public static final String COMMENT_SUFFIX = String.format("%n%n---%n%n[...truncated...]", new Object[0]);
    private static final Logger logger = LoggerFactory.getLogger(CommentService.class);
    private CiIdService ciIdService;
    private TaskRepository taskRepository;
    private XLReleaseEventBus eventBus;
    private CommentRepository commentRepository;

    @Autowired
    public CommentService(CiIdService ciIdService, TaskRepository taskRepository, XLReleaseEventBus eventBus, CommentRepository commentRepository) {
        this.ciIdService = ciIdService;
        this.taskRepository = taskRepository;
        this.eventBus = eventBus;
        this.commentRepository = commentRepository;
    }

    @Timed
    public Comment create(String taskId, String text, User author, boolean notify) {
        Object task = this.taskRepository.findById(taskId);
        return this.create((Task)task, text, author, notify);
    }

    @Timed
    public Comment create(Task task, String text, User author, boolean notify) {
        return this.createComment(task, text, author, notify, COMMENT_PREFIX_MANUAL, COMMENT_SUFFIX);
    }

    @Timed
    public Comment update(String commentId, String text) {
        Comment comment = this.commentRepository.findById(commentId);
        Comment original = CiCloneHelper.cloneCi(comment);
        String taskId = Ids.getParentId((String)commentId);
        Object task = this.taskRepository.findById(taskId);
        int maxCommentSize = task.getMaxCommentSize();
        if (!text.equals(comment.getText())) {
            CommentServiceHelper.updateCommentText((Comment)comment, (String)text, (int)maxCommentSize, (String)COMMENT_PREFIX_MANUAL, (String)COMMENT_SUFFIX);
            task.updateComment(original, comment);
            this.commentRepository.update(comment.getId(), comment.getText());
            this.eventBus.publish((XLReleaseEvent)new CommentUpdatedEvent(task, original, comment));
        }
        return comment;
    }

    @Timed
    public String appendComment(String taskId, String commentId, String commentText) {
        String updatedCommentId = commentId;
        try {
            Object task = this.taskRepository.findById(taskId);
            int maxCommentSize = task.getMaxCommentSize();
            if (Strings.isBlank((String)updatedCommentId)) {
                Comment comment = this.createComment((Task)task, commentText, User.LOG_OUTPUT, false, COMMENT_PREFIX_SCRIPT, COMMENT_SUFFIX);
                updatedCommentId = comment.getId();
            } else {
                Comment comment = this.commentRepository.findById(updatedCommentId);
                Comment original = CiCloneHelper.cloneCi(comment);
                CommentServiceHelper.appendCommentText((Comment)comment, (String)commentText, (int)maxCommentSize, (String)COMMENT_PREFIX_SCRIPT, (String)COMMENT_SUFFIX);
                task.updateComment(original, comment);
                this.commentRepository.update(comment.getId(), comment.getText());
            }
        }
        catch (Exception exception) {
            logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)exception);
        }
        return updatedCommentId;
    }

    @Timed
    public Comment create(Task task, Comment comment) {
        task.getComments().add(comment);
        logger.debug("Creating comment: {}", (Object)comment);
        this.commentRepository.create(comment);
        return comment;
    }

    private Comment createComment(Task task, String commentText, User author, boolean notify, String prefix, String suffix) {
        Comment comment = this.buildComment(task, commentText, author, new Date(), prefix, suffix);
        task.getComments().add(comment);
        logger.debug("Creating comment: {}", (Object)comment);
        this.commentRepository.create(comment);
        this.eventBus.publish((XLReleaseEvent)new CommentCreatedEvent(task, comment, author.getName(), notify));
        return comment;
    }

    public Comment buildComment(Task task, String commentText, User author, Date creationDate, String prefix, String suffix) {
        int maxCommentSize = task.getMaxCommentSize();
        Comment comment = CommentBuilder.newComment().withId(this.ciIdService.getUniqueId(Type.valueOf(Comment.class), task.getId())).withCreationDate(creationDate).withLimit(task.getMaxCommentSize()).withAuthor(author == User.SYSTEM ? null : author.getName()).build();
        CommentServiceHelper.appendCommentText((Comment)comment, (String)commentText, (int)maxCommentSize, (String)prefix, (String)suffix);
        return comment;
    }

    public void decorate(Task task) {
        this.commentRepository.decorate(task);
    }
}

