/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0001\r]w!B\u0001\u0003\u0011\u0003Y\u0011\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qB\u0001\tBe\u000eD\u0017N^5oON+'O^5dKN\u0019Q\u0002\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9B$D\u0001\u0019\u0015\tI\"$A\u0003tY\u001a$$NC\u0001\u001c\u0003!9'/\u001b>{Y\u0016$\u0017BA\u000f\u0019\u0005\u001daunZ4j]\u001eDQaH\u0007\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0006\t\u000b\tjA\u0011A\u0012\u00025\u0011,7/\u001a:jC2L'0Z!sG\"Lg/\u001a3SK2,\u0017m]3\u0015\u0007\u0011Rs\u0007\u0005\u0002&Q5\taE\u0003\u0002(\t\u00051Am\\7bS:L!!\u000b\u0014\u0003\u000fI+G.Z1tK\")1&\ta\u0001Y\u0005Y!/\u001a7fCN,'j]8o!\tiCG\u0004\u0002/eA\u0011qFE\u0007\u0002a)\u0011\u0011GC\u0001\u0007yI|w\u000e\u001e \n\u0005M\u0012\u0012A\u0002)sK\u0012,g-\u0003\u00026m\t11\u000b\u001e:j]\u001eT!a\r\n\t\u000ba\n\u0003\u0019A\u001d\u0002\u0015I,\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002;}5\t1H\u0003\u00029y)\u0011QHB\u0001\tI\u0016\u0004Hn\\=ji&\u0011qh\u000f\u0002\u0012%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b\"B!\u000e\t\u0003\u0011\u0015\u0001D4fi6{g\u000e\u001e5ZK\u0006\u0014HC\u0001\u0017D\u0011\u0015!\u0005\t1\u0001F\u0003%\u0019H/\u0019:u\t\u0006$X\r\u0005\u0002G\u001b6\tqI\u0003\u0002I\u0013\u0006!A/[7f\u0015\tQ5*\u0001\u0003k_\u0012\f'\"\u0001'\u0002\u0007=\u0014x-\u0003\u0002O\u000f\nAA)\u0019;f)&lWM\u0002\u0003\u000f\u0005\u0001\u00016cA(\u0011-!A!k\u0014BC\u0002\u0013\u00051+\u0001\tbe\u000eD\u0017N^3e%\u0016dW-Y:fgV\tA\u000b\u0005\u0002V16\taK\u0003\u0002X\t\u0005\u0011AMY\u0005\u00033Z\u0013\u0001#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:\t\u0011m{%\u0011!Q\u0001\nQ\u000b\u0011#\u0019:dQ&4X\r\u001a*fY\u0016\f7/Z:!\u0011!ivJ!A!\u0002\u0013q\u0016AF1sG\"Lg/\u001a3SK2,\u0017m]3t'\u0016\f'o\u00195\u0011\u0005U{\u0016B\u00011W\u0005Y\t%o\u00195jm\u0016$'+\u001a7fCN,7oU3be\u000eD\u0007\u0002\u00032P\u0005\u0003\u0005\u000b\u0011B2\u0002=\u0005\u00148\r[5wK\u0012\f5\r^5wSRLHj\\4t'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u0001\u0007e\u0013\t)'A\u0001\u0010Be\u000eD\u0017N^3e\u0003\u000e$\u0018N^5us2{wm]*fe&\fG.\u001b>fe\"Aqm\u0014B\u0001B\u0003%\u0011(A\tsKB|7/\u001b;pef\fE-\u00199uKJD\u0001\"[(\u0003\u0002\u0003\u0006IA[\u0001\u001fG>l\u0007\u000f\\3uK\u0012\u0014V\r\\3bg\u0016\u001cX\t\u001f9peR\u001cVM\u001d<jG\u0016\u0004\"\u0001D6\n\u00051\u0014!!H\"p[BdW\r^3e%\u0016dW-Y:f\u000bb\u0004xN\u001d;TKJ4\u0018nY3\t\u00119|%\u0011!Q\u0001\n=\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\t\u0001(/D\u0001r\u0015\tAD!\u0003\u0002tc\n\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\t\u0011U|%\u0011!Q\u0001\nY\fA\u0003Z3qK:$WM\\2z%\u0016\u0004xn]5u_JL\bC\u00019x\u0013\tA\u0018O\u0001\u000bEKB,g\u000eZ3oGf\u0014V\r]8tSR|'/\u001f\u0005\tu>\u0013\t\u0011)A\u0005w\u0006\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKB\u0011Ap`\u0007\u0002{*\u0011a\u0010B\u0001\u0007C\u000e$xN]:\n\u0007\u0005\u0005QPA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0003\u0006\u0002\u0006=\u0013\t\u0011)A\u0005\u0003\u000f\ta\u0002^3b[J+\u0007o\\:ji>\u0014\u0018\u0010E\u0002q\u0003\u0013I1!a\u0003r\u00059!V-Y7SKB|7/\u001b;pefD!\"a\u0004P\u0005\u0003\u0005\u000b\u0011BA\t\u0003)\u0019XmY;sK\u0012\u001c\u0015n\u001d\t\u0004a\u0006M\u0011bAA\u000bc\nQ1+Z2ve\u0016$7)[:\t\u0015\u0005eqJ!A!\u0002\u0013\tY\"A\u000esK2,\u0017m]3FqR,gn]5p]N\u0014V\r]8tSR|'/\u001f\t\u0004a\u0006u\u0011bAA\u0010c\nY\"+\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pefD!\"a\tP\u0005\u0003\u0005\u000b\u0011BA\u0013\u00039\u0019w.\\7f]R\u001cVM\u001d<jG\u0016\u00042\u0001DA\u0014\u0013\r\tIC\u0001\u0002\u000f\u0007>lW.\u001a8u'\u0016\u0014h/[2f\u0011\u0019yr\n\"\u0001\u0002.QQ\u0012qFA\u0019\u0003g\t)$a\u000e\u0002:\u0005m\u0012QHA \u0003\u0003\n\u0019%!\u0012\u0002HA\u0011Ab\u0014\u0005\u0007%\u0006-\u0002\u0019\u0001+\t\ru\u000bY\u00031\u0001_\u0011\u0019\u0011\u00171\u0006a\u0001G\"1q-a\u000bA\u0002eBa![A\u0016\u0001\u0004Q\u0007B\u00028\u0002,\u0001\u0007q\u000e\u0003\u0004v\u0003W\u0001\rA\u001e\u0005\u0007u\u0006-\u0002\u0019A>\t\u0011\u0005\u0015\u00111\u0006a\u0001\u0003\u000fA\u0001\"a\u0004\u0002,\u0001\u0007\u0011\u0011\u0003\u0005\t\u00033\tY\u00031\u0001\u0002\u001c!A\u00111EA\u0016\u0001\u0004\t)\u0003\u000b\u0003\u0002,\u0005-\u0003\u0003BA'\u0003?j!!a\u0014\u000b\t\u0005E\u00131K\u0001\u000bC:tw\u000e^1uS>t'\u0002BA+\u0003/\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002Z\u0005m\u0013!\u00022fC:\u001c(bAA/\u0017\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0003\u0002b\u0005=#!C!vi><\u0018N]3e\u0011\u001d\t)g\u0014C\u0001\u0003O\na\"\u0019:dQ&4XMU3mK\u0006\u001cX\r\u0006\u0003\u0002j\u0005=\u0004cA\t\u0002l%\u0019\u0011Q\u000e\n\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003c\n\u0019\u00071\u0001-\u0003%\u0011X\r\\3bg\u0016LE\r\u000b\u0003\u0002d\u0005U\u0004\u0003BA<\u0003\u0007k!!!\u001f\u000b\t\u0005E\u00131\u0010\u0006\u0005\u0003{\ny(A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005\u0005\u0005\"\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t))!\u001f\u0003\u000bQKW.\u001a3\t\u000f\u0005%u\n\"\u0003\u0002\f\u0006\u0011\u0012M]2iSZ,\u0017\t\u001e;bG\"lWM\u001c;t)\u0011\tI'!$\t\u000f\u0005=\u0015q\u0011a\u0001I\u00059!/\u001a7fCN,\u0007bBAJ\u001f\u0012%\u0011QS\u0001\u0014CJ\u001c\u0007.\u001b<f\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0005\u0003S\n9\nC\u0004\u0002\u0010\u0006E\u0005\u0019\u0001\u0013\t\u000f\u0005mu\n\"\u0001\u0002\u001e\u0006\t\u0002O]3Be\u000eD\u0017N^3SK2,\u0017m]3\u0015\t\u0005%\u0014q\u0014\u0005\b\u0003\u001f\u000bI\n1\u0001%Q\u0011\tI*!\u001e\t\u000f\u0005\u0015v\n\"\u0001\u0002(\u0006Qq-\u001a;SK2,\u0017m]3\u0015\u0007\u0011\nI\u000bC\u0004\u0002r\u0005\r\u0006\u0019\u0001\u0017\t\u000f\u0005\u0015v\n\"\u0001\u0002.R)A%a,\u00022\"9\u0011\u0011OAV\u0001\u0004a\u0003\u0002CAZ\u0003W\u0003\r!!.\u0002%%t7\r\\;eKB\u0013X-\u0011:dQ&4X\r\u001a\t\u0004#\u0005]\u0016bAA]%\t9!i\\8mK\u0006t\u0007\u0006BAV\u0003kBq!a0P\t\u0003\t\t-A\bhKR\u0014V\r\\3bg\u0016$\u0016\u000e\u001e7f)\ra\u00131\u0019\u0005\b\u0003c\ni\f1\u0001-Q\u0011\ti,!\u001e\t\u000f\u0005%w\n\"\u0001\u0002L\u0006Aq-\u001a;QQ\u0006\u001cX\r\u0006\u0003\u0002N\u0006M\u0007cA\u0013\u0002P&\u0019\u0011\u0011\u001b\u0014\u0003\u000bAC\u0017m]3\t\u000f\u0005U\u0017q\u0019a\u0001Y\u00059\u0001\u000f[1tK&#\u0007\u0006BAd\u0003kBq!a7P\t\u0003\ti.A\u0004hKR$\u0016m]6\u0015\t\u0005}\u0017Q\u001d\t\u0004K\u0005\u0005\u0018bAArM\t!A+Y:l\u0011\u001d\t9/!7A\u00021\na\u0001^1tW&#\u0007\u0006BAm\u0003kBq!!<P\t\u0003\ty/A\u0006hKR4\u0016M]5bE2,G\u0003BAy\u0003{\u0004B!a=\u0002z6\u0011\u0011Q\u001f\u0006\u0004\u0003o4\u0013!\u0003<be&\f'\r\\3t\u0013\u0011\tY0!>\u0003\u0011Y\u000b'/[1cY\u0016Dq!a@\u0002l\u0002\u0007A&\u0001\u0006wCJL\u0017M\u00197f\u0013\u0012DC!a;\u0002v!9!QA(\u0005\u0002\t\u001d\u0011AB3ySN$8\u000f\u0006\u0003\u00026\n%\u0001b\u0002B\u0006\u0005\u0007\u0001\r\u0001L\u0001\u0005G&LE\r\u000b\u0003\u0003\u0004\u0005U\u0004b\u0002B\t\u001f\u0012\u0005!1C\u0001\u0012KbL7\u000f^:Qe\u0016\f%o\u00195jm\u0016$G\u0003BA[\u0005+AqAa\u0003\u0003\u0010\u0001\u0007A\u0006\u000b\u0003\u0003\u0010\u0005U\u0004b\u0002B\u000e\u001f\u0012\u0005!QD\u0001\rKbL7\u000f^:Cs:\u000bW.\u001a\u000b\u0005\u0003k\u0013y\u0002C\u0004\u0003\"\te\u0001\u0019\u0001\u0017\u0002\u0017I,G.Z1tK:\u000bW.\u001a\u0015\u0005\u00053\t)\bC\u0004\u0003(=#\tA!\u000b\u0002!\rDWmY6O_R\f%o\u00195jm\u0016$G\u0003BA5\u0005WAqAa\u0003\u0003&\u0001\u0007A\u0006\u000b\u0003\u0003&\u0005U\u0004b\u0002B\u0019\u001f\u0012\u0005!1G\u0001\u0011CR$\u0018m\u00195nK:$X\t_5tiN$B!!.\u00036!9!q\u0007B\u0018\u0001\u0004a\u0013\u0001D1ui\u0006\u001c\u0007.\\3oi&#\u0007\u0006\u0002B\u0018\u0003kBqA!\u0010P\t\u0003\u0011y$A\u0007hKR\fE\u000f^1dQ6,g\u000e\u001e\u000b\u0005\u0005\u0003\u00129\u0005E\u0002&\u0005\u0007J1A!\u0012'\u0005)\tE\u000f^1dQ6,g\u000e\u001e\u0005\b\u0005o\u0011Y\u00041\u0001-Q\u0011\u0011Y$!\u001e\t\u000f\t5s\n\"\u0001\u0003P\u0005\u0019r-\u001a;BiR\f7\r[7f]R|\u0005\u000f^5p]R!!\u0011\u000bB,!\u0015\t\"1\u000bB!\u0013\r\u0011)F\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\t]\"1\na\u0001Y!\"!1JA;\u0011\u001d\u0011if\u0014C\u0001\u0005?\nab]3be\u000eD'+\u001a7fCN,7\u000f\u0006\u0003\u0003b\tE\u0004#\u0002B2\u0005[\"SB\u0001B3\u0015\u0011\u00119G!\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005W\nAA[1wC&!!q\u000eB3\u0005\u0011a\u0015n\u001d;\t\u0011\tM$1\fa\u0001\u0005k\nqAZ5mi\u0016\u00148\u000f\u0005\u0003\u0003x\t\u0015UB\u0001B=\u0015\u0011\u0011YH! \u0002\u000b\u0019|'/\\:\u000b\t\t}$\u0011Q\u0001\u0003mFR1Aa!\u0005\u0003\r\t\u0007/[\u0005\u0005\u0005\u000f\u0013IHA\bSK2,\u0017m]3t\r&dG/\u001a:tQ\u0011\u0011Y&!\u001e\t\u000f\tus\n\"\u0001\u0003\u000eRA!\u0011\rBH\u0005#\u0013Y\n\u0003\u0005\u0003t\t-\u0005\u0019\u0001B;\u0011!\u0011\u0019Ja#A\u0002\tU\u0015!\u00027j[&$\bcA\t\u0003\u0018&\u0019!\u0011\u0014\n\u0003\t1{gn\u001a\u0005\t\u0005;\u0013Y\t1\u0001\u0003\u0016\u00061qN\u001a4tKRDCAa#\u0002v!9!1U(\u0005\u0002\t\u0015\u0016!F2pk:$(+\u001a7fCN,7OQ=Ti\u0006$Xo\u001d\u000b\u0005\u0005O\u0013y\fE\u0004.\u0005S\u0013iK!/\n\u0007\t-fGA\u0002NCB\u0004BAa,\u000366\u0011!\u0011\u0017\u0006\u0004\u0005g3\u0013AB:uCR,8/\u0003\u0003\u00038\nE&!\u0004*fY\u0016\f7/Z*uCR,8\u000fE\u0002\u0012\u0005wK1A!0\u0013\u0005\rIe\u000e\u001e\u0005\t\u0005g\u0012\t\u000b1\u0001\u0003v!\"!\u0011UA;\u0011\u001d\u0011)m\u0014C\u0001\u0005\u000f\f\u0001DZ5oI\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u0011IMa7\u0003fB)!1\u001aBkY9!!Q\u001aBi\u001d\ry#qZ\u0005\u0002'%\u0019!1\u001b\n\u0002\u000fA\f7m[1hK&!!q\u001bBm\u0005\r\u0019V-\u001d\u0006\u0004\u0005'\u0014\u0002\u0002\u0003Bo\u0005\u0007\u0004\rAa8\u0002\t\u0011\fG/\u001a\t\u0005\u0005G\u0012\t/\u0003\u0003\u0003d\n\u0015$\u0001\u0002#bi\u0016D\u0001Ba:\u0003D\u0002\u0007!\u0011^\u0001\ta\u0006<WmU5{KB!!1\u001eBy\u001b\t\u0011iO\u0003\u0003\u0003p\n%\u0014\u0001\u00027b]\u001eLAAa=\u0003n\n9\u0011J\u001c;fO\u0016\u0014\b\u0006\u0002Bb\u0003kBqA!?P\t\u0003\u0011Y0\u0001\u0010be\u000eD\u0017N^3BY2LenY8nS:<G)\u001a9f]\u0012,gnY5fgR!\u0011\u0011\u000eB\u007f\u0011\u001d\t\tHa>A\u00021BCAa>\u0002v!911A(\u0005\u0002\r\u0015\u0011AC4fi\u0006cG\u000eV1hgR!1qAB\u0007!\u0015\u0011\u0019g!\u0003-\u0013\u0011\u0019YA!\u001a\u0003\u0007M+G\u000f\u0003\u0005\u0004\u0010\r\u0005\u0001\u0019\u0001B]\u0003-a\u0017.\\5u\u001dVl'-\u001a:)\t\r\u0005\u0011Q\u000f\u0005\b\u0005;zE\u0011BB\u000b)!\u0011\tga\u0006\u0004\u001a\ru\u0001\u0002\u0003B:\u0007'\u0001\rA!\u001e\t\u0011\tM51\u0003a\u0001\u00077\u0001R!\u0005B*\u0005+C\u0001B!(\u0004\u0014\u0001\u000711\u0004\u0005\b\u0007CyE\u0011BB\u0012\u0003A9W\r\u001e*fY\u0016\f7/Z(qi&|g\u000e\u0006\u0004\u0004&\r\u001d2\u0011\u0006\t\u0005#\tMC\u0005C\u0004\u0002r\r}\u0001\u0019\u0001\u0017\t\u0015\u0005M6q\u0004I\u0001\u0002\u0004\t)\fC\u0004\u0004.=#Iaa\f\u0002\u001d\u001d,GOU3mK\u0006\u001cX-\u0013;f[V!1\u0011GB\u001e)\u0011\u0019\u0019d!\u0017\u0015\t\rU2Q\n\t\u0006#\tM3q\u0007\t\u0005\u0007s\u0019Y\u0004\u0004\u0001\u0005\u0011\ru21\u0006b\u0001\u0007\u007f\u0011\u0011\u0001V\t\u0005\u0007\u0003\u001a9\u0005E\u0002\u0012\u0007\u0007J1a!\u0012\u0013\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!JB%\u0013\r\u0019YE\n\u0002\t!2\fg.\u0013;f[\"A1qJB\u0016\u0001\u0004\u0019\t&A\u0004hKRLE/Z7\u0011\rE\u0019\u0019\u0006JB,\u0013\r\u0019)F\u0005\u0002\n\rVt7\r^5p]F\u0002b!EB*Y\r]\u0002bBB.\u0007W\u0001\r\u0001L\u0001\u0007SR,W.\u00133\t\u000f\r}s\n\"\u0003\u0004b\u0005\tr-\u001a;WCJL\u0017M\u00197f\u001fB$\u0018n\u001c8\u0015\t\r\r4Q\r\t\u0006#\tM\u0013\u0011\u001f\u0005\b\u0003\u007f\u001ci\u00061\u0001-\u0011\u001d\u0019Ig\u0014C\u0005\u0007W\na$\u0019:dQ&4X-\u00117m\u001fV$xm\\5oO\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\r54Q\u000f\t\u0007\u0005\u0017\u0014)na\u001c\u0011\u0007\u0015\u001a\t(C\u0002\u0004t\u0019\u0012!\u0002R3qK:$WM\\2z\u0011\u001d\tyia\u001aA\u0002\u0011B\u0011b!\u001fP#\u0003%Iaa\u001f\u00025\u001d,GOU3mK\u0006\u001cXm\u00149uS>tG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\ru$\u0006BA[\u0007\u007fZ#a!!\u0011\t\r\r51R\u0007\u0003\u0007\u000bSAaa\"\u0004\n\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003#\u0012\u0012\u0002BBG\u0007\u000b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2fQMy5\u0011SBP\u0007C\u001b)ka*\u00042\u000eM6QXB`!\u0011\u0019\u0019ja'\u000e\u0005\rU%\u0002BA)\u0007/SAa!'\u0002\\\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\u0019ij!&\u0003\u001bQ\u0013\u0018M\\:bGRLwN\\1m\u0003\u00151\u0018\r\\;fC\t\u0019\u0019+A\u000esKB|'\u000f^5oOR\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM]\u0001\faJ|\u0007/Y4bi&|g\u000e\n\u0002\u0004*&!11VBW\u0003!\u0011V)U+J%\u0016#%\u0002BBX\u0007+\u000b1\u0002\u0015:pa\u0006<\u0017\r^5p]\u0006I\u0011n]8mCRLwN\u001c\u0013\u0003\u0007kKAaa.\u0004:\u0006q!+R!E?\u000e{U*T%U)\u0016#%\u0002BB^\u0007+\u000b\u0011\"S:pY\u0006$\u0018n\u001c8\u0002\u0017I|G\u000e\u001c2bG.4uN\u001d\u0017\u0003\u0007\u0003\u001c#aa1\u0011\t\t-7QY\u0005\u0005\u0007\u000f\u0014INA\u0005UQJ|w/\u00192mK\"\u001aqja3\u0011\t\r571[\u0007\u0003\u0007\u001fTAa!5\u0002\\\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\rU7q\u001a\u0002\b'\u0016\u0014h/[2f\u0001")
public class ArchivingService
implements Logging {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentService commentService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public static String getMonthYear(DateTime dateTime) {
        return ArchivingService$.MODULE$.getMonthYear(dateTime);
    }

    public static Release deserializeArchivedRelease(String string, RepositoryAdapter repositoryAdapter) {
        return ArchivingService$.MODULE$.deserializeArchivedRelease(string, repositoryAdapter);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Timed
    public void archiveRelease(String releaseId) {
        Release release = (Release)this.repositoryAdapter.read(releaseId);
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES)).contains((Object)release.getStatus())) {
            if (this.existsPreArchived(releaseId)) {
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving dependencies for '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
                this.releaseExtensionsRepository.decorate(release);
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
                    this.commentService.decorate(task);
                    return BoxedUnit.UNIT;
                });
                java.util.List<Team> updatedTeams = this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
                release.setTeams(updatedTeams);
                if (!release.isTutorial()) {
                    this.archiveAttachments(release);
                }
                this.archiveDependencies(release);
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating activity logs and releaseJson for '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
                String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
                String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
                if (!this.archivedReleases().update(releaseId, serializedRelease, activityLogsJson, false)) {
                    this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"could not update ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
                } else {
                    this.archivedReleases().updateViewers(releaseId, (Seq<Team>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(updatedTeams).asScala()));
                }
                if (this.releaseRepository.exists(releaseId)) {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting '", "' from active database"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
                    this.releaseRepository.delete(releaseId);
                }
            } else if (!release.isTutorial()) {
                throw new IllegalStateException("Only pre-archived releases can be archived");
            }
        } else {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to pre-archive a release with invalid status ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release.getStatus()})));
            throw new IllegalStateException("Only inactive releases can be archived");
        }
    }

    private void archiveAttachments(Release release) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving attachments for '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release.getId()})));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAttachments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)attachment -> {
            ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
            return BoxedUnit.UNIT;
        });
    }

    private void archiveDependencies(Release release) {
        Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is already pre-archived, nothing to do"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release})));
        } else {
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            if (!release.isTutorial()) {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"copying release ", " to archive database, marked as pre-archived"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release})));
                this.archivedReleases().insert(release, serializedRelease, "", true);
                this.releaseRepository.setPreArchived(release.getId(), true);
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running release ", " through export hooks"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release.getId()})));
            } else {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting tutorial release ", " instead of pre-archiving"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release})));
                this.releaseRepository.delete(release.getId());
            }
            this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
        }
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable & scala.Serializable)x$12 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$12.getPhase(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)phaseId)})), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable & scala.Serializable)x$2 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$2.getTask(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)taskId)})), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)variableId)})), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable & scala.Serializable)x$3 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$3.getPhase(x$1)).isDefined() : (Ids.isTaskId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable & scala.Serializable)x$4 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$4.getTask(x$1)).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().existsPreArchived(ciId) : false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases().exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You cannot perform this operation on archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)ciId)})), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived attachment [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachmentId})), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable & scala.Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable & scala.Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (Seq<String>)((Seq)Seq$.MODULE$.empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable & scala.Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter), List$.MODULE$.canBuildFrom())).asJava();
    }

    private Option<Release> getReleaseOption(String releaseId, boolean includePreArchived) {
        return this.archivedReleases().getRelease(releaseId, includePreArchived).map((Function1 & Serializable & scala.Serializable)releaseJson -> {
            void var3_3;
            Release release = ArchivingService$.MODULE$.deserializeArchivedRelease((String)releaseJson, $this.repositoryAdapter);
            Map<String, String> attachmentsFileNames = this.archivedReleases().getAttachmentsFileNames(release.getId());
            release.getAttachments().forEach(attachment -> {
                Option option = attachmentsFileNames.get((Object)ArchivedReleases$.MODULE$.shortenId(attachment.getId()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String filename = (String)some.value();
                    attachment.setFile((OverthereFile)SourceArtifactFile.withNullableWorkDir((String)filename, (SourceArtifact)attachment, null));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find attachment ", " of release ", " in the attachments table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachment.getId(), releaseId})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            });
            return var3_3;
        });
    }

    private boolean getReleaseOption$default$2() {
        return false;
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)release -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$6))));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        void var2_2;
        Buffer dependencies = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$8)));
        dependencies.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.archive();
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$2, Attachment attachment$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$2.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$2, Attachment attachment) {
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable & scala.Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$2, attachment, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        Seq rawDependenciesToArchive = (Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (Seq<String>)((Seq)rawDependenciesToArchive.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Seq$.MODULE$.canBuildFrom())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$6) {
        String string = x$6.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$8) {
        return !x$8.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentService commentService) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentService = commentService;
        Logging.$init$((Logging)this);
    }
}

