/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.GlobalVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.GlobalVariableDeletedEvent;
import com.xebialabs.xlrelease.domain.events.GlobalVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableReplacedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariablesUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.VariableRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.TaskBackup;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\u000f\u001f\u0001\u001dB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011I\u0003!\u0011!Q\u0001\nMCQ!\u0017\u0001\u0005\u0002iCQA\u001d\u0001\u0005\u0002MDq!a\n\u0001\t\u0003\tI\u0003C\u0004\u00020\u0001!I!!\r\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA%\u0001\u0011\u0005\u00111\n\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!!\"\u0001\t\u0003\t9\tC\u0004\u0002\u0012\u0002!I!a\"\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005bBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003g\u0003A\u0011AA[\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fCq!a8\u0001\t\u0013\t\t\u000fC\u0004\u0002~\u0002!I!a@\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b!9!1\u0003\u0001\u0005\n\tU\u0001b\u0002B$\u0001\u0011%!\u0011\n\u0002\u0010-\u0006\u0014\u0018.\u00192mKN+'O^5dK*\u0011q\u0004I\u0001\bg\u0016\u0014h/[2f\u0015\t\t#%A\u0005yYJ,G.Z1tK*\u00111\u0005J\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!J\u0001\u0004G>l7\u0001A\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005)1\u000f\u001c45U*\t1'\u0001\u0005he&T(\u0010\\3e\u0013\t)\u0004GA\u0004M_\u001e<\u0017N\\4\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e!\u0003)\u0011X\r]8tSR|'/_\u0005\u0003ye\u0012qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00029\u007f%\u0011\u0001)\u000f\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005<be&\f'\r\\3SKB|7/\u001b;pef\u0004\"\u0001O\"\n\u0005\u0011K$A\u0005,be&\f'\r\\3SKB|7/\u001b;pef\f\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0011\u0005\u001dCU\"\u0001\u0010\n\u0005%s\"\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u0005\u001dc\u0015BA'\u001f\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0015Q\f7o\u001b\"bG.,\b\u000f\u0005\u0002H!&\u0011\u0011K\b\u0002\u000b)\u0006\u001c8NQ1dWV\u0004\u0018\u0001C3wK:$()^:\u0011\u0005Q;V\"A+\u000b\u0005Y\u0003\u0013AB3wK:$8/\u0003\u0002Y+\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002\rqJg.\u001b;?)!YF,\u00180`A\u0006\u0014\u0007CA$\u0001\u0011\u00151\u0004\u00021\u00018\u0011\u0015i\u0004\u00021\u0001?\u0011\u0015\t\u0005\u00021\u0001C\u0011\u0015)\u0005\u00021\u0001G\u0011\u0015Q\u0005\u00021\u0001L\u0011\u0015q\u0005\u00021\u0001P\u0011\u0015\u0011\u0006\u00021\u0001TQ\tAA\r\u0005\u0002fa6\taM\u0003\u0002hQ\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005%T\u0017a\u00024bGR|'/\u001f\u0006\u0003W2\fQAY3b]NT!!\u001c8\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011a\\\u0001\u0004_J<\u0017BA9g\u0005%\tU\u000f^8xSJ,G-A\rgS:$')_%e\u0013:\u001cG.\u001e3j]\u001e\f%o\u00195jm\u0016$GC\u0001;}!\t)(0D\u0001w\u0015\t9\b0A\u0005wCJL\u0017M\u00197fg*\u0011\u0011\u0010I\u0001\u0007I>l\u0017-\u001b8\n\u0005m4(\u0001\u0003,be&\f'\r\\3\t\u000buL\u0001\u0019\u0001@\u0002\u0015Y\f'/[1cY\u0016LE\rE\u0002\u0000\u0003\u001bqA!!\u0001\u0002\nA\u0019\u00111\u0001\u0016\u000e\u0005\u0005\u0015!bAA\u0004M\u00051AH]8pizJ1!a\u0003+\u0003\u0019\u0001&/\u001a3fM&!\u0011qBA\t\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0002\u0016)\u0007%\t)\u0002\u0005\u0003\u0002\u0018\u0005\rRBAA\r\u0015\r9\u00171\u0004\u0006\u0005\u0003;\ty\"A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005\u0005B%\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t)#!\u0007\u0003\u000bQKW.\u001a3\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$2\u0001^A\u0016\u0011\u0015i(\u00021\u0001\u007fQ\rQ\u0011QC\u0001\u0018M&tGMU3mK\u0006\u001cXMV1sS\u0006\u0014G.\u001a\"z\u0013\u0012$2\u0001^A\u001a\u0011\u0015i8\u00021\u0001\u007f\u0003Y1\u0017N\u001c3HY>\u0014\u0017\r\u001c,be&\f'\r\\3Cs&#Gc\u0001;\u0002:!)Q\u0010\u0004a\u0001}\u0006Ia-\u001b8e\u0005f\\U-\u001f\u000b\u0006i\u0006}\u00121\t\u0005\u0007\u0003\u0003j\u0001\u0019\u0001@\u0002\u0019Y\f'/[1cY\u0016t\u0015-\\3\t\r\u0005\u0015S\u00021\u0001\u007f\u0003%\u0011X\r\\3bg\u0016LE\rK\u0002\u000e\u0003+\t1\"\u00193e-\u0006\u0014\u0018.\u00192mKR)A/!\u0014\u0002Z!9\u0011q\n\bA\u0002\u0005E\u0013a\u0002:fY\u0016\f7/\u001a\t\u0005\u0003'\n)&D\u0001y\u0013\r\t9\u0006\u001f\u0002\b%\u0016dW-Y:f\u0011\u0019\tYF\u0004a\u0001i\u0006Aa/\u0019:jC\ndW\rK\u0002\u000f\u0003+\ta#\u001e9eCR,'+\u001a7fCN,g+\u0019:jC\ndWm\u001d\u000b\u0007\u0003#\n\u0019'!\u001a\t\u000f\u0005=s\u00021\u0001\u0002R!1qo\u0004a\u0001\u0003O\u0002R!!\u001b\u0002tQl!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005kRLGN\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\u0011\t)(a\u001b\u0003\t1K7\u000f\u001e\u0015\u0004\u001f\u0005U\u0011AD;qI\u0006$XMV1sS\u0006\u0014G.\u001a\u000b\u0006i\u0006u\u0014q\u0010\u0005\b\u0003\u001f\u0002\u0002\u0019AA)\u0011\u0019\t\t\t\u0005a\u0001i\u00069Q\u000f\u001d3bi\u0016$\u0007f\u0001\t\u0002\u0016\u0005Qb-\u001b8e\u000f2|'-\u00197WCJL\u0017M\u00197fg>\u0013X)\u001c9usR\u0011\u0011\u0011\u0012\t\u0004k\u0006-\u0015bAAGm\nyq\t\\8cC24\u0016M]5bE2,7\u000fK\u0002\u0012\u0003+\t1CZ5oI\u001ecwNY1m-\u0006\u0014\u0018.\u00192mKN\f\u0011#\u00193e\u000f2|'-\u00197WCJL\u0017M\u00197f)\r!\u0018q\u0013\u0005\u0007\u00033\u001b\u0002\u0019\u0001;\u0002\u0003YD3aEA\u000b\u0003Q)\b\u000fZ1uK\u001ecwNY1m-\u0006\u0014\u0018.\u00192mKR\u0019A/!)\t\r\u0005\u0005E\u00031\u0001uQ\r!\u0012QC\u0001\u0015I\u0016dW\r^3HY>\u0014\u0017\r\u001c,be&\f'\r\\3\u0015\t\u0005%\u0016q\u0016\t\u0004S\u0005-\u0016bAAWU\t!QK\\5u\u0011\u0015iX\u00031\u0001\u007fQ\r)\u0012QC\u0001\u000fI\u0016dW\r^3WCJL\u0017M\u00197f)\u0019\tI+a.\u0002:\"9\u0011q\n\fA\u0002\u0005E\u0003\"B?\u0017\u0001\u0004q\bf\u0001\f\u0002\u0016\u0005y!/\u001a9mC\u000e,g+\u0019:jC\ndW\r\u0006\u0005\u0002*\u0006\u0005\u00171YAc\u0011\u001d\tye\u0006a\u0001\u0003#Ba!a\u0017\u0018\u0001\u0004!\bbBAd/\u0001\u0007\u0011\u0011Z\u0001\fe\u0016\u0004H.Y2f[\u0016tG\u000f\u0005\u0003\u0002L\u0006eWBAAg\u0015\u0011\ty-!5\u0002\u000b\u0019|'/\\:\u000b\t\u0005M\u0017Q[\u0001\u0003mFR1!a6!\u0003\r\t\u0007/[\u0005\u0005\u00037\fiMA\bWCJL\u0017M\u00197f\u001fJ4\u0016\r\\;fQ\r9\u0012QC\u0001\u0014G\",7m\u001b*f]\u0006lWMV1mS\u0012LG/\u001f\u000b\t\u0003S\u000b\u0019/a>\u0002|\"1q\u000f\u0007a\u0001\u0003K\u0004R!a:\u0002rRtA!!;\u0002n:!\u00111AAv\u0013\u0005Y\u0013bAAxU\u00059\u0001/Y2lC\u001e,\u0017\u0002BAz\u0003k\u00141aU3r\u0015\r\tyO\u000b\u0005\u0007\u0003sD\u0002\u0019\u0001;\u0002\u000f\r,(O]3oi\"1\u0011\u0011\u0011\rA\u0002Q\fQb\u00195fG.\u001c\u0016-\\3UsB,GCBAU\u0005\u0003\u0011\u0019\u0001\u0003\u0004\u0002zf\u0001\r\u0001\u001e\u0005\u0007\u0003\u0003K\u0002\u0019\u0001;\u00023U\u0004H-\u0019;f-\u0006\u0014\u0018.\u00192mK\u0006sG\r\u0015:pm&$WM\u001d\u000b\ni\n%!Q\u0002B\b\u0005#AaAa\u0003\u001b\u0001\u0004q\u0018\u0001\u00039be\u0016tG/\u00133\t\r\u0005e(\u00041\u0001u\u0011\u0019\t\tI\u0007a\u0001i\"9\u0011q\n\u000eA\u0002\u0005E\u0013\u0001E;qI\u0006$X-V:bO\u0016\u0004v.\u001b8u)!\u00119Ba\r\u0003D\t\u0015\u0003#B@\u0003\u001a\tu\u0011\u0002\u0002B\u000e\u0003#\u00111aU3u!\u0011\u0011yBa\f\u000e\u0005\t\u0005\"\u0002\u0002B\u0012\u0005K\t1!\u001e3n\u0015\u0011\t9Na\n\u000b\t\t%\"1F\u0001\u0007a2,x-\u001b8\u000b\u0007\t5\"%\u0001\u0005eKBdw._5u\u0013\u0011\u0011\tD!\t\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W\u000eC\u0004\u00036m\u0001\rAa\u000e\u0002\u0005U\u0004\b\u0003\u0002B\u001d\u0005\u007fi!Aa\u000f\u000b\u0007\tub/A\u0005sK\u001a,'/\u001a8dK&!!\u0011\tB\u001e\u0005))6/Y4f!>Lg\u000e\u001e\u0005\u0007\u00037Z\u0002\u0019\u0001;\t\u000f\u0005\u001d7\u00041\u0001\u0002J\u0006y1/\u001f8d)JLwmZ3s-\u0006\u00148\u000f\u0006\u0003\u0002*\n-\u0003bBA(9\u0001\u0007\u0011\u0011\u000b\u0015\u0004\u0001\t=\u0003\u0003\u0002B)\u0005/j!Aa\u0015\u000b\u0007\tUC.\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!\u0017\u0003T\t91+\u001a:wS\u000e,\u0007")
public class VariableService
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final ReleaseRepository releaseRepository;
    private final VariableRepository variableRepository;
    private final ArchivingService archivingService;
    private final CiIdService ciIdService;
    private final TaskBackup taskBackup;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        VariableService variableService = this;
        synchronized (variableService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Variable findByIdIncludingArchived(String variableId) {
        Variable variable;
        if (VariableHelper$.MODULE$.isGlobalVariableId(variableId)) {
            variable = this.findGlobalVariableById(variableId);
        } else if (this.variableRepository.exists(variableId)) {
            variable = this.findById(variableId);
        } else if (this.archivingService.exists(variableId)) {
            variable = this.archivingService.getVariable(variableId);
        } else {
            throw new NotFoundException(new StringBuilder(55).append("Variable [").append(variableId).append("] does not exist in the repository or archive").toString(), new Object[0]);
        }
        return variable;
    }

    @Timed
    public Variable findById(String variableId) {
        return VariableHelper$.MODULE$.isGlobalVariableId(variableId) ? this.findGlobalVariableById(variableId) : this.findReleaseVariableById(variableId);
    }

    private Variable findReleaseVariableById(String variableId) {
        return this.variableRepository.findById(variableId);
    }

    private Variable findGlobalVariableById(String variableId) {
        return (Variable)this.configurationRepository.read(variableId);
    }

    @Timed
    public Variable findByKey(String variableName, String releaseId) {
        String string = variableName;
        Variable variable = Strings.isNotBlank((String)string) ? this.variableRepository.findByKey(string, releaseId) : null;
        return variable;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Variable addVariable(Release release, Variable variable) {
        void var3_3;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Adding new variable with key [").append(variable.getKey()).append("] to release [").append(release.getId()).append("]").toString());
        release.addVariable(variable);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        Object object = !release.getVariableById(variable.getId()).isPresent() ? release.addVariable(variable) : BoxedUnit.UNIT;
        this.syncTriggerVars(release);
        Variable created = this.variableRepository.create(variable, release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableCreatedEvent(variable));
        return var3_3;
    }

    @Timed
    public Release updateReleaseVariables(Release release, java.util.List<Variable> variables) {
        variables.forEach(variable -> Checks.checkArgument((!com.google.common.base.Strings.isNullOrEmpty((String)variable.getKey()) ? 1 : 0) != 0, (String)"Variable must have a 'key' field", (Object[])new Object[0]));
        java.util.List originalVariables = release.getVariables();
        release.setVariables(variables);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        this.syncTriggerVars(release);
        this.variableRepository.update((Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(originalVariables).asScala()), (Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(variables).asScala()), release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariablesUpdatedEvent(originalVariables, variables));
        return release;
    }

    @Timed
    public Variable updateVariable(Release release, Variable updated) {
        Variable updatedVariable;
        block3: {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Updating variable [").append(updated.getId()).append("]").toString());
            updated.checkValidity();
            Variable current = this.findById(updated.getId());
            this.checkSameType(current, updated);
            String string = current.getKey();
            String string2 = updated.getKey();
            if (string == null ? string2 != null : !string.equals(string2)) {
                ReleaseStatus releaseStatus = release.getStatus();
                ReleaseStatus releaseStatus2 = ReleaseStatus.TEMPLATE;
                if (releaseStatus == null ? releaseStatus2 != null : !releaseStatus.equals(releaseStatus2)) {
                    ReleaseStatus releaseStatus3 = release.getStatus();
                    ReleaseStatus releaseStatus4 = ReleaseStatus.PLANNED;
                    if (releaseStatus3 == null ? releaseStatus4 != null : !releaseStatus3.equals(releaseStatus4)) {
                        throw new IllegalStateException(new StringBuilder(53).append("Cannot rename variable ").append(updated.getId()).append(" of an already started release").toString());
                    }
                }
                this.checkRenameValidity((Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()), current, updated);
            }
            updatedVariable = this.updateVariableAndProvider(release.getId(), current, updated, release);
            this.eventBus.publish((XLReleaseEvent)new ReleaseVariableUpdatedEvent(current, updated));
            String string3 = current.getKey();
            String string4 = updated.getKey();
            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block3;
            this.replaceVariableUsages$1(current, updatedVariable, release);
        }
        return updatedVariable;
    }

    @Timed
    public GlobalVariables findGlobalVariablesOrEmpty() {
        return this.findGlobalVariables();
    }

    /*
     * WARNING - void declaration
     */
    private GlobalVariables findGlobalVariables() {
        void var1_1;
        GlobalVariables globalVariables = new GlobalVariables();
        globalVariables.setVariables(this.configurationRepository.findAllByType(Type.valueOf(Variable.class)));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Variable addGlobalVariable(Variable v) {
        void var3_3;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Adding new global variable with key [").append(v.getKey()).append("]").toString());
        GlobalVariables globalVars = this.findGlobalVariables();
        Variable newVariable = globalVars.addVariable(v);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(globalVars.getId(), globalVars.getVariables(), this.ciIdService);
        this.configurationRepository.create(newVariable);
        this.eventBus.publish((XLReleaseEvent)new GlobalVariableCreatedEvent(newVariable, null));
        return var3_3;
    }

    @Timed
    public Variable updateGlobalVariable(Variable updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Updating global variable [").append(updated.getId()).append("]").toString());
        updated.checkGlobalVariableValidity();
        Variable current = this.findGlobalVariableById(updated.getId());
        this.checkSameType(current, updated);
        GlobalVariables globalVars = this.findGlobalVariables();
        String string = current.getKey();
        String string2 = updated.getKey();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkRenameValidity((Seq<Variable>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(globalVars.getVariables()).asScala()), current, updated);
        }
        Variable variable = this.updateVariableAndProvider(globalVars.getId(), current, updated, null);
        this.eventBus.publish((XLReleaseEvent)new GlobalVariableUpdatedEvent(current, variable, null));
        return variable;
    }

    @Timed
    public void deleteGlobalVariable(String variableId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Deleting global variable [").append(variableId).append("]").toString());
        Variable variable = this.findGlobalVariableById(variableId);
        this.configurationRepository.delete(variableId);
        this.eventBus.publish((XLReleaseEvent)new GlobalVariableDeletedEvent(variable, null));
    }

    @Timed
    public void deleteVariable(Release release, String variableId) {
        Variable variable = (Variable)release.getVariableById(variableId).orElseThrow(() -> new NotFoundException(new StringBuilder(30).append("Repository entity [").append(variableId).append("] not found").toString(), new Object[0]));
        release.removeVariable(variableId);
        release.getAllUserInputTasks().forEach(task -> $this.taskBackup.removeVariable((UserInputTask)task, variableId));
        this.syncTriggerVars(release);
        this.variableRepository.delete(variableId, release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableDeletedEvent(variable));
    }

    @Timed
    public void replaceVariable(Release release, Variable variable, VariableOrValue replacement) {
        if (replacement.getVariable() == null && replacement.getValue() == null) {
            replacement.setValue(variable.getEmptyValue());
        }
        if (replacement.getVariable() != null) {
            replacement.setVariable(VariableHelper$.MODULE$.formatVariableIfNeeded(replacement.getVariable()));
        }
        Set cis = (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(release.collectVariableReferences()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)varRef -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$replaceVariable$1(variable, varRef))).flatMap((Function1 & Serializable & scala.Serializable)varRef -> (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(varRef.getUsagePoints()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)up -> (scala.collection.immutable.Set)this.updateUsagePoint((UsagePoint)up, variable, replacement).map((Function1 & Serializable & scala.Serializable)u -> u, Set$.MODULE$.canBuildFrom()), scala.collection.mutable.Set$.MODULE$.canBuildFrom()), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService);
        this.syncTriggerVars(release);
        this.variableRepository.replace(release, (Seq<ConfigurationItem>)cis.toSeq());
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableReplacedEvent(variable, replacement));
    }

    private void checkRenameValidity(Seq<Variable> variables, Variable current, Variable updated) {
        if (((SeqLike)variables.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKey(), Seq$.MODULE$.canBuildFrom())).contains((Object)updated.getKey())) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Cannot rename variable ").append(updated.getId()).append(" from ").append(current.getKey()).append(new StringBuilder(28).append(" to ").append(updated.getKey()).append(" because ").append(updated.getKey()).append(" already exists").toString()).toString());
        }
    }

    private void checkSameType(Variable current, Variable updated) {
        if (!current.getType().equals((Object)updated.getType())) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Cannot change type of variable ").append(updated.getId()).append(" from ").append(current.getType()).append(" to ").append(updated.getType()).toString());
        }
    }

    private Variable updateVariableAndProvider(String parentId, Variable current, Variable updated, Release release) {
        Variable variable;
        PropertyDescriptor currentValueType = current.getType().getDescriptor().getPropertyDescriptor("value");
        PropertyDescriptor updatedValueType = updated.getType().getDescriptor().getPropertyDescriptor("value");
        if (!currentValueType.getKind().equals((Object)updatedValueType.getKind())) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Cannot change type of variable from ").append(current.getType()).append(" to ").append(updated.getType()).toString());
        }
        if (updated.getValueProvider() != null) {
            updated.getValueProvider().setVariable(updated);
        }
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(parentId, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)updated, (List)Nil$.MODULE$)).asJava(), this.ciIdService);
        if (Ids.isReleaseId((String)parentId)) {
            release.replaceVariable(current, updated);
            this.syncTriggerVars(release);
            this.variableRepository.update(current, updated, release);
            variable = BoxedUnit.UNIT;
        } else {
            variable = this.configurationRepository.update(updated);
        }
        return updated;
    }

    private scala.collection.immutable.Set<ConfigurationItem> updateUsagePoint(UsagePoint up, Variable variable, VariableOrValue replacement) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(up.replaceVariable(variable, replacement)).asScala()).toSet();
    }

    private void syncTriggerVars(Release release) {
        release.getReleaseTriggers().forEach(trigger -> {
            Map templateVarsMap = (Map)Map$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.getShowOnReleaseStart())).map((Function1 & Serializable & scala.Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.getKey()), (Object)CiCloneHelper.cloneCi(v)), Buffer$.MODULE$.canBuildFrom()));
            Buffer updatedTriggerVars = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(trigger.getVariables()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)triggerVar -> Option$.MODULE$.option2Iterable(templateVarsMap.remove((Object)triggerVar.getKey()).map((Function1 & Serializable & scala.Serializable)templateVar -> {
                block0: {
                    if (triggerVar.isValueEmpty()) break block0;
                    templateVar.setUntypedValue(triggerVar.getValue());
                }
                return templateVar;
            })), Buffer$.MODULE$.canBuildFrom());
            java.util.List newTriggerVars = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(updatedTriggerVars.$plus$plus((GenTraversableOnce)templateVarsMap.values())).asJava();
            VariablePersistenceHelper$.MODULE$.fixUpVariableIds(trigger.getId(), newTriggerVars, $this.ciIdService);
            trigger.setVariables(newTriggerVars);
        });
    }

    private final void replaceVariableUsages$1(Variable oldVariable, Variable updatedVariable, Release release$2) {
        VariableOrValue replacement = new VariableOrValue();
        replacement.setVariable(updatedVariable.getKey());
        Release updatedRelease = this.releaseRepository.findById(release$2.getId(), null);
        this.replaceVariable(updatedRelease, oldVariable, replacement);
    }

    public static final /* synthetic */ boolean $anonfun$replaceVariable$1(Variable variable$2, VariableReference varRef) {
        String string = VariableHelper$.MODULE$.withoutVariableSyntax(varRef.getKey());
        String string2 = VariableHelper$.MODULE$.withoutVariableSyntax(variable$2.getKey());
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public VariableService(ConfigurationRepository configurationRepository, ReleaseRepository releaseRepository, VariableRepository variableRepository, ArchivingService archivingService, CiIdService ciIdService, TaskBackup taskBackup, XLReleaseEventBus eventBus) {
        this.configurationRepository = configurationRepository;
        this.releaseRepository = releaseRepository;
        this.variableRepository = variableRepository;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.taskBackup = taskBackup;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

