/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.excel;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class Export {
    protected XSSFWorkbook workBook = new XSSFWorkbook();
    protected XSSFSheet sheet = this.workBook.createSheet();
    protected int rowIndex = 0;

    protected abstract void addContent();

    protected abstract void setColumnsWidth();

    protected abstract void addHeaderRow();

    public Workbook getWorkBook() {
        this.workBook = new XSSFWorkbook();
        this.sheet = this.workBook.createSheet();
        this.addHeaderRow();
        this.setColumnsWidth();
        this.addContent();
        this.preventDynamicDataExchangeAttack();
        return this.workBook;
    }

    protected int numberOfCharacter(int number) {
        return number * 256;
    }

    private void preventDynamicDataExchangeAttack() {
        String pattern = "^(=|@|-|\"|\\+).*$";
        for (Sheet sheet : this.workBook) {
            for (Row row : sheet) {
                for (Cell cell : row) {
                    XSSFCell xssfcell = (XSSFCell)cell;
                    if (xssfcell.getCellTypeEnum() != CellType.STRING || !xssfcell.toString().matches(pattern)) continue;
                    xssfcell.setCellValue("'" + xssfcell.getStringCellValue());
                }
            }
        }
    }
}

