/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.authentication;

import com.xebialabs.xlplatform.utils.SecureRandomHolder;
import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.util.Assert;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\u000f\u001e\u0001\u0019B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"AQ\n\u0001B\u0001B\u0003%a\nC\u0003U\u0001\u0011\u0005Q\u000bC\u0004\\\u0001\t\u0007I\u0011\u0002/\t\r\u0005\u0004\u0001\u0015!\u0003^\u0011\u001d\u0011\u0007A1A\u0005\nqCaa\u0019\u0001!\u0002\u0013i\u0006b\u00023\u0001\u0001\u0004%I\u0001\u0018\u0005\bK\u0002\u0001\r\u0011\"\u0003g\u0011\u0019a\u0007\u0001)Q\u0005;\"9Q\u000e\u0001a\u0001\n\u0013a\u0006b\u00028\u0001\u0001\u0004%Ia\u001c\u0005\u0007c\u0002\u0001\u000b\u0015B/\t\u000bI\u0004A\u0011B:\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA!\u0001\u0011\u0005\u00131\t\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\t\u0019\u0007\u0001C\t\u0003KBq!a\u001a\u0001\t#\t)\u0007C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0005bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\r\u0003\u001f\u0003\u0001\u0013!A\u0001\u0002\u0013\u0005\u0011\u0011\u0013\u0005\r\u0003C\u0003\u0001\u0013!A\u0001\u0002\u0013\u0005\u00111\u0015\u0002$12\u0004VM]:jgR,g\u000e\u001e+pW\u0016t'+Z7f[\n,'/T3TKJ4\u0018nY3t\u0015\tqr$\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u0005\u0001\n\u0013!\u0003=me\u0016dW-Y:f\u0015\t\u00113%A\u0005yK\nL\u0017\r\\1cg*\tA%A\u0002d_6\u001c\u0001a\u0005\u0002\u0001OA\u0011\u0001\u0006N\u0007\u0002S)\u0011!fK\u0001\u000be\u0016lW-\u001c2fe6,'B\u0001\u0010-\u0015\tic&A\u0002xK\nT!a\f\u0019\u0002\u0011M,7-\u001e:jifT!!\r\u001a\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aM\u0001\u0004_J<\u0017BA\u001b*\u0005i\t%m\u001d;sC\u000e$(+Z7f[\n,'/T3TKJ4\u0018nY3t\u0003\rYW-\u001f\t\u0003q\u0005s!!O \u0011\u0005ijT\"A\u001e\u000b\u0005q*\u0013A\u0002\u001fs_>$hHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001U(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!>\u0003I)8/\u001a:EKR\f\u0017\u000e\\:TKJ4\u0018nY3\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015aC;tKJ$W\r^1jYNT!A\u0013\u0018\u0002\t\r|'/Z\u0005\u0003\u0019\u001e\u0013!#V:fe\u0012+G/Y5mgN+'O^5dK\u0006yAo\\6f]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002P%6\t\u0001K\u0003\u0002R?\u0005Q!/\u001a9pg&$xN]=\n\u0005M\u0003&aH\"vgR|W\u000eU3sg&\u001cH/\u001a8u)>\\WM\u001c*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"BA\u0016-Z5B\u0011q\u000bA\u0007\u0002;!)a\u0007\u0002a\u0001o!)A\t\u0002a\u0001\u000b\")Q\n\u0002a\u0001\u001d\u0006)B)\u0012$B+2#vlU#S\u0013\u0016\u001bv\fT#O\u000fRCU#A/\u0011\u0005y{V\"A\u001f\n\u0005\u0001l$aA%oi\u00061B)\u0012$B+2#vlU#S\u0013\u0016\u001bv\fT#O\u000fRC\u0005%\u0001\u000bE\u000b\u001a\u000bU\u000b\u0014+`)>[UIT0M\u000b:;E\u000bS\u0001\u0016\t\u00163\u0015)\u0016'U?R{5*\u0012(`\u0019\u0016su\t\u0016%!\u00031\u0019XM]5fg2+gn\u001a;i\u0003A\u0019XM]5fg2+gn\u001a;i?\u0012*\u0017\u000f\u0006\u0002hUB\u0011a\f[\u0005\u0003Sv\u0012A!\u00168ji\"91NCA\u0001\u0002\u0004i\u0016a\u0001=%c\u0005i1/\u001a:jKNdUM\\4uQ\u0002\n1\u0002^8lK:dUM\\4uQ\u0006yAo\\6f]2+gn\u001a;i?\u0012*\u0017\u000f\u0006\u0002ha\"91.DA\u0001\u0002\u0004i\u0016\u0001\u0004;pW\u0016tG*\u001a8hi\"\u0004\u0013AB4p!\u0006\u001cH\u000fF\u0002uyz\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\tU$\u0018\u000e\u001c\u0006\u0002s\u0006!!.\u0019<b\u0013\tYhO\u0001\u0003ECR,\u0007\"B?\u0010\u0001\u0004!\u0018!C4jm\u0016tG)\u0019;f\u0011\u0019yx\u00021\u0001\u0002\u0002\u0005AA/[7f\u0013:l5\u000fE\u0002_\u0003\u0007I1!!\u0002>\u0005\u0011auN\\4\u0002\u0011\u001d|g)\u001e;ve\u0016$R\u0001^A\u0006\u0003\u001bAQ! \tA\u0002QDaa \tA\u0002\u0005\u0005\u0011AD8o\u0019><\u0017N\\*vG\u000e,7o\u001d\u000b\bO\u0006M\u00111FA\u001b\u0011\u001d\t)\"\u0005a\u0001\u0003/\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\u001a\u0005\u001dRBAA\u000e\u0015\u0011\ti\"a\b\u0002\t!$H\u000f\u001d\u0006\u0005\u0003C\t\u0019#A\u0004tKJ4H.\u001a;\u000b\u0005\u0005\u0015\u0012!\u00026bm\u0006D\u0018\u0002BA\u0015\u00037\u0011!\u0003\u0013;uaN+'O\u001e7fiJ+\u0017/^3ti\"9\u0011QF\tA\u0002\u0005=\u0012\u0001\u0003:fgB|gn]3\u0011\t\u0005e\u0011\u0011G\u0005\u0005\u0003g\tYBA\nIiR\u00048+\u001a:wY\u0016$(+Z:q_:\u001cX\rC\u0004\u00028E\u0001\r!!\u000f\u00021M,8mY3tg\u001a,H.Q;uQ\u0016tG/[2bi&|g\u000e\u0005\u0003\u0002<\u0005uR\"A%\n\u0007\u0005}\u0012J\u0001\bBkRDWM\u001c;jG\u0006$\u0018n\u001c8\u0002-A\u0014xnY3tg\u0006+Ho\u001c'pO&t7i\\8lS\u0016$\u0002\"!\u0012\u0002L\u0005U\u0013q\u000b\t\u0004\r\u0006\u001d\u0013bAA%\u000f\nYQk]3s\t\u0016$\u0018-\u001b7t\u0011\u001d\tiE\u0005a\u0001\u0003\u001f\nAbY8pW&,Gk\\6f]N\u0004BAXA)o%\u0019\u00111K\u001f\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005U!\u00031\u0001\u0002\u0018!9\u0011Q\u0006\nA\u0002\u0005=\u0012A\u00027pO>,H\u000fF\u0004h\u0003;\ny&!\u0019\t\u000f\u0005U1\u00031\u0001\u0002\u0018!9\u0011QF\nA\u0002\u0005=\u0002B\u0002\u0010\u0014\u0001\u0004\tI$\u0001\nhK:,'/\u0019;f'\u0016\u0014\u0018.Z:ECR\fW#A\u001c\u0002#\u001d,g.\u001a:bi\u0016$vn[3o\t\u0006$\u0018-A\u0005bI\u0012\u001cun\\6jKR9q-!\u001c\u0002x\u0005e\u0004bBA8-\u0001\u0007\u0011\u0011O\u0001\u0006i>\\WM\u001c\t\u0004Q\u0005M\u0014bAA;S\tI\u0002+\u001a:tSN$XM\u001c;SK6,WNY3s\u001b\u0016$vn[3o\u0011\u001d\t)B\u0006a\u0001\u0003/Aq!!\f\u0017\u0001\u0004\ty#A\btKR\u001cVM]5fg2+gn\u001a;i)\r9\u0017q\u0010\u0005\u0006I^\u0001\r!X\u0001\u000fg\u0016$Hk\\6f]2+gn\u001a;i)\r9\u0017Q\u0011\u0005\u0006[b\u0001\r!X\u0001\u0018g\u0016$Hk\\6f]Z\u000bG.\u001b3jif\u001cVmY8oIN$2aZAF\u0011\u0019\ti)\u0007a\u0001;\u0006!Bo\\6f]Z\u000bG.\u001b3jif\u001cVmY8oIN\fq\u0003\u001d:pi\u0016\u001cG/\u001a3%O\u0016$8i\\8lS\u0016t\u0015-\\3\u0015\t\u0005M\u0015q\u0014\u000b\u0003\u0003+\u0003B!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0004\u00037C\u0018\u0001\u00027b]\u001eL1AQAM\u0011\u001dY'$!AA\u0002Y\u000ba\u0003\u001d:pi\u0016\u001cG/\u001a3%I\u0016\u001cw\u000eZ3D_>\\\u0017.\u001a\u000b\u0005\u0003K\u000bY\u000b\u0006\u0003\u0002(\u0006%\u0006#\u00020\u0002R\u0005U\u0005\u0002C6\u001c\u0003\u0003\u0005\r!!&\t\u000f-\\\u0012\u0011!a\u0001-\u0002")
public class XlPersistentTokenRememberMeServices
extends AbstractRememberMeServices {
    private final CustomPersistentTokenRepository tokenRepository;
    private final int DEFAULT_SERIES_LENGTH;
    private final int DEFAULT_TOKEN_LENGTH;
    private int seriesLength;
    private int tokenLength;

    public /* synthetic */ String protected$getCookieName(XlPersistentTokenRememberMeServices x$1) {
        return x$1.getCookieName();
    }

    public /* synthetic */ String[] protected$decodeCookie(XlPersistentTokenRememberMeServices x$1, String x$12) {
        return x$1.decodeCookie(x$12);
    }

    private int DEFAULT_SERIES_LENGTH() {
        return this.DEFAULT_SERIES_LENGTH;
    }

    private int DEFAULT_TOKEN_LENGTH() {
        return this.DEFAULT_TOKEN_LENGTH;
    }

    private int seriesLength() {
        return this.seriesLength;
    }

    private void seriesLength_$eq(int x$1) {
        this.seriesLength = x$1;
    }

    private int tokenLength() {
        return this.tokenLength;
    }

    private void tokenLength_$eq(int x$1) {
        this.tokenLength = x$1;
    }

    private Date goPast(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long pastTime = givenTimeInMs - timeInMs;
        return new Date(pastTime);
    }

    private Date goFuture(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long futureTime = givenTimeInMs + timeInMs;
        return new Date(futureTime);
    }

    public void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        String username = successfulAuthentication.getName();
        this.logger.debug((Object)new StringBuilder(39).append("Creating new persistent login for user ").append(username).toString());
        PersistentRememberMeToken persistentToken = new PersistentRememberMeToken(username.toLowerCase(), this.generateSeriesData(), this.generateTokenData(), new Date());
        try {
            this.tokenRepository.createNewToken(persistentToken);
            this.addCookie(persistentToken, request, response);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to save persistent token ", (Throwable)e);
        }
    }

    public UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        if (cookieTokens.length != 2) {
            throw new InvalidCookieException(new StringBuilder(54).append("Cookie token did not contain ").append(2).append(" tokens, but contained '").append(Arrays.asList((Object[])new String[][]{cookieTokens})).append("'").toString());
        }
        String presentedSeries = cookieTokens[0];
        String presentedToken = cookieTokens[1];
        PersistentRememberMeToken token = this.tokenRepository.getTokenForSeries(presentedSeries);
        if (token == null) {
            throw new RememberMeAuthenticationException(new StringBuilder(41).append("No persistent token found for series id: ").append(presentedSeries).toString());
        }
        String string = presentedToken;
        String string2 = token.getTokenValue();
        if (string == null ? string2 != null : !string.equals(string2)) {
            List<PersistentRememberMeToken> previousTokenList = this.tokenRepository.getPreviousTokenForSeries(presentedSeries, token.getTokenValue());
            Optional<PersistentRememberMeToken> previousOldToken = previousTokenList.stream().filter(previousToken -> {
                String string = previousToken.getTokenValue();
                String string2 = presentedToken;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).findFirst();
            if (!previousOldToken.isPresent()) {
                this.tokenRepository.removeUserTokens(token.getUsername());
                throw new CookieTheftException(this.messages.getMessage("PersistentTokenBasedRememberMeServices.cookieStolen", "Invalid remember-me token (Series/token) mismatch. Implies previous cookie theft attack."));
            }
            this.tokenRepository.removeTokenInSeriesBeforeGivenDate(token.getSeries(), this.goPast(previousOldToken.get().getDate(), 60000L));
        }
        if (this.goFuture(token.getDate(), (long)this.getTokenValiditySeconds() * 1000L).getTime() < System.currentTimeMillis()) {
            throw new RememberMeAuthenticationException("Remember-me login has expired");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)new StringBuilder(56).append("Refreshing persistent login token for user '").append(token.getUsername()).append("', series '").append(token.getSeries()).append("'").toString());
        }
        try {
            if (this.goFuture(token.getDate(), 30000L).getTime() < System.currentTimeMillis()) {
                PersistentRememberMeToken newToken = new PersistentRememberMeToken(token.getUsername().toLowerCase(), token.getSeries(), this.generateTokenData(), new Date());
                this.tokenRepository.createNewToken(newToken);
                this.addCookie(newToken, request, response);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to update token: ", (Throwable)e);
            throw new RememberMeAuthenticationException("Autologin failed due to data access problem");
        }
        return this.getUserDetailsService().loadUserByUsername(token.getUsername());
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        super.logout(request, response, authentication);
        if (authentication != null) {
            this.tokenRepository.removeUserTokens(authentication.getName().toLowerCase());
        } else {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])request.getCookies())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)XlPersistentTokenRememberMeServices.$anonfun$logout$1(this, x$1))).foreach((Function1 & Serializable & scala.Serializable)c -> {
                XlPersistentTokenRememberMeServices.$anonfun$logout$2(this, c);
                return BoxedUnit.UNIT;
            });
        }
        SecurityContextLogoutHandler securityContextLogoutHandler = new SecurityContextLogoutHandler();
        securityContextLogoutHandler.logout(request, response, null);
    }

    public String generateSeriesData() {
        return new String(Base64.getEncoder().encode(SecureRandomHolder.getRandomByteArray((int)this.seriesLength())));
    }

    public String generateTokenData() {
        return new String(Base64.getEncoder().encode(SecureRandomHolder.getRandomByteArray((int)this.tokenLength())));
    }

    private void addCookie(PersistentRememberMeToken token, HttpServletRequest request, HttpServletResponse response) {
        this.setCookie((String[])((Object[])new String[]{token.getSeries(), token.getTokenValue()}), this.getTokenValiditySeconds(), request, response);
    }

    public void setSeriesLength(int seriesLength) {
        this.seriesLength_$eq(seriesLength);
    }

    public void setTokenLength(int tokenLength) {
        this.tokenLength_$eq(tokenLength);
    }

    public void setTokenValiditySeconds(int tokenValiditySeconds) {
        Assert.isTrue((tokenValiditySeconds > 0 ? 1 : 0) != 0, (String)"tokenValiditySeconds must be positive for this implementation");
        super.setTokenValiditySeconds(tokenValiditySeconds);
    }

    public static final /* synthetic */ boolean $anonfun$logout$1(XlPersistentTokenRememberMeServices $this, Cookie x$1) {
        String string = x$1.getName();
        String string2 = $this.protected$getCookieName($this);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$logout$2(XlPersistentTokenRememberMeServices $this, Cookie c) {
        String[] values = $this.protected$decodeCookie($this, c.getValue());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).headOption().foreach((Function1 & Serializable & scala.Serializable)series -> {
            $this.tokenRepository.removeUserTokensBasedOnSeries(series);
            return BoxedUnit.UNIT;
        });
    }

    public XlPersistentTokenRememberMeServices(String key, UserDetailsService userDetailsService, CustomPersistentTokenRepository tokenRepository) {
        this.tokenRepository = tokenRepository;
        super(key, userDetailsService);
        this.DEFAULT_SERIES_LENGTH = 16;
        this.DEFAULT_TOKEN_LENGTH = 16;
        this.seriesLength = this.DEFAULT_SERIES_LENGTH();
        this.tokenLength = this.DEFAULT_TOKEN_LENGTH();
    }
}

