/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SupportService {
    private static final Logger logger = LoggerFactory.getLogger(SupportService.class);
    private static final String PASSWORD = "password";

    @Timed
    public void prepareZip(OutputStream output, List<String> directories) throws IOException {
        this.checkArguments(output, directories);
        logger.info("Going to zip the following directories: {}", directories);
        try (ZipOutputStream zos = new ZipOutputStream(this.asBuffered(output));){
            directories.forEach(directory -> {
                try {
                    this.addToZip(zos, new File((String)directory), null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private OutputStream asBuffered(OutputStream os) {
        return os instanceof BufferedOutputStream ? os : new BufferedOutputStream(os);
    }

    private void addToZip(ZipOutputStream zos, File fileToZip, String parentDirectoryName) throws IOException {
        if (!this.isValidFile(fileToZip)) {
            return;
        }
        String zipEntryName = fileToZip.getName();
        if (parentDirectoryName != null && !parentDirectoryName.isEmpty()) {
            zipEntryName = parentDirectoryName + "/" + fileToZip.getName();
        }
        if (fileToZip.isDirectory()) {
            for (File file : fileToZip.listFiles()) {
                this.addToZip(zos, file, zipEntryName);
            }
        } else if (this.shouldScrubPasswordsInFile(fileToZip.getName())) {
            this.zipFileWithScrubPasswords(zos, fileToZip, zipEntryName);
        } else {
            this.zipFile(zos, fileToZip, zipEntryName);
        }
    }

    private void zipFileWithScrubPasswords(ZipOutputStream zos, File fileToZip, String zipEntryName) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(fileToZip));){
            zos.putNextEntry(new ZipEntry(zipEntryName));
            while (reader.ready()) {
                String line = reader.readLine();
                if (this.shouldScrubPasswordsInLine(line)) {
                    line = "<line contained a password and was removed>";
                }
                zos.write((line + System.lineSeparator()).getBytes());
            }
            zos.closeEntry();
        }
    }

    private void zipFile(ZipOutputStream zos, File fileToZip, String zipEntryName) throws IOException {
        zos.putNextEntry(new ZipEntry(zipEntryName));
        Files.copy(fileToZip.toPath(), zos);
        zos.closeEntry();
    }

    private boolean shouldScrubPasswordsInFile(String fileName) {
        return fileName.endsWith(".xml") || fileName.endsWith(".conf");
    }

    private boolean shouldScrubPasswordsInLine(String line) {
        return line.contains(PASSWORD);
    }

    private void checkArguments(OutputStream outputStream, List<String> directories) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Received null OutputStream");
        }
        if (directories == null || directories.isEmpty()) {
            throw new IllegalArgumentException("Received null or empty directories list");
        }
    }

    private boolean isValidFile(File fileToZip) {
        if (fileToZip == null || !fileToZip.exists() || fileToZip.getName().endsWith(".lck")) {
            logger.info("The file or directory [{}] does not exist or is a service lock file and will not be in the zip", (Object)(fileToZip != null ? fileToZip.getName() : "null"));
            return false;
        }
        return true;
    }
}

