/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.FacetCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FacetDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FacetUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.facet.FacetScope;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.TypeHelper$;
import com.xebialabs.xlrelease.repository.VariableRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001\u0002\u000b\u0016\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u0006c\u0002!\tA\u001d\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0005bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003g\u0003A\u0011BA[\u0011\u001d\ty\r\u0001C\u0005\u0003#\u0014ABR1dKR\u001cVM\u001d<jG\u0016T!AF\f\u0002\u000fM,'O^5dK*\u0011\u0001$G\u0001\nq2\u0014X\r\\3bg\u0016T!AG\u000e\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M-j\u0011a\n\u0006\u0003Q%\nQa\u001d7gi)T\u0011AK\u0001\tOJL'P\u001f7fI&\u0011Af\n\u0002\b\u0019><w-\u001b8h\u0003=1\u0017mY3u%\u0016\u0004xn]5u_JL\bCA\u00183\u001b\u0005\u0001$BA\u0019\u0018\u0003)\u0011X\r]8tSR|'/_\u0005\u0003gA\u0012qBR1dKR\u0014V\r]8tSR|'/_\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z!\tyc'\u0003\u00028a\tqA+Y:l%\u0016\u0004xn]5u_JL\u0018\u0001C3wK:$()^:\u0011\u0005ijT\"A\u001e\u000b\u0005q:\u0012AB3wK:$8/\u0003\u0002?w\t\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002!\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007CA!C\u001b\u0005)\u0012BA\"\u0016\u0005A\t%o\u00195jm&twmU3sm&\u001cW-A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004\"a\f$\n\u0005\u001d\u0003$!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006Y1-[%e'\u0016\u0014h/[2f!\t\t%*\u0003\u0002L+\tY1)[%e'\u0016\u0014h/[2f\u0003I1\u0018M]5bE2,'+\u001a9pg&$xN]=\u0011\u0005=r\u0015BA(1\u0005I1\u0016M]5bE2,'+\u001a9pg&$xN]=\u0002'I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0011\u0005I+V\"A*\u000b\u0005Q;\u0012AB1di>\u00148/\u0003\u0002W'\n\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u00061A(\u001b8jiz\"\u0012\"\u0017.\\9vsv\fY1\u0011\u0005\u0005\u0003\u0001\"B\u0017\n\u0001\u0004q\u0003\"\u0002\u001b\n\u0001\u0004)\u0004\"\u0002\u001d\n\u0001\u0004I\u0004\"B \n\u0001\u0004\u0001\u0005\"\u0002#\n\u0001\u0004)\u0005\"\u0002%\n\u0001\u0004I\u0005\"\u0002'\n\u0001\u0004i\u0005\"\u0002)\n\u0001\u0004\t\u0006FA\u0005d!\t!w.D\u0001f\u0015\t1w-\u0001\u0006b]:|G/\u0019;j_:T!\u0001[5\u0002\u000f\u0019\f7\r^8ss*\u0011!n[\u0001\u0006E\u0016\fgn\u001d\u0006\u0003Y6\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002]\u0006\u0019qN]4\n\u0005A,'!C!vi><\u0018N]3e\u0003\r9W\r\u001e\u000b\u0003gn\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\u000b\u0019\f7-\u001a;\u000b\u0005a<\u0012A\u00023p[\u0006Lg.\u0003\u0002{k\n)a)Y2fi\")AP\u0003a\u0001{\u00069a-Y2fi&#\u0007c\u0001@\u0002\f9\u0019q0a\u0002\u0011\u0007\u0005\u0005\u0011%\u0004\u0002\u0002\u0004)\u0019\u0011QA\u000f\u0002\rq\u0012xn\u001c;?\u0013\r\tI!I\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%\u0011\u0005K\u0002\u000b\u0003'\u0001B!!\u0006\u0002\"5\u0011\u0011q\u0003\u0006\u0004M\u0006e!\u0002BA\u000e\u0003;\tq!\\3ue&\u001c7OC\u0002\u0002 m\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0003G\t9BA\u0003US6,G-\u0001\u0004de\u0016\fG/\u001a\u000b\u0004g\u0006%\u0002\"\u0002<\f\u0001\u0004\u0019\bfA\u0006\u0002\u0014\u00051A-\u001a7fi\u0016$B!!\r\u00028A\u0019\u0001%a\r\n\u0007\u0005U\u0012E\u0001\u0003V]&$\b\"\u0002?\r\u0001\u0004i\bf\u0001\u0007\u0002\u0014\u00051Q\u000f\u001d3bi\u0016$2a]A \u0011\u00151X\u00021\u0001tQ\ri\u00111C\u0001\u0007g\u0016\f'o\u00195\u0015\t\u0005\u001d\u0013q\u000b\t\u0006\u0003\u0013\n\u0019f]\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005!Q\u000f^5m\u0015\t\t\t&\u0001\u0003kCZ\f\u0017\u0002BA+\u0003\u0017\u0012A\u0001T5ti\"9\u0011\u0011\f\bA\u0002\u0005m\u0013a\u00024jYR,'o\u001d\t\u0005\u0003;\nY'\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003\u00151wN]7t\u0015\u0011\t)'a\u001a\u0002\u0005Y\f$bAA5/\u0005\u0019\u0011\r]5\n\t\u00055\u0014q\f\u0002\r\r\u0006\u001cW\r\u001e$jYR,'o\u001d\u0015\u0004\u001d\u0005M\u0011AB3ySN$8\u000f\u0006\u0003\u0002v\u0005m\u0004c\u0001\u0011\u0002x%\u0019\u0011\u0011P\u0011\u0003\u000f\t{w\u000e\\3b]\")Ap\u0004a\u0001{\"\u001aq\"a\u0005\u0002%\r\u0014X-\u0019;f\u001d\u0016<h+\u0019:jC\ndWm\u001d\u000b\u0007\u0003c\t\u0019)a$\t\u000f\u0005\u0015\u0005\u00031\u0001\u0002\b\u00069!/\u001a7fCN,\u0007\u0003BAE\u0003\u0017k\u0011a^\u0005\u0004\u0003\u001b;(a\u0002*fY\u0016\f7/\u001a\u0005\u0006mB\u0001\ra]\u0001\u000eO\u0016$h)Y2fiRK\b/Z:\u0015\t\u0005U\u0015Q\u0016\t\u0007\u0003\u0013\n\u0019&a&\u0011\t\u0005e\u0015\u0011V\u0007\u0003\u00037SA!!(\u0002 \u00069!/\u001a4mK\u000e$(\u0002BA5\u0003CSA!a)\u0002&\u00061\u0001\u000f\\;hS:T1!a*\u001a\u0003!!W\r\u001d7ps&$\u0018\u0002BAV\u00037\u0013!\u0002R3tGJL\u0007\u000f^8s\u0011\u0019\ty+\u0005a\u0001{\u0006A!-Y:f)f\u0004X\rK\u0002\u0012\u0003'\tqc]3be\u000eD\u0017J\\!sG\"Lg/\u001a3SK2,\u0017m]3\u0015\r\u0005]\u0016\u0011ZAg!\u0015\tI,a1t\u001d\u0011\tY,a0\u000f\t\u0005\u0005\u0011QX\u0005\u0002E%\u0019\u0011\u0011Y\u0011\u0002\u000fA\f7m[1hK&!\u0011QYAd\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0003\f\u0003BBAf%\u0001\u0007Q0A\u0005sK2,\u0017m]3JI\"9\u0011\u0011\f\nA\u0002\u0005m\u0013\u0001\u0003<bY&$\u0017\r^3\u0015\t\u0005E\u00121\u001b\u0005\u0006mN\u0001\ra\u001d\u0015\u0004\u0001\u0005]\u0007\u0003BAm\u0003?l!!a7\u000b\u0007\u0005u7.\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!9\u0002\\\n91+\u001a:wS\u000e,\u0007")
public class FacetService
implements Logging {
    private final FacetRepository facetRepository;
    private final TaskRepository taskRepository;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private final CiIdService ciIdService;
    private final ReleaseActorService releaseActorService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FacetService facetService = this;
        synchronized (facetService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Facet get(String facetId) {
        return this.facetRepository.get(facetId);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Facet create(Facet facet) {
        void var2_2;
        this.validate(facet);
        Facet createdFacet = this.facetRepository.create(facet);
        Object task = this.taskRepository.findById(facet.getTargetId());
        this.createNewVariables(task.getRelease(), createdFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetCreatedEvent(createdFacet));
        return var2_2;
    }

    @Timed
    public void delete(String facetId) {
        Facet facet = this.facetRepository.get(facetId);
        this.facetRepository.delete(facetId);
        this.eventBus.publish((XLReleaseEvent)new FacetDeletedEvent(facet));
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Facet update(Facet facet) {
        void var3_3;
        this.validate(facet);
        Facet originalFacet = this.facetRepository.get(facet.getId());
        Facet updatedFacet = this.facetRepository.update(facet);
        Object task = this.taskRepository.findById(facet.getTargetId());
        this.createNewVariables(task.getRelease(), updatedFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetUpdatedEvent(originalFacet, updatedFacet));
        return var3_3;
    }

    @Timed
    public List<Facet> search(FacetFilters filters) {
        filters.validate();
        filters.setTypes((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Option$.MODULE$.apply(filters.getTypes()).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).flatMap((Function1 & Serializable & scala.Serializable)ciType -> TypeHelper$.MODULE$.getAllSubtypesOf(ciType), Buffer$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty())).asJava());
        String containerId = filters.getParentId() != null ? filters.getParentId() : filters.getTargetId();
        return this.archivingService.exists(Ids.releaseIdFrom((String)containerId)) ? (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.searchInArchivedRelease(Ids.releaseIdFrom((String)containerId), filters)).asJava() : (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.facetRepository.search(filters)).asJava();
    }

    @Timed
    public boolean exists(String facetId) {
        return this.facetRepository.exists(facetId);
    }

    private void createNewVariables(Release release, Facet facet) {
        block0: {
            Buffer newVariables = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)facet, this.ciIdService)).asScala();
            if (!newVariables.nonEmpty()) break block0;
            newVariables.foreach((Function1 & Serializable & scala.Serializable)v -> $this.releaseActorService.createVariable((Variable)v, release.getId()));
        }
    }

    @Timed
    public List<Descriptor> getFacetTypes(String baseType) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf((String)baseType))).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getDescriptor(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$getFacetTypes$2(desc)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getLabel(), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    private Seq<Facet> searchInArchivedRelease(String releaseId, FacetFilters filters) {
        Release release = this.archivingService.getRelease(releaseId);
        return ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$searchInArchivedRelease$1(filters, x$4)))).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$5.getFacets()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)facet -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$searchInArchivedRelease$3(filters, facet)))).toList();
    }

    private void validate(Facet facet) {
        FacetScope facetScope = facet.getScope();
        if (!FacetScope.TASK.equals(facetScope)) {
            throw new IllegalArgumentException(new StringBuilder(30).append("Target type ").append(facet.getScope()).append(" is not supported.").toString());
        }
        Checks.checkArgument((boolean)Ids.isTaskId((String)facet.getTargetId()), (String)"Target ID is not a valid task ID.", (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(facet.getTargetId()), (String)new StringBuilder(56).append("Task with the ID '").append(facet.getTargetId()).append("' does not exist or has been archived.").toString(), (Object[])new Object[0]);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getFacetTypes$2(Descriptor desc) {
        return !desc.isVirtual() && desc.getPropertyDescriptor("configurationUri") != null;
    }

    public static final /* synthetic */ boolean $anonfun$searchInArchivedRelease$1(FacetFilters filters$1, Task x$4) {
        String string = x$4.getId();
        String string2 = filters$1.getTargetId();
        return !(string == null ? string2 != null : !string.equals(string2)) || !filters$1.hasTargetId();
    }

    public static final /* synthetic */ boolean $anonfun$searchInArchivedRelease$3(FacetFilters filters$1, Facet facet) {
        return filters$1.getTypes().isEmpty() || filters$1.getTypes().contains(facet.getType());
    }

    @Autowired
    public FacetService(FacetRepository facetRepository, TaskRepository taskRepository, XLReleaseEventBus eventBus, ArchivingService archivingService, ReleaseRepository releaseRepository, CiIdService ciIdService, VariableRepository variableRepository, ReleaseActorService releaseActorService) {
        this.facetRepository = facetRepository;
        this.taskRepository = taskRepository;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.releaseActorService = releaseActorService;
        Logging.$init$((Logging)this);
    }
}

