/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.views.PhaseView;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ReleaseView {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    private String title;
    private Map<String, String> variables;
    private List<PhaseView> phases;

    public ReleaseView(Release release) {
        this.id = release.getId();
        this.title = release.getTitle();
        this.phases = release.getPhases().stream().map(PhaseView::new).collect(Collectors.toList());
        this.variables = release.getAllStringVariableValues();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public List<PhaseView> getPhases() {
        return this.phases;
    }
}

